/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.ashley.core;

import com.badlogic.ashley.core.Component;
import com.badlogic.ashley.core.ComponentType;
import com.badlogic.ashley.core.Entity;

public final class ComponentMapper<T extends Component> {
    private final ComponentType componentType;

    public static <T extends Component> ComponentMapper<T> getFor(Class<T> componentClass) {
        return new ComponentMapper<T>(componentClass);
    }

    public T get(Entity entity) {
        return entity.getComponent(this.componentType);
    }

    public boolean has(Entity entity) {
        return entity.hasComponent(this.componentType);
    }

    private ComponentMapper(Class<T> componentClass) {
        this.componentType = ComponentType.getFor(componentClass);
    }
}

