/*
 * Decompiled with CFR 0.152.
 */
package com.github.liaochong.myexcel.core.style;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.poi.ss.usermodel.CellStyle;

public final class BorderStyle {
    public static final String BORDER_STYLE = "border-style";
    public static final String BORDER_LEFT_STYLE = "border-left-style";
    public static final String BORDER_RIGHT_STYLE = "border-right-style";
    public static final String BORDER_TOP_STYLE = "border-top-style";
    public static final String BORDER_BOTTOM_STYLE = "border-bottom-style";
    private static final Pattern BORDER_PATTERN = Pattern.compile("(\\w+)");
    private static final Map<String, org.apache.poi.ss.usermodel.BorderStyle> borderStyleMap = Arrays.stream(org.apache.poi.ss.usermodel.BorderStyle.values()).collect(Collectors.toMap(b -> b.toString().toLowerCase(), b -> b));

    public static void setBorder(CellStyle cellStyle, Map<String, String> tdStyle) {
        String borderBottomStyle;
        String borderTopStyle;
        String borderRightStyle;
        String borderLeftStyle;
        String borderStyle = tdStyle.get(BORDER_STYLE);
        if (borderStyle != null) {
            Matcher matcher = BORDER_PATTERN.matcher(borderStyle);
            ArrayList<String> styles = new ArrayList<String>();
            while (matcher.find()) {
                styles.add(matcher.group());
            }
            tdStyle = new HashMap<String, String>(tdStyle);
            if (styles.size() == 1) {
                tdStyle.put(BORDER_TOP_STYLE, (String)styles.get(0));
                tdStyle.put(BORDER_RIGHT_STYLE, (String)styles.get(0));
                tdStyle.put(BORDER_BOTTOM_STYLE, (String)styles.get(0));
                tdStyle.put(BORDER_LEFT_STYLE, (String)styles.get(0));
            } else if (styles.size() == 2) {
                tdStyle.put(BORDER_TOP_STYLE, (String)styles.get(0));
                tdStyle.put(BORDER_RIGHT_STYLE, (String)styles.get(1));
                tdStyle.put(BORDER_BOTTOM_STYLE, (String)styles.get(0));
                tdStyle.put(BORDER_LEFT_STYLE, (String)styles.get(1));
            } else if (styles.size() == 3) {
                tdStyle.put(BORDER_TOP_STYLE, (String)styles.get(0));
                tdStyle.put(BORDER_RIGHT_STYLE, (String)styles.get(1));
                tdStyle.put(BORDER_BOTTOM_STYLE, (String)styles.get(2));
                tdStyle.put(BORDER_LEFT_STYLE, (String)styles.get(1));
            } else if (styles.size() == 4) {
                tdStyle.put(BORDER_TOP_STYLE, (String)styles.get(0));
                tdStyle.put(BORDER_RIGHT_STYLE, (String)styles.get(1));
                tdStyle.put(BORDER_BOTTOM_STYLE, (String)styles.get(2));
                tdStyle.put(BORDER_LEFT_STYLE, (String)styles.get(3));
            }
        }
        if (borderStyleMap.containsKey(borderLeftStyle = tdStyle.get(BORDER_LEFT_STYLE))) {
            cellStyle.setBorderLeft(borderStyleMap.get(borderLeftStyle));
        }
        if (borderStyleMap.containsKey(borderRightStyle = tdStyle.get(BORDER_RIGHT_STYLE))) {
            cellStyle.setBorderRight(borderStyleMap.get(borderRightStyle));
        }
        if (borderStyleMap.containsKey(borderTopStyle = tdStyle.get(BORDER_TOP_STYLE))) {
            cellStyle.setBorderTop(borderStyleMap.get(borderTopStyle));
        }
        if (borderStyleMap.containsKey(borderBottomStyle = tdStyle.get(BORDER_BOTTOM_STYLE))) {
            cellStyle.setBorderBottom(borderStyleMap.get(borderBottomStyle));
        }
    }
}

