/*
 * Decompiled with CFR 0.152.
 */
package com.github.liaochong.myexcel.core.converter.writer;

import com.github.liaochong.myexcel.core.ConvertContext;
import com.github.liaochong.myexcel.core.constant.BooleanDropDownList;
import com.github.liaochong.myexcel.core.constant.DropDownList;
import com.github.liaochong.myexcel.core.constant.NumberDropDownList;
import com.github.liaochong.myexcel.core.container.Pair;
import com.github.liaochong.myexcel.core.converter.WriteConverter;
import com.github.liaochong.myexcel.utils.ReflectUtil;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class DropDownListWriteConverter
implements WriteConverter {
    @Override
    public Pair<Class, Object> convert(Field field, Object fieldVal, ConvertContext convertContext) {
        String content;
        if (field.getType() == List.class) {
            List list = (List)fieldVal;
            content = list.stream().map(Object::toString).collect(Collectors.joining(","));
            Optional<Object> optional = list.stream().filter(Objects::nonNull).findFirst();
            if (optional.isPresent()) {
                Class<?> clazz = optional.get().getClass();
                if (ReflectUtil.isBool(clazz)) {
                    return Pair.of(BooleanDropDownList.class, content);
                }
                if (ReflectUtil.isNumber(clazz)) {
                    return Pair.of(NumberDropDownList.class, content);
                }
            }
        } else {
            Array array = (Array)fieldVal;
            content = Stream.of(array).map(Object::toString).collect(Collectors.joining(","));
            Class<?> clazz = Array.get(array, 0).getClass();
            if (ReflectUtil.isBool(clazz)) {
                return Pair.of(BooleanDropDownList.class, content);
            }
            if (ReflectUtil.isNumber(clazz)) {
                return Pair.of(NumberDropDownList.class, content);
            }
        }
        return Pair.of(DropDownList.class, content);
    }

    @Override
    public boolean support(Field field, Object fieldVal, ConvertContext convertContext) {
        return field.getType() == Array.class || field.getType() == List.class;
    }
}

