/*
 * Decompiled with CFR 0.152.
 */
package com.drake.net.request;

import android.net.Uri;
import com.drake.net.interfaces.ProgressListener;
import com.drake.net.request.BaseRequest;
import com.drake.net.request.MediaConst;
import com.drake.net.request.Method;
import com.drake.net.request.RequestBuilderKt;
import com.drake.net.utils.FileUtilsKt;
import com.drake.net.utils.UriKt;
import java.io.File;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import okhttp3.FormBody;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.Request;
import okhttp3.RequestBody;
import okio.ByteString;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONArray;
import org.json.JSONObject;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0090\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0012\n\u0002\u0010\u0004\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$J\b\u0010%\u001a\u00020&H\u0016J;\u0010'\u001a\u00020\"2.\u0010\u0003\u001a\u0018\u0012\u0014\b\u0001\u0012\u0010\u0012\u0004\u0012\u00020*\u0012\u0006\u0012\u0004\u0018\u00010+0)0(\"\u0010\u0012\u0004\u0012\u00020*\u0012\u0006\u0012\u0004\u0018\u00010+0)\u00a2\u0006\u0002\u0010,J\u0010\u0010'\u001a\u00020\"2\b\u0010\u0003\u001a\u0004\u0018\u00010*J\u001e\u0010'\u001a\u00020\"2\u0016\u0010\u0003\u001a\u0012\u0012\u0004\u0012\u00020*\u0012\u0006\u0012\u0004\u0018\u00010+\u0018\u00010-J\u0010\u0010'\u001a\u00020\"2\b\u0010\u0003\u001a\u0004\u0018\u00010.J\u0010\u0010'\u001a\u00020\"2\b\u0010\u0003\u001a\u0004\u0018\u00010/J\u0018\u00100\u001a\u00020\"2\u0006\u00101\u001a\u00020*2\b\u00102\u001a\u0004\u0018\u000103J\u0018\u00100\u001a\u00020\"2\u0006\u00101\u001a\u00020*2\b\u00102\u001a\u0004\u0018\u000104J\u001f\u00100\u001a\u00020\"2\u0006\u00101\u001a\u00020*2\b\u00102\u001a\u0004\u0018\u000105H\u0016\u00a2\u0006\u0002\u00106J\u0018\u00100\u001a\u00020\"2\u0006\u00101\u001a\u00020*2\b\u00102\u001a\u0004\u0018\u000107J\u001a\u00100\u001a\u00020\"2\u0006\u00101\u001a\u00020*2\b\u00102\u001a\u0004\u0018\u000108H\u0016J\u001a\u00100\u001a\u00020\"2\u0006\u00101\u001a\u00020*2\b\u00102\u001a\u0004\u0018\u00010*H\u0016J\"\u00100\u001a\u00020\"2\u0006\u00101\u001a\u00020*2\b\u00109\u001a\u0004\u0018\u00010*2\b\u00102\u001a\u0004\u0018\u000104J\"\u00100\u001a\u00020\"2\u0006\u00101\u001a\u00020*2\b\u00102\u001a\u0004\u0018\u00010*2\u0006\u0010:\u001a\u000205H\u0016J\"\u00100\u001a\u00020\"2\u0006\u00101\u001a\u00020*2\b\u0010;\u001a\u0004\u0018\u00010*2\b\u00102\u001a\u0004\u0018\u00010\u0004J \u00100\u001a\u00020\"2\u0006\u00101\u001a\u00020*2\u0010\u00102\u001a\f\u0012\u0006\u0012\u0004\u0018\u000104\u0018\u00010<J\u0018\u00100\u001a\u00020\"2\u0006\u00101\u001a\u00020*2\b\u00102\u001a\u0004\u0018\u00010\u0004J\u0018\u00100\u001a\u00020\"2\u0006\u00101\u001a\u00020*2\b\u00102\u001a\u0004\u0018\u00010=J\u000e\u00100\u001a\u00020\"2\u0006\u0010\u0003\u001a\u00020>R\u001c\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u00020\nX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\u00020\u0010X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0015\u001a\u00020\u0016X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u001a\u0010\u001b\u001a\u00020\u001cX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 \u00a8\u0006?"}, d2={"Lcom/drake/net/request/BodyRequest;", "Lcom/drake/net/request/BaseRequest;", "()V", "body", "Lokhttp3/RequestBody;", "getBody", "()Lokhttp3/RequestBody;", "setBody", "(Lokhttp3/RequestBody;)V", "formBody", "Lokhttp3/FormBody$Builder;", "getFormBody", "()Lokhttp3/FormBody$Builder;", "setFormBody", "(Lokhttp3/FormBody$Builder;)V", "mediaType", "Lokhttp3/MediaType;", "getMediaType", "()Lokhttp3/MediaType;", "setMediaType", "(Lokhttp3/MediaType;)V", "method", "Lcom/drake/net/request/Method;", "getMethod", "()Lcom/drake/net/request/Method;", "setMethod", "(Lcom/drake/net/request/Method;)V", "partBody", "Lokhttp3/MultipartBody$Builder;", "getPartBody", "()Lokhttp3/MultipartBody$Builder;", "setPartBody", "(Lokhttp3/MultipartBody$Builder;)V", "addUploadListener", "", "progressListener", "Lcom/drake/net/interfaces/ProgressListener;", "buildRequest", "Lokhttp3/Request;", "json", "", "Lkotlin/Pair;", "", "", "([Lkotlin/Pair;)V", "", "Lorg/json/JSONArray;", "Lorg/json/JSONObject;", "param", "name", "value", "Landroid/net/Uri;", "Ljava/io/File;", "", "(Ljava/lang/String;Ljava/lang/Boolean;)V", "", "", "fileName", "encoded", "filename", "", "Lokio/ByteString;", "Lokhttp3/MultipartBody$Part;", "net_release"})
@SourceDebugExtension(value={"SMAP\nBodyRequest.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BodyRequest.kt\ncom/drake/net/request/BodyRequest\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,205:1\n1855#2,2:206\n*S KotlinDebug\n*F\n+ 1 BodyRequest.kt\ncom/drake/net/request/BodyRequest\n*L\n124#1:206,2\n*E\n"})
public class BodyRequest
extends BaseRequest {
    @Nullable
    private RequestBody body;
    @NotNull
    private MultipartBody.Builder partBody = new MultipartBody.Builder(null, 1, null);
    @NotNull
    private FormBody.Builder formBody = new FormBody.Builder(null, 1, null);
    @NotNull
    private MediaType mediaType = MediaConst.INSTANCE.getFORM();
    @NotNull
    private Method method = Method.POST;

    @Nullable
    public RequestBody getBody() {
        return this.body;
    }

    public void setBody(@Nullable RequestBody requestBody) {
        this.body = requestBody;
    }

    @NotNull
    public MultipartBody.Builder getPartBody() {
        return this.partBody;
    }

    public void setPartBody(@NotNull MultipartBody.Builder builder) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"<set-?>");
        this.partBody = builder;
    }

    @NotNull
    public FormBody.Builder getFormBody() {
        return this.formBody;
    }

    public void setFormBody(@NotNull FormBody.Builder builder) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"<set-?>");
        this.formBody = builder;
    }

    @NotNull
    public MediaType getMediaType() {
        return this.mediaType;
    }

    public void setMediaType(@NotNull MediaType mediaType) {
        Intrinsics.checkNotNullParameter((Object)mediaType, (String)"<set-?>");
        this.mediaType = mediaType;
    }

    @Override
    @NotNull
    public Method getMethod() {
        return this.method;
    }

    @Override
    public void setMethod(@NotNull Method method) {
        Intrinsics.checkNotNullParameter((Object)((Object)method), (String)"<set-?>");
        this.method = method;
    }

    @Override
    public void param(@NotNull String name, @Nullable String value) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        String string2 = value;
        if (string2 == null) {
            return;
        }
        this.getFormBody().add(name, string2);
    }

    @Override
    public void param(@NotNull String name, @Nullable String value, boolean encoded) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        if (value == null) {
            return;
        }
        if (encoded) {
            this.getFormBody().addEncoded(name, value);
        } else {
            this.getFormBody().add(name, value);
        }
    }

    @Override
    public void param(@NotNull String name, @Nullable Number value) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        if (value == null) {
            return;
        }
        this.getFormBody().add(name, value.toString());
    }

    @Override
    public void param(@NotNull String name, @Nullable Boolean value) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Boolean bl = value;
        if (bl == null) {
            return;
        }
        bl.booleanValue();
        this.getFormBody().add(name, value.toString());
    }

    public final void param(@NotNull String name, @Nullable RequestBody value) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        if (value == null) {
            return;
        }
        this.getPartBody().addFormDataPart(name, null, value);
    }

    public final void param(@NotNull String name, @Nullable String filename, @Nullable RequestBody value) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        if (value == null) {
            return;
        }
        this.getPartBody().addFormDataPart(name, filename, value);
    }

    public final void param(@NotNull String name, @Nullable ByteString value) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        if (value == null) {
            return;
        }
        this.getPartBody().addFormDataPart(name, null, RequestBody.Companion.create$default((RequestBody.Companion)RequestBody.Companion, (ByteString)value, null, (int)1, null));
    }

    public final void param(@NotNull String name, @Nullable byte[] value) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        byte[] byArray = value;
        if (value == null) {
            return;
        }
        this.getPartBody().addFormDataPart(name, null, RequestBody.Companion.create$default((RequestBody.Companion)RequestBody.Companion, (byte[])value, null, (int)0, (int)0, (int)7, null));
    }

    public final void param(@NotNull String name, @Nullable Uri value) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        if (value == null) {
            return;
        }
        this.getPartBody().addFormDataPart(name, UriKt.fileName(value), UriKt.toRequestBody(value));
    }

    public final void param(@NotNull String name, @Nullable File value) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        if (value == null) {
            return;
        }
        this.getPartBody().addFormDataPart(name, value.getName(), FileUtilsKt.toRequestBody$default(value, null, 1, null));
    }

    public final void param(@NotNull String name, @Nullable List<? extends File> value) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            List<? extends File> list = value;
            if (list == null) break block1;
            Iterable $this$forEach$iv = list;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                File file = (File)element$iv;
                boolean bl = false;
                this.param(name, file);
            }
        }
    }

    public final void param(@NotNull String name, @Nullable String fileName, @Nullable File value) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        File file = value;
        if (file == null || (file = FileUtilsKt.toRequestBody$default(file, null, 1, null)) == null) {
            return;
        }
        this.getPartBody().addFormDataPart(name, fileName, (RequestBody)file);
    }

    public final void param(@NotNull MultipartBody.Part body) {
        Intrinsics.checkNotNullParameter((Object)body, (String)"body");
        this.getPartBody().addPart(body);
    }

    public final void json(@Nullable JSONObject body) {
        Object object = body;
        this.setBody(object != null && (object = object.toString()) != null ? RequestBody.Companion.create((String)object, MediaConst.INSTANCE.getJSON()) : null);
    }

    public final void json(@Nullable JSONArray body) {
        Object object = body;
        this.setBody(object != null && (object = object.toString()) != null ? RequestBody.Companion.create((String)object, MediaConst.INSTANCE.getJSON()) : null);
    }

    public final void json(@Nullable String body) {
        String string2 = body;
        this.setBody(string2 != null ? RequestBody.Companion.create(string2, MediaConst.INSTANCE.getJSON()) : null);
    }

    public final void json(@Nullable Map<String, ? extends Object> body) {
        Map<String, ? extends Object> map = body;
        if (map == null) {
            return;
        }
        String string2 = new JSONObject(map).toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"JSONObject(body ?: return).toString()");
        this.setBody(RequestBody.Companion.create(string2, MediaConst.INSTANCE.getJSON()));
    }

    public final void json(Pair<String, ? extends Object> ... body) {
        Intrinsics.checkNotNullParameter(body, (String)"body");
        String string2 = new JSONObject(MapsKt.toMap(body)).toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"JSONObject(body.toMap()).toString()");
        this.setBody(RequestBody.Companion.create(string2, MediaConst.INSTANCE.getJSON()));
    }

    public final void addUploadListener(@NotNull ProgressListener progressListener) {
        Intrinsics.checkNotNullParameter((Object)progressListener, (String)"progressListener");
        RequestBuilderKt.uploadListeners(this.getOkHttpRequest()).add(progressListener);
    }

    @Override
    @NotNull
    public Request buildRequest() {
        RequestBody requestBody;
        if (this.getBody() != null) {
            requestBody = this.getBody();
        } else {
            RequestBody requestBody2;
            FormBody form = this.getFormBody().build();
            try {
                this.getPartBody().build();
                int n = form.size();
                for (int i = 0; i < n; ++i) {
                    String name = form.name(i);
                    String value = form.value(i);
                    this.getPartBody().addFormDataPart(name, value);
                }
                requestBody2 = (RequestBody)this.getPartBody().setType(this.getMediaType()).build();
            }
            catch (IllegalStateException e) {
                requestBody2 = (RequestBody)form;
            }
            requestBody = requestBody2;
        }
        RequestBody body = requestBody;
        return RequestBuilderKt.setConverter(this.getOkHttpRequest().method(this.getMethod().name(), body).url(this.getHttpUrl().build()), this.getConverter()).build();
    }
}

