/*
 * Decompiled with CFR 0.152.
 */
package com.drake.brv;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Rect;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.ColorInt;
import androidx.annotation.ColorRes;
import androidx.annotation.DrawableRes;
import androidx.core.content.ContextCompat;
import androidx.recyclerview.widget.GridLayoutManager;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import androidx.recyclerview.widget.StaggeredGridLayoutManager;
import com.drake.brv.BindingAdapter;
import com.drake.brv.annotaion.DividerOrientation;
import com.drake.brv.item.ItemExpand;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u008a\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000e\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010!\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u000e\u0018\u00002\u00020\u0001:\u0001WB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0014\u00101\u001a\u0002022\f\b\u0001\u00103\u001a\u000204\"\u00020\u0017J\u0010\u00105\u001a\u0002022\u0006\u00106\u001a\u00020/H\u0002J \u00107\u001a\u0002022\u0006\u00108\u001a\u0002092\u0006\u0010:\u001a\u00020;2\u0006\u0010<\u001a\u00020\bH\u0002J \u0010=\u001a\u0002022\u0006\u00108\u001a\u0002092\u0006\u0010:\u001a\u00020;2\u0006\u0010<\u001a\u00020\bH\u0002J \u0010>\u001a\u0002022\u0006\u00108\u001a\u0002092\u0006\u0010:\u001a\u00020;2\u0006\u0010<\u001a\u00020\bH\u0002J(\u0010?\u001a\u0002022\u0006\u0010@\u001a\u00020A2\u0006\u0010B\u001a\u00020C2\u0006\u0010:\u001a\u00020;2\u0006\u0010D\u001a\u00020EH\u0016J \u0010F\u001a\u0002022\u0006\u00108\u001a\u0002092\u0006\u0010:\u001a\u00020;2\u0006\u0010D\u001a\u00020EH\u0016J#\u0010\u0019\u001a\u0002022\u001b\u0010G\u001a\u0017\u0012\b\u0012\u00060\u001bR\u00020\u001c\u0012\u0004\u0012\u00020\b0\u001a\u00a2\u0006\u0002\b\u001dJ\u0010\u0010H\u001a\u0002022\b\b\u0001\u0010I\u001a\u00020\u0017J\u000e\u0010H\u001a\u0002022\u0006\u0010I\u001a\u00020JJ\u0010\u0010K\u001a\u0002022\b\b\u0001\u0010I\u001a\u00020\u0017J\u001a\u0010L\u001a\u0002022\b\b\u0002\u0010M\u001a\u00020\u00172\b\b\u0002\u0010N\u001a\u00020\bJ\u000e\u0010O\u001a\u0002022\u0006\u0010P\u001a\u00020\u0006J\u0010\u0010O\u001a\u0002022\b\b\u0001\u0010Q\u001a\u00020\u0017J8\u0010R\u001a\u0002022\b\b\u0002\u0010S\u001a\u00020\u00172\b\b\u0002\u0010T\u001a\u00020\u00172\b\b\u0002\u0010N\u001a\u00020\b2\b\b\u0002\u0010U\u001a\u00020\b2\b\b\u0002\u0010V\u001a\u00020\bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u001a\u0010\r\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\n\"\u0004\b\u000f\u0010\fR$\u0010\u0011\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\b8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0012\u0010\n\"\u0004\b\u0013\u0010\fR\u000e\u0010\u0014\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R%\u0010\u0019\u001a\u0019\u0012\b\u0012\u00060\u001bR\u00020\u001c\u0012\u0004\u0012\u00020\b\u0018\u00010\u001a\u00a2\u0006\u0002\b\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001e\u001a\u00020\u001fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010!\"\u0004\b\"\u0010#R\u000e\u0010$\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010%\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b&\u0010\n\"\u0004\b'\u0010\fR\"\u0010(\u001a\n\u0012\u0004\u0012\u00020\u0017\u0018\u00010)X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b*\u0010+\"\u0004\b,\u0010-R\u0018\u0010.\u001a\u00020\b*\u00020/8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b.\u00100\u00a8\u0006X"}, d2={"Lcom/drake/brv/DefaultDecoration;", "Landroidx/recyclerview/widget/RecyclerView$ItemDecoration;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "divider", "Landroid/graphics/drawable/Drawable;", "endVisible", "", "getEndVisible", "()Z", "setEndVisible", "(Z)V", "expandVisible", "getExpandVisible", "setExpandVisible", "value", "includeVisible", "getIncludeVisible", "setIncludeVisible", "marginBaseItemEnd", "marginBaseItemStart", "marginEnd", "", "marginStart", "onEnabled", "Lkotlin/Function1;", "Lcom/drake/brv/BindingAdapter$BindingViewHolder;", "Lcom/drake/brv/BindingAdapter;", "Lkotlin/ExtensionFunctionType;", "orientation", "Lcom/drake/brv/annotaion/DividerOrientation;", "getOrientation", "()Lcom/drake/brv/annotaion/DividerOrientation;", "setOrientation", "(Lcom/drake/brv/annotaion/DividerOrientation;)V", "size", "startVisible", "getStartVisible", "setStartVisible", "typePool", "", "getTypePool", "()Ljava/util/List;", "setTypePool", "(Ljava/util/List;)V", "isReverseLayout", "Landroidx/recyclerview/widget/RecyclerView$LayoutManager;", "(Landroidx/recyclerview/widget/RecyclerView$LayoutManager;)Z", "addType", "", "typeArray", "", "adjustOrientation", "layoutManager", "drawGrid", "canvas", "Landroid/graphics/Canvas;", "parent", "Landroidx/recyclerview/widget/RecyclerView;", "reverseLayout", "drawHorizontal", "drawVertical", "getItemOffsets", "outRect", "Landroid/graphics/Rect;", "view", "Landroid/view/View;", "state", "Landroidx/recyclerview/widget/RecyclerView$State;", "onDraw", "block", "setColor", "color", "", "setColorRes", "setDivider", "width", "dp", "setDrawable", "drawable", "drawableRes", "setMargin", "start", "end", "baseItemStart", "baseItemEnd", "Edge", "brv_release"})
public final class DefaultDecoration
extends RecyclerView.ItemDecoration {
    @NotNull
    private final Context context;
    private boolean startVisible;
    private boolean endVisible;
    private boolean expandVisible;
    @NotNull
    private DividerOrientation orientation;
    private int size;
    private int marginStart;
    private int marginEnd;
    private boolean marginBaseItemStart;
    private boolean marginBaseItemEnd;
    @Nullable
    private Drawable divider;
    @Nullable
    private List<Integer> typePool;
    @Nullable
    private Function1<? super BindingAdapter.BindingViewHolder, Boolean> onEnabled;

    public DefaultDecoration(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
        this.orientation = DividerOrientation.HORIZONTAL;
        this.size = 1;
    }

    public final boolean getStartVisible() {
        return this.startVisible;
    }

    public final void setStartVisible(boolean bl) {
        this.startVisible = bl;
    }

    public final boolean getEndVisible() {
        return this.endVisible;
    }

    public final void setEndVisible(boolean bl) {
        this.endVisible = bl;
    }

    public final boolean getIncludeVisible() {
        return this.startVisible && this.endVisible;
    }

    public final void setIncludeVisible(boolean value) {
        this.startVisible = value;
        this.endVisible = value;
    }

    public final boolean getExpandVisible() {
        return this.expandVisible;
    }

    public final void setExpandVisible(boolean bl) {
        this.expandVisible = bl;
    }

    @NotNull
    public final DividerOrientation getOrientation() {
        return this.orientation;
    }

    public final void setOrientation(@NotNull DividerOrientation dividerOrientation) {
        Intrinsics.checkNotNullParameter((Object)((Object)dividerOrientation), (String)"<set-?>");
        this.orientation = dividerOrientation;
    }

    private final boolean isReverseLayout(RecyclerView.LayoutManager $this$isReverseLayout) {
        RecyclerView.LayoutManager layoutManager = $this$isReverseLayout;
        return layoutManager instanceof LinearLayoutManager ? ((LinearLayoutManager)$this$isReverseLayout).getReverseLayout() : (layoutManager instanceof StaggeredGridLayoutManager ? ((StaggeredGridLayoutManager)$this$isReverseLayout).getReverseLayout() : false);
    }

    @Nullable
    public final List<Integer> getTypePool() {
        return this.typePool;
    }

    public final void setTypePool(@Nullable List<Integer> list) {
        this.typePool = list;
    }

    public final void onEnabled(@NotNull Function1<? super BindingAdapter.BindingViewHolder, Boolean> block) {
        Intrinsics.checkNotNullParameter(block, (String)"block");
        this.onEnabled = block;
    }

    public final void addType(int ... typeArray) {
        Intrinsics.checkNotNullParameter((Object)typeArray, (String)"typeArray");
        if (this.typePool == null) {
            this.typePool = new ArrayList();
            this.onEnabled = (Function1)new Function1<BindingAdapter.BindingViewHolder, Boolean>(this){
                final /* synthetic */ DefaultDecoration this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(@NotNull BindingAdapter.BindingViewHolder $this$null) {
                    boolean bl;
                    Intrinsics.checkNotNullParameter((Object)((Object)$this$null), (String)"$this$null");
                    List<Integer> list = this.this$0.getTypePool();
                    return list == null ? true : (bl = list.contains($this$null.getItemViewType()));
                }
            };
        }
        int[] $this$forEach$iv = typeArray;
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv.length;
        for (int i = 0; i < n; ++i) {
            int element$iv;
            int it = element$iv = $this$forEach$iv[i];
            boolean bl = false;
            List<Integer> list = this.getTypePool();
            if (list == null) continue;
            list.add(it);
        }
    }

    public final void setDrawable(@NotNull Drawable drawable) {
        Intrinsics.checkNotNullParameter((Object)drawable, (String)"drawable");
        this.divider = drawable;
    }

    public final void setDrawable(@DrawableRes int drawableRes) {
        Drawable drawable;
        Drawable drawable2 = ContextCompat.getDrawable((Context)this.context, (int)drawableRes);
        if (drawable2 == null) {
            throw new IllegalArgumentException("Drawable cannot be find");
        }
        this.divider = drawable = drawable2;
    }

    public final void setColor(@ColorInt int color) {
        this.divider = (Drawable)new ColorDrawable(color);
    }

    public final void setColor(@NotNull String color) {
        Intrinsics.checkNotNullParameter((Object)color, (String)"color");
        int parseColor = Color.parseColor((String)color);
        this.divider = (Drawable)new ColorDrawable(parseColor);
    }

    public final void setColorRes(@ColorRes int color) {
        int colorRes = ContextCompat.getColor((Context)this.context, (int)color);
        this.divider = (Drawable)new ColorDrawable(colorRes);
    }

    public final void setDivider(int width, boolean dp) {
        if (!dp) {
            this.size = width;
        } else {
            float density = this.context.getResources().getDisplayMetrics().density;
            this.size = MathKt.roundToInt((float)(density * (float)width));
        }
    }

    public static /* synthetic */ void setDivider$default(DefaultDecoration defaultDecoration, int n, boolean bl, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = 1;
        }
        if ((n2 & 2) != 0) {
            bl = false;
        }
        defaultDecoration.setDivider(n, bl);
    }

    public final void setMargin(int start, int end, boolean dp, boolean baseItemStart, boolean baseItemEnd) {
        this.marginBaseItemStart = baseItemStart;
        this.marginBaseItemEnd = baseItemEnd;
        if (!dp) {
            this.marginStart = start;
            this.marginEnd = end;
        } else {
            float density = this.context.getResources().getDisplayMetrics().density;
            this.marginStart = MathKt.roundToInt((float)((float)start * density));
            this.marginEnd = MathKt.roundToInt((float)((float)end * density));
        }
    }

    public static /* synthetic */ void setMargin$default(DefaultDecoration defaultDecoration, int n, int n2, boolean bl, boolean bl2, boolean bl3, int n3, Object object) {
        if ((n3 & 1) != 0) {
            n = 0;
        }
        if ((n3 & 2) != 0) {
            n2 = n;
        }
        if ((n3 & 4) != 0) {
            bl = false;
        }
        if ((n3 & 8) != 0) {
            bl2 = false;
        }
        if ((n3 & 0x10) != 0) {
            bl3 = false;
        }
        defaultDecoration.setMargin(n, n2, bl, bl2, bl3);
    }

    public void getItemOffsets(@NotNull Rect outRect, @NotNull View view, @NotNull RecyclerView parent, @NotNull RecyclerView.State state) {
        Intrinsics.checkNotNullParameter((Object)outRect, (String)"outRect");
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        RecyclerView.LayoutManager layoutManager = parent.getLayoutManager();
        if (layoutManager == null) {
            return;
        }
        RecyclerView.LayoutManager layoutManager2 = layoutManager;
        Function1<? super BindingAdapter.BindingViewHolder, Boolean> function1 = this.onEnabled;
        if (function1 != null) {
            Object modelOrNull;
            BindingAdapter.BindingViewHolder vh;
            Function1<? super BindingAdapter.BindingViewHolder, Boolean> it = function1;
            boolean bl = false;
            RecyclerView.ViewHolder viewHolder = parent.findContainingViewHolder(view);
            if (viewHolder == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.drake.brv.BindingAdapter.BindingViewHolder");
            }
            BindingAdapter.BindingViewHolder this_$iv = vh = (BindingAdapter.BindingViewHolder)viewHolder;
            boolean $i$f$getModelOrNull = false;
            Object object = this_$iv.get_data();
            if (!(object instanceof Object)) {
                object = modelOrNull = null;
            }
            if (!this.getExpandVisible() && modelOrNull != null && modelOrNull instanceof ItemExpand && ((ItemExpand)modelOrNull).getItemExpand()) {
                return;
            }
            if (!((Boolean)it.invoke((Object)vh)).booleanValue()) {
                return;
            }
        }
        int position = parent.getChildAdapterPosition(view);
        if (position == -1) {
            return;
        }
        Drawable divider2 = this.divider;
        int height = divider2 == null ? this.size : (divider2.getIntrinsicHeight() != -1 ? divider2.getIntrinsicHeight() : (divider2.getIntrinsicWidth() != -1 ? divider2.getIntrinsicWidth() : this.size));
        int width = divider2 == null ? this.size : (divider2.getIntrinsicWidth() != -1 ? divider2.getIntrinsicWidth() : (divider2.getIntrinsicHeight() != -1 ? divider2.getIntrinsicHeight() : this.size));
        boolean reverseLayout = this.isReverseLayout(layoutManager2);
        Edge edge = Edge.Companion.computeEdge(position, layoutManager2, reverseLayout);
        this.adjustOrientation(layoutManager2);
        if (this.orientation == DividerOrientation.GRID || layoutManager2 instanceof GridLayoutManager && ((GridLayoutManager)layoutManager2).getOrientation() == 0 && this.orientation == DividerOrientation.HORIZONTAL || layoutManager2 instanceof GridLayoutManager && ((GridLayoutManager)layoutManager2).getOrientation() == 1 && this.orientation == DividerOrientation.VERTICAL) {
            RecyclerView.LayoutManager v;
            int n;
            RecyclerView.LayoutManager $i$f$getModelOrNull = layoutManager2;
            int rvOrientation = $i$f$getModelOrNull instanceof GridLayoutManager ? ((GridLayoutManager)layoutManager2).getOrientation() : ($i$f$getModelOrNull instanceof StaggeredGridLayoutManager ? ((StaggeredGridLayoutManager)layoutManager2).getOrientation() : 1);
            RecyclerView.LayoutManager layoutManager3 = layoutManager2;
            int spanCount = layoutManager3 instanceof GridLayoutManager ? ((GridLayoutManager)layoutManager2).getSpanCount() : (layoutManager3 instanceof StaggeredGridLayoutManager ? ((StaggeredGridLayoutManager)layoutManager2).getSpanCount() : 1);
            RecyclerView.LayoutManager layoutManager4 = layoutManager2;
            int spanGroupCount = layoutManager4 instanceof GridLayoutManager ? ((GridLayoutManager)layoutManager2).getSpanSizeLookup().getSpanGroupIndex(state.getItemCount() - 1, spanCount) + 1 : (layoutManager4 instanceof StaggeredGridLayoutManager ? (int)Math.ceil((float)state.getItemCount() / (float)spanCount) : 1);
            RecyclerView.LayoutManager layoutManager5 = layoutManager2;
            if (layoutManager5 instanceof GridLayoutManager) {
                n = ((GridLayoutManager)layoutManager2).getSpanSizeLookup().getSpanIndex(position, spanCount);
            } else if (layoutManager5 instanceof StaggeredGridLayoutManager) {
                View view2 = layoutManager2.findViewByPosition(position);
                if (view2 == null) {
                    return;
                }
                v = view2;
                ViewGroup.LayoutParams layoutParams = v.getLayoutParams();
                if (layoutParams == null) {
                    throw new NullPointerException("null cannot be cast to non-null type androidx.recyclerview.widget.StaggeredGridLayoutManager.LayoutParams");
                }
                n = ((StaggeredGridLayoutManager.LayoutParams)layoutParams).getSpanIndex();
            } else {
                n = 0;
            }
            int spanIndex = n;
            v = layoutManager2;
            int spanGroupIndex = v instanceof GridLayoutManager ? ((GridLayoutManager)layoutManager2).getSpanSizeLookup().getSpanGroupIndex(position, spanCount) : (v instanceof StaggeredGridLayoutManager ? (int)Math.ceil((float)(position + 1) / (float)spanCount) - 1 : 0);
            int spanSize = layoutManager2 instanceof GridLayoutManager ? ((GridLayoutManager)layoutManager2).getSpanSizeLookup().getSpanSize(position) : 1;
            int left = this.endVisible && rvOrientation == 1 ? width - spanIndex * width / spanCount : (this.startVisible && rvOrientation == 0 ? width - spanIndex * width / spanCount : spanIndex * width / spanCount);
            int right = this.endVisible && rvOrientation == 1 ? (spanIndex + spanSize) * width / spanCount : (this.startVisible && rvOrientation == 0 ? (spanIndex + spanSize) * width / spanCount : width - (spanIndex + spanSize) * width / spanCount);
            int top = layoutManager2 instanceof StaggeredGridLayoutManager ? (rvOrientation == 1 ? (edge.getTop() ? (this.startVisible ? height : 0) : 0) : (edge.getLeft() ? (this.endVisible ? width : 0) : 0)) : (this.startVisible && rvOrientation == 1 || this.endVisible && rvOrientation == 0 ? (reverseLayout ? (spanGroupIndex + 1) * height / spanGroupCount : height - spanGroupIndex * height / spanGroupCount) : (reverseLayout ? height - (spanGroupIndex + 1) * height / spanGroupCount : spanGroupIndex * height / spanGroupCount));
            int bottom = layoutManager2 instanceof StaggeredGridLayoutManager ? (rvOrientation == 1 ? (edge.getBottom() ? (this.startVisible ? height : 0) : height) : (edge.getRight() ? (this.endVisible ? width : 0) : height)) : (this.startVisible && rvOrientation == 1 || this.endVisible && rvOrientation == 0 ? (reverseLayout ? height - spanGroupIndex * height / spanGroupCount : (spanGroupIndex + 1) * height / spanGroupCount) : (reverseLayout ? spanGroupIndex * height / spanGroupCount : height - (spanGroupIndex + 1) * height / spanGroupCount));
            if (this.orientation == DividerOrientation.VERTICAL) {
                outRect.set(left, 0, right, 0);
            } else if (this.orientation == DividerOrientation.HORIZONTAL) {
                outRect.set(0, left, 0, right);
            } else if (rvOrientation == 1) {
                outRect.set(left, top, right, bottom);
            } else if (rvOrientation == 0) {
                outRect.set(top, left, bottom, right);
            }
        } else if (this.orientation == DividerOrientation.HORIZONTAL) {
            int top;
            int n = reverseLayout ? (this.endVisible && edge.getTop() || !edge.getTop() ? height : 0) : (top = this.startVisible && edge.getTop() ? height : 0);
            int bottom = reverseLayout ? (this.startVisible && edge.getBottom() ? height : 0) : (this.endVisible && edge.getBottom() || !edge.getBottom() ? height : 0);
            outRect.set(0, top, 0, bottom);
        } else if (this.orientation == DividerOrientation.VERTICAL) {
            int left = this.startVisible && edge.getLeft() ? width : 0;
            int right = this.endVisible && edge.getRight() || !edge.getRight() ? width : 0;
            outRect.set(left, 0, right, 0);
        }
    }

    public void onDraw(@NotNull Canvas canvas, @NotNull RecyclerView parent, @NotNull RecyclerView.State state) {
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        RecyclerView.LayoutManager layoutManager = parent.getLayoutManager();
        if (layoutManager == null || this.divider == null) {
            return;
        }
        this.adjustOrientation(layoutManager);
        boolean reverseLayout = this.isReverseLayout(layoutManager);
        switch (WhenMappings.$EnumSwitchMapping$0[this.orientation.ordinal()]) {
            case 1: {
                this.drawHorizontal(canvas, parent, reverseLayout);
                break;
            }
            case 2: {
                this.drawVertical(canvas, parent, reverseLayout);
                break;
            }
            case 3: {
                this.drawGrid(canvas, parent, reverseLayout);
            }
        }
    }

    private final void adjustOrientation(RecyclerView.LayoutManager layoutManager) {
        if (!(layoutManager instanceof GridLayoutManager) && layoutManager instanceof LinearLayoutManager) {
            LinearLayoutManager linearLayoutManager = layoutManager instanceof LinearLayoutManager ? (LinearLayoutManager)layoutManager : null;
            this.orientation = (linearLayoutManager == null ? false : linearLayoutManager.getOrientation() == 1) ? DividerOrientation.HORIZONTAL : DividerOrientation.VERTICAL;
        } else if (layoutManager instanceof StaggeredGridLayoutManager) {
            this.orientation = DividerOrientation.GRID;
        }
    }

    private final void drawHorizontal(Canvas canvas, RecyclerView parent, boolean reverseLayout) {
        canvas.save();
        int left = 0;
        int right = 0;
        if (parent.getClipToPadding()) {
            left = parent.getPaddingLeft() + this.marginStart;
            right = parent.getWidth() - parent.getPaddingRight() - this.marginEnd;
        } else {
            left = 0 + this.marginStart;
            right = parent.getWidth() - this.marginEnd;
        }
        int n = 0;
        int n2 = parent.getChildCount();
        while (n < n2) {
            Drawable drawable;
            RecyclerView.LayoutManager layoutManager;
            int i = n++;
            View child = parent.getChildAt(i);
            if (this.onEnabled != null) {
                boolean enabled;
                boolean bl;
                Object modelOrNull;
                BindingAdapter.BindingViewHolder vh;
                RecyclerView.ViewHolder viewHolder = parent.getChildViewHolder(child);
                if (viewHolder == null) {
                    throw new NullPointerException("null cannot be cast to non-null type com.drake.brv.BindingAdapter.BindingViewHolder");
                }
                BindingAdapter.BindingViewHolder this_$iv = vh = (BindingAdapter.BindingViewHolder)viewHolder;
                boolean $i$f$getModelOrNull = false;
                Object object = this_$iv.get_data();
                if (!(object instanceof Object)) {
                    object = modelOrNull = null;
                }
                if (!this.expandVisible && modelOrNull != null && modelOrNull instanceof ItemExpand && ((ItemExpand)modelOrNull).getItemExpand()) continue;
                Function1<? super BindingAdapter.BindingViewHolder, Boolean> function1 = this.onEnabled;
                if (function1 == null) {
                    bl = true;
                } else {
                    Boolean bl2 = (Boolean)function1.invoke((Object)vh);
                    bl = enabled = bl2 == null ? true : bl2;
                }
                if (!enabled) continue;
            }
            int position = parent.getChildAdapterPosition(child);
            if (parent.getLayoutManager() == null) {
                return;
            }
            Edge edge = Edge.Companion.computeEdge(position, layoutManager, reverseLayout);
            if (this.orientation != DividerOrientation.GRID && !this.endVisible && (reverseLayout ? edge.getTop() : edge.getBottom()) || this.divider == null) continue;
            Drawable $this$drawHorizontal_u24lambda_u2d2 = drawable;
            boolean bl = false;
            Rect decoratedBounds = new Rect();
            parent.getDecoratedBoundsWithMargins(child, decoratedBounds);
            int firstTop = 0;
            int firstBottom = 0;
            if (reverseLayout) {
                firstBottom = decoratedBounds.bottom;
                firstTop = $this$drawHorizontal_u24lambda_u2d2.getIntrinsicHeight() == -1 ? firstBottom - this.size : firstBottom - $this$drawHorizontal_u24lambda_u2d2.getIntrinsicHeight();
            } else {
                firstTop = decoratedBounds.top;
                firstBottom = $this$drawHorizontal_u24lambda_u2d2.getIntrinsicHeight() == -1 ? firstTop + this.size : firstTop + $this$drawHorizontal_u24lambda_u2d2.getIntrinsicHeight();
            }
            int top = 0;
            int bottom = 0;
            if (reverseLayout) {
                top = decoratedBounds.top;
                bottom = $this$drawHorizontal_u24lambda_u2d2.getIntrinsicHeight() == -1 ? top + this.size : top + $this$drawHorizontal_u24lambda_u2d2.getIntrinsicHeight();
            } else {
                bottom = decoratedBounds.bottom;
                int n3 = top = $this$drawHorizontal_u24lambda_u2d2.getIntrinsicHeight() == -1 ? bottom - this.size : bottom - $this$drawHorizontal_u24lambda_u2d2.getIntrinsicHeight();
            }
            if (this.getStartVisible() && (reverseLayout ? edge.getBottom() : edge.getTop())) {
                $this$drawHorizontal_u24lambda_u2d2.setBounds(left, firstTop, right, firstBottom);
                $this$drawHorizontal_u24lambda_u2d2.draw(canvas);
            }
            $this$drawHorizontal_u24lambda_u2d2.setBounds(left, top, right, bottom);
            $this$drawHorizontal_u24lambda_u2d2.draw(canvas);
        }
        canvas.restore();
    }

    private final void drawVertical(Canvas canvas, RecyclerView parent, boolean reverseLayout) {
        canvas.save();
        int top = 0;
        int bottom = 0;
        if (parent.getClipToPadding()) {
            top = parent.getPaddingTop() + this.marginStart;
            bottom = parent.getHeight() - parent.getPaddingBottom() - this.marginEnd;
        } else {
            top = 0 + this.marginStart;
            bottom = parent.getHeight() - this.marginEnd;
        }
        int childCount = parent.getChildCount();
        int n = 0;
        while (n < childCount) {
            int left;
            Drawable drawable;
            RecyclerView.LayoutManager layoutManager;
            int i = n++;
            View child = parent.getChildAt(i);
            if (this.onEnabled != null) {
                boolean enabled;
                boolean bl;
                Object modelOrNull;
                BindingAdapter.BindingViewHolder vh;
                RecyclerView.ViewHolder viewHolder = parent.getChildViewHolder(child);
                if (viewHolder == null) {
                    throw new NullPointerException("null cannot be cast to non-null type com.drake.brv.BindingAdapter.BindingViewHolder");
                }
                BindingAdapter.BindingViewHolder this_$iv = vh = (BindingAdapter.BindingViewHolder)viewHolder;
                boolean $i$f$getModelOrNull = false;
                Object object = this_$iv.get_data();
                if (!(object instanceof Object)) {
                    object = modelOrNull = null;
                }
                if (!this.expandVisible && modelOrNull != null && modelOrNull instanceof ItemExpand && ((ItemExpand)modelOrNull).getItemExpand()) continue;
                Function1<? super BindingAdapter.BindingViewHolder, Boolean> function1 = this.onEnabled;
                if (function1 == null) {
                    bl = true;
                } else {
                    Boolean bl2 = (Boolean)function1.invoke((Object)vh);
                    bl = enabled = bl2 == null ? true : bl2;
                }
                if (!enabled) continue;
            }
            int position = parent.getChildAdapterPosition(child);
            if (parent.getLayoutManager() == null) {
                return;
            }
            Edge edge = Edge.Companion.computeEdge(position, layoutManager, reverseLayout);
            if (this.orientation != DividerOrientation.GRID && !this.endVisible && edge.getRight() || this.divider == null) continue;
            Drawable $this$drawVertical_u24lambda_u2d3 = drawable;
            boolean bl = false;
            Rect decoratedBounds = new Rect();
            parent.getDecoratedBoundsWithMargins(child, decoratedBounds);
            int firstRight = $this$drawVertical_u24lambda_u2d3.getIntrinsicWidth() == -1 ? decoratedBounds.left + this.size : decoratedBounds.left + $this$drawVertical_u24lambda_u2d3.getIntrinsicWidth();
            int firstLeft = decoratedBounds.left;
            int right = MathKt.roundToInt((float)((float)decoratedBounds.right + child.getTranslationX()));
            int n2 = left = $this$drawVertical_u24lambda_u2d3.getIntrinsicWidth() == -1 ? right - this.size : right - $this$drawVertical_u24lambda_u2d3.getIntrinsicWidth();
            if (this.getStartVisible() && edge.getLeft()) {
                $this$drawVertical_u24lambda_u2d3.setBounds(firstLeft, top, firstRight, bottom);
                $this$drawVertical_u24lambda_u2d3.draw(canvas);
            }
            $this$drawVertical_u24lambda_u2d3.setBounds(left, top, right, bottom);
            $this$drawVertical_u24lambda_u2d3.draw(canvas);
        }
        canvas.restore();
    }

    private final void drawGrid(Canvas canvas, RecyclerView parent, boolean reverseLayout) {
        canvas.save();
        int childCount = parent.getChildCount();
        int n = 0;
        while (n < childCount) {
            int baseItemEndMargin;
            Drawable drawable;
            int width;
            RecyclerView.LayoutManager layoutManager;
            int position;
            int i = n++;
            View child = parent.getChildAt(i);
            if (this.onEnabled != null) {
                boolean enabled;
                boolean bl;
                Object modelOrNull;
                BindingAdapter.BindingViewHolder vh;
                RecyclerView.ViewHolder viewHolder = parent.getChildViewHolder(child);
                if (viewHolder == null) {
                    throw new NullPointerException("null cannot be cast to non-null type com.drake.brv.BindingAdapter.BindingViewHolder");
                }
                BindingAdapter.BindingViewHolder this_$iv = vh = (BindingAdapter.BindingViewHolder)viewHolder;
                boolean $i$f$getModelOrNull = false;
                Object object = this_$iv.get_data();
                if (!(object instanceof Object)) {
                    object = modelOrNull = null;
                }
                if (!this.expandVisible && modelOrNull != null && modelOrNull instanceof ItemExpand && ((ItemExpand)modelOrNull).getItemExpand()) continue;
                Function1<? super BindingAdapter.BindingViewHolder, Boolean> function1 = this.onEnabled;
                if (function1 == null) {
                    bl = true;
                } else {
                    Boolean bl2 = (Boolean)function1.invoke((Object)vh);
                    bl = bl2 == null ? true : bl2;
                }
                if (!(enabled = bl)) continue;
            }
            if ((position = parent.getChildAdapterPosition(child)) == -1) {
                parent.invalidateItemDecorations();
                continue;
            }
            if (parent.getLayoutManager() == null) {
                return;
            }
            Edge edge = Edge.Companion.computeEdge(position, layoutManager, reverseLayout);
            Drawable divider2 = this.divider;
            int height = divider2 == null ? this.size : (divider2.getIntrinsicHeight() != -1 ? divider2.getIntrinsicHeight() : (divider2.getIntrinsicWidth() != -1 ? divider2.getIntrinsicWidth() : this.size));
            int n2 = divider2 == null ? this.size : (divider2.getIntrinsicWidth() != -1 ? divider2.getIntrinsicWidth() : (width = divider2.getIntrinsicHeight() != -1 ? divider2.getIntrinsicHeight() : this.size));
            if (divider2 == null) continue;
            Drawable $this$drawGrid_u24lambda_u2d4 = drawable;
            boolean bl = false;
            ViewGroup.LayoutParams layoutParams = child.getLayoutParams();
            if (layoutParams == null) {
                throw new NullPointerException("null cannot be cast to non-null type androidx.recyclerview.widget.RecyclerView.LayoutParams");
            }
            RecyclerView.LayoutParams layoutParams2 = (RecyclerView.LayoutParams)layoutParams;
            Rect bounds = new Rect(child.getLeft() + layoutParams2.leftMargin, child.getTop() + layoutParams2.topMargin, child.getRight() + layoutParams2.rightMargin, child.getBottom() + layoutParams2.bottomMargin);
            int baseItemStartMargin = this.marginBaseItemStart && this.marginStart != 0 ? this.marginStart + height : 0;
            int n3 = baseItemEndMargin = this.marginBaseItemEnd && this.marginEnd != 0 ? this.marginEnd + width : 0;
            if (this.getStartVisible() && edge.getTop()) {
                $this$drawGrid_u24lambda_u2d4.setBounds(bounds.left - width, bounds.top - height, bounds.right + width, bounds.top);
                $this$drawGrid_u24lambda_u2d4.draw(canvas);
            } else if (!edge.getTop() && edge.getRight()) {
                $this$drawGrid_u24lambda_u2d4.setBounds(bounds.left - width + baseItemEndMargin, bounds.top - height, bounds.right - this.marginEnd, bounds.top);
                $this$drawGrid_u24lambda_u2d4.draw(canvas);
            } else if (!edge.getTop() && edge.getLeft()) {
                $this$drawGrid_u24lambda_u2d4.setBounds(bounds.left + this.marginEnd, bounds.top - height, bounds.right + width - baseItemEndMargin, bounds.top);
                $this$drawGrid_u24lambda_u2d4.draw(canvas);
            } else if (!edge.getTop()) {
                $this$drawGrid_u24lambda_u2d4.setBounds(bounds.left - width + baseItemEndMargin, bounds.top - height, bounds.right + width - baseItemEndMargin, bounds.top);
                $this$drawGrid_u24lambda_u2d4.draw(canvas);
            }
            if (this.getStartVisible() && edge.getBottom()) {
                $this$drawGrid_u24lambda_u2d4.setBounds(bounds.left - width, bounds.bottom, bounds.right + width, bounds.bottom + height);
                $this$drawGrid_u24lambda_u2d4.draw(canvas);
            } else if (!edge.getBottom() && edge.getRight()) {
                $this$drawGrid_u24lambda_u2d4.setBounds(bounds.left - width + baseItemEndMargin, bounds.bottom, bounds.right - this.marginEnd, bounds.bottom + height);
                $this$drawGrid_u24lambda_u2d4.draw(canvas);
            } else if (!edge.getBottom() && edge.getLeft()) {
                $this$drawGrid_u24lambda_u2d4.setBounds(bounds.left + this.marginEnd, bounds.bottom, bounds.right + width - baseItemEndMargin, bounds.bottom + height);
                $this$drawGrid_u24lambda_u2d4.draw(canvas);
            } else if (!edge.getBottom()) {
                $this$drawGrid_u24lambda_u2d4.setBounds(bounds.left - width + baseItemEndMargin, bounds.bottom, bounds.right + width - baseItemEndMargin, bounds.bottom + height);
                $this$drawGrid_u24lambda_u2d4.draw(canvas);
            }
            if (this.getEndVisible() && edge.getLeft()) {
                $this$drawGrid_u24lambda_u2d4.setBounds(bounds.left - width, bounds.top, bounds.left, bounds.bottom + height);
                $this$drawGrid_u24lambda_u2d4.draw(canvas);
            } else if (!edge.getLeft() && edge.getTop()) {
                $this$drawGrid_u24lambda_u2d4.setBounds(bounds.left - width, bounds.top + this.marginStart, bounds.left, bounds.bottom + height - baseItemStartMargin);
                $this$drawGrid_u24lambda_u2d4.draw(canvas);
            } else if (!edge.getLeft() && edge.getBottom()) {
                $this$drawGrid_u24lambda_u2d4.setBounds(bounds.left - width, bounds.top - height + baseItemStartMargin, bounds.left, bounds.bottom - this.marginStart);
                $this$drawGrid_u24lambda_u2d4.draw(canvas);
            } else if (!edge.getLeft()) {
                $this$drawGrid_u24lambda_u2d4.setBounds(bounds.left - width, bounds.top + baseItemStartMargin, bounds.left, bounds.bottom + height - baseItemStartMargin);
                $this$drawGrid_u24lambda_u2d4.draw(canvas);
            }
            if (this.getEndVisible() && edge.getRight()) {
                $this$drawGrid_u24lambda_u2d4.setBounds(bounds.right, bounds.top, bounds.right + width, bounds.bottom + height);
                $this$drawGrid_u24lambda_u2d4.draw(canvas);
                continue;
            }
            if (!edge.getRight() && edge.getTop()) {
                $this$drawGrid_u24lambda_u2d4.setBounds(bounds.right, bounds.top + this.marginStart, bounds.right + width, bounds.bottom + height - baseItemStartMargin);
                $this$drawGrid_u24lambda_u2d4.draw(canvas);
                continue;
            }
            if (!edge.getRight() && edge.getBottom()) {
                $this$drawGrid_u24lambda_u2d4.setBounds(bounds.right, bounds.top - height + baseItemStartMargin, bounds.right + width, bounds.bottom - this.marginStart);
                $this$drawGrid_u24lambda_u2d4.draw(canvas);
                continue;
            }
            if (edge.getRight()) continue;
            $this$drawGrid_u24lambda_u2d4.setBounds(bounds.right, bounds.top + baseItemStartMargin, bounds.right + width, bounds.bottom + height - baseItemStartMargin);
            $this$drawGrid_u24lambda_u2d4.draw(canvas);
        }
        canvas.restore();
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0016\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dB-\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0007J\t\u0010\u0012\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0003H\u00c6\u0003J1\u0010\u0016\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0017\u001a\u00020\u00032\b\u0010\u0018\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0019\u001a\u00020\u001aH\u00d6\u0001J\t\u0010\u001b\u001a\u00020\u001cH\u00d6\u0001R\u001a\u0010\u0006\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\t\"\u0004\b\r\u0010\u000bR\u001a\u0010\u0005\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\t\"\u0004\b\u000f\u0010\u000bR\u001a\u0010\u0004\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\t\"\u0004\b\u0011\u0010\u000b\u00a8\u0006\u001e"}, d2={"Lcom/drake/brv/DefaultDecoration$Edge;", "", "left", "", "top", "right", "bottom", "(ZZZZ)V", "getBottom", "()Z", "setBottom", "(Z)V", "getLeft", "setLeft", "getRight", "setRight", "getTop", "setTop", "component1", "component2", "component3", "component4", "copy", "equals", "other", "hashCode", "", "toString", "", "Companion", "brv_release"})
    public static final class Edge {
        @NotNull
        public static final Companion Companion = new Companion(null);
        private boolean left;
        private boolean top;
        private boolean right;
        private boolean bottom;

        public Edge(boolean left, boolean top, boolean right, boolean bottom) {
            this.left = left;
            this.top = top;
            this.right = right;
            this.bottom = bottom;
        }

        public /* synthetic */ Edge(boolean bl, boolean bl2, boolean bl3, boolean bl4, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                bl = false;
            }
            if ((n & 2) != 0) {
                bl2 = false;
            }
            if ((n & 4) != 0) {
                bl3 = false;
            }
            if ((n & 8) != 0) {
                bl4 = false;
            }
            this(bl, bl2, bl3, bl4);
        }

        public final boolean getLeft() {
            return this.left;
        }

        public final void setLeft(boolean bl) {
            this.left = bl;
        }

        public final boolean getTop() {
            return this.top;
        }

        public final void setTop(boolean bl) {
            this.top = bl;
        }

        public final boolean getRight() {
            return this.right;
        }

        public final void setRight(boolean bl) {
            this.right = bl;
        }

        public final boolean getBottom() {
            return this.bottom;
        }

        public final void setBottom(boolean bl) {
            this.bottom = bl;
        }

        public final boolean component1() {
            return this.left;
        }

        public final boolean component2() {
            return this.top;
        }

        public final boolean component3() {
            return this.right;
        }

        public final boolean component4() {
            return this.bottom;
        }

        @NotNull
        public final Edge copy(boolean left, boolean top, boolean right, boolean bottom) {
            return new Edge(left, top, right, bottom);
        }

        public static /* synthetic */ Edge copy$default(Edge edge, boolean bl, boolean bl2, boolean bl3, boolean bl4, int n, Object object) {
            if ((n & 1) != 0) {
                bl = edge.left;
            }
            if ((n & 2) != 0) {
                bl2 = edge.top;
            }
            if ((n & 4) != 0) {
                bl3 = edge.right;
            }
            if ((n & 8) != 0) {
                bl4 = edge.bottom;
            }
            return edge.copy(bl, bl2, bl3, bl4);
        }

        @NotNull
        public String toString() {
            return "Edge(left=" + this.left + ", top=" + this.top + ", right=" + this.right + ", bottom=" + this.bottom + ')';
        }

        public int hashCode() {
            int n;
            int result;
            int n2 = this.left ? 1 : 0;
            if (n2 != 0) {
                n2 = result = 1;
            }
            if ((n = this.top) != 0) {
                n = 1;
            }
            result = result * 31 + n;
            int n3 = this.right ? 1 : 0;
            if (n3 != 0) {
                n3 = 1;
            }
            result = result * 31 + n3;
            int n4 = this.bottom ? 1 : 0;
            if (n4 != 0) {
                n4 = 1;
            }
            result = result * 31 + n4;
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Edge)) {
                return false;
            }
            Edge edge = (Edge)other;
            if (this.left != edge.left) {
                return false;
            }
            if (this.top != edge.top) {
                return false;
            }
            if (this.right != edge.right) {
                return false;
            }
            return this.bottom == edge.bottom;
        }

        public Edge() {
            this(false, false, false, false, 15, null);
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n\u00a8\u0006\u000b"}, d2={"Lcom/drake/brv/DefaultDecoration$Edge$Companion;", "", "()V", "computeEdge", "Lcom/drake/brv/DefaultDecoration$Edge;", "position", "", "layoutManager", "Landroidx/recyclerview/widget/RecyclerView$LayoutManager;", "reverseLayout", "", "brv_release"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final Edge computeEdge(int position, @NotNull RecyclerView.LayoutManager layoutManager, boolean reverseLayout) {
                Edge edge;
                Intrinsics.checkNotNullParameter((Object)layoutManager, (String)"layoutManager");
                int index = position + 1;
                int itemCount = layoutManager.getItemCount();
                Edge $this$computeEdge_u24lambda_u2d0 = edge = new Edge(false, false, false, false, 15, null);
                boolean bl = false;
                RecyclerView.LayoutManager layoutManager2 = layoutManager;
                if (layoutManager2 instanceof StaggeredGridLayoutManager) {
                    int spanCount = ((StaggeredGridLayoutManager)layoutManager).getSpanCount();
                    View view = layoutManager.findViewByPosition(position);
                    if (view != null) {
                        View viewByPosition = view;
                        ViewGroup.LayoutParams layoutParams = viewByPosition.getLayoutParams();
                        if (layoutParams == null) {
                            throw new NullPointerException("null cannot be cast to non-null type androidx.recyclerview.widget.StaggeredGridLayoutManager.LayoutParams");
                        }
                        int spanIndex = ((StaggeredGridLayoutManager.LayoutParams)layoutParams).getSpanIndex() + 1;
                        if (((StaggeredGridLayoutManager)layoutManager).getOrientation() == 1) {
                            $this$computeEdge_u24lambda_u2d0.setLeft(spanIndex == 1);
                            $this$computeEdge_u24lambda_u2d0.setRight(spanIndex == spanCount);
                            $this$computeEdge_u24lambda_u2d0.setTop(reverseLayout ? index > itemCount - spanCount : index <= spanCount);
                            $this$computeEdge_u24lambda_u2d0.setBottom(reverseLayout ? index <= spanCount : index > itemCount - spanCount);
                        } else {
                            $this$computeEdge_u24lambda_u2d0.setLeft(index <= spanCount);
                            $this$computeEdge_u24lambda_u2d0.setRight(index > itemCount - spanCount);
                            $this$computeEdge_u24lambda_u2d0.setTop(reverseLayout ? spanIndex == spanCount : spanIndex == 1);
                            $this$computeEdge_u24lambda_u2d0.setBottom(reverseLayout ? spanIndex == 1 : spanIndex == spanCount);
                        }
                    }
                } else if (layoutManager2 instanceof GridLayoutManager) {
                    GridLayoutManager.SpanSizeLookup spanSizeLookup = ((GridLayoutManager)layoutManager).getSpanSizeLookup();
                    int spanCount = ((GridLayoutManager)layoutManager).getSpanCount();
                    int spanGroupIndex = spanSizeLookup.getSpanGroupIndex(position, spanCount);
                    int maxSpanGroupIndex = spanSizeLookup.getSpanGroupIndex(itemCount - 1, spanCount);
                    int spanIndex = spanSizeLookup.getSpanIndex(position, spanCount) + 1;
                    int spanSize = spanSizeLookup.getSpanSize(position);
                    if (((GridLayoutManager)layoutManager).getOrientation() == 1) {
                        $this$computeEdge_u24lambda_u2d0.setLeft(spanIndex == 1);
                        $this$computeEdge_u24lambda_u2d0.setRight(spanIndex + spanSize - 1 == spanCount);
                        $this$computeEdge_u24lambda_u2d0.setTop(reverseLayout ? spanGroupIndex == maxSpanGroupIndex : index <= spanCount && spanGroupIndex == spanSizeLookup.getSpanGroupIndex(position - 1, spanCount));
                        $this$computeEdge_u24lambda_u2d0.setBottom(reverseLayout ? index <= spanCount && spanGroupIndex == spanSizeLookup.getSpanGroupIndex(position - 1, spanCount) : spanGroupIndex == maxSpanGroupIndex);
                    } else {
                        $this$computeEdge_u24lambda_u2d0.setLeft(spanGroupIndex == 0);
                        $this$computeEdge_u24lambda_u2d0.setRight(spanGroupIndex == maxSpanGroupIndex);
                        $this$computeEdge_u24lambda_u2d0.setTop(reverseLayout ? spanIndex + spanSize - 1 == spanCount : spanIndex == 1);
                        $this$computeEdge_u24lambda_u2d0.setBottom(reverseLayout ? spanIndex == 1 : spanIndex + spanSize - 1 == spanCount);
                    }
                } else if (layoutManager2 instanceof LinearLayoutManager) {
                    if (((LinearLayoutManager)layoutManager).getOrientation() == 1) {
                        $this$computeEdge_u24lambda_u2d0.setLeft(true);
                        $this$computeEdge_u24lambda_u2d0.setRight(true);
                        $this$computeEdge_u24lambda_u2d0.setTop(reverseLayout ? index == itemCount : index == 1);
                        $this$computeEdge_u24lambda_u2d0.setBottom(reverseLayout ? index == 1 : index == itemCount);
                    } else {
                        $this$computeEdge_u24lambda_u2d0.setLeft(index == 1);
                        $this$computeEdge_u24lambda_u2d0.setRight(index == itemCount);
                        $this$computeEdge_u24lambda_u2d0.setTop(true);
                        $this$computeEdge_u24lambda_u2d0.setBottom(true);
                    }
                }
                return edge;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[DividerOrientation.values().length];
            nArray[DividerOrientation.HORIZONTAL.ordinal()] = 1;
            nArray[DividerOrientation.VERTICAL.ordinal()] = 2;
            nArray[DividerOrientation.GRID.ordinal()] = 3;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

