/*
 * Decompiled with CFR 0.152.
 */
package com.lxj.xpopup.animator;

import android.animation.TimeInterpolator;
import android.util.Log;
import android.view.View;
import android.view.ViewPropertyAnimator;
import androidx.interpolator.view.animation.FastOutSlowInInterpolator;
import com.lxj.xpopup.animator.PopupAnimator;
import com.lxj.xpopup.enums.PopupAnimation;

public class TranslateAnimator
extends PopupAnimator {
    public float startTranslationX;
    public float startTranslationY;
    public float endTranslationX;
    public float endTranslationY;

    public TranslateAnimator(View target, int animationDuration, PopupAnimation popupAnimation) {
        super(target, animationDuration, popupAnimation);
    }

    @Override
    public void initAnimator() {
        if (!this.hasInit) {
            this.endTranslationX = this.targetView.getTranslationX();
            this.endTranslationY = this.targetView.getTranslationY();
            this.applyTranslation();
            this.startTranslationX = this.targetView.getTranslationX();
            this.startTranslationY = this.targetView.getTranslationY();
        }
    }

    private void applyTranslation() {
        switch (this.popupAnimation) {
            case TranslateFromLeft: {
                this.targetView.setTranslationX((float)(-this.targetView.getRight()) + this.targetView.getTranslationX());
                break;
            }
            case TranslateFromTop: {
                this.targetView.setTranslationY((float)(-this.targetView.getBottom()) + this.targetView.getTranslationY());
                break;
            }
            case TranslateFromRight: {
                this.targetView.setTranslationX((float)(((View)this.targetView.getParent()).getMeasuredWidth() - this.targetView.getLeft()) + this.targetView.getTranslationX());
                break;
            }
            case TranslateFromBottom: {
                this.targetView.setTranslationY((float)(((View)this.targetView.getParent()).getMeasuredHeight() - this.targetView.getTop()) + this.targetView.getTranslationY());
            }
        }
    }

    @Override
    public void animateShow() {
        ViewPropertyAnimator animator = null;
        switch (this.popupAnimation) {
            case TranslateFromLeft: 
            case TranslateFromRight: {
                animator = this.targetView.animate().translationX(this.endTranslationX);
                break;
            }
            case TranslateFromTop: 
            case TranslateFromBottom: {
                animator = this.targetView.animate().translationY(this.endTranslationY);
            }
        }
        if (animator != null) {
            animator.setInterpolator((TimeInterpolator)new FastOutSlowInInterpolator()).setDuration((long)this.animationDuration).withLayer().start();
        }
        Log.e((String)"part", (String)("start: " + this.targetView.getTranslationY() + "  endy: " + this.endTranslationY));
    }

    @Override
    public void animateDismiss() {
        if (this.animating) {
            return;
        }
        ViewPropertyAnimator animator = null;
        switch (this.popupAnimation) {
            case TranslateFromLeft: {
                this.startTranslationX = -this.targetView.getRight();
                animator = this.targetView.animate().translationX(this.startTranslationX);
                break;
            }
            case TranslateFromTop: {
                this.startTranslationY = -this.targetView.getBottom();
                animator = this.targetView.animate().translationY(this.startTranslationY);
                break;
            }
            case TranslateFromRight: {
                this.startTranslationX = ((View)this.targetView.getParent()).getMeasuredWidth() - this.targetView.getLeft();
                animator = this.targetView.animate().translationX(this.startTranslationX);
                break;
            }
            case TranslateFromBottom: {
                this.startTranslationY = ((View)this.targetView.getParent()).getMeasuredHeight() - this.targetView.getTop();
                animator = this.targetView.animate().translationY(this.startTranslationY);
            }
        }
        if (animator != null) {
            this.observerAnimator(animator.setInterpolator((TimeInterpolator)new FastOutSlowInInterpolator()).setDuration((long)((double)this.animationDuration * 0.8)).withLayer()).start();
        }
    }
}

