/*
 * Decompiled with CFR 0.152.
 */
package com.lxj.xpopup.widget;

import android.content.Context;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.view.ViewCompat;
import androidx.customview.widget.ViewDragHelper;
import com.lxj.xpopup.enums.DragOrientation;

public class PositionPopupContainer
extends FrameLayout {
    private static final String TAG = "PositionPopupContainer";
    private ViewDragHelper dragHelper;
    public View child;
    public float dragRatio = 0.2f;
    private OnPositionDragListener positionDragListener;
    public boolean enableDrag = false;
    public DragOrientation dragOrientation = DragOrientation.DragToUp;
    int touchSlop;
    private float touchX;
    private float touchY;
    boolean canIntercept = false;
    ViewDragHelper.Callback cb = new ViewDragHelper.Callback(){

        public boolean tryCaptureView(@NonNull View view, int i) {
            return view == PositionPopupContainer.this.child && PositionPopupContainer.this.enableDrag;
        }

        public int getViewVerticalDragRange(@NonNull View child) {
            return PositionPopupContainer.this.dragOrientation == DragOrientation.DragToUp || PositionPopupContainer.this.dragOrientation == DragOrientation.DragToBottom ? 1 : 0;
        }

        public int getViewHorizontalDragRange(@NonNull View child) {
            return PositionPopupContainer.this.dragOrientation == DragOrientation.DragToLeft || PositionPopupContainer.this.dragOrientation == DragOrientation.DragToRight ? 1 : 0;
        }

        public int clampViewPositionVertical(@NonNull View child, int top, int dy) {
            if (PositionPopupContainer.this.dragOrientation == DragOrientation.DragToUp) {
                return dy < 0 ? top : 0;
            }
            return PositionPopupContainer.this.dragOrientation == DragOrientation.DragToBottom && dy > 0 ? top : 0;
        }

        public int clampViewPositionHorizontal(@NonNull View child, int left, int dx) {
            if (PositionPopupContainer.this.dragOrientation == DragOrientation.DragToLeft) {
                return dx < 0 ? left : 0;
            }
            return PositionPopupContainer.this.dragOrientation == DragOrientation.DragToRight && dx > 0 ? left : 0;
        }

        public void onViewPositionChanged(@NonNull View changedView, int left, int top, int dx, int dy) {
            super.onViewPositionChanged(changedView, left, top, dx, dy);
        }

        public void onViewReleased(@NonNull View releasedChild, float xvel, float yvel) {
            super.onViewReleased(releasedChild, xvel, yvel);
            float maxX = (float)releasedChild.getMeasuredWidth() * PositionPopupContainer.this.dragRatio;
            float maxY = (float)releasedChild.getMeasuredHeight() * PositionPopupContainer.this.dragRatio;
            if (PositionPopupContainer.this.dragOrientation == DragOrientation.DragToLeft && (float)releasedChild.getLeft() < -maxX || PositionPopupContainer.this.dragOrientation == DragOrientation.DragToRight && (float)releasedChild.getRight() > (float)releasedChild.getMeasuredWidth() + maxX || PositionPopupContainer.this.dragOrientation == DragOrientation.DragToUp && (float)releasedChild.getTop() < -maxY || PositionPopupContainer.this.dragOrientation == DragOrientation.DragToBottom && (float)releasedChild.getBottom() > (float)releasedChild.getMeasuredHeight() + maxY) {
                PositionPopupContainer.this.positionDragListener.onDismiss();
            } else {
                PositionPopupContainer.this.dragHelper.smoothSlideViewTo(releasedChild, 0, 0);
                ViewCompat.postInvalidateOnAnimation((View)PositionPopupContainer.this);
            }
        }
    };

    public PositionPopupContainer(@NonNull Context context) {
        this(context, null);
    }

    public PositionPopupContainer(@NonNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public PositionPopupContainer(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init();
    }

    private void init() {
        this.dragHelper = ViewDragHelper.create((ViewGroup)this, (ViewDragHelper.Callback)this.cb);
        this.touchSlop = ViewConfiguration.get((Context)this.getContext()).getScaledTouchSlop();
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        this.child = this.getChildAt(0);
    }

    public boolean dispatchTouchEvent(MotionEvent ev) {
        if (ev.getPointerCount() > 1 || !this.enableDrag) {
            return super.dispatchTouchEvent(ev);
        }
        try {
            switch (ev.getAction()) {
                case 0: {
                    this.touchX = ev.getX();
                    this.touchY = ev.getY();
                    break;
                }
                case 2: {
                    float dx = ev.getX() - this.touchX;
                    float dy = ev.getY() - this.touchY;
                    this.canIntercept = Math.sqrt(Math.pow(dx, 2.0) + Math.pow(dy, 2.0)) > (double)this.touchSlop;
                    this.touchX = ev.getX();
                    this.touchY = ev.getY();
                    break;
                }
                case 1: 
                case 3: {
                    this.touchX = 0.0f;
                    this.touchY = 0.0f;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return super.dispatchTouchEvent(ev);
    }

    public boolean onInterceptTouchEvent(MotionEvent ev) {
        if (!this.enableDrag) {
            return super.onInterceptTouchEvent(ev);
        }
        boolean result = this.dragHelper.shouldInterceptTouchEvent(ev);
        return this.dragHelper.shouldInterceptTouchEvent(ev) || this.canIntercept;
    }

    public boolean onTouchEvent(MotionEvent ev) {
        if (ev.getPointerCount() > 1 || !this.enableDrag) {
            return false;
        }
        try {
            this.dragHelper.processTouchEvent(ev);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return true;
    }

    public void computeScroll() {
        super.computeScroll();
        if (this.dragHelper.continueSettling(false)) {
            ViewCompat.postInvalidateOnAnimation((View)this);
        }
    }

    public void setOnPositionDragChangeListener(OnPositionDragListener positionDragListener) {
        this.positionDragListener = positionDragListener;
    }

    public static interface OnPositionDragListener {
        public void onDismiss();
    }
}

