/*
 * Decompiled with CFR 0.152.
 */
package com.lxj.xpopup.widget;

import android.content.Context;
import android.graphics.Rect;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewConfiguration;
import android.widget.FrameLayout;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.lxj.xpopup.core.BasePopupView;
import com.lxj.xpopup.interfaces.OnClickOutsideListener;
import com.lxj.xpopup.util.XPopupUtils;
import java.util.ArrayList;

public class PartShadowContainer
extends FrameLayout {
    public ArrayList<Rect> notDismissArea;
    public BasePopupView popupView;
    private float x;
    private float y;
    private OnClickOutsideListener listener;

    public PartShadowContainer(@NonNull Context context) {
        super(context);
    }

    public PartShadowContainer(@NonNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public PartShadowContainer(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    public boolean onTouchEvent(MotionEvent event) {
        View implView = this.getChildAt(0);
        int[] location = new int[2];
        implView.getLocationInWindow(location);
        Rect implViewRect = new Rect(location[0], location[1], location[0] + implView.getMeasuredWidth(), location[1] + implView.getMeasuredHeight());
        if (!XPopupUtils.isInRect(event.getRawX(), event.getRawY(), implViewRect)) {
            switch (event.getAction()) {
                case 0: {
                    this.x = event.getX();
                    this.y = event.getY();
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    float dx = event.getX() - this.x;
                    float dy = event.getY() - this.y;
                    float distance = (float)Math.sqrt(Math.pow(dx, 2.0) + Math.pow(dy, 2.0));
                    if (distance < (float)ViewConfiguration.get((Context)this.getContext()).getScaledTouchSlop()) {
                        if (this.notDismissArea != null && !this.notDismissArea.isEmpty()) {
                            boolean inRect = false;
                            for (Rect r : this.notDismissArea) {
                                if (!XPopupUtils.isInRect(event.getRawX(), event.getRawY(), r)) continue;
                                inRect = true;
                                break;
                            }
                            if (!inRect && this.listener != null) {
                                this.listener.onClickOutside();
                            }
                        } else if (this.listener != null) {
                            this.listener.onClickOutside();
                        }
                    }
                    this.x = 0.0f;
                    this.y = 0.0f;
                }
            }
        }
        return true;
    }

    public void setOnClickOutsideListener(OnClickOutsideListener listener) {
        this.listener = listener;
    }
}

