/*
 * Decompiled with CFR 0.152.
 */
package com.lxj.xpopup.util;

import android.annotation.TargetApi;
import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.provider.Settings;
import android.util.Log;
import android.view.MotionEvent;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.core.content.ContextCompat;
import com.lxj.xpopup.util.PermissionConstants;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public final class XPermission {
    private static List<String> PERMISSIONS;
    private static XPermission sInstance;
    private Context context;
    private OnRationaleListener mOnRationaleListener;
    private SimpleCallback mSimpleCallback;
    private FullCallback mFullCallback;
    private ThemeCallback mThemeCallback;
    private Set<String> mPermissions;
    private List<String> mPermissionsRequest;
    private List<String> mPermissionsGranted;
    private List<String> mPermissionsDenied;
    private List<String> mPermissionsDeniedForever;
    private static SimpleCallback sSimpleCallback4WriteSettings;
    private static SimpleCallback sSimpleCallback4DrawOverlays;

    public List<String> getPermissions() {
        return this.getPermissions(this.context.getPackageName());
    }

    public List<String> getPermissions(String packageName) {
        PackageManager pm = this.context.getPackageManager();
        try {
            String[] permissions = pm.getPackageInfo((String)packageName, (int)4096).requestedPermissions;
            if (permissions == null) {
                return Collections.emptyList();
            }
            return Arrays.asList(permissions);
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
            return Collections.emptyList();
        }
    }

    public boolean isGranted(String ... permissions) {
        for (String permission2 : permissions) {
            if (this.isGranted(permission2)) continue;
            return false;
        }
        return true;
    }

    private boolean isGranted(String permission2) {
        return Build.VERSION.SDK_INT < 23 || 0 == ContextCompat.checkSelfPermission((Context)this.context, (String)permission2);
    }

    @RequiresApi(api=23)
    public boolean isGrantedWriteSettings() {
        return Settings.System.canWrite((Context)this.context);
    }

    @RequiresApi(api=23)
    public void requestWriteSettings(SimpleCallback callback) {
        if (this.isGrantedWriteSettings()) {
            if (callback != null) {
                callback.onGranted();
            }
            return;
        }
        sSimpleCallback4WriteSettings = callback;
        PermissionActivity.start(this.context, 2);
    }

    @TargetApi(value=23)
    private void startWriteSettingsActivity(Activity activity, int requestCode) {
        Intent intent = new Intent("android.settings.action.MANAGE_WRITE_SETTINGS");
        intent.setData(Uri.parse((String)("package:" + this.context.getPackageName())));
        if (!this.isIntentAvailable(intent)) {
            this.launchAppDetailsSettings();
            return;
        }
        activity.startActivityForResult(intent, requestCode);
    }

    @RequiresApi(api=23)
    public boolean isGrantedDrawOverlays() {
        return Settings.canDrawOverlays((Context)this.context);
    }

    @RequiresApi(api=23)
    public void requestDrawOverlays(SimpleCallback callback) {
        if (this.isGrantedDrawOverlays()) {
            if (callback != null) {
                callback.onGranted();
            }
            return;
        }
        sSimpleCallback4DrawOverlays = callback;
        PermissionActivity.start(this.context, 3);
    }

    @TargetApi(value=23)
    private void startOverlayPermissionActivity(Activity activity, int requestCode) {
        Intent intent = new Intent("android.settings.action.MANAGE_OVERLAY_PERMISSION");
        intent.setData(Uri.parse((String)("package:" + this.context.getPackageName())));
        if (!this.isIntentAvailable(intent)) {
            this.launchAppDetailsSettings();
            return;
        }
        activity.startActivityForResult(intent, requestCode);
    }

    public void launchAppDetailsSettings() {
        Intent intent = new Intent("android.settings.APPLICATION_DETAILS_SETTINGS");
        intent.setData(Uri.parse((String)("package:" + this.context.getPackageName())));
        if (!this.isIntentAvailable(intent)) {
            return;
        }
        this.context.startActivity(intent.addFlags(0x10000000));
    }

    public static XPermission create(Context context, String ... permissions) {
        if (sInstance == null) {
            return new XPermission(context, permissions);
        }
        sInstance.prepare(permissions);
        return sInstance;
    }

    private boolean isIntentAvailable(Intent intent) {
        return this.context.getPackageManager().queryIntentActivities(intent, 65536).size() > 0;
    }

    private XPermission(Context ctx, String ... permissions) {
        sInstance = this;
        this.context = ctx;
        this.prepare(permissions);
    }

    private void prepare(String ... permissions) {
        this.mPermissions = new LinkedHashSet<String>();
        PERMISSIONS = this.getPermissions();
        if (permissions == null) {
            return;
        }
        for (String permission2 : permissions) {
            for (String aPermission : PermissionConstants.getPermissions(permission2)) {
                if (!PERMISSIONS.contains(aPermission)) continue;
                this.mPermissions.add(aPermission);
            }
        }
    }

    public XPermission rationale(OnRationaleListener listener) {
        this.mOnRationaleListener = listener;
        return this;
    }

    public XPermission callback(SimpleCallback callback) {
        this.mSimpleCallback = callback;
        return this;
    }

    public XPermission callback(FullCallback callback) {
        this.mFullCallback = callback;
        return this;
    }

    public void request() {
        this.mPermissionsGranted = new ArrayList<String>();
        this.mPermissionsRequest = new ArrayList<String>();
        if (Build.VERSION.SDK_INT < 23) {
            this.mPermissionsGranted.addAll(this.mPermissions);
            this.requestCallback();
        } else {
            for (String permission2 : this.mPermissions) {
                if (this.isGranted(permission2)) {
                    this.mPermissionsGranted.add(permission2);
                    continue;
                }
                this.mPermissionsRequest.add(permission2);
            }
            if (this.mPermissionsRequest.isEmpty()) {
                this.requestCallback();
            } else {
                this.startPermissionActivity();
            }
        }
    }

    @RequiresApi(api=23)
    private void startPermissionActivity() {
        this.mPermissionsDenied = new ArrayList<String>();
        this.mPermissionsDeniedForever = new ArrayList<String>();
        PermissionActivity.start(this.context, 1);
    }

    @RequiresApi(api=23)
    private boolean rationale(Activity activity) {
        boolean isRationale = false;
        if (this.mOnRationaleListener != null) {
            for (String permission2 : this.mPermissionsRequest) {
                if (!activity.shouldShowRequestPermissionRationale(permission2)) continue;
                this.getPermissionsStatus(activity);
                this.mOnRationaleListener.rationale(new OnRationaleListener.ShouldRequest(){

                    @Override
                    public void again(boolean again) {
                        if (again) {
                            XPermission.this.startPermissionActivity();
                        } else {
                            XPermission.this.requestCallback();
                        }
                    }
                });
                isRationale = true;
                break;
            }
            this.mOnRationaleListener = null;
        }
        return isRationale;
    }

    private void getPermissionsStatus(Activity activity) {
        for (String permission2 : this.mPermissionsRequest) {
            if (this.isGranted(permission2)) {
                this.mPermissionsGranted.add(permission2);
                continue;
            }
            this.mPermissionsDenied.add(permission2);
            if (activity.shouldShowRequestPermissionRationale(permission2)) continue;
            this.mPermissionsDeniedForever.add(permission2);
        }
    }

    private void requestCallback() {
        if (this.mSimpleCallback != null) {
            if (this.mPermissionsRequest.size() == 0 || this.mPermissions.size() == this.mPermissionsGranted.size()) {
                this.mSimpleCallback.onGranted();
            } else if (!this.mPermissionsDenied.isEmpty()) {
                this.mSimpleCallback.onDenied();
            }
            this.mSimpleCallback = null;
        }
        if (this.mFullCallback != null) {
            if (this.mPermissionsRequest.size() == 0 || this.mPermissions.size() == this.mPermissionsGranted.size()) {
                this.mFullCallback.onGranted(this.mPermissionsGranted);
            } else if (!this.mPermissionsDenied.isEmpty()) {
                this.mFullCallback.onDenied(this.mPermissionsDeniedForever, this.mPermissionsDenied);
            }
            this.mFullCallback = null;
        }
        this.mOnRationaleListener = null;
        this.mThemeCallback = null;
    }

    private void onRequestPermissionsResult(Activity activity) {
        this.getPermissionsStatus(activity);
        this.requestCallback();
    }

    public static interface ThemeCallback {
        public void onActivityCreate(Activity var1);
    }

    public static interface FullCallback {
        public void onGranted(List<String> var1);

        public void onDenied(List<String> var1, List<String> var2);
    }

    public static interface SimpleCallback {
        public void onGranted();

        public void onDenied();
    }

    public static interface OnRationaleListener {
        public void rationale(ShouldRequest var1);

        public static interface ShouldRequest {
            public void again(boolean var1);
        }
    }

    @RequiresApi(api=23)
    public static class PermissionActivity
    extends Activity {
        private static final String TYPE = "TYPE";
        public static final int TYPE_RUNTIME = 1;
        public static final int TYPE_WRITE_SETTINGS = 2;
        public static final int TYPE_DRAW_OVERLAYS = 3;

        public static void start(Context context, int type) {
            Intent starter = new Intent(context, PermissionActivity.class);
            starter.addFlags(0x10000000);
            starter.putExtra(TYPE, type);
            context.startActivity(starter);
        }

        protected void onCreate(@Nullable Bundle savedInstanceState) {
            this.getWindow().addFlags(262672);
            this.getWindow().getAttributes().alpha = 0.0f;
            int byteExtra = this.getIntent().getIntExtra(TYPE, 1);
            if (byteExtra == 1) {
                if (sInstance == null) {
                    super.onCreate(savedInstanceState);
                    Log.e((String)"XPermission", (String)"request permissions failed");
                    this.finish();
                    return;
                }
                if (sInstance.mThemeCallback != null) {
                    sInstance.mThemeCallback.onActivityCreate(this);
                }
                super.onCreate(savedInstanceState);
                if (sInstance.rationale(this)) {
                    this.finish();
                    return;
                }
                if (sInstance.mPermissionsRequest != null) {
                    int size = sInstance.mPermissionsRequest.size();
                    if (size <= 0) {
                        this.finish();
                        return;
                    }
                    this.requestPermissions(sInstance.mPermissionsRequest.toArray(new String[size]), 1);
                }
            } else if (byteExtra == 2) {
                super.onCreate(savedInstanceState);
                sInstance.startWriteSettingsActivity(this, 2);
            } else if (byteExtra == 3) {
                super.onCreate(savedInstanceState);
                sInstance.startOverlayPermissionActivity(this, 3);
            }
        }

        public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
            sInstance.onRequestPermissionsResult(this);
            this.finish();
        }

        public boolean dispatchTouchEvent(MotionEvent ev) {
            this.finish();
            return true;
        }

        protected void onActivityResult(int requestCode, int resultCode, Intent data) {
            if (requestCode == 2) {
                if (sSimpleCallback4WriteSettings == null) {
                    return;
                }
                if (sInstance.isGrantedWriteSettings()) {
                    sSimpleCallback4WriteSettings.onGranted();
                } else {
                    sSimpleCallback4WriteSettings.onDenied();
                }
                sSimpleCallback4WriteSettings = null;
            } else if (requestCode == 3) {
                if (sSimpleCallback4DrawOverlays == null) {
                    return;
                }
                if (sInstance.isGrantedDrawOverlays()) {
                    sSimpleCallback4DrawOverlays.onGranted();
                } else {
                    sSimpleCallback4DrawOverlays.onDenied();
                }
                sSimpleCallback4DrawOverlays = null;
            }
            this.finish();
        }
    }
}

