/*
 * Decompiled with CFR 0.152.
 */
package com.lxj.xpopup.widget;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.v4.view.ViewCompat;
import android.support.v4.widget.ViewDragHelper;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import com.lxj.xpopup.animator.ShadowBgAnimator;

public class PopupDrawerLayout
extends FrameLayout {
    ViewDragHelper dragHelper;
    View child;
    Position position = Position.Left;
    ShadowBgAnimator bgAnimator = new ShadowBgAnimator();
    ViewDragHelper.Callback callback = new ViewDragHelper.Callback(){

        public boolean tryCaptureView(@NonNull View view, int i) {
            return true;
        }

        public int getViewHorizontalDragRange(@NonNull View child) {
            return 1;
        }

        public int clampViewPositionHorizontal(@NonNull View child, int left, int dx) {
            if (PopupDrawerLayout.this.position == Position.Left) {
                if (left < -child.getMeasuredWidth()) {
                    left = -child.getMeasuredWidth();
                }
                if (left > 0) {
                    left = 0;
                }
            } else {
                if (left < PopupDrawerLayout.this.getMeasuredWidth() - child.getMeasuredWidth()) {
                    left = PopupDrawerLayout.this.getMeasuredWidth() - child.getMeasuredWidth();
                }
                if (left > PopupDrawerLayout.this.getMeasuredWidth()) {
                    left = PopupDrawerLayout.this.getMeasuredWidth();
                }
            }
            return left;
        }

        public void onViewPositionChanged(@NonNull View changedView, int left, int top, int dx, int dy) {
            super.onViewPositionChanged(changedView, left, top, dx, dy);
            float fraction = 0.0f;
            if (PopupDrawerLayout.this.position == Position.Left) {
                fraction = (float)(left + PopupDrawerLayout.this.child.getMeasuredWidth()) * 1.0f / (float)PopupDrawerLayout.this.child.getMeasuredWidth();
                if (left == -PopupDrawerLayout.this.child.getMeasuredWidth() && PopupDrawerLayout.this.listener != null) {
                    PopupDrawerLayout.this.listener.onClose();
                }
            } else {
                fraction = (float)(left - PopupDrawerLayout.this.getMeasuredWidth()) * 1.0f / (float)(-PopupDrawerLayout.this.child.getMeasuredWidth());
                if (left == PopupDrawerLayout.this.getMeasuredWidth() && PopupDrawerLayout.this.listener != null) {
                    PopupDrawerLayout.this.listener.onClose();
                }
            }
            PopupDrawerLayout.this.setBackgroundColor(PopupDrawerLayout.this.bgAnimator.calculateBgColor(fraction));
            if (PopupDrawerLayout.this.listener != null) {
                PopupDrawerLayout.this.listener.onDismissing(fraction);
            }
        }

        public void onViewReleased(@NonNull View releasedChild, float xvel, float yvel) {
            super.onViewReleased(releasedChild, xvel, yvel);
            int centerLeft = 0;
            if (PopupDrawerLayout.this.position == Position.Left) {
                if (xvel < -1000.0f) {
                    PopupDrawerLayout.this.dragHelper.smoothSlideViewTo(releasedChild, -PopupDrawerLayout.this.child.getMeasuredWidth(), releasedChild.getTop());
                } else {
                    centerLeft = -PopupDrawerLayout.this.child.getMeasuredWidth() / 2;
                    int finalLeft = releasedChild.getLeft() < centerLeft ? -PopupDrawerLayout.this.child.getMeasuredWidth() : 0;
                    PopupDrawerLayout.this.dragHelper.smoothSlideViewTo(releasedChild, finalLeft, releasedChild.getTop());
                }
            } else if (xvel > 1000.0f) {
                PopupDrawerLayout.this.dragHelper.smoothSlideViewTo(releasedChild, PopupDrawerLayout.this.getMeasuredWidth(), releasedChild.getTop());
            } else {
                centerLeft = PopupDrawerLayout.this.getMeasuredWidth() + PopupDrawerLayout.this.child.getMeasuredWidth() / 2;
                int finalLeft = releasedChild.getLeft() < centerLeft ? PopupDrawerLayout.this.getMeasuredWidth() : PopupDrawerLayout.this.getMeasuredWidth() + PopupDrawerLayout.this.child.getMeasuredWidth();
                PopupDrawerLayout.this.dragHelper.smoothSlideViewTo(releasedChild, finalLeft, releasedChild.getTop());
            }
            ViewCompat.postInvalidateOnAnimation((View)PopupDrawerLayout.this);
        }
    };
    private OnCloseListener listener;

    public PopupDrawerLayout(Context context) {
        this(context, null);
    }

    public PopupDrawerLayout(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public PopupDrawerLayout(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.dragHelper = ViewDragHelper.create((ViewGroup)this, (ViewDragHelper.Callback)this.callback);
    }

    public void setDrawerPosition(Position position) {
        this.position = position;
    }

    protected void onFinishInflate() {
        super.onFinishInflate();
        this.child = this.getChildAt(0);
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        if (this.position == Position.Left) {
            this.child.layout(-this.child.getMeasuredWidth(), 0, 0, this.getMeasuredHeight());
        } else {
            this.child.layout(this.getMeasuredWidth(), 0, this.getMeasuredWidth() + this.child.getMeasuredWidth(), this.getMeasuredHeight());
        }
    }

    public boolean onInterceptTouchEvent(MotionEvent ev) {
        return this.dragHelper.shouldInterceptTouchEvent(ev);
    }

    public boolean onTouchEvent(MotionEvent event) {
        this.dragHelper.processTouchEvent(event);
        return super.onTouchEvent(event);
    }

    public void computeScroll() {
        super.computeScroll();
        if (this.dragHelper.continueSettling(true)) {
            ViewCompat.postInvalidateOnAnimation((View)this);
        }
    }

    public void open() {
        this.post(new Runnable(){

            @Override
            public void run() {
                PopupDrawerLayout.this.dragHelper.smoothSlideViewTo(PopupDrawerLayout.this.child, PopupDrawerLayout.this.position == Position.Left ? 0 : PopupDrawerLayout.this.getMeasuredWidth() - PopupDrawerLayout.this.child.getMeasuredWidth(), PopupDrawerLayout.this.getTop());
                ViewCompat.postInvalidateOnAnimation((View)PopupDrawerLayout.this);
            }
        });
    }

    public void close() {
        this.post(new Runnable(){

            @Override
            public void run() {
                PopupDrawerLayout.this.dragHelper.smoothSlideViewTo(PopupDrawerLayout.this.child, PopupDrawerLayout.this.position == Position.Left ? -PopupDrawerLayout.this.child.getMeasuredWidth() : PopupDrawerLayout.this.getMeasuredWidth(), PopupDrawerLayout.this.getTop());
                ViewCompat.postInvalidateOnAnimation((View)PopupDrawerLayout.this);
            }
        });
    }

    public void setOnCloseListener(OnCloseListener listener) {
        this.listener = listener;
    }

    public static interface OnCloseListener {
        public void onClose();

        public void onDismissing(float var1);
    }

    public static enum Position {
        Left,
        Right;

    }
}

