/*
 * Decompiled with CFR 0.152.
 */
package com.lxj.xpopup.animator;

import android.animation.TimeInterpolator;
import android.support.v4.view.animation.FastOutSlowInInterpolator;
import android.view.View;
import com.lxj.xpopup.animator.PopupAnimator;
import com.lxj.xpopup.enums.PopupAnimation;

public class TranslateAnimator
extends PopupAnimator {
    private float startTranslationX;
    private float startTranslationY;

    public TranslateAnimator(View target, PopupAnimation popupAnimation) {
        super(target, popupAnimation);
    }

    @Override
    public void initAnimator() {
        this.applyTranslation();
        this.startTranslationX = this.targetView.getTranslationX();
        this.startTranslationY = this.targetView.getTranslationY();
    }

    private void applyTranslation() {
        switch (this.popupAnimation) {
            case TranslateFromLeft: {
                this.targetView.setTranslationX((float)(-this.targetView.getRight()));
                break;
            }
            case TranslateFromTop: {
                this.targetView.setTranslationY((float)(-this.targetView.getBottom()));
                break;
            }
            case TranslateFromRight: {
                this.targetView.setTranslationX((float)(((View)this.targetView.getParent()).getMeasuredWidth() - this.targetView.getLeft()));
                break;
            }
            case TranslateFromBottom: {
                this.targetView.setTranslationY((float)(((View)this.targetView.getParent()).getMeasuredHeight() - this.targetView.getTop()));
            }
        }
    }

    @Override
    public void animateShow() {
        this.targetView.animate().translationX(0.0f).translationY(0.0f).setInterpolator((TimeInterpolator)new FastOutSlowInInterpolator()).setDuration((long)this.animateDuration).start();
    }

    @Override
    public void animateDismiss() {
        this.targetView.animate().translationX(this.startTranslationX).translationY(this.startTranslationY).setInterpolator((TimeInterpolator)new FastOutSlowInInterpolator()).setDuration((long)this.animateDuration).start();
    }
}

