/*
 * Decompiled with CFR 0.152.
 */
package io.palaima.debugdrawer.view;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import io.palaima.debugdrawer.base.DebugModule;

public class DebugView
extends LinearLayout {
    private DebugModule[] drawerItems;

    public DebugView(Context context) {
        this(context, null);
        this.setOrientation(1);
    }

    public DebugView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
        this.setOrientation(1);
    }

    public DebugView(Context context, AttributeSet attrSet, int defStyleAttr) {
        super(context, attrSet, defStyleAttr);
        this.setOrientation(1);
        int[] attrs = new int[]{16842836};
        TypedArray a = context.obtainStyledAttributes(attrSet, attrs);
        Drawable windowBackground = a.getDrawable(0);
        a.recycle();
        this.setBackgroundDrawable(windowBackground);
    }

    public void onResume() {
        if (this.drawerItems != null) {
            for (DebugModule drawerItem : this.drawerItems) {
                drawerItem.onResume();
            }
        }
    }

    public void onPause() {
        if (this.drawerItems != null) {
            for (DebugModule drawerItem : this.drawerItems) {
                drawerItem.onPause();
            }
        }
    }

    public void onStart() {
        if (this.drawerItems != null) {
            for (DebugModule drawerItem : this.drawerItems) {
                drawerItem.onStart();
            }
        }
    }

    public void onStop() {
        if (this.drawerItems != null) {
            for (DebugModule drawerItem : this.drawerItems) {
                drawerItem.onStop();
            }
        }
    }

    public void modules(DebugModule ... drawerItems) {
        this.drawerItems = drawerItems;
        if (this.drawerItems != null && this.drawerItems.length != 0) {
            LayoutInflater inflater = LayoutInflater.from((Context)this.getContext());
            for (int i = 0; i < this.drawerItems.length; ++i) {
                DebugModule drawerItem = this.drawerItems[i];
                this.addView(drawerItem.onCreateView(inflater, (ViewGroup)this));
            }
        }
    }
}

