/*
 * Decompiled with CFR 0.152.
 */
package lecho.lib.hellocharts.model;

import java.util.Arrays;
import lecho.lib.hellocharts.util.ChartUtils;

public class SubcolumnValue {
    private float value;
    private float originValue;
    private float diff;
    private int color = ChartUtils.DEFAULT_COLOR;
    private int darkenColor = ChartUtils.DEFAULT_DARKEN_COLOR;
    private char[] label;

    public SubcolumnValue() {
        this.setValue(0.0f);
    }

    public SubcolumnValue(float value) {
        this.setValue(value);
    }

    public SubcolumnValue(float value, int color) {
        this.setValue(value);
        this.setColor(color);
    }

    public SubcolumnValue(SubcolumnValue columnValue) {
        this.setValue(columnValue.value);
        this.setColor(columnValue.color);
        this.label = columnValue.label;
    }

    public void update(float scale) {
        this.value = this.originValue + this.diff * scale;
    }

    public void finish() {
        this.setValue(this.originValue + this.diff);
    }

    public float getValue() {
        return this.value;
    }

    public SubcolumnValue setValue(float value) {
        this.value = value;
        this.originValue = value;
        this.diff = 0.0f;
        return this;
    }

    public SubcolumnValue setTarget(float target) {
        this.setValue(this.value);
        this.diff = target - this.originValue;
        return this;
    }

    public int getColor() {
        return this.color;
    }

    public SubcolumnValue setColor(int color) {
        this.color = color;
        this.darkenColor = ChartUtils.darkenColor(color);
        return this;
    }

    public int getDarkenColor() {
        return this.darkenColor;
    }

    @Deprecated
    public char[] getLabel() {
        return this.label;
    }

    public char[] getLabelAsChars() {
        return this.label;
    }

    @Deprecated
    public SubcolumnValue setLabel(char[] label) {
        this.label = label;
        return this;
    }

    public SubcolumnValue setLabel(String label) {
        this.label = label.toCharArray();
        return this;
    }

    public String toString() {
        return "ColumnValue [value=" + this.value + "]";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SubcolumnValue that = (SubcolumnValue)o;
        if (this.color != that.color) {
            return false;
        }
        if (this.darkenColor != that.darkenColor) {
            return false;
        }
        if (Float.compare(that.diff, this.diff) != 0) {
            return false;
        }
        if (Float.compare(that.originValue, this.originValue) != 0) {
            return false;
        }
        if (Float.compare(that.value, this.value) != 0) {
            return false;
        }
        return Arrays.equals(this.label, that.label);
    }

    public int hashCode() {
        int result = this.value != 0.0f ? Float.floatToIntBits(this.value) : 0;
        result = 31 * result + (this.originValue != 0.0f ? Float.floatToIntBits(this.originValue) : 0);
        result = 31 * result + (this.diff != 0.0f ? Float.floatToIntBits(this.diff) : 0);
        result = 31 * result + this.color;
        result = 31 * result + this.darkenColor;
        result = 31 * result + (this.label != null ? Arrays.hashCode(this.label) : 0);
        return result;
    }
}

