/*
 * Decompiled with CFR 0.152.
 */
package lecho.lib.hellocharts.model;

import java.util.ArrayList;
import java.util.List;
import lecho.lib.hellocharts.model.AbstractChartData;
import lecho.lib.hellocharts.model.Column;
import lecho.lib.hellocharts.model.SubcolumnValue;

public class ColumnChartData
extends AbstractChartData {
    public static final float DEFAULT_FILL_RATIO = 0.75f;
    private float fillRatio = 0.75f;
    public static final float DEFAULT_BASE_VALUE = 0.0f;
    private float baseValue = 0.0f;
    private List<Column> columns = new ArrayList<Column>();
    private boolean isStacked = false;

    public ColumnChartData() {
    }

    public ColumnChartData(List<Column> columns) {
        this.setColumns(columns);
    }

    public ColumnChartData(ColumnChartData data) {
        super(data);
        this.isStacked = data.isStacked;
        this.fillRatio = data.fillRatio;
        for (Column column : data.columns) {
            this.columns.add(new Column(column));
        }
    }

    public static ColumnChartData generateDummyData() {
        int numColumns = 4;
        ColumnChartData data = new ColumnChartData();
        ArrayList<Column> columns = new ArrayList<Column>(4);
        for (int i = 1; i <= 4; ++i) {
            ArrayList<SubcolumnValue> values = new ArrayList<SubcolumnValue>(4);
            values.add(new SubcolumnValue(i));
            Column column = new Column(values);
            columns.add(column);
        }
        data.setColumns(columns);
        return data;
    }

    @Override
    public void update(float scale) {
        for (Column column : this.columns) {
            column.update(scale);
        }
    }

    @Override
    public void finish() {
        for (Column column : this.columns) {
            column.finish();
        }
    }

    public List<Column> getColumns() {
        return this.columns;
    }

    public ColumnChartData setColumns(List<Column> columns) {
        this.columns = null == columns ? new ArrayList<Column>() : columns;
        return this;
    }

    public boolean isStacked() {
        return this.isStacked;
    }

    public ColumnChartData setStacked(boolean isStacked) {
        this.isStacked = isStacked;
        return this;
    }

    public float getFillRatio() {
        return this.fillRatio;
    }

    public ColumnChartData setFillRatio(float fillRatio) {
        if (fillRatio < 0.0f) {
            fillRatio = 0.0f;
        }
        if (fillRatio > 1.0f) {
            fillRatio = 1.0f;
        }
        this.fillRatio = fillRatio;
        return this;
    }

    public float getBaseValue() {
        return this.baseValue;
    }

    public ColumnChartData setBaseValue(float baseValue) {
        this.baseValue = baseValue;
        return this;
    }
}

