/*
 * Decompiled with CFR 0.152.
 */
package lecho.lib.hellocharts.util;

import android.content.Context;
import android.graphics.Color;
import android.util.DisplayMetrics;
import android.util.TypedValue;

public abstract class ChartUtils {
    public static final int DEFAULT_COLOR = Color.parseColor((String)"#DFDFDF");
    public static final int DEFAULT_DARKEN_COLOR = Color.parseColor((String)"#DDDDDD");
    public static final int COLOR_BLUE = Color.parseColor((String)"#33B5E5");
    public static final int COLOR_VIOLET = Color.parseColor((String)"#AA66CC");
    public static final int COLOR_GREEN = Color.parseColor((String)"#99CC00");
    public static final int COLOR_ORANGE = Color.parseColor((String)"#FFBB33");
    public static final int COLOR_RED = Color.parseColor((String)"#FF4444");
    public static final int[] COLORS = new int[]{COLOR_BLUE, COLOR_VIOLET, COLOR_GREEN, COLOR_ORANGE, COLOR_RED};
    private static final float DARKEN_SATURATION = 1.1f;
    private static final float DARKEN_INTENSITY = 0.9f;
    private static int COLOR_INDEX = 0;

    public static final int pickColor() {
        return COLORS[(int)Math.round(Math.random() * (double)(COLORS.length - 1))];
    }

    public static final int nextColor() {
        if (COLOR_INDEX >= COLORS.length) {
            COLOR_INDEX = 0;
        }
        return COLORS[COLOR_INDEX++];
    }

    public static int dp2px(float density, int dp) {
        if (dp == 0) {
            return 1;
        }
        return (int)((float)dp * density + 0.5f);
    }

    public static int px2dp(float density, int px) {
        return (int)Math.ceil((float)px / density);
    }

    public static int sp2px(float scaledDensity, int sp) {
        return (int)((float)sp * scaledDensity + 0.5f);
    }

    public static int px2sp(float scaledDensity, int px) {
        return (int)Math.ceil((float)px / scaledDensity);
    }

    public static int mm2px(Context context, int mm) {
        return (int)(TypedValue.applyDimension((int)5, (float)mm, (DisplayMetrics)context.getResources().getDisplayMetrics()) + 0.5f);
    }

    public static int darkenColor(int color) {
        float[] hsv = new float[3];
        int alpha = Color.alpha((int)color);
        Color.colorToHSV((int)color, (float[])hsv);
        hsv[1] = Math.min(hsv[1] * 1.1f, 1.0f);
        hsv[2] = hsv[2] * 0.9f;
        int tempColor = Color.HSVToColor((float[])hsv);
        return Color.argb((int)alpha, (int)Color.red((int)tempColor), (int)Color.green((int)tempColor), (int)Color.blue((int)tempColor));
    }
}

