/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.render;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Container;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import javax.imageio.ImageIO;
import javax.media.jai.JAI;
import javax.swing.JOptionPane;
import org.jpedal.PdfDecoder;
import org.jpedal.color.ColorSpaces;
import org.jpedal.color.PdfColor;
import org.jpedal.color.PdfPaint;
import org.jpedal.exception.PdfException;
import org.jpedal.external.JPedalCustomDrawObject;
import org.jpedal.fonts.PdfFont;
import org.jpedal.fonts.glyph.GlyphFactory;
import org.jpedal.fonts.glyph.PdfGlyph;
import org.jpedal.fonts.glyph.PdfGlyphs;
import org.jpedal.fonts.glyph.PdfJavaGlyphs;
import org.jpedal.io.ColorSpaceConvertor;
import org.jpedal.io.JAIHelper;
import org.jpedal.io.ObjectStore;
import org.jpedal.objects.GraphicsState;
import org.jpedal.parser.DecoderOptions;
import org.jpedal.render.BaseDisplay;
import org.jpedal.render.DynamicVectorRenderer;
import org.jpedal.render.ImageObject;
import org.jpedal.render.RenderUtils;
import org.jpedal.render.TextObject;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.Matrix;
import org.jpedal.utils.Messages;
import org.jpedal.utils.repositories.Vector_Double;
import org.jpedal.utils.repositories.Vector_Float;
import org.jpedal.utils.repositories.Vector_Int;
import org.jpedal.utils.repositories.Vector_Object;
import org.jpedal.utils.repositories.Vector_Rectangle;
import org.jpedal.utils.repositories.Vector_Shape;

public class SwingDisplay
extends BaseDisplay
implements DynamicVectorRenderer {
    private static boolean drawPDFShapes = true;
    boolean ignoreHighlight;
    private boolean noRepaint;
    private int lastItemPainted;
    private boolean optimsePainting;
    private boolean needsHorizontalInvert;
    private boolean needsVerticalInvert;
    private int pageX1;
    private int pageX2;
    private int pageY1;
    private int pageY2;
    private boolean highlightsNeedToBeGenerated;
    private BufferedImage singleImage;
    private int imageCount;
    private static final int defaultSize = 5000;
    int endItem;
    private static RenderingHints hints = null;
    private final Map cachedWidths;
    private final Map cachedHeights;
    private Map fonts;
    private Map fontsUsed;
    protected GlyphFactory factory;
    private PdfGlyphs glyphs;
    private Map imageID;
    private final Map imageIDtoName;
    private Map storedImageValues;
    private int[] textHighlightsX;
    private int[] textHighlightsWidth;
    private int[] textHighlightsHeight;
    boolean stopG2setting;
    private float[] x_coord;
    private float[] y_coord;
    private Map largeImages;
    private Vector_Object text_color;
    private Vector_Object stroke_color;
    private Vector_Object fill_color;
    private Vector_Object stroke;
    private Vector_Object pageObjects;
    private Vector_Int shapeType;
    private Vector_Rectangle fontBounds;
    private Vector_Double af1;
    private Vector_Double af2;
    private Vector_Double af3;
    private Vector_Double af4;
    private Vector_Int imageOptions;
    private Vector_Int TRvalues;
    private Vector_Int fs;
    private Vector_Int lw;
    private Vector_Shape clips;
    private Vector_Int objectType;
    private Vector_Object javaObjects;
    private Vector_Int textFillType;
    private Vector_Float opacity;
    private int currentItem;
    private int lastFillTextCol;
    private int lastFillCol;
    private int lastStrokeCol;
    private Stroke lastStroke;
    private double[] lastAf;
    private int lastTR;
    private int lastFS;
    private int lastLW;
    private boolean resetTextColors;
    private boolean fillSet;
    private boolean strokeSet;
    private boolean needsHighlights;
    private int paintThreadCount;
    private int paintThreadID;
    private boolean[] drawnHighlights;
    private boolean hasOCR;
    protected int type;
    private double minX;
    private double minY;
    private double maxX;
    private double maxY;
    private boolean renderFailed;
    private Container frame;
    private static boolean userAlerted;

    public SwingDisplay() {
        this.ignoreHighlight = false;
        this.noRepaint = false;
        this.lastItemPainted = -1;
        this.optimsePainting = false;
        this.needsHorizontalInvert = false;
        this.needsVerticalInvert = false;
        this.pageX1 = 9999;
        this.pageX2 = -9999;
        this.pageY1 = -9999;
        this.pageY2 = 9999;
        this.highlightsNeedToBeGenerated = false;
        this.singleImage = null;
        this.imageCount = 0;
        this.endItem = -1;
        this.cachedWidths = new HashMap(10);
        this.cachedHeights = new HashMap(10);
        this.fonts = new HashMap(50);
        this.fontsUsed = new HashMap(50);
        this.factory = null;
        this.imageID = new HashMap(10);
        this.imageIDtoName = new HashMap(10);
        this.storedImageValues = new HashMap(10);
        this.largeImages = new WeakHashMap(10);
        this.currentItem = 0;
        this.lastStroke = null;
        this.lastAf = new double[4];
        this.lastTR = 2;
        this.lastFS = -1;
        this.lastLW = -1;
        this.resetTextColors = true;
        this.fillSet = false;
        this.strokeSet = false;
        this.needsHighlights = true;
        this.paintThreadCount = 0;
        this.paintThreadID = 0;
        this.hasOCR = false;
        this.type = 1;
        this.minX = -1.0;
        this.minY = -1.0;
        this.maxX = -1.0;
        this.maxY = -1.0;
        this.frame = null;
    }

    void setupArrays(int defaultSize) {
        this.x_coord = new float[defaultSize];
        this.y_coord = new float[defaultSize];
        this.text_color = new Vector_Object(defaultSize);
        this.textFillType = new Vector_Int(defaultSize);
        this.stroke_color = new Vector_Object(defaultSize);
        this.fill_color = new Vector_Object(defaultSize);
        this.stroke = new Vector_Object(defaultSize);
        this.pageObjects = new Vector_Object(defaultSize);
        this.javaObjects = new Vector_Object(defaultSize);
        this.shapeType = new Vector_Int(defaultSize);
        this.areas = new Vector_Rectangle(defaultSize);
        this.af1 = new Vector_Double(defaultSize);
        this.af2 = new Vector_Double(defaultSize);
        this.af3 = new Vector_Double(defaultSize);
        this.af4 = new Vector_Double(defaultSize);
        this.fontBounds = new Vector_Rectangle(defaultSize);
        this.clips = new Vector_Shape(defaultSize);
        this.objectType = new Vector_Int(defaultSize);
    }

    public SwingDisplay(int pageNumber, boolean addBackground, int defaultSize, ObjectStore newObjectRef) {
        this.ignoreHighlight = false;
        this.noRepaint = false;
        this.lastItemPainted = -1;
        this.optimsePainting = false;
        this.needsHorizontalInvert = false;
        this.needsVerticalInvert = false;
        this.pageX1 = 9999;
        this.pageX2 = -9999;
        this.pageY1 = -9999;
        this.pageY2 = 9999;
        this.highlightsNeedToBeGenerated = false;
        this.singleImage = null;
        this.imageCount = 0;
        this.endItem = -1;
        this.cachedWidths = new HashMap(10);
        this.cachedHeights = new HashMap(10);
        this.fonts = new HashMap(50);
        this.fontsUsed = new HashMap(50);
        this.factory = null;
        this.imageID = new HashMap(10);
        this.imageIDtoName = new HashMap(10);
        this.storedImageValues = new HashMap(10);
        this.largeImages = new WeakHashMap(10);
        this.currentItem = 0;
        this.lastStroke = null;
        this.lastAf = new double[4];
        this.lastTR = 2;
        this.lastFS = -1;
        this.lastLW = -1;
        this.resetTextColors = true;
        this.fillSet = false;
        this.strokeSet = false;
        this.needsHighlights = true;
        this.paintThreadCount = 0;
        this.paintThreadID = 0;
        this.hasOCR = false;
        this.type = 1;
        this.minX = -1.0;
        this.minY = -1.0;
        this.maxX = -1.0;
        this.maxY = -1.0;
        this.frame = null;
        this.pageNumber = pageNumber;
        this.objectStoreRef = newObjectRef;
        this.addBackground = addBackground;
        this.setupArrays(defaultSize);
    }

    public SwingDisplay(int pageNumber, ObjectStore newObjectRef, boolean isPrinting) {
        this.ignoreHighlight = false;
        this.noRepaint = false;
        this.lastItemPainted = -1;
        this.optimsePainting = false;
        this.needsHorizontalInvert = false;
        this.needsVerticalInvert = false;
        this.pageX1 = 9999;
        this.pageX2 = -9999;
        this.pageY1 = -9999;
        this.pageY2 = 9999;
        this.highlightsNeedToBeGenerated = false;
        this.singleImage = null;
        this.imageCount = 0;
        this.endItem = -1;
        this.cachedWidths = new HashMap(10);
        this.cachedHeights = new HashMap(10);
        this.fonts = new HashMap(50);
        this.fontsUsed = new HashMap(50);
        this.factory = null;
        this.imageID = new HashMap(10);
        this.imageIDtoName = new HashMap(10);
        this.storedImageValues = new HashMap(10);
        this.largeImages = new WeakHashMap(10);
        this.currentItem = 0;
        this.lastStroke = null;
        this.lastAf = new double[4];
        this.lastTR = 2;
        this.lastFS = -1;
        this.lastLW = -1;
        this.resetTextColors = true;
        this.fillSet = false;
        this.strokeSet = false;
        this.needsHighlights = true;
        this.paintThreadCount = 0;
        this.paintThreadID = 0;
        this.hasOCR = false;
        this.type = 1;
        this.minX = -1.0;
        this.minY = -1.0;
        this.maxX = -1.0;
        this.maxY = -1.0;
        this.frame = null;
        this.pageNumber = pageNumber;
        this.objectStoreRef = newObjectRef;
        this.isPrinting = isPrinting;
        this.setupArrays(5000);
    }

    @Override
    public void setOptimsePainting(boolean optimsePainting) {
        this.optimsePainting = optimsePainting;
        this.lastItemPainted = -1;
    }

    private void renderHighlight(Rectangle highlight, Graphics2D g2) {
        if (highlight != null && !this.ignoreHighlight) {
            Shape currentClip = g2.getClip();
            g2.setClip(null);
            Composite comp = g2.getComposite();
            Paint p = g2.getPaint();
            g2.setComposite(AlphaComposite.getInstance(3, PdfDecoder.highlightComposite));
            if (invertHighlight) {
                g2.setColor(Color.WHITE);
                g2.setXORMode(Color.BLACK);
            } else {
                g2.setPaint(DecoderOptions.highlightColor);
            }
            g2.fill(highlight);
            g2.setComposite(comp);
            g2.setPaint(p);
            this.needsHighlights = false;
            g2.setClip(currentClip);
        }
    }

    @Override
    public void stopG2HintSetting(boolean isSet) {
        this.stopG2setting = isSet;
    }

    @Override
    public void flush() {
        this.singleImage = null;
        this.imageCount = 0;
        this.lastFS = -1;
        if (this.shapeType != null) {
            this.shapeType.clear();
            this.pageObjects.clear();
            this.objectType.clear();
            this.areas.clear();
            this.clips.clear();
            this.x_coord = new float[5000];
            this.y_coord = new float[5000];
            this.textFillType.clear();
            this.text_color.clear();
            this.fill_color.clear();
            this.stroke_color.clear();
            this.stroke.clear();
            if (this.TRvalues != null) {
                this.TRvalues = null;
            }
            if (this.imageOptions != null) {
                this.imageOptions = null;
            }
            if (this.fs != null) {
                this.fs = null;
            }
            if (this.lw != null) {
                this.lw = null;
            }
            this.af1.clear();
            this.af2.clear();
            this.af3.clear();
            this.af4.clear();
            this.fontBounds.clear();
            if (this.opacity != null) {
                this.opacity = null;
            }
            if (this.isPrinting) {
                this.largeImages.clear();
            }
            this.endItem = -1;
        }
        this.lastFillTextCol = 0;
        this.lastFillCol = 0;
        this.lastStrokeCol = 0;
        this.lastClip = null;
        this.hasClips = false;
        this.lastStroke = null;
        this.lastAf = new double[4];
        this.currentItem = 0;
        this.fillSet = false;
        this.strokeSet = false;
        this.fonts.clear();
        this.fontsUsed.clear();
        this.imageID.clear();
        this.pageX1 = 9999;
        this.pageX2 = -9999;
        this.pageY1 = -9999;
        this.pageY2 = 9999;
        this.lastScaling = 0.0f;
    }

    @Override
    public void dispose() {
        this.singleImage = null;
        this.shapeType = null;
        this.pageObjects = null;
        this.objectType = null;
        this.areas = null;
        this.clips = null;
        this.x_coord = null;
        this.y_coord = null;
        this.textFillType = null;
        this.text_color = null;
        this.fill_color = null;
        this.stroke_color = null;
        this.stroke = null;
        this.TRvalues = null;
        this.imageOptions = null;
        this.fs = null;
        this.lw = null;
        this.af1 = null;
        this.af2 = null;
        this.af3 = null;
        this.af4 = null;
        this.fontBounds = null;
        this.opacity = null;
        this.largeImages = null;
        this.lastClip = null;
        this.lastStroke = null;
        this.lastAf = null;
        this.fonts = null;
        this.fontsUsed = null;
        this.imageID = null;
        this.storedImageValues = null;
    }

    @Override
    public Rectangle paint(Rectangle[] highlights, AffineTransform viewScaling, Rectangle userAnnot) {
        Shape rawClip;
        Vector_Rectangle ocr_highlights = null;
        HashMap<String, String> ocr_used = null;
        if (this.hasOCR) {
            ocr_highlights = new Vector_Rectangle(4000);
            ocr_used = new HashMap<String, String>(10);
        }
        int currentThreadID = ++this.paintThreadID;
        ++this.paintThreadCount;
        if (highlights != null) {
            this.drawnHighlights = new boolean[highlights.length];
            for (int i = 0; i != this.drawnHighlights.length; ++i) {
                this.drawnHighlights[i] = false;
            }
        }
        if (this.paintThreadCount > 1) {
            block110: {
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException e) {
                    if (!LogWriter.isOutput()) break block110;
                    LogWriter.writeLog("Exception: " + e.getMessage());
                }
            }
            if (currentThreadID != this.paintThreadID) {
                --this.paintThreadCount;
                return null;
            }
        }
        boolean debug = false;
        float a = 0.0f;
        float b = 0.0f;
        float c = 0.0f;
        float d = 0.0f;
        Rectangle dirtyRegion = null;
        int[] objectTypes = this.objectType.get();
        int[] textFill = this.textFillType.get();
        int count = this.currentItem;
        Area[] pageClips = this.clips.get();
        double[] afValues1 = this.af1.get();
        int[] fsValues = null;
        if (this.fs != null) {
            fsValues = this.fs.get();
        }
        Rectangle[] fontBounds = this.fontBounds.get();
        int[] lwValues = null;
        if (this.lw != null) {
            lwValues = this.lw.get();
        }
        double[] afValues2 = this.af2.get();
        double[] afValues3 = this.af3.get();
        double[] afValues4 = this.af4.get();
        Object[] text_color = this.text_color.get();
        Object[] fill_color = this.fill_color.get();
        Object[] stroke_color = this.stroke_color.get();
        Object[] pageObjects = this.pageObjects.get();
        Object[] javaObjects = this.javaObjects.get();
        Object[] stroke = this.stroke.get();
        int[] fillType = this.shapeType.get();
        float[] opacity = null;
        if (this.opacity != null) {
            opacity = this.opacity.get();
        }
        int[] TRvalues = null;
        if (this.TRvalues != null) {
            TRvalues = this.TRvalues.get();
        }
        Rectangle[] areas = null;
        if (this.areas != null) {
            areas = this.areas.get();
        }
        int[] imageOptions = null;
        if (this.imageOptions != null) {
            imageOptions = this.imageOptions.get();
        }
        if ((rawClip = this.g2.getClip()) != null) {
            dirtyRegion = rawClip.getBounds();
        }
        boolean isInitialised = false;
        Shape defaultClip = this.g2.getClip();
        Area clipToUse = null;
        boolean newClip = false;
        if (this.noRepaint) {
            this.noRepaint = false;
        } else if (this.lastItemPainted == -1) {
            this.paintBackground(dirtyRegion);
        }
        AffineTransform rawScaling = this.g2.getTransform();
        if (viewScaling != null) {
            this.g2.transform(viewScaling);
            defaultClip = this.g2.getClip();
        }
        this.minX = -1.0;
        this.minY = -1.0;
        this.maxX = -1.0;
        this.maxY = -1.0;
        int currentTR = 2;
        int lineWidth = 0;
        float fillOpacity = 1.0f;
        float strokeOpacity = 1.0f;
        int iCount = 0;
        int cCount = 0;
        int sCount = 0;
        int fsCount = -1;
        int lwCount = 0;
        int afCount = -1;
        int tCount = 0;
        int stCount = 0;
        int fillCount = 0;
        int strokeCount = 0;
        int trCount = 0;
        int opCount = 0;
        int stringCount = 0;
        PdfPaint textStrokeCol = null;
        PdfPaint textFillCol = null;
        PdfPaint fillCol = null;
        PdfPaint strokeCol = null;
        Stroke currentStroke = null;
        if (this.colorsLocked) {
            strokeCol = this.strokeCol;
            fillCol = this.fillCol;
        }
        if (this.highlightsNeedToBeGenerated && areas != null && highlights != null) {
            this.generateHighlights(this.g2, count, objectTypes, pageObjects, a, b, c, d, afValues1, afValues2, afValues3, afValues4, fsValues, fontBounds);
        }
        block38: for (int i = 0; drawPDFShapes && i < count; ++i) {
            int imageUsed;
            boolean ignoreItem = false;
            int type = objectTypes[i];
            if (type == 27) continue;
            Rectangle currentArea = null;
            if (currentThreadID != this.paintThreadID) {
                --this.paintThreadCount;
                return null;
            }
            if (type <= 0) continue;
            float x = this.x_coord[i];
            float y = this.y_coord[i];
            Object currentObject = pageObjects[i];
            if (type == 29) {
                type = 3;
                imageUsed = (Integer)currentObject;
                currentObject = pageObjects[imageUsed];
            } else {
                imageUsed = -1;
            }
            if (currentArea == null) {
                currentArea = SwingDisplay.getObjectArea(afValues1, fsValues, afValues2, afValues3, afValues4, pageObjects, areas, type, x, y, fsCount, afCount, i);
            }
            ignoreItem = false;
            if (currentArea != null && type < 7 && userAnnot != null && !userAnnot.intersects(currentArea) && currentArea.width > 0) {
                ignoreItem = true;
            }
            if (ignoreItem || this.lastItemPainted != -1 && i < this.lastItemPainted) {
                switch (type) {
                    case 2: {
                        ++sCount;
                        break;
                    }
                    case 3: {
                        ++iCount;
                        break;
                    }
                    case 29: {
                        ++iCount;
                        break;
                    }
                    case 7: {
                        ++cCount;
                        break;
                    }
                    case 21: {
                        ++fsCount;
                        break;
                    }
                    case 22: {
                        ++lwCount;
                        break;
                    }
                    case 10: {
                        ++tCount;
                        break;
                    }
                    case 11: {
                        ++fillCount;
                        break;
                    }
                    case 12: {
                        ++strokeCount;
                        break;
                    }
                    case 14: {
                        ++stCount;
                        break;
                    }
                    case 15: {
                        ++trCount;
                    }
                }
                continue;
            }
            if (!isInitialised && !this.stopG2setting) {
                if (userHints != null) {
                    this.g2.setRenderingHints(userHints);
                } else {
                    this.g2.setRenderingHints(hints);
                }
                isInitialised = true;
            }
            if (currentTR == 4) {
                this.needsHighlights = true;
            }
            Rectangle highlight = null;
            switch (type) {
                case 2: {
                    if (newClip) {
                        RenderUtils.renderClip(clipToUse, dirtyRegion, defaultClip, this.g2);
                        newClip = false;
                    }
                    Shape s = null;
                    if (this.endItem != -1 && this.endItem < i) {
                        s = this.g2.getClip();
                        this.g2.setClip(defaultClip);
                    }
                    this.renderShape(defaultClip, fillType[sCount], strokeCol, fillCol, currentStroke, (Shape)currentObject, strokeOpacity, fillOpacity);
                    if (this.endItem != -1 && this.endItem < i) {
                        this.g2.setClip(s);
                    }
                    ++sCount;
                    continue block38;
                }
                case 1: {
                    String key;
                    if (newClip) {
                        RenderUtils.renderClip(clipToUse, dirtyRegion, defaultClip, this.g2);
                        newClip = false;
                    }
                    if (!invertHighlight) {
                        highlight = this.setHighlightForGlyph(currentArea, highlights);
                    }
                    if (this.hasOCR && highlight != null && ocr_used.get(key = highlight.x + " " + highlight.y) == null) {
                        ocr_used.put(key, "x");
                        ocr_highlights.addElement(highlight);
                    }
                    AffineTransform def = this.g2.getTransform();
                    this.renderHighlight(highlight, this.g2);
                    this.g2.transform(new AffineTransform(afValues1[afCount], afValues2[afCount], -afValues3[afCount], -afValues4[afCount], (double)x, (double)y));
                    this.renderText(x, y, currentTR, (Area)currentObject, highlight, textStrokeCol, textFillCol, strokeOpacity, fillOpacity);
                    this.g2.setTransform(def);
                    continue block38;
                }
                case 4: {
                    String key;
                    if (newClip) {
                        RenderUtils.renderClip(clipToUse, dirtyRegion, defaultClip, this.g2);
                        newClip = false;
                    }
                    if (afCount == -1) continue block38;
                    AffineTransform aff = new AffineTransform(afValues1[afCount], afValues2[afCount], afValues3[afCount], afValues4[afCount], (double)x, (double)y);
                    if (!invertHighlight) {
                        highlight = this.setHighlightForGlyph(currentArea, highlights);
                    }
                    if (this.hasOCR && highlight != null && ocr_used.get(key = highlight.x + " " + highlight.y) == null) {
                        ocr_used.put(key, "x");
                        ocr_highlights.addElement(highlight);
                    }
                    this.renderHighlight(highlight, this.g2);
                    this.renderEmbeddedText(currentTR, currentObject, 4, aff, highlight, textStrokeCol, textFillCol, strokeOpacity, fillOpacity, lineWidth);
                    continue block38;
                }
                case 5: {
                    String key;
                    if (newClip) {
                        RenderUtils.renderClip(clipToUse, dirtyRegion, defaultClip, this.g2);
                        newClip = false;
                    }
                    AffineTransform aff = new AffineTransform(afValues1[afCount], afValues2[afCount], afValues3[afCount], afValues4[afCount], (double)x, (double)y);
                    if (!invertHighlight) {
                        highlight = this.setHighlightForGlyph(currentArea, highlights);
                    }
                    if (this.hasOCR && highlight != null && ocr_used.get(key = highlight.x + " " + highlight.y) == null) {
                        ocr_used.put(key, "x");
                        ocr_highlights.addElement(highlight);
                    }
                    this.renderHighlight(highlight, this.g2);
                    this.renderEmbeddedText(currentTR, currentObject, 5, aff, highlight, textStrokeCol, textFillCol, strokeOpacity, fillOpacity, lineWidth);
                    continue block38;
                }
                case 6: {
                    String key;
                    if (newClip) {
                        RenderUtils.renderClip(clipToUse, dirtyRegion, defaultClip, this.g2);
                        newClip = false;
                    }
                    AffineTransform aff = new AffineTransform(afValues1[afCount], afValues2[afCount], afValues3[afCount], afValues4[afCount], (double)x, (double)y);
                    if (!invertHighlight) {
                        highlight = this.setHighlightForGlyph(currentArea, highlights);
                    }
                    if (this.hasOCR && highlight != null && ocr_used.get(key = highlight.x + " " + highlight.y) == null) {
                        ocr_used.put(key, "x");
                        ocr_highlights.addElement(highlight);
                    }
                    this.renderHighlight(highlight, this.g2);
                    this.renderEmbeddedText(currentTR, currentObject, 6, aff, highlight, textStrokeCol, textFillCol, strokeOpacity, fillOpacity, lineWidth);
                    continue block38;
                }
                case 3: {
                    if (newClip) {
                        RenderUtils.renderClip(clipToUse, dirtyRegion, defaultClip, this.g2);
                        newClip = false;
                    }
                    this.renderImage(afValues1, afValues2, afValues3, afValues4, pageObjects, imageOptions, currentObject, fillOpacity, x, y, iCount, afCount, imageUsed, i);
                    ++iCount;
                    continue block38;
                }
                case 7: {
                    clipToUse = pageClips[cCount];
                    newClip = true;
                    ++cCount;
                    continue block38;
                }
                case 9: {
                    ++afCount;
                    continue block38;
                }
                case 21: {
                    ++fsCount;
                    continue block38;
                }
                case 22: {
                    lineWidth = lwValues[lwCount];
                    ++lwCount;
                    continue block38;
                }
                case 10: {
                    int textFillType = textFill[tCount];
                    if (textFillType == 1) {
                        textStrokeCol = (PdfPaint)text_color[tCount];
                    } else {
                        textFillCol = (PdfPaint)text_color[tCount];
                    }
                    ++tCount;
                    continue block38;
                }
                case 11: {
                    if (!this.colorsLocked) {
                        fillCol = (PdfPaint)fill_color[fillCount];
                    }
                    ++fillCount;
                    continue block38;
                }
                case 12: {
                    if (!this.colorsLocked && (strokeCol = (PdfPaint)stroke_color[strokeCount]) != null) {
                        strokeCol.setScaling(this.cropX, this.cropH, this.scaling, 0.0f, 0.0f);
                    }
                    ++strokeCount;
                    continue block38;
                }
                case 14: {
                    currentStroke = (Stroke)stroke[stCount];
                    ++stCount;
                    continue block38;
                }
                case 15: {
                    currentTR = TRvalues[trCount];
                    ++trCount;
                    continue block38;
                }
                case 17: {
                    strokeOpacity = opacity[opCount];
                    ++opCount;
                    continue block38;
                }
                case 18: {
                    fillOpacity = opacity[opCount];
                    ++opCount;
                    continue block38;
                }
                case 16: {
                    Shape s1 = this.g2.getClip();
                    this.g2.setClip(defaultClip);
                    AffineTransform defaultAf = this.g2.getTransform();
                    String displayValue = (String)currentObject;
                    double[] af = new double[6];
                    this.g2.getTransform().getMatrix(af);
                    if (af[2] != 0.0) {
                        af[2] = -af[2];
                    }
                    if (af[3] != 0.0) {
                        af[3] = -af[3];
                    }
                    this.g2.setTransform(new AffineTransform(af));
                    Font javaFont = (Font)javaObjects[stringCount];
                    this.g2.setFont(javaFont);
                    if ((currentTR & 2) == 2) {
                        if (textFillCol != null) {
                            textFillCol.setScaling(this.cropX, this.cropH, this.scaling, 0.0f, 0.0f);
                        }
                        if (this.customColorHandler != null) {
                            this.customColorHandler.setPaint(this.g2, textFillCol, this.pageNumber, this.isPrinting);
                        } else if (PdfDecoder.Helper != null) {
                            PdfDecoder.Helper.setPaint(this.g2, textFillCol, this.pageNumber, this.isPrinting);
                        } else {
                            this.g2.setPaint(textFillCol);
                        }
                    }
                    if ((currentTR & 1) == 1) {
                        if (textStrokeCol != null) {
                            textStrokeCol.setScaling(this.cropX, this.cropH, this.scaling, 0.0f, 0.0f);
                        }
                        if (this.customColorHandler != null) {
                            this.customColorHandler.setPaint(this.g2, textFillCol, this.pageNumber, this.isPrinting);
                        } else if (PdfDecoder.Helper != null) {
                            PdfDecoder.Helper.setPaint(this.g2, textFillCol, this.pageNumber, this.isPrinting);
                        } else {
                            this.g2.setPaint(textFillCol);
                        }
                    }
                    this.g2.drawString(displayValue, x, y);
                    this.g2.setTransform(defaultAf);
                    this.g2.setClip(s1);
                    ++stringCount;
                    continue block38;
                }
                case 25: {
                    this.renderXForm((DynamicVectorRenderer)currentObject, fillOpacity);
                    continue block38;
                }
                case 23: {
                    Shape s2 = this.g2.getClip();
                    this.g2.setClip(defaultClip);
                    AffineTransform af2 = this.g2.getTransform();
                    JPedalCustomDrawObject customObj = (JPedalCustomDrawObject)currentObject;
                    if (this.isPrinting) {
                        customObj.print(this.g2, this.pageNumber);
                    } else {
                        customObj.paint(this.g2);
                    }
                    this.g2.setTransform(af2);
                    this.g2.setClip(s2);
                }
            }
        }
        if (this.needsHighlights && highlights != null) {
            for (int h = 0; h != highlights.length; ++h) {
                this.ignoreHighlight = false;
                this.renderHighlight(highlights[h], this.g2);
            }
        }
        if (ocr_highlights != null) {
            Rectangle[] highlights2 = ocr_highlights.get();
            Composite comp = this.g2.getComposite();
            Paint p = this.g2.getPaint();
            for (int h = 0; h != highlights2.length; ++h) {
                if (highlights2[h] != null) {
                    this.g2.setComposite(AlphaComposite.getInstance(3, PdfDecoder.highlightComposite));
                    this.g2.setPaint(DecoderOptions.highlightColor);
                    this.g2.fill(highlights2[h]);
                }
                this.g2.setComposite(comp);
                this.g2.setPaint(p);
            }
        }
        this.g2.setClip(defaultClip);
        this.g2.setTransform(rawScaling);
        if (this.frame != null && this.renderFailed && !userAlerted) {
            userAlerted = true;
            if (PdfDecoder.showErrorMessages) {
                String status = Messages.getMessage("PdfViewer.ImageDisplayError") + Messages.getMessage("PdfViewer.ImageDisplayError1") + Messages.getMessage("PdfViewer.ImageDisplayError2") + Messages.getMessage("PdfViewer.ImageDisplayError3") + Messages.getMessage("PdfViewer.ImageDisplayError4") + Messages.getMessage("PdfViewer.ImageDisplayError5") + Messages.getMessage("PdfViewer.ImageDisplayError6") + Messages.getMessage("PdfViewer.ImageDisplayError7");
                JOptionPane.showMessageDialog(this.frame, status);
                this.frame.invalidate();
                this.frame.repaint();
            }
        }
        --this.paintThreadCount;
        this.lastItemPainted = this.optimsePainting ? count : -1;
        this.lastScaling = this.scaling;
        if (this.minX == -1.0) {
            return null;
        }
        return new Rectangle((int)this.minX, (int)this.minY, (int)(this.maxX - this.minX), (int)(this.maxY - this.minY));
    }

    private static Rectangle getObjectArea(double[] afValues1, int[] fsValues, double[] afValues2, double[] afValues3, double[] afValues4, Object[] pageObjects, Rectangle[] areas, int type, float x, float y, int fsCount, int afCount, int i) {
        Rectangle currentArea = null;
        if (afValues1 != null && type == 3) {
            if (areas != null) {
                currentArea = areas[i];
            }
        } else if (afValues1 != null && type == 2) {
            currentArea = ((Shape)pageObjects[i]).getBounds();
        } else if (type == 1 && afCount > -1) {
            currentArea = RenderUtils.getAreaForGlyph(new float[][]{{(float)afValues1[afCount], (float)afValues2[afCount], 0.0f}, {(float)afValues3[afCount], (float)afValues4[afCount], 0.0f}, {x, y, 1.0f}});
        } else if (fsCount != -1 && afValues1 != null) {
            int realSize = fsValues[fsCount];
            currentArea = realSize < 0 ? new Rectangle((int)x + realSize, (int)y, -realSize, -realSize) : new Rectangle((int)x, (int)y, realSize, realSize);
        }
        return currentArea;
    }

    private void renderImage(double[] afValues1, double[] afValues2, double[] afValues3, double[] afValues4, Object[] pageObjects, int[] imageOptions, Object currentObject, float fillOpacity, float x, float y, int iCount, int afCount, int imageUsed, int i) {
        int currentImageOption = 0;
        if (imageOptions != null) {
            currentImageOption = imageOptions[iCount];
        }
        boolean sampling = true;
        int w1 = 0;
        int pY = 0;
        boolean defaultSampling = true;
        String key = Integer.toString(this.pageNumber) + Integer.toString(iCount);
        if (this.useHiResImageForDisplay) {
            double aa = 1.0;
            if (sampling >= true && this.scaling > 1.0f && w1 > 0) {
                aa = (float)sampling / (float)defaultSampling;
            }
            AffineTransform imageAf = new AffineTransform(afValues1[afCount] * aa, afValues2[afCount] * aa, afValues3[afCount] * aa, afValues4[afCount] * aa, (double)x, (double)y);
            BufferedImage img = null;
            if (currentObject != null) {
                img = (BufferedImage)currentObject;
            }
            if (currentObject == null) {
                img = this.reloadCachedImage(imageUsed, i, img);
            }
            if (img != null) {
                this.renderImage(imageAf, img, fillOpacity, null, x, y, currentImageOption);
            }
        } else {
            AffineTransform before = this.g2.getTransform();
            this.extraRot = false;
            if (pY > 0) {
                double ratio;
                double[] matrix = new double[6];
                this.g2.getTransform().getMatrix(matrix);
                matrix[0] = ratio = (double)((float)pY / (float)((BufferedImage)currentObject).getHeight());
                matrix[1] = 0.0;
                matrix[2] = 0.0;
                matrix[3] = -ratio;
                this.g2.scale(1.0f / this.scaling, 1.0f / this.scaling);
                this.g2.setTransform(new AffineTransform(matrix));
            } else {
                this.extraRot = true;
            }
            this.renderImage(null, (BufferedImage)currentObject, fillOpacity, null, x, y, currentImageOption);
            this.g2.setTransform(before);
        }
    }

    private BufferedImage resampleImageData(int sampling, int w1, int h1, byte[] maskCol, int newW, int newH, String key, int ID) {
        byte[] data = this.objectStoreRef.getRawImageData(key);
        byte[] index = null;
        if (maskCol != null && ID != 1785221209) {
            index = maskCol;
        }
        int size = newW * newH;
        if (index != null) {
            size *= 3;
        }
        byte[] newData = new byte[size];
        int[] flag = new int[]{1, 2, 4, 8, 16, 32, 64, 128};
        int origLineLength = w1 + 7 >> 3;
        int offset = 0;
        for (int y1 = 0; y1 < newH; ++y1) {
            for (int x1 = 0; x1 < newW; ++x1) {
                int ii;
                int bytes = 0;
                int count1 = 0;
                int wCount = sampling;
                int hCount = sampling;
                int wGapLeft = w1 - x1;
                int hGapLeft = h1 - y1;
                if (wCount > wGapLeft) {
                    wCount = wGapLeft;
                }
                if (hCount > hGapLeft) {
                    hCount = hGapLeft;
                }
                for (int yy = 0; yy < hCount; ++yy) {
                    for (int xx = 0; xx < wCount; ++xx) {
                        int ptr = (yy + y1 * sampling) * origLineLength + (x1 * sampling + xx >> 3);
                        int currentByte = ptr < data.length ? data[ptr] : -1;
                        int bit = currentByte & flag[7 - (x1 * sampling + xx & 7)];
                        if (bit != 0) {
                            ++bytes;
                        }
                        ++count1;
                    }
                }
                if (count1 > 0) {
                    if (index == null) {
                        newData[x1 + newW * y1] = (byte)(255 * bytes / count1);
                        continue;
                    }
                    for (ii = 0; ii < 3; ++ii) {
                        newData[offset] = (float)(bytes / count1) < 0.5f ? (int)(maskCol[ii] & 0xFF) : -1;
                        ++offset;
                    }
                    continue;
                }
                if (index == null) {
                    newData[x1 + newW * y1] = -1;
                    continue;
                }
                for (ii = 0; ii < 3; ++ii) {
                    newData[offset] = -1;
                    ++offset;
                }
            }
        }
        BufferedImage image = null;
        int type = 10;
        DataBufferByte db = new DataBufferByte(newData, newData.length);
        int[] bands = new int[]{0};
        int count = 1;
        if (maskCol == null && w1 * h1 * 3 == data.length) {
            type = 1;
            bands = new int[]{0, 1, 2};
            count = 3;
        }
        image = new BufferedImage(newW, newH, type);
        WritableRaster raster = Raster.createInterleavedRaster(db, newW, newH, newW * count, count, bands, null);
        image.setData(raster);
        return image;
    }

    private BufferedImage reloadCachedImage(int imageUsed, int i, BufferedImage img) {
        block8: {
            try {
                BufferedImage currentObject = this.singleImage != null ? this.singleImage.getSubimage(0, 0, this.singleImage.getWidth(), this.singleImage.getHeight()) : (this.rawKey == null ? this.largeImages.get("HIRES_" + i) : this.largeImages.get("HIRES_" + i + '_' + this.rawKey));
                if (currentObject == null) {
                    int keyID = i;
                    if (imageUsed != -1) {
                        keyID = imageUsed;
                    }
                    if ((currentObject = this.rawKey == null ? this.objectStoreRef.loadStoredImage(this.pageNumber + "_HIRES_" + keyID) : this.objectStoreRef.loadStoredImage(this.pageNumber + "_HIRES_" + keyID + '_' + this.rawKey)) == null) {
                        this.renderFailed = true;
                    }
                    if (!this.isPrinting) {
                        if (this.rawKey == null) {
                            this.largeImages.put("HIRES_" + i, currentObject);
                        } else {
                            this.largeImages.put("HIRES_" + i, currentObject + "_" + this.rawKey);
                        }
                    }
                }
                img = currentObject;
            }
            catch (Exception e) {
                if (!LogWriter.isOutput()) break block8;
                LogWriter.writeLog("Exception: " + e.getMessage());
            }
        }
        return img;
    }

    @Override
    public void setMessageFrame(Container frame) {
        this.frame = frame;
    }

    private Rectangle setHighlightForGlyph(Rectangle area, Rectangle[] highlights) {
        if (highlights == null || this.textHighlightsX == null) {
            return null;
        }
        this.ignoreHighlight = false;
        for (int j = 0; j != highlights.length; ++j) {
            if (highlights[j] == null || area == null || !highlights[j].intersects(area)) continue;
            Rectangle intersection = highlights[j].intersection(area);
            float iArea = intersection.width * intersection.height;
            float tArea = (float)(area.width * area.height) / 4.0f;
            if (!(highlights[j].contains(area.x, area.y) && iArea > tArea) && !(iArea > (float)(area.width * area.height) / 1.667f)) continue;
            if (!this.drawnHighlights[j]) {
                this.ignoreHighlight = false;
                this.drawnHighlights[j] = true;
                return highlights[j];
            }
            this.ignoreHighlight = true;
            return highlights[j];
        }
        return null;
    }

    @Override
    public void drawText(float[][] Trm, String text, GraphicsState currentGraphicsState, float x, float y, Font javaFont) {
        int newCol;
        int text_fill_type;
        double[] nextAf;
        PdfPaint currentCol = null;
        if (Trm != null && (this.lastAf[0] != (nextAf = new double[]{Trm[0][0], Trm[0][1], Trm[1][0], Trm[1][1], Trm[2][0], Trm[2][1]})[0] || this.lastAf[1] != nextAf[1] || this.lastAf[2] != nextAf[2] || this.lastAf[3] != nextAf[3])) {
            this.drawAffine(nextAf);
            this.lastAf[0] = nextAf[0];
            this.lastAf[1] = nextAf[1];
            this.lastAf[2] = nextAf[2];
            this.lastAf[3] = nextAf[3];
        }
        if (((text_fill_type = currentGraphicsState.getTextRenderType()) & 2) == 2) {
            currentCol = currentGraphicsState.getNonstrokeColor();
            if (currentCol.isPattern()) {
                this.drawColor(currentCol, 2);
                this.resetTextColors = true;
            } else {
                newCol = currentCol.getRGB();
                if (this.resetTextColors || this.lastFillTextCol != newCol) {
                    this.lastFillTextCol = newCol;
                    this.drawColor(currentCol, 2);
                }
            }
        }
        if ((text_fill_type & 1) == 1) {
            currentCol = currentGraphicsState.getStrokeColor();
            if (currentCol.isPattern()) {
                this.drawColor(currentCol, 1);
                this.resetTextColors = true;
            } else {
                newCol = currentCol.getRGB();
                if (this.resetTextColors || this.lastStrokeCol != newCol) {
                    this.lastStrokeCol = newCol;
                    this.drawColor(currentCol, 1);
                }
            }
        }
        this.pageObjects.addElement(text);
        this.javaObjects.addElement(javaFont);
        this.objectType.addElement(16);
        int fontSize = javaFont.getSize();
        if (fontSize > 100) {
            this.areas.addElement(new Rectangle((int)x, (int)y, fontSize, fontSize));
        } else {
            this.areas.addElement(null);
        }
        this.x_coord = RenderUtils.checkSize(this.x_coord, this.currentItem);
        this.y_coord = RenderUtils.checkSize(this.y_coord, this.currentItem);
        this.x_coord[this.currentItem] = x;
        this.y_coord[this.currentItem] = y;
        ++this.currentItem;
        this.resetTextColors = false;
    }

    @Override
    public Rectangle getCombinedAreas(Rectangle targetRectangle, boolean justText) {
        Rectangle combinedRectangle = null;
        if (this.areas != null) {
            Rectangle[] currentAreas;
            Rectangle target = targetRectangle.getBounds();
            int x2 = target.x;
            int y2 = target.y;
            int x1 = x2 + target.width;
            int y1 = y2 + target.height;
            boolean matchFound = false;
            for (Rectangle currentArea : currentAreas = this.areas.get()) {
                int newY;
                if (currentArea == null || !targetRectangle.contains(currentArea)) continue;
                matchFound = true;
                int newX = currentArea.x;
                if (x1 > newX) {
                    x1 = newX;
                }
                if (x2 < (newX = currentArea.x + currentArea.width)) {
                    x2 = newX;
                }
                if (y1 > (newY = currentArea.y)) {
                    y1 = newY;
                }
                if (y2 >= (newY = currentArea.y + currentArea.height)) continue;
                y2 = newY;
            }
            if (matchFound) {
                combinedRectangle = new Rectangle(x1 - 1, y1 + 1, x2 - x1 + 2, y2 - y1 + 2);
            }
        }
        return combinedRectangle;
    }

    @Override
    public int drawImage(int pageNumber, BufferedImage image, GraphicsState currentGraphicsState, boolean alreadyCached, String name, int optionsApplied, int previousUse) {
        boolean oddRotationCase;
        if (previousUse != -1) {
            return this.redrawImage(pageNumber, currentGraphicsState, name, previousUse);
        }
        this.pageNumber = pageNumber;
        float[][] CTM = currentGraphicsState.CTM;
        float x = currentGraphicsState.x;
        float y = currentGraphicsState.y;
        double[] nextAf = new double[6];
        boolean cacheInMemory = image.getWidth() < 100 && image.getHeight() < 100 || image.getHeight() == 1;
        String key = this.rawKey == null ? pageNumber + "_" + (this.currentItem + 1) : this.rawKey + '_' + (this.currentItem + 1);
        if (this.imageOptions == null) {
            this.imageOptions = new Vector_Int(5000);
            this.imageOptions.setCheckpoint();
        }
        boolean bl = oddRotationCase = optionsApplied == 0 && CTM[0][0] < 0.0f && CTM[0][1] > 0.0f && CTM[1][0] < 0.0f && CTM[1][1] < 0.0f && this.pageRotation == 0 && this.type == 1;
        if (!alreadyCached && image.getHeight() > 1 && (optionsApplied & 1) != 1) {
            boolean turnLater;
            boolean bl2 = turnLater = this.optimisedTurnCode && CTM[0][0] * CTM[0][1] == 0.0f && CTM[1][1] * CTM[1][0] == 0.0f && !RenderUtils.isRotated(CTM);
            if (!(this.optimisedTurnCode && turnLater || this.pageRotation == 90 || this.pageRotation == 270 || this.type != 3 && !oddRotationCase)) {
                image = RenderUtils.invertImage(CTM, image);
            }
            if (turnLater) {
                optionsApplied += 4;
            }
        }
        this.imageOptions.addElement(optionsApplied);
        if (this.useHiResImageForDisplay) {
            float[][] scaleDown;
            int h;
            int w;
            if (!alreadyCached || this.cachedWidths.get(key) == null) {
                w = image.getWidth();
                h = image.getHeight();
            } else {
                w = (Integer)this.cachedWidths.get(key);
                h = (Integer)this.cachedHeights.get(key);
            }
            boolean isRotated = RenderUtils.isRotated(CTM);
            if (isRotated) {
                if ((optionsApplied & 2) != 2) {
                    AffineTransform tx = new AffineTransform();
                    tx.rotate(1.5707963267948966, w / 2, h / 2);
                    tx.translate(-((double)h - tx.getTranslateX()), -tx.getTranslateY());
                    double[] matrix = new double[6];
                    tx.getMatrix(matrix);
                    if (matrix[4] < 1.0) {
                        matrix[4] = 1.0;
                        tx = new AffineTransform(matrix);
                    }
                    AffineTransformOp op = new AffineTransformOp(tx, 2);
                    if (image != null) {
                        if (image.getHeight() > 1 && image.getWidth() > 1) {
                            image = op.filter(image, null);
                        }
                        if (RenderUtils.isInverted(CTM) && (optionsApplied & 2) != 2) {
                            AffineTransform image_at2 = new AffineTransform();
                            image_at2.scale(-1.0, 1.0);
                            image_at2.translate(-image.getWidth(), 0.0);
                            AffineTransformOp invert3 = new AffineTransformOp(image_at2, ColorSpaces.hints);
                            if (image.getType() == 12) {
                                BufferedImage source = image;
                                image = new BufferedImage(source.getWidth(), source.getHeight(), source.getType());
                                invert3.filter(source, image);
                            } else {
                                image = invert3.filter(image, null);
                            }
                        }
                    }
                    float[][] scaleDown2 = new float[][]{{0.0f, 1.0f / (float)h, 0.0f}, {1.0f / (float)w, 0.0f, 0.0f}, {0.0f, 0.0f, 1.0f}};
                    CTM = Matrix.multiply(scaleDown2, CTM);
                } else {
                    scaleDown = new float[][]{{0.0f, 1.0f / (float)w, 0.0f}, {1.0f / (float)h, 0.0f, 0.0f}, {0.0f, 0.0f, 1.0f}};
                    CTM = Matrix.multiply(scaleDown, CTM);
                }
            } else {
                scaleDown = new float[][]{{1.0f / (float)w, 0.0f, 0.0f}, {0.0f, 1.0f / (float)h, 0.0f}, {0.0f, 0.0f, 1.0f}};
                CTM = Matrix.multiply(scaleDown, CTM);
            }
            AffineTransform upside_down = null;
            upside_down = new AffineTransform(CTM[0][0], CTM[0][1], CTM[1][0], CTM[1][1], 0.0f, 0.0f);
            upside_down.getMatrix(nextAf);
            this.drawAffine(nextAf);
            this.lastAf[0] = nextAf[0];
            this.lastAf[1] = nextAf[1];
            this.lastAf[2] = nextAf[2];
            this.lastAf[3] = nextAf[3];
            if (!alreadyCached && !cacheInMemory) {
                if (!this.isPrinting) {
                    if (this.rawKey == null) {
                        this.largeImages.put("HIRES_" + this.currentItem, image);
                    } else {
                        this.largeImages.put("HIRES_" + this.currentItem + '_' + this.rawKey, image);
                    }
                    if (this.imageCount == 0) {
                        this.singleImage = image.getSubimage(0, 0, image.getWidth(), image.getHeight());
                        ++this.imageCount;
                    } else {
                        this.singleImage = null;
                    }
                }
                if (this.rawKey == null) {
                    this.objectStoreRef.saveStoredImage(pageNumber + "_HIRES_" + this.currentItem, image, false, false, "tif");
                    this.imageIDtoName.put(this.currentItem, pageNumber + "_HIRES_" + this.currentItem);
                } else {
                    this.objectStoreRef.saveStoredImage(pageNumber + "_HIRES_" + this.currentItem + '_' + this.rawKey, image, false, false, "tif");
                    this.imageIDtoName.put(this.currentItem, pageNumber + "_HIRES_" + this.currentItem + '_' + this.rawKey);
                }
                key = this.rawKey == null ? pageNumber + "_" + this.currentItem : this.rawKey + '_' + this.currentItem;
                this.cachedWidths.put(key, w);
                this.cachedHeights.put(key, h);
            }
        }
        this.x_coord = RenderUtils.checkSize(this.x_coord, this.currentItem);
        this.y_coord = RenderUtils.checkSize(this.y_coord, this.currentItem);
        this.x_coord[this.currentItem] = x;
        this.y_coord[this.currentItem] = y;
        this.objectType.addElement(3);
        float WidthModifier = 1.0f;
        float HeightModifier = 1.0f;
        if (this.useHiResImageForDisplay) {
            if (!alreadyCached) {
                WidthModifier = image.getWidth();
                HeightModifier = image.getHeight();
            } else {
                WidthModifier = ((Integer)this.cachedWidths.get(key)).intValue();
                HeightModifier = ((Integer)this.cachedHeights.get(key)).intValue();
            }
        }
        if (CTM[0][0] > 0.0f && (double)CTM[0][0] < 0.05 && CTM[0][1] != 0.0f && CTM[1][0] != 0.0f && CTM[1][1] != 0.0f) {
            this.areas.addElement(null);
        } else {
            this.w = (int)(CTM[0][0] * WidthModifier);
            if (this.w == 0) {
                this.w = (int)(CTM[0][1] * WidthModifier);
            }
            this.h = (int)(CTM[1][1] * HeightModifier);
            if (this.h == 0) {
                this.h = (int)(CTM[1][0] * HeightModifier);
            }
            if (!this.useHiResImageForDisplay && CTM[1][0] < 0.0f && CTM[0][1] > 0.0f && CTM[0][0] == 0.0f && CTM[1][1] == 0.0f) {
                int tmp = this.w;
                this.w = -this.h;
                this.h = tmp;
            }
            if (this.h < 0 && !this.useHiResImageForDisplay) {
                this.h = -this.h;
            }
            int x1 = (int)currentGraphicsState.x;
            int y1 = (int)currentGraphicsState.y;
            int w1 = this.w;
            int h1 = this.h;
            if (h1 < 0) {
                y1 += h1;
                h1 = -h1;
            }
            if (h1 == 0) {
                h1 = 1;
            }
            Rectangle rect = new Rectangle(x1, y1, w1, h1);
            this.areas.addElement(rect);
            this.checkWidth(rect);
        }
        if (this.useHiResImageForDisplay && !cacheInMemory) {
            this.pageObjects.addElement(null);
        } else {
            this.pageObjects.addElement(image);
        }
        this.imageID.put(name, this.currentItem);
        this.storedImageValues.put("imageOptions-" + this.currentItem, optionsApplied);
        this.storedImageValues.put("imageAff-" + this.currentItem, nextAf);
        ++this.currentItem;
        return this.currentItem - 1;
    }

    private int redrawImage(int pageNumber, GraphicsState currentGraphicsState, String name, int previousUse) {
        this.pageNumber = pageNumber;
        float x = currentGraphicsState.x;
        float y = currentGraphicsState.y;
        this.imageOptions.addElement((Integer)this.storedImageValues.get("imageOptions-" + previousUse));
        if (this.useHiResImageForDisplay) {
            // empty if block
        }
        this.x_coord = RenderUtils.checkSize(this.x_coord, this.currentItem);
        this.y_coord = RenderUtils.checkSize(this.y_coord, this.currentItem);
        this.x_coord[this.currentItem] = x;
        this.y_coord[this.currentItem] = y;
        this.objectType.addElement(29);
        Rectangle previousRectangle = this.areas.elementAt(previousUse);
        Rectangle newRect = null;
        if (previousRectangle != null) {
            newRect = new Rectangle((int)x, (int)y, previousRectangle.width, previousRectangle.height);
        }
        this.areas.addElement(newRect);
        if (previousRectangle != null) {
            this.checkWidth(newRect);
        }
        this.pageObjects.addElement(previousUse);
        this.imageID.put(name, previousUse);
        ++this.currentItem;
        return this.currentItem - 1;
    }

    private void checkWidth(Rectangle rect) {
        int x1 = rect.getBounds().x;
        int y2 = rect.getBounds().y;
        int y1 = y2 + rect.getBounds().height;
        int x2 = x1 + rect.getBounds().width;
        if (x1 < this.pageX1) {
            this.pageX1 = x1;
        }
        if (x2 > this.pageX2) {
            this.pageX2 = x2;
        }
        if (y1 > this.pageY1) {
            this.pageY1 = y1;
        }
        if (y2 < this.pageY2) {
            this.pageY2 = y2;
        }
    }

    @Override
    public Rectangle getOccupiedArea() {
        return new Rectangle(this.pageX1, this.pageY1, this.pageX2 - this.pageX1, this.pageY1 - this.pageY2);
    }

    @Override
    public void drawShape(Shape currentShape, GraphicsState currentGraphicsState, int cmd) {
        int newCol;
        PdfPaint currentCol;
        int fillType = currentGraphicsState.getFillType();
        if (currentShape.getBounds().getWidth() == 1.0 && currentShape.getBounds().getHeight() == 1.0 && currentGraphicsState.getLineWidth() < 1.0f) {
            currentShape = new Rectangle(currentShape.getBounds().x, currentShape.getBounds().y, 1, 1);
        }
        if (fillType == 2 || fillType == 3) {
            currentCol = currentGraphicsState.getNonstrokeColor();
            if (currentCol.isPattern()) {
                this.drawFillColor(currentCol);
                this.fillSet = true;
            } else {
                newCol = currentCol.getRGB();
                if (!this.fillSet || this.lastFillCol != newCol) {
                    this.lastFillCol = newCol;
                    this.drawFillColor(currentCol);
                    this.fillSet = true;
                }
            }
        }
        if (fillType == 1 || fillType == 3) {
            currentCol = currentGraphicsState.getStrokeColor();
            if (currentCol instanceof Color) {
                newCol = currentCol.getRGB();
                if (!this.strokeSet || this.lastStrokeCol != newCol) {
                    this.lastStrokeCol = newCol;
                    this.drawStrokeColor(currentCol);
                    this.strokeSet = true;
                }
            } else {
                this.drawStrokeColor(currentCol);
                this.strokeSet = true;
            }
        }
        Stroke newStroke = currentGraphicsState.getStroke();
        if (this.lastStroke == null || !this.lastStroke.equals(newStroke)) {
            this.lastStroke = newStroke;
            this.drawStroke(newStroke);
        }
        this.pageObjects.addElement(currentShape);
        this.objectType.addElement(2);
        this.areas.addElement(currentShape.getBounds());
        this.checkWidth(currentShape.getBounds());
        this.x_coord = RenderUtils.checkSize(this.x_coord, this.currentItem);
        this.y_coord = RenderUtils.checkSize(this.y_coord, this.currentItem);
        this.x_coord[this.currentItem] = currentGraphicsState.x;
        this.y_coord[this.currentItem] = currentGraphicsState.y;
        this.shapeType.addElement(fillType);
        ++this.currentItem;
        this.resetTextColors = true;
    }

    @Override
    public void drawColor(PdfPaint currentCol, int type) {
        this.areas.addElement(null);
        this.pageObjects.addElement(null);
        this.objectType.addElement(10);
        this.textFillType.addElement(type);
        this.text_color.addElement(currentCol);
        this.x_coord = RenderUtils.checkSize(this.x_coord, this.currentItem);
        this.y_coord = RenderUtils.checkSize(this.y_coord, this.currentItem);
        this.x_coord[this.currentItem] = 0.0f;
        this.y_coord[this.currentItem] = 0.0f;
        ++this.currentItem;
        this.strokeSet = false;
        this.fillSet = false;
    }

    @Override
    public void drawXForm(DynamicVectorRenderer dvr, GraphicsState gs) {
        this.areas.addElement(null);
        this.pageObjects.addElement(dvr);
        this.objectType.addElement(25);
        this.x_coord = RenderUtils.checkSize(this.x_coord, this.currentItem);
        this.y_coord = RenderUtils.checkSize(this.y_coord, this.currentItem);
        this.x_coord[this.currentItem] = 0.0f;
        this.y_coord[this.currentItem] = 0.0f;
        ++this.currentItem;
    }

    @Override
    public void resetOnColorspaceChange() {
        this.fillSet = false;
        this.strokeSet = false;
    }

    @Override
    public void drawFillColor(PdfPaint currentCol) {
        this.pageObjects.addElement(null);
        this.objectType.addElement(11);
        this.areas.addElement(null);
        this.fill_color.addElement(currentCol);
        this.x_coord = RenderUtils.checkSize(this.x_coord, this.currentItem);
        this.y_coord = RenderUtils.checkSize(this.y_coord, this.currentItem);
        this.x_coord[this.currentItem] = 0.0f;
        this.y_coord[this.currentItem] = 0.0f;
        ++this.currentItem;
        this.lastFillCol = currentCol.getRGB();
    }

    @Override
    public void setGraphicsState(int fillType, float value) {
        if (value != 1.0f || this.opacity != null) {
            if (this.opacity == null) {
                this.opacity = new Vector_Float(5000);
                this.opacity.setCheckpoint();
            }
            this.pageObjects.addElement(null);
            this.areas.addElement(null);
            if (fillType == 1) {
                this.objectType.addElement(17);
            } else {
                this.objectType.addElement(18);
            }
            this.opacity.addElement(value);
            this.x_coord = RenderUtils.checkSize(this.x_coord, this.currentItem);
            this.y_coord = RenderUtils.checkSize(this.y_coord, this.currentItem);
            this.x_coord[this.currentItem] = 0.0f;
            this.y_coord[this.currentItem] = 0.0f;
            ++this.currentItem;
        }
    }

    @Override
    public void drawAdditionalObjectsOverPage(int[] type, Color[] colors, Object[] obj) throws PdfException {
        if (obj == null) {
            return;
        }
        if (this.endItem == -1) {
            this.endItem = this.currentItem;
            this.objectType.setCheckpoint();
            this.shapeType.setCheckpoint();
            this.pageObjects.setCheckpoint();
            this.areas.setCheckpoint();
            this.clips.setCheckpoint();
            this.textFillType.setCheckpoint();
            this.text_color.setCheckpoint();
            this.fill_color.setCheckpoint();
            this.stroke_color.setCheckpoint();
            this.stroke.setCheckpoint();
            if (this.imageOptions == null) {
                this.imageOptions = new Vector_Int(5000);
            }
            this.imageOptions.setCheckpoint();
            if (this.TRvalues == null) {
                this.TRvalues = new Vector_Int(5000);
            }
            this.TRvalues.setCheckpoint();
            if (this.fs == null) {
                this.fs = new Vector_Int(5000);
            }
            this.fs.setCheckpoint();
            if (this.lw == null) {
                this.lw = new Vector_Int(5000);
            }
            this.lw.setCheckpoint();
            this.af1.setCheckpoint();
            this.af2.setCheckpoint();
            this.af3.setCheckpoint();
            this.af4.setCheckpoint();
            this.fontBounds.setCheckpoint();
            if (this.opacity != null) {
                this.opacity.setCheckpoint();
            }
        }
        int count = type.length;
        boolean debug = false;
        block10: for (int i = 0; i < count; ++i) {
            int currentType = type[i];
            switch (currentType) {
                case 18: {
                    this.setGraphicsState(2, ((Float)obj[i]).floatValue());
                    continue block10;
                }
                case 17: {
                    this.setGraphicsState(1, ((Float)obj[i]).floatValue());
                    continue block10;
                }
                case 19: {
                    GraphicsState gs = new GraphicsState();
                    gs.setFillType(1);
                    gs.setStrokeColor(new PdfColor(colors[i].getRed(), colors[i].getGreen(), colors[i].getBlue()));
                    this.drawShape((Shape)obj[i], gs, 83);
                    continue block10;
                }
                case 20: {
                    GraphicsState gs = new GraphicsState();
                    gs.setFillType(2);
                    gs.setNonstrokeColor(new PdfColor(colors[i].getRed(), colors[i].getGreen(), colors[i].getBlue()));
                    this.drawShape((Shape)obj[i], gs, 70);
                    continue block10;
                }
                case 23: {
                    this.drawCustom(obj[i]);
                    continue block10;
                }
                case 3: {
                    ImageObject imgObj = (ImageObject)obj[i];
                    GraphicsState gs = new GraphicsState();
                    gs.CTM = new float[][]{{imgObj.image.getWidth(), 0.0f, 1.0f}, {0.0f, imgObj.image.getHeight(), 1.0f}, {0.0f, 0.0f, 0.0f}};
                    gs.x = imgObj.x;
                    gs.y = imgObj.y;
                    this.drawImage(this.pageNumber, imgObj.image, gs, false, "extImg" + i, 0, -1);
                    continue block10;
                }
                case 16: {
                    TextObject textObj = (TextObject)obj[i];
                    GraphicsState gs = new GraphicsState();
                    float fontSize = textObj.font.getSize();
                    double[] afValues = new double[]{fontSize, 0.0, 0.0, fontSize, 0.0, 0.0};
                    this.drawAffine(afValues);
                    this.drawTR(2);
                    gs.setTextRenderType(2);
                    gs.setNonstrokeColor(new PdfColor(colors[i].getRed(), colors[i].getGreen(), colors[i].getBlue()));
                    this.drawText(null, textObj.text, gs, textObj.x, -textObj.y, textObj.font);
                    continue block10;
                }
                case 0: {
                    continue block10;
                }
                default: {
                    throw new PdfException("Unrecognised type " + currentType);
                }
            }
        }
    }

    private static String getTypeAsString(int i) {
        String str = "Value Not set";
        switch (i) {
            case 18: {
                str = "FILLOPACITY";
                break;
            }
            case 17: {
                str = "STROKEOPACITY";
                break;
            }
            case 19: {
                str = "STROKEDSHAPE";
                break;
            }
            case 20: {
                str = "FILLEDSHAPE";
                break;
            }
            case 23: {
                str = "CUSTOM";
                break;
            }
            case 3: {
                str = "IMAGE";
                break;
            }
            case 16: {
                str = "String";
            }
        }
        return str;
    }

    @Override
    public void flushAdditionalObjOnPage() {
        if (this.endItem != -1) {
            this.currentItem = this.endItem;
        }
        this.endItem = -1;
        this.objectType.resetToCheckpoint();
        this.shapeType.resetToCheckpoint();
        this.pageObjects.resetToCheckpoint();
        this.areas.resetToCheckpoint();
        this.clips.resetToCheckpoint();
        this.textFillType.resetToCheckpoint();
        this.text_color.resetToCheckpoint();
        this.fill_color.resetToCheckpoint();
        this.stroke_color.resetToCheckpoint();
        this.stroke.resetToCheckpoint();
        if (this.imageOptions != null) {
            this.imageOptions.resetToCheckpoint();
        }
        if (this.TRvalues != null) {
            this.TRvalues.resetToCheckpoint();
        }
        if (this.fs != null) {
            this.fs.resetToCheckpoint();
        }
        if (this.lw != null) {
            this.lw.resetToCheckpoint();
        }
        this.af1.resetToCheckpoint();
        this.af2.resetToCheckpoint();
        this.af3.resetToCheckpoint();
        this.af4.resetToCheckpoint();
        this.fontBounds.resetToCheckpoint();
        if (this.opacity != null) {
            this.opacity.resetToCheckpoint();
        }
        this.lastFillTextCol = 0;
        this.lastFillCol = 0;
        this.lastStrokeCol = 0;
        this.lastClip = null;
        this.hasClips = false;
        this.lastStroke = null;
        this.lastAf = new double[4];
        this.fillSet = false;
        this.strokeSet = false;
    }

    @Override
    public void drawStrokeColor(Paint currentCol) {
        this.pageObjects.addElement(null);
        this.objectType.addElement(12);
        this.areas.addElement(null);
        this.stroke_color.addElement(currentCol);
        this.x_coord = RenderUtils.checkSize(this.x_coord, this.currentItem);
        this.y_coord = RenderUtils.checkSize(this.y_coord, this.currentItem);
        this.x_coord[this.currentItem] = 0.0f;
        this.y_coord[this.currentItem] = 0.0f;
        ++this.currentItem;
        this.strokeSet = false;
        this.fillSet = false;
        this.resetTextColors = true;
    }

    @Override
    public void drawCustom(Object value) {
        this.pageObjects.addElement(value);
        this.objectType.addElement(23);
        this.areas.addElement(null);
        this.x_coord = RenderUtils.checkSize(this.x_coord, this.currentItem);
        this.y_coord = RenderUtils.checkSize(this.y_coord, this.currentItem);
        this.x_coord[this.currentItem] = 0.0f;
        this.y_coord[this.currentItem] = 0.0f;
        ++this.currentItem;
    }

    @Override
    public void drawTR(int value) {
        if (value != this.lastTR) {
            if (this.TRvalues == null) {
                this.TRvalues = new Vector_Int(5000);
                this.TRvalues.setCheckpoint();
            }
            this.lastTR = value;
            this.pageObjects.addElement(null);
            this.objectType.addElement(15);
            this.areas.addElement(null);
            this.TRvalues.addElement(value);
            this.x_coord = RenderUtils.checkSize(this.x_coord, this.currentItem);
            this.y_coord = RenderUtils.checkSize(this.y_coord, this.currentItem);
            this.x_coord[this.currentItem] = 0.0f;
            this.y_coord[this.currentItem] = 0.0f;
            ++this.currentItem;
        }
    }

    @Override
    public void drawStroke(Stroke current) {
        this.pageObjects.addElement(null);
        this.objectType.addElement(14);
        this.areas.addElement(null);
        this.stroke.addElement(current);
        this.x_coord = RenderUtils.checkSize(this.x_coord, this.currentItem);
        this.y_coord = RenderUtils.checkSize(this.y_coord, this.currentItem);
        this.x_coord[this.currentItem] = 0.0f;
        this.y_coord[this.currentItem] = 0.0f;
        ++this.currentItem;
    }

    @Override
    public void drawClip(GraphicsState currentGraphicsState, Shape defaultClip, boolean canBeCached) {
        boolean resetClip = false;
        Area clip = currentGraphicsState.getClippingShape();
        if (!canBeCached || !this.hasClips || this.lastClip != null || clip != null) {
            if (!canBeCached || this.lastClip == null || clip == null) {
                resetClip = true;
            } else {
                Rectangle bounds = clip.getBounds();
                Rectangle oldBounds = this.lastClip.getBounds();
                if (bounds.x != oldBounds.x || bounds.y != oldBounds.y || bounds.width != oldBounds.width || bounds.height != oldBounds.height) {
                    resetClip = true;
                } else {
                    int count = SwingDisplay.isRectangle(bounds);
                    int count2 = SwingDisplay.isRectangle(oldBounds);
                    if (!(count == 6 && count2 == 6 || clip.equals(this.lastClip))) {
                        resetClip = true;
                    }
                }
            }
        }
        if (resetClip) {
            this.pageObjects.addElement(null);
            this.objectType.addElement(7);
            this.areas.addElement(null);
            this.lastClip = clip;
            if (clip == null) {
                this.clips.addElement(null);
            } else {
                this.clips.addElement((Area)clip.clone());
            }
            this.x_coord = RenderUtils.checkSize(this.x_coord, this.currentItem);
            this.y_coord = RenderUtils.checkSize(this.y_coord, this.currentItem);
            this.x_coord[this.currentItem] = currentGraphicsState.x;
            this.y_coord[this.currentItem] = currentGraphicsState.y;
            ++this.currentItem;
            this.hasClips = true;
        }
    }

    @Override
    public void drawEmbeddedText(float[][] Trm, int fontSize, PdfGlyph embeddedGlyph, Object javaGlyph, int type, GraphicsState gs, AffineTransform at, String glyf, PdfFont currentFontData, float glyfWidth) {
        int newCol;
        PdfPaint currentCol;
        int text_fill_type = gs.getTextRenderType();
        if ((text_fill_type & 2) == 2) {
            currentCol = gs.getNonstrokeColor();
            if (currentCol.isPattern()) {
                this.drawColor(currentCol, 2);
                this.resetTextColors = true;
            } else {
                newCol = currentCol.getRGB();
                if (this.resetTextColors || this.lastFillTextCol != newCol) {
                    this.lastFillTextCol = newCol;
                    this.drawColor(currentCol, 2);
                    this.resetTextColors = false;
                }
            }
        }
        if ((text_fill_type & 1) == 1) {
            currentCol = gs.getStrokeColor();
            if (currentCol.isPattern()) {
                this.drawColor(currentCol, 1);
                this.resetTextColors = true;
            } else {
                newCol = currentCol.getRGB();
                if (this.resetTextColors || this.lastStrokeCol != newCol) {
                    this.resetTextColors = false;
                    this.lastStrokeCol = newCol;
                    this.drawColor(currentCol, 1);
                }
            }
        }
        this.setLineWidth((int)gs.getLineWidth());
        this.drawFontSize(fontSize);
        if (javaGlyph != null) {
            double[] nextAf;
            if (Trm != null && (this.lastAf[0] != (nextAf = new double[]{Trm[0][0], Trm[0][1], Trm[1][0], Trm[1][1], Trm[2][0], Trm[2][1]})[0] || this.lastAf[1] != nextAf[1] || this.lastAf[2] != nextAf[2] || this.lastAf[3] != nextAf[3])) {
                this.drawAffine(nextAf);
                this.lastAf[0] = nextAf[0];
                this.lastAf[1] = nextAf[1];
                this.lastAf[2] = nextAf[2];
                this.lastAf[3] = nextAf[3];
            }
            if (!(javaGlyph instanceof Area)) {
                type = -type;
            }
        } else {
            double[] nextAf = new double[6];
            at.getMatrix(nextAf);
            if (this.lastAf[0] != nextAf[0] || this.lastAf[1] != nextAf[1] || this.lastAf[2] != nextAf[2] || this.lastAf[3] != nextAf[3]) {
                this.drawAffine(nextAf);
                this.lastAf[0] = nextAf[0];
                this.lastAf[1] = nextAf[1];
                this.lastAf[2] = nextAf[2];
                this.lastAf[3] = nextAf[3];
            }
        }
        if (embeddedGlyph == null) {
            this.pageObjects.addElement(javaGlyph);
        } else {
            this.pageObjects.addElement(embeddedGlyph);
        }
        this.objectType.addElement(type);
        if (type < 0) {
            this.areas.addElement(null);
        } else if (javaGlyph != null) {
            this.areas.addElement(new Rectangle((int)Trm[2][0], (int)Trm[2][1], fontSize, fontSize));
            this.checkWidth(new Rectangle((int)Trm[2][0], (int)Trm[2][1], fontSize, fontSize));
        } else {
            int realSize = fontSize;
            if (realSize < 0) {
                realSize = -realSize;
            }
            Rectangle area = new Rectangle((int)Trm[2][0], (int)Trm[2][1], realSize, realSize);
            this.areas.addElement(area);
            this.checkWidth(area);
        }
        this.x_coord = RenderUtils.checkSize(this.x_coord, this.currentItem);
        this.y_coord = RenderUtils.checkSize(this.y_coord, this.currentItem);
        this.x_coord[this.currentItem] = Trm[2][0];
        this.y_coord[this.currentItem] = Trm[2][1];
        ++this.currentItem;
    }

    @Override
    public void drawFontBounds(Rectangle newfontBB) {
        this.pageObjects.addElement(null);
        this.objectType.addElement(24);
        this.areas.addElement(null);
        this.fontBounds.addElement(newfontBB);
        this.x_coord = RenderUtils.checkSize(this.x_coord, this.currentItem);
        this.y_coord = RenderUtils.checkSize(this.y_coord, this.currentItem);
        this.x_coord[this.currentItem] = 0.0f;
        this.y_coord[this.currentItem] = 0.0f;
        ++this.currentItem;
    }

    @Override
    public void drawAffine(double[] afValues) {
        this.pageObjects.addElement(null);
        this.objectType.addElement(9);
        this.areas.addElement(null);
        this.af1.addElement(afValues[0]);
        this.af2.addElement(afValues[1]);
        this.af3.addElement(afValues[2]);
        this.af4.addElement(afValues[3]);
        this.x_coord = RenderUtils.checkSize(this.x_coord, this.currentItem);
        this.y_coord = RenderUtils.checkSize(this.y_coord, this.currentItem);
        this.x_coord[this.currentItem] = (float)afValues[4];
        this.y_coord[this.currentItem] = (float)afValues[5];
        ++this.currentItem;
    }

    @Override
    public void drawFontSize(int fontSize) {
        int realSize = fontSize;
        if (realSize < 0) {
            realSize = -realSize;
        }
        if (realSize != this.lastFS) {
            this.pageObjects.addElement(null);
            this.objectType.addElement(21);
            this.areas.addElement(null);
            if (this.fs == null) {
                this.fs = new Vector_Int(5000);
                this.fs.setCheckpoint();
            }
            this.fs.addElement(fontSize);
            this.x_coord = RenderUtils.checkSize(this.x_coord, this.currentItem);
            this.y_coord = RenderUtils.checkSize(this.y_coord, this.currentItem);
            this.x_coord[this.currentItem] = 0.0f;
            this.y_coord[this.currentItem] = 0.0f;
            ++this.currentItem;
            this.lastFS = realSize;
        }
    }

    @Override
    public void setLineWidth(int lineWidth) {
        if (lineWidth != this.lastLW) {
            this.areas.addElement(null);
            this.pageObjects.addElement(null);
            this.objectType.addElement(22);
            if (this.lw == null) {
                this.lw = new Vector_Int(5000);
                this.lw.setCheckpoint();
            }
            this.lw.addElement(lineWidth);
            this.x_coord = RenderUtils.checkSize(this.x_coord, this.currentItem);
            this.y_coord = RenderUtils.checkSize(this.y_coord, this.currentItem);
            this.x_coord[this.currentItem] = 0.0f;
            this.y_coord[this.currentItem] = 0.0f;
            ++this.currentItem;
            this.lastLW = lineWidth;
        }
    }

    public SwingDisplay(byte[] stream, Map fonts) {
        block5: {
            this.ignoreHighlight = false;
            this.noRepaint = false;
            this.lastItemPainted = -1;
            this.optimsePainting = false;
            this.needsHorizontalInvert = false;
            this.needsVerticalInvert = false;
            this.pageX1 = 9999;
            this.pageX2 = -9999;
            this.pageY1 = -9999;
            this.pageY2 = 9999;
            this.highlightsNeedToBeGenerated = false;
            this.singleImage = null;
            this.imageCount = 0;
            this.endItem = -1;
            this.cachedWidths = new HashMap(10);
            this.cachedHeights = new HashMap(10);
            this.fonts = new HashMap(50);
            this.fontsUsed = new HashMap(50);
            this.factory = null;
            this.imageID = new HashMap(10);
            this.imageIDtoName = new HashMap(10);
            this.storedImageValues = new HashMap(10);
            this.largeImages = new WeakHashMap(10);
            this.currentItem = 0;
            this.lastStroke = null;
            this.lastAf = new double[4];
            this.lastTR = 2;
            this.lastFS = -1;
            this.lastLW = -1;
            this.resetTextColors = true;
            this.fillSet = false;
            this.strokeSet = false;
            this.needsHighlights = true;
            this.paintThreadCount = 0;
            this.paintThreadID = 0;
            this.hasOCR = false;
            this.type = 1;
            this.minX = -1.0;
            this.minY = -1.0;
            this.maxX = -1.0;
            this.maxY = -1.0;
            this.frame = null;
            try {
                this.fonts = fonts;
                ByteArrayInputStream bis = new ByteArrayInputStream(stream);
                int version = bis.read();
                if (version != 1) {
                    throw new PdfException("Unknown version in serialised object " + version);
                }
                int isHires = bis.read();
                this.useHiResImageForDisplay = isHires == 1;
                this.pageNumber = bis.read();
                this.x_coord = (float[])RenderUtils.restoreFromStream(bis);
                this.y_coord = (float[])RenderUtils.restoreFromStream(bis);
                this.text_color = (Vector_Object)RenderUtils.restoreFromStream(bis);
                this.textFillType = (Vector_Int)RenderUtils.restoreFromStream(bis);
                this.stroke_color = new Vector_Object();
                this.stroke_color.restoreFromStream(bis);
                this.fill_color = new Vector_Object();
                this.fill_color.restoreFromStream(bis);
                this.stroke = new Vector_Object();
                this.stroke.restoreFromStream(bis);
                this.pageObjects = new Vector_Object();
                this.pageObjects.restoreFromStream(bis);
                this.javaObjects = (Vector_Object)RenderUtils.restoreFromStream(bis);
                this.shapeType = (Vector_Int)RenderUtils.restoreFromStream(bis);
                this.af1 = (Vector_Double)RenderUtils.restoreFromStream(bis);
                this.af2 = (Vector_Double)RenderUtils.restoreFromStream(bis);
                this.af3 = (Vector_Double)RenderUtils.restoreFromStream(bis);
                this.af4 = (Vector_Double)RenderUtils.restoreFromStream(bis);
                this.fontBounds = new Vector_Rectangle();
                this.fontBounds.restoreFromStream(bis);
                this.clips = new Vector_Shape();
                this.clips.restoreFromStream(bis);
                this.objectType = (Vector_Int)RenderUtils.restoreFromStream(bis);
                this.opacity = (Vector_Float)RenderUtils.restoreFromStream(bis);
                this.imageOptions = (Vector_Int)RenderUtils.restoreFromStream(bis);
                this.TRvalues = (Vector_Int)RenderUtils.restoreFromStream(bis);
                this.fs = (Vector_Int)RenderUtils.restoreFromStream(bis);
                this.lw = (Vector_Int)RenderUtils.restoreFromStream(bis);
                int fontCount = (Integer)RenderUtils.restoreFromStream(bis);
                for (int ii = 0; ii < fontCount; ++ii) {
                    Object key = RenderUtils.restoreFromStream(bis);
                    Object glyphs = RenderUtils.restoreFromStream(bis);
                    fonts.put(key, glyphs);
                }
                int alteredFontCount = (Integer)RenderUtils.restoreFromStream(bis);
                for (int ii = 0; ii < alteredFontCount; ++ii) {
                    Object key = RenderUtils.restoreFromStream(bis);
                    PdfJavaGlyphs updatedFont = (PdfJavaGlyphs)fonts.get(key);
                    updatedFont.setDisplayValues((Map)RenderUtils.restoreFromStream(bis));
                    updatedFont.setCharGlyphs((Map)RenderUtils.restoreFromStream(bis));
                    updatedFont.setEmbeddedEncs((Map)RenderUtils.restoreFromStream(bis));
                }
                bis.close();
            }
            catch (Exception e) {
                if (!LogWriter.isOutput()) break block5;
                LogWriter.writeLog("Exception: " + e.getMessage());
            }
        }
        this.currentItem = this.pageObjects.get().length;
    }

    @Override
    public void stopClearOnNextRepaint(boolean flag) {
        this.noRepaint = flag;
    }

    @Override
    public byte[] serializeToByteArray(Set fontsAlreadyOnClient) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        bos.write(1);
        if (this.useHiResImageForDisplay) {
            bos.write(1);
        } else {
            bos.write(0);
        }
        bos.write(this.pageNumber);
        this.text_color.trim();
        this.stroke_color.trim();
        this.fill_color.trim();
        this.stroke.trim();
        this.pageObjects.trim();
        this.javaObjects.trim();
        this.stroke.trim();
        this.pageObjects.trim();
        this.javaObjects.trim();
        this.shapeType.trim();
        this.af1.trim();
        this.af2.trim();
        this.af3.trim();
        this.af4.trim();
        this.fontBounds.trim();
        this.clips.trim();
        this.objectType.trim();
        if (this.opacity != null) {
            this.opacity.trim();
        }
        if (this.imageOptions != null) {
            this.imageOptions.trim();
        }
        if (this.TRvalues != null) {
            this.TRvalues.trim();
        }
        if (this.fs != null) {
            this.fs.trim();
        }
        if (this.lw != null) {
            this.lw.trim();
        }
        RenderUtils.writeToStream(bos, this.x_coord, "x_coord");
        RenderUtils.writeToStream(bos, this.y_coord, "y_coord");
        RenderUtils.writeToStream(bos, this.text_color, "text_color");
        RenderUtils.writeToStream(bos, this.textFillType, "textFillType");
        this.stroke_color.writeToStream(bos);
        this.fill_color.writeToStream(bos);
        this.stroke.writeToStream(bos);
        this.pageObjects.writeToStream(bos);
        RenderUtils.writeToStream(bos, this.javaObjects, "javaObjects");
        RenderUtils.writeToStream(bos, this.shapeType, "shapeType");
        RenderUtils.writeToStream(bos, this.af1, "af1");
        RenderUtils.writeToStream(bos, this.af2, "af2");
        RenderUtils.writeToStream(bos, this.af3, "af3");
        RenderUtils.writeToStream(bos, this.af4, "af4");
        this.fontBounds.writeToStream(bos);
        this.clips.writeToStream(bos);
        RenderUtils.writeToStream(bos, this.objectType, "objectType");
        RenderUtils.writeToStream(bos, this.opacity, "opacity");
        RenderUtils.writeToStream(bos, this.imageOptions, "imageOptions");
        RenderUtils.writeToStream(bos, this.TRvalues, "TRvalues");
        RenderUtils.writeToStream(bos, this.fs, "fs");
        RenderUtils.writeToStream(bos, this.lw, "lw");
        int fontCount = 0;
        int updateCount = 0;
        HashMap fontsAlreadySent = new HashMap(10);
        HashMap newFontsToSend = new HashMap(10);
        for (Object fontUsed : this.fontsUsed.keySet()) {
            if (!fontsAlreadyOnClient.contains(fontUsed)) {
                ++fontCount;
                newFontsToSend.put(fontUsed, "x");
                continue;
            }
            ++updateCount;
            fontsAlreadySent.put(fontUsed, "x");
        }
        RenderUtils.writeToStream(bos, fontCount, "new Integer(fontCount)");
        for (Object key : newFontsToSend.keySet()) {
            RenderUtils.writeToStream(bos, key, "key");
            RenderUtils.writeToStream(bos, this.fonts.get(key), "font");
            fontsAlreadyOnClient.add(key);
        }
        RenderUtils.writeToStream(bos, updateCount, "new Integer(existingfontCount)");
        for (Object key : fontsAlreadySent.keySet()) {
            RenderUtils.writeToStream(bos, key, "key");
            PdfJavaGlyphs aa = (PdfJavaGlyphs)this.fonts.get(key);
            RenderUtils.writeToStream(bos, aa.getDisplayValues(), "display");
            RenderUtils.writeToStream(bos, aa.getCharGlyphs(), "char");
            RenderUtils.writeToStream(bos, aa.getEmbeddedEncs(), "emb");
        }
        bos.close();
        this.fontsUsed.clear();
        return bos.toByteArray();
    }

    @Override
    public void setneedsVerticalInvert(boolean b) {
        this.needsVerticalInvert = b;
    }

    @Override
    public void setneedsHorizontalInvert(boolean b) {
        this.needsHorizontalInvert = b;
    }

    @Override
    public void checkFontSaved(Object glyph, String name, PdfFont currentFontData) {
        this.pageObjects.addElement(glyph);
        this.objectType.addElement(200);
        this.areas.addElement(null);
        ++this.currentItem;
        if (this.fontsUsed.get(name) == null || currentFontData.isFontSubsetted()) {
            this.fonts.put(name, currentFontData.getGlyphData());
            this.fontsUsed.put(name, "x");
        }
    }

    @Override
    public Rectangle getArea(int i) {
        return this.areas.elementAt(i);
    }

    @Override
    public int isInsideImage(int x, int y) {
        int outLine = -1;
        Rectangle[] areas = this.areas.get();
        Rectangle possArea = null;
        int count = areas.length;
        int[] types = this.objectType.get();
        for (int i = 0; i < count; ++i) {
            if (areas[i] == null || !RenderUtils.rectangleContains(areas[i], x, y, i) || types[i] != 3) continue;
            if (possArea != null) {
                int area2 = areas[i].height * areas[i].width;
                int area1 = possArea.height * possArea.width;
                if (area2 < area1) {
                    possArea = areas[i];
                }
                outLine = i;
                continue;
            }
            possArea = areas[i];
            outLine = i;
        }
        return outLine;
    }

    @Override
    public void saveImage(int id, String des, String type) {
        block16: {
            String name = (String)this.imageIDtoName.get(id);
            BufferedImage image = null;
            if (this.useHiResImageForDisplay) {
                image = this.objectStoreRef.loadStoredImage(name);
                if (image == null) {
                    image = (BufferedImage)this.pageObjects.elementAt(id);
                }
            } else {
                image = (BufferedImage)this.pageObjects.elementAt(id);
            }
            if (image != null) {
                if (!this.optimisedTurnCode) {
                    image = RenderUtils.invertImage(null, image);
                }
                if ((image.getType() == 0 || type.equals("jpg") && image.getType() == 2) && (image = ColorSpaceConvertor.convertToRGB(image)).getType() == 0 && PdfDecoder.showErrorMessages) {
                    JOptionPane.showMessageDialog(null, "This is a custom Image, Java's standard libraries may not be able to save the image as a jpg correctly.\nEnabling JAI will ensure correct output. \n\nFor information on how to do this please go to http://www.jpedal.org/flags.php");
                }
                if (this.needsHorizontalInvert) {
                    image = RenderUtils.invertImageBeforeSave(image, true);
                }
                if (this.needsVerticalInvert) {
                    image = RenderUtils.invertImageBeforeSave(image, false);
                }
                if (JAIHelper.isJAIused() && type.toLowerCase().startsWith("tif")) {
                    JAI.create((String)"filestore", (RenderedImage)image, (Object)des, (Object)type);
                } else if (type.toLowerCase().startsWith("tif")) {
                    if (PdfDecoder.showErrorMessages) {
                        JOptionPane.showMessageDialog(null, "Please setup JAI library for Tiffs");
                    }
                    if (LogWriter.isOutput()) {
                        LogWriter.writeLog("Please setup JAI library for Tiffs");
                    }
                } else {
                    try {
                        BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(new File(des)));
                        ImageIO.write((RenderedImage)image, type, bos);
                        bos.flush();
                        bos.close();
                    }
                    catch (IOException e) {
                        if (!LogWriter.isOutput()) break block16;
                        LogWriter.writeLog("Exception: " + e.getMessage());
                    }
                }
            }
        }
    }

    @Override
    public void flagDecodingFinished() {
        this.highlightsNeedToBeGenerated = true;
    }

    private void generateHighlights(Graphics2D g2, int count, int[] objectTypes, Object[] pageObjects, float a, float b, float c, float d, double[] afValues1, double[] afValues2, double[] afValues3, double[] afValues4, int[] fsValues, Rectangle[] fontBounds) {
        this.highlightsNeedToBeGenerated = false;
        int[] highlightIDs = new int[count];
        int fsCount = -1;
        int fontBBCount = 0;
        Rectangle currentHighlight = null;
        float[] top = new float[count];
        float[] bottom = new float[count];
        float[] left = new float[count];
        float[] right = new float[count];
        boolean[] isFontEmbedded = new boolean[count];
        int[] fontSizes = new int[count];
        float[] w = new float[count];
        this.textHighlightsX = new int[count];
        int[] textHighlightsY = new int[count];
        this.textHighlightsWidth = new int[count];
        this.textHighlightsHeight = new int[count];
        int fontBoundsY = 0;
        int fontBoundsH = 1000;
        int fontBoundsW = 1000;
        int fontSize = 1;
        int realSize = 1;
        double[] matrix = new double[6];
        g2.getTransform().getMatrix(matrix);
        int pageRotation = 0;
        if (matrix[1] < 0.0 && matrix[2] < 0.0) {
            pageRotation = 270;
        }
        for (int i = 0; i < count; ++i) {
            this.type = objectTypes[i];
            if (this.type <= 0) continue;
            float x = this.x_coord[i];
            float y = this.y_coord[i];
            if (realSize < 0) {
                x += (float)realSize;
            }
            Object currentObject = pageObjects[i];
            if (this.type == 24) {
                currentHighlight = fontBounds[fontBBCount];
                fontBoundsH = currentHighlight.height;
                fontBoundsY = currentHighlight.y;
                fontBoundsW = currentHighlight.width;
                ++fontBBCount;
                continue;
            }
            if (this.type == 21) {
                if ((realSize = fsValues[++fsCount]) < 0) {
                    fontSize = -realSize;
                    continue;
                }
                fontSize = realSize;
                continue;
            }
            if (this.type != 4 && this.type != 5 && this.type != 1) continue;
            float scaling = 1.0f;
            if (this.type == 4 || this.type == 5) {
                PdfGlyph raw = (PdfGlyph)currentObject;
                scaling = (float)fontSize / 1000.0f;
                this.textHighlightsX[i] = raw.getFontBB(1);
                textHighlightsY[i] = fontBoundsY;
                this.textHighlightsWidth[i] = raw.getFontBB(3);
                this.textHighlightsHeight[i] = fontBoundsH;
                isFontEmbedded[i] = true;
                if (pageRotation == 90) {
                    bottom[i] = -((float)textHighlightsY[i] * scaling) + x;
                    left[i] = (float)this.textHighlightsX[i] * scaling + y;
                } else if (pageRotation == 270) {
                    bottom[i] = (float)textHighlightsY[i] * scaling + x;
                    left[i] = -((float)this.textHighlightsX[i] * scaling + y);
                } else {
                    bottom[i] = (float)textHighlightsY[i] * scaling + y;
                    left[i] = (float)this.textHighlightsX[i] * scaling + x;
                }
                top[i] = bottom[i] + (float)this.textHighlightsHeight[i] * scaling;
                right[i] = left[i] + (float)this.textHighlightsWidth[i] * scaling;
                w[i] = 10.0f;
                fontSizes[i] = fontSize;
            } else {
                scaling = 1.0f;
                float scale = 1000.0f / (float)fontSize;
                this.textHighlightsX[i] = (int)x;
                textHighlightsY[i] = (int)(y + (float)fontBoundsY / scale);
                this.textHighlightsWidth[i] = (int)((float)fontBoundsW / scale);
                this.textHighlightsHeight[i] = (int)((float)(fontBoundsH - fontBoundsY) / scale);
                if (pageRotation == 90) {
                    bottom[i] = -textHighlightsY[i];
                    left[i] = this.textHighlightsX[i];
                } else if (pageRotation == 270) {
                    bottom[i] = textHighlightsY[i];
                    left[i] = -this.textHighlightsX[i];
                } else {
                    bottom[i] = textHighlightsY[i];
                    left[i] = this.textHighlightsX[i];
                }
                top[i] = bottom[i] + (float)this.textHighlightsHeight[i];
                right[i] = left[i] + (float)this.textHighlightsWidth[i];
                w[i] = ((Area)currentObject).getBounds().width;
                fontSizes[i] = fontSize;
            }
            highlightIDs[i] = i;
        }
        int zz = -31;
        for (int aa = 0; aa < count - 1; ++aa) {
            int ptr = highlightIDs[aa];
            if (ptr == zz) {
                System.out.println("*" + ptr + " =  left=" + left[ptr] + " bottom=" + bottom[ptr] + " right=" + right[ptr] + " top=" + top[ptr]);
            }
            int gap = 0;
            for (int next = aa + 1; next < count; ++next) {
                boolean isCorrectLocation;
                int nextPtr = highlightIDs[next];
                if (isFontEmbedded[nextPtr] != isFontEmbedded[ptr] || w[nextPtr] < 1.0f) continue;
                if (ptr == zz) {
                    System.out.println("compare with=" + nextPtr + " left=" + left[nextPtr] + " right=" + right[nextPtr] + ' ' + (left[nextPtr] > left[ptr] && left[nextPtr] < right[ptr]));
                }
                if (!(left[nextPtr] > left[ptr] && left[nextPtr] < right[ptr]) && (!(left[nextPtr] > (left[ptr] + right[ptr]) / 2.0f) || !(right[ptr] < right[nextPtr]))) continue;
                int currentW = this.textHighlightsWidth[ptr];
                int currentX = this.textHighlightsX[ptr];
                if (isFontEmbedded[nextPtr]) {
                    float diff = left[nextPtr] - right[ptr];
                    diff = diff > 0.0f ? (diff += 0.5f) : (diff += 0.5f);
                    gap = (int)(diff * 1000.0f / (float)fontSizes[ptr]);
                    if (this.textHighlightsX[nextPtr] > 0) {
                        gap += this.textHighlightsX[nextPtr];
                    }
                } else {
                    gap = (int)(left[nextPtr] - right[ptr]);
                }
                if (ptr == zz) {
                    System.out.println(left[nextPtr] - right[ptr] + " gap=" + gap + ' ' + (left[nextPtr] - right[ptr]) * 1000.0f / (float)fontSizes[ptr] + " currentX=" + currentX + " scaling=" + this.scaling + ' ' + fontBoundsW);
                }
                boolean bl = isCorrectLocation = gap > 0 || gap < 0 && left[ptr] < left[nextPtr] && right[ptr] > left[nextPtr] && right[ptr] < right[nextPtr] && left[ptr] < right[ptr] && (-gap < fontSizes[ptr] && !isFontEmbedded[ptr] || -gap < fontBoundsW && isFontEmbedded[ptr]);
                if (!(bottom[ptr] < top[nextPtr]) || !(bottom[nextPtr] < top[ptr]) || gap <= 0 && !isCorrectLocation) continue;
                if (isCorrectLocation && (!isFontEmbedded[ptr] && gap < fontSizes[ptr] && currentW + gap < fontSizes[ptr] || isFontEmbedded[ptr] && gap < fontBoundsW)) {
                    if (ptr == zz) {
                        System.out.println(nextPtr + " =  left=" + left[nextPtr] + " bottom=" + bottom[nextPtr] + " right=" + right[nextPtr] + " top=" + top[nextPtr]);
                    }
                    this.textHighlightsWidth[ptr] = isFontEmbedded[ptr] ? (gap > 0 ? currentW + gap : currentW - gap) : (gap > 0 ? gap : currentW + gap);
                    if (ptr == zz) {
                        System.out.println("new=" + this.textHighlightsWidth[ptr]);
                    }
                    next = count;
                    continue;
                }
                if (gap <= fontBoundsW) continue;
            }
        }
    }

    @Override
    public void setPrintPage(int currentPrintPage) {
        this.pageNumber = currentPrintPage;
    }

    @Override
    public int getObjectUnderneath(int x, int y) {
        int typeFound = -1;
        Rectangle[] areas = this.areas.get();
        int count = areas.length;
        int[] types = this.objectType.get();
        boolean nothing = true;
        for (int i = count - 1; i > -1; --i) {
            if (areas[i] == null || !RenderUtils.rectangleContains(areas[i], x, y, i) || types[i] == 2 || types[i] == 7) continue;
            nothing = false;
            typeFound = types[i];
            i = -1;
        }
        if (nothing) {
            return -1;
        }
        return typeFound;
    }

    @Override
    public void flagImageDeleted(int i) {
        this.objectType.setElementAt(27, i);
    }

    @Override
    public void setOCR(boolean isOCR) {
        this.hasOCR = isOCR;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("SwingDisplay [ignoreHighlight=");
        builder.append(this.ignoreHighlight);
        builder.append(", noRepaint=");
        builder.append(this.noRepaint);
        builder.append(", lastItemPainted=");
        builder.append(this.lastItemPainted);
        builder.append(", optimsePainting=");
        builder.append(this.optimsePainting);
        builder.append(", needsHorizontalInvert=");
        builder.append(this.needsHorizontalInvert);
        builder.append(", needsVerticalInvert=");
        builder.append(this.needsVerticalInvert);
        builder.append(", pageX1=");
        builder.append(this.pageX1);
        builder.append(", pageX2=");
        builder.append(this.pageX2);
        builder.append(", pageY1=");
        builder.append(this.pageY1);
        builder.append(", pageY2=");
        builder.append(this.pageY2);
        builder.append(", highlightsNeedToBeGenerated=");
        builder.append(this.highlightsNeedToBeGenerated);
        builder.append(", ");
        if (this.singleImage != null) {
            builder.append("singleImage=");
            builder.append(this.singleImage);
            builder.append(", ");
        }
        builder.append("imageCount=");
        builder.append(this.imageCount);
        builder.append(", endItem=");
        builder.append(this.endItem);
        builder.append(", ");
        if (this.cachedWidths != null) {
            builder.append("cachedWidths=");
            builder.append(this.cachedWidths);
            builder.append(", ");
        }
        if (this.cachedHeights != null) {
            builder.append("cachedHeights=");
            builder.append(this.cachedHeights);
            builder.append(", ");
        }
        if (this.fonts != null) {
            builder.append("fonts=");
            builder.append(this.fonts);
            builder.append(", ");
        }
        if (this.fontsUsed != null) {
            builder.append("fontsUsed=");
            builder.append(this.fontsUsed);
            builder.append(", ");
        }
        if (this.factory != null) {
            builder.append("factory=");
            builder.append(this.factory);
            builder.append(", ");
        }
        if (this.glyphs != null) {
            builder.append("glyphs=");
            builder.append(this.glyphs);
            builder.append(", ");
        }
        if (this.imageID != null) {
            builder.append("imageID=");
            builder.append(this.imageID);
            builder.append(", ");
        }
        if (this.imageIDtoName != null) {
            builder.append("imageIDtoName=");
            builder.append(this.imageIDtoName);
            builder.append(", ");
        }
        if (this.storedImageValues != null) {
            builder.append("storedImageValues=");
            builder.append(this.storedImageValues);
            builder.append(", ");
        }
        if (this.textHighlightsX != null) {
            builder.append("textHighlightsX=");
            builder.append(Arrays.toString(this.textHighlightsX));
            builder.append(", ");
        }
        if (this.textHighlightsWidth != null) {
            builder.append("textHighlightsWidth=");
            builder.append(Arrays.toString(this.textHighlightsWidth));
            builder.append(", ");
        }
        if (this.textHighlightsHeight != null) {
            builder.append("textHighlightsHeight=");
            builder.append(Arrays.toString(this.textHighlightsHeight));
            builder.append(", ");
        }
        builder.append("stopG2setting=");
        builder.append(this.stopG2setting);
        builder.append(", ");
        if (this.x_coord != null) {
            builder.append("x_coord=");
            builder.append(Arrays.toString(this.x_coord));
            builder.append(", ");
        }
        if (this.y_coord != null) {
            builder.append("y_coord=");
            builder.append(Arrays.toString(this.y_coord));
            builder.append(", ");
        }
        if (this.largeImages != null) {
            builder.append("largeImages=");
            builder.append(this.largeImages);
            builder.append(", ");
        }
        if (this.text_color != null) {
            builder.append("text_color=");
            builder.append(this.text_color);
            builder.append(", ");
        }
        if (this.stroke_color != null) {
            builder.append("stroke_color=");
            builder.append(this.stroke_color);
            builder.append(", ");
        }
        if (this.fill_color != null) {
            builder.append("fill_color=");
            builder.append(this.fill_color);
            builder.append(", ");
        }
        if (this.stroke != null) {
            builder.append("stroke=");
            builder.append(this.stroke);
            builder.append(", ");
        }
        if (this.pageObjects != null) {
            builder.append("pageObjects=");
            builder.append(this.pageObjects);
            builder.append(", ");
        }
        if (this.shapeType != null) {
            builder.append("shapeType=");
            builder.append(this.shapeType);
            builder.append(", ");
        }
        if (this.fontBounds != null) {
            builder.append("fontBounds=");
            builder.append(this.fontBounds);
            builder.append(", ");
        }
        if (this.af1 != null) {
            builder.append("af1=");
            builder.append(this.af1);
            builder.append(", ");
        }
        if (this.af2 != null) {
            builder.append("af2=");
            builder.append(this.af2);
            builder.append(", ");
        }
        if (this.af3 != null) {
            builder.append("af3=");
            builder.append(this.af3);
            builder.append(", ");
        }
        if (this.af4 != null) {
            builder.append("af4=");
            builder.append(this.af4);
            builder.append(", ");
        }
        if (this.imageOptions != null) {
            builder.append("imageOptions=");
            builder.append(this.imageOptions);
            builder.append(", ");
        }
        if (this.TRvalues != null) {
            builder.append("TRvalues=");
            builder.append(this.TRvalues);
            builder.append(", ");
        }
        if (this.fs != null) {
            builder.append("fs=");
            builder.append(this.fs);
            builder.append(", ");
        }
        if (this.lw != null) {
            builder.append("lw=");
            builder.append(this.lw);
            builder.append(", ");
        }
        if (this.clips != null) {
            builder.append("clips=");
            builder.append(this.clips);
            builder.append(", ");
        }
        if (this.objectType != null) {
            builder.append("objectType=");
            builder.append(this.objectType);
            builder.append(", ");
        }
        if (this.javaObjects != null) {
            builder.append("javaObjects=");
            builder.append(this.javaObjects);
            builder.append(", ");
        }
        if (this.textFillType != null) {
            builder.append("textFillType=");
            builder.append(this.textFillType);
            builder.append(", ");
        }
        if (this.opacity != null) {
            builder.append("opacity=");
            builder.append(this.opacity);
            builder.append(", ");
        }
        builder.append("currentItem=");
        builder.append(this.currentItem);
        builder.append(", lastFillTextCol=");
        builder.append(this.lastFillTextCol);
        builder.append(", lastFillCol=");
        builder.append(this.lastFillCol);
        builder.append(", lastStrokeCol=");
        builder.append(this.lastStrokeCol);
        builder.append(", ");
        if (this.lastStroke != null) {
            builder.append("lastStroke=");
            builder.append(this.lastStroke);
            builder.append(", ");
        }
        if (this.lastAf != null) {
            builder.append("lastAf=");
            builder.append(Arrays.toString(this.lastAf));
            builder.append(", ");
        }
        builder.append("lastTR=");
        builder.append(this.lastTR);
        builder.append(", lastFS=");
        builder.append(this.lastFS);
        builder.append(", lastLW=");
        builder.append(this.lastLW);
        builder.append(", resetTextColors=");
        builder.append(this.resetTextColors);
        builder.append(", fillSet=");
        builder.append(this.fillSet);
        builder.append(", strokeSet=");
        builder.append(this.strokeSet);
        builder.append(", needsHighlights=");
        builder.append(this.needsHighlights);
        builder.append(", paintThreadCount=");
        builder.append(this.paintThreadCount);
        builder.append(", paintThreadID=");
        builder.append(this.paintThreadID);
        builder.append(", ");
        if (this.drawnHighlights != null) {
            builder.append("drawnHighlights=");
            builder.append(Arrays.toString(this.drawnHighlights));
            builder.append(", ");
        }
        builder.append("hasOCR=");
        builder.append(this.hasOCR);
        builder.append(", type=");
        builder.append(this.type);
        builder.append(", minX=");
        builder.append(this.minX);
        builder.append(", minY=");
        builder.append(this.minY);
        builder.append(", maxX=");
        builder.append(this.maxX);
        builder.append(", maxY=");
        builder.append(this.maxY);
        builder.append(", renderFailed=");
        builder.append(this.renderFailed);
        builder.append(", ");
        if (this.frame != null) {
            builder.append("frame=");
            builder.append(this.frame);
        }
        builder.append("]");
        return builder.toString();
    }

    static {
        hints = new RenderingHints(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        hints.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        userAlerted = false;
    }
}

