/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.parser;

import java.awt.Color;
import java.awt.Rectangle;
import java.awt.print.PageFormat;
import java.awt.print.Paper;
import java.util.HashMap;
import java.util.Map;
import javax.print.attribute.SetOfIntegerSyntax;
import org.jpedal.Overlays;
import org.jpedal.exception.PdfException;
import org.jpedal.external.ExternalHandlers;
import org.jpedal.io.ObjectStore;
import org.jpedal.io.PdfObjectReader;
import org.jpedal.objects.PdfPageData;
import org.jpedal.parser.PdfStreamDecoderForPrinting;
import org.jpedal.render.DynamicVectorRenderer;
import org.jpedal.utils.Messages;

public class SwingPrinter {
    private Overlays overlays;
    private int duplexGapOdd = 0;
    private int duplexGapEven = 0;
    ObjectStore objectPrintStoreRef = null;
    ExternalHandlers externalHandlers;
    private boolean centerOnScaling = false;
    public boolean operationSuccessful = true;
    public int pageScalingMode = 2;
    public String pageErrorMessages = "";
    public boolean printOnlyVisible = false;
    public int logicalPageOffset = 0;
    public DynamicVectorRenderer printRender = null;
    public int lastPrintedPage = -1;
    public int currentPrintPage = 0;
    public boolean isCustomPrinting = false;
    PdfObjectReader currentPdfFile;
    public Map pageFormats = new HashMap(100);
    public int[] listOfPages;
    public boolean allowDifferentPrintPageSizes = false;
    public int start = 0;
    public int end = -1;
    public boolean oddPagesOnly = false;
    public boolean evenPagesOnly = false;
    public SetOfIntegerSyntax range;
    public boolean pagesPrintedInReverse = false;
    public boolean stopPrinting = false;
    public boolean isPrintAutoRotateAndCenter = false;
    public boolean usePDFPaperSize = false;
    public PdfStreamDecoderForPrinting currentPrintDecoder = null;
    public boolean legacyPrintMode = true;
    private float scaling;
    private int insetW;
    private int insetH;

    public int getNumberOfPages(int pageCount) {
        if (this.range != null) {
            int rangeCount = 0;
            for (int ii = 1; ii < pageCount + 1; ++ii) {
                if (!this.range.contains(ii) || this.oddPagesOnly && (ii & 1) != 1 || this.evenPagesOnly && (ii & 1) != 0) continue;
                ++rangeCount;
            }
            return rangeCount;
        }
        int count = 1;
        if (this.end != -1 && (count = this.end - this.start + 1) < 0) {
            count = 2 - count;
        }
        if (this.oddPagesOnly || this.evenPagesOnly) {
            return (count + 1) / 2;
        }
        return count;
    }

    public PageFormat getPageFormat(int p, PdfPageData pageData, int pageCount) throws IndexOutOfBoundsException {
        int actualPage;
        Object returnValue;
        if (this.listOfPages != null && p < this.listOfPages.length) {
            p = this.listOfPages[p];
        }
        if ((returnValue = this.pageFormats.get(actualPage = this.end == -1 ? p + 1 : (this.end > this.start ? this.start + p : this.start - p))) == null) {
            returnValue = this.pageFormats.get("standard");
        }
        PageFormat pf = new PageFormat();
        this.pageFormats.put("Align-" + actualPage, "normal");
        if (this.usePDFPaperSize) {
            int crw = pageData.getCropBoxWidth(actualPage);
            int crh = pageData.getCropBoxHeight(actualPage);
            int rotation = pageData.getRotation(actualPage);
            if (this.allowDifferentPrintPageSizes) {
                int tmp;
                if (rotation == 90 || rotation == 270) {
                    tmp = crw;
                    crw = crh;
                    crh = tmp;
                }
                if (crw > crh) {
                    tmp = crw;
                    crw = crh;
                    crh = tmp;
                    if (rotation == 90) {
                        this.pageFormats.put("Align-" + actualPage, "inverted");
                    }
                }
            }
            this.createCustomPaper(pf, crw, crh, pageCount, pageData);
        } else if (returnValue != null) {
            pf = (PageFormat)returnValue;
        }
        if (!this.isPrintAutoRotateAndCenter) {
            pf.setOrientation(1);
        }
        return pf;
    }

    private void createCustomPaper(PageFormat pf, int clipW, int clipH, int pageCount, PdfPageData pageData) {
        Paper customPaper = new Paper();
        if (pageCount == 1 || this.allowDifferentPrintPageSizes) {
            customPaper.setSize(clipW, clipH);
            customPaper.setImageableArea(0.0, 0.0, clipW, clipH);
        } else {
            int paperClipW = 0;
            int paperClipH = 0;
            for (int t = this.start; t <= this.end; ++t) {
                if (clipW > pageData.getMediaBoxWidth(t) + 1 || clipH > pageData.getMediaBoxHeight(t) + 1) continue;
                paperClipW = pageData.getMediaBoxWidth(t) + 1;
                paperClipH = pageData.getMediaBoxHeight(t) + 1;
            }
            customPaper.setSize(paperClipW, paperClipH);
            customPaper.setImageableArea(0.0, 0.0, clipW, clipH);
        }
        pf.setPaper(customPaper);
    }

    public void setPagePrintRange(SetOfIntegerSyntax range, int pageCount) throws PdfException {
        this.range = range;
        this.start = range.next(0);
        int rangeCount = 0;
        for (int ii = 0; ii < pageCount; ++ii) {
            if (!range.contains(ii)) continue;
            ++rangeCount;
        }
        this.listOfPages = new int[rangeCount + 1];
        int i = this.start;
        this.end = this.start;
        if (range.contains(Integer.MAX_VALUE)) {
            this.end = pageCount;
        } else {
            while (range.next(i) != -1) {
                ++i;
            }
            this.end = i;
        }
        if (this.start > this.end) {
            int tmp = this.start;
            this.start = this.end;
            this.end = tmp;
        }
        int j = 0;
        for (int ii = this.start; ii < this.end + 1; ++ii) {
            if (!range.contains(ii) || this.oddPagesOnly && (ii & 1) != 1 || this.evenPagesOnly && (ii & 1) != 0) continue;
            this.listOfPages[j] = ii - this.start;
            ++j;
        }
        if (this.start < 1 || this.end < 1 || this.start > pageCount || this.end > pageCount) {
            throw new PdfException(Messages.getMessage("PdfViewerPrint.InvalidPageRange") + ' ' + this.start + ' ' + this.end);
        }
    }

    public void setPrintPageMode(int mode) {
        this.oddPagesOnly = (mode & 0x10) == 16;
        this.evenPagesOnly = (mode & 0x20) == 32;
        this.pagesPrintedInReverse = (mode & 0x40) == 64;
    }

    public void putPageFormat(Object key, PageFormat value) {
        this.pageFormats.put(key, value);
    }

    public int getCurrentPrintPage() {
        return this.currentPrintPage;
    }

    public final void stopPrinting() {
        this.stopPrinting = true;
    }

    public void setPagePrintRange(int start, int end, int pageCount) throws PdfException {
        this.start = start;
        this.end = end;
        if (end == Integer.MAX_VALUE) {
            end = pageCount;
        }
        if (start > end) {
            int tmp = start;
            start = end;
            end = tmp;
        }
        if (start < 1 || end < 1 || start > pageCount || end > pageCount) {
            throw new PdfException(Messages.getMessage("PdfViewerPrint.InvalidPageRange") + ' ' + start + ' ' + end);
        }
    }

    public void useLogicalPrintOffset(int pagesPrinted) {
        this.logicalPageOffset = pagesPrinted;
    }

    public boolean isPageSuccessful() {
        return this.operationSuccessful;
    }

    public String getPageFailureMessage() {
        return this.pageErrorMessages;
    }

    public void setPrintPageScalingMode(int pageScalingMode) {
        this.pageScalingMode = pageScalingMode;
    }

    private static Map toMap(int[] values) {
        if (values == null || values.length == 0) {
            return null;
        }
        int count = values.length;
        HashMap<Integer, String> newList = new HashMap<Integer, String>(count);
        for (int value : values) {
            newList.put(value, "x");
        }
        return newList;
    }

    private Rectangle workoutClipping(int displayRotation, Rectangle vr, int print_x_size, int print_y_size) {
        double x = vr.getX();
        double y = vr.getY();
        double w = vr.getWidth();
        double h = vr.getHeight();
        int newX = 0;
        int newY = 0;
        int newW = 0;
        int newH = 0;
        switch (displayRotation) {
            case 0: {
                newX = (int)((float)(vr.x - this.insetW) / this.scaling);
                newY = (int)((float)print_y_size - (float)(vr.y + vr.height - this.insetH) / this.scaling);
                newW = (int)((float)vr.width / this.scaling - 1.0f);
                newH = (int)((float)vr.height / this.scaling);
                break;
            }
            case 90: {
                newX = (int)((y - (double)this.insetH) / (double)this.scaling);
                newY = (int)((x - (double)this.insetW) / (double)this.scaling);
                newW = (int)(h / (double)this.scaling);
                newH = (int)(w / (double)this.scaling);
                break;
            }
            case 180: {
                newY = (int)(y / (double)this.scaling - (double)((float)this.insetH / this.scaling));
                newX = (int)((double)print_x_size - (x + w - (double)this.insetW) / (double)this.scaling);
                newW = (int)(w / (double)this.scaling);
                newH = (int)(h / (double)this.scaling);
                break;
            }
            case 270: {
                newX = (int)((double)print_x_size - (y + h - (double)this.insetH) / (double)this.scaling);
                newY = (int)((double)print_y_size - (x + w - (double)this.insetW) / (double)this.scaling);
                newW = (int)(h / (double)this.scaling);
                newH = (int)(w / (double)this.scaling);
            }
        }
        Rectangle cRect = new Rectangle(newX, newY, newW, newH);
        return cRect;
    }

    public void printAdditionalObjectsOverPage(int page, int[] type, Color[] colors, Object[] obj) throws PdfException {
        if (this.overlays == null) {
            this.overlays = new Overlays();
        }
        this.overlays.printAdditionalObjectsOverPage(page, type, colors, obj);
    }

    public void printAdditionalObjectsOverAllPages(int[] type, Color[] colors, Object[] obj) throws PdfException {
        if (this.overlays == null) {
            this.overlays = new Overlays();
        }
        this.overlays.printAdditionalObjectsOverAllPages(type, colors, obj);
    }

    public void clear() {
        if (this.overlays != null) {
            this.overlays.clear();
        }
        if (this.objectPrintStoreRef != null) {
            this.objectPrintStoreRef.flush();
        }
    }

    public void setPrintIndent(int oddPages, int evenPages) {
        this.duplexGapOdd = oddPages;
        this.duplexGapEven = evenPages;
    }

    public void setCenterOnScaling(boolean center) {
        this.centerOnScaling = center;
    }
}

