/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.parser;

import java.awt.geom.Area;
import java.awt.geom.Rectangle2D;
import java.util.HashMap;
import java.util.Map;
import org.jpedal.objects.GraphicsState;
import org.jpedal.objects.layers.PdfLayerList;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.render.DynamicVectorRenderer;

public class LayerDecoder {
    private boolean isLayerVisible = true;
    int layerLevel = 0;
    private Map layerVisibility = new HashMap(50);
    private Map layerClips = new HashMap(50);
    PdfLayerList layers;

    public boolean isLayerVisible() {
        return this.isLayerVisible;
    }

    public void BMC() {
        ++this.layerLevel;
    }

    public void BDC(PdfObject BDCobj, GraphicsState gs, DynamicVectorRenderer current, int dataPointer, byte[] raw, boolean hasDictionary, int rawStart) {
        ++this.layerLevel;
        if (this.layers != null && this.isLayerVisible) {
            String name = "";
            if (hasDictionary) {
                PdfObject layerObj;
                name = BDCobj.getName(7955);
                if (name == null && (layerObj = BDCobj.getDictionary(826881374)) != null) {
                    name = layerObj.getTextStreamValue(960773209);
                }
                this.layerClips.put(this.layerLevel, null);
                float[] BBox = BDCobj.getFloatArray(303185736);
                if (BBox != null) {
                    Area currentClip = gs.getClippingShape();
                    if (currentClip != null) {
                        this.layerClips.put(this.layerLevel, currentClip.clone());
                    }
                    Area clip = new Area(new Rectangle2D.Float(BBox[0], BBox[1], -gs.CTM[2][0] + (BBox[2] - BBox[0]), -gs.CTM[2][1] + (BBox[3] - BBox[1])));
                    gs.setClippingShape(clip);
                    current.drawClip(gs, clip, true);
                }
            } else {
                name = LayerDecoder.readOPName(dataPointer, raw, rawStart, name);
            }
            if (name != null && name.length() > 0) {
                this.isLayerVisible = this.layers.decodeLayer(name, true);
            }
            if (this.isLayerVisible) {
                this.layerVisibility.put(this.layerLevel, "x");
            }
        }
    }

    private static String readOPName(int dataPointer, byte[] raw, int rawStart, String name) {
        for (int ii = rawStart; ii < dataPointer; ++ii) {
            if (raw[ii] != 47 || raw[ii + 1] != 79 || raw[ii + 2] != 67) continue;
            ii += 2;
            while (raw[ii] != 47) {
                ++ii;
            }
            int strStart = ++ii;
            int charCount = 0;
            while (ii < dataPointer) {
                ++charCount;
                if (raw[++ii] != 13 && raw[ii] != 10 && raw[ii] != 32 && raw[ii] != 47) continue;
            }
            name = new String(raw, strStart, charCount);
        }
        return name;
    }

    public void EMC(DynamicVectorRenderer current, GraphicsState gs) {
        Integer key = this.layerLevel;
        if (this.layerClips.containsKey(key)) {
            Area currentClip = (Area)this.layerClips.get(key);
            gs.setClippingShape(currentClip);
            current.drawClip(gs, currentClip, true);
        }
        --this.layerLevel;
        this.isLayerVisible = this.layers == null || this.layerLevel == 0 || this.layerVisibility.containsKey(this.layerLevel);
    }

    public void setPdfLayerList(PdfLayerList layers) {
        this.layers = layers;
    }

    public Object getPdfLayerList() {
        return this.layers;
    }
}

