/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.objects;

import java.io.Serializable;
import org.jpedal.utils.repositories.Vector_Int;
import org.jpedal.utils.repositories.Vector_Object;

public class PdfPageData
implements Serializable {
    private static final long serialVersionUID = -8258244553460848813L;
    private boolean valuesSet = false;
    private int lastPage = -1;
    private int pagesRead = -1;
    private int pageCount = 1;
    private float[] defaultMediaBox = null;
    private int rotation = 0;
    private Vector_Object mediaBoxes = new Vector_Object(500);
    private Vector_Object cropBoxes = new Vector_Object(500);
    private Vector_Int rotations = null;
    private float cropBoxX = -99999.0f;
    private float cropBoxY = -1.0f;
    private float cropBoxW = -1.0f;
    private float cropBoxH = -1.0f;
    private float mediaBoxX = -1.0f;
    private float mediaBoxY;
    private float mediaBoxW;
    private float mediaBoxH;
    private boolean hasMultipleSizes = false;
    private boolean hasMultipleSizesSet = false;
    private float scalingValue = 1.0f;
    private float[] mediaBox;
    private float[] cropBox;
    private int defaultrotation;
    private float defaultcropBoxX;
    private float defaultcropBoxY;
    private float defaultcropBoxW;
    private float defaultcropBoxH;
    private float defaultmediaBoxX;
    private float defaultmediaBoxY;
    private float defaultmediaBoxW;
    private float defaultmediaBoxH;

    public void checkSizeSet(int pageNumber) {
        if (this.mediaBox == null) {
            this.mediaBox = this.defaultMediaBox;
        }
        if (this.cropBox != null && (this.cropBox[0] != this.mediaBox[0] || this.cropBox[1] != this.mediaBox[1] || this.cropBox[2] != this.mediaBox[2] || this.cropBox[3] != this.mediaBox[3])) {
            this.mediaBoxes.setElementAt(this.mediaBox, pageNumber);
            if (this.cropBox[0] >= this.mediaBox[0] && this.cropBox[1] >= this.mediaBox[1] && this.cropBox[2] - this.cropBox[0] <= this.mediaBox[2] - this.mediaBox[0] && this.cropBox[3] - this.cropBox[1] <= this.mediaBox[3] - this.mediaBox[1]) {
                this.cropBoxes.setElementAt(this.cropBox, pageNumber);
            }
        } else if (this.mediaBox != null && (this.defaultMediaBox[0] != this.mediaBox[0] || this.defaultMediaBox[1] != this.mediaBox[1] || this.defaultMediaBox[2] != this.mediaBox[2] || this.defaultMediaBox[3] != this.mediaBox[3])) {
            this.mediaBoxes.setElementAt(this.mediaBox, pageNumber);
        }
        if (this.pagesRead < pageNumber) {
            this.pagesRead = pageNumber;
        }
        this.lastPage = -1;
        this.mediaBox = null;
        this.cropBox = null;
    }

    public final int getMediaBoxHeight(int pageNumber) {
        this.setSizeForPage(pageNumber);
        return (int)this.mediaBoxH;
    }

    public final int getMediaBoxY(int pageNumber) {
        this.setSizeForPage(pageNumber);
        return (int)this.mediaBoxY;
    }

    public final int getMediaBoxX(int pageNumber) {
        this.setSizeForPage(pageNumber);
        return (int)this.mediaBoxX;
    }

    public void setMediaBox(float[] mediaBox) {
        this.mediaBox = mediaBox;
        this.cropBox = null;
        if (this.defaultMediaBox == null) {
            this.defaultMediaBox = mediaBox;
        }
    }

    public void setCropBox(float[] cropBox) {
        this.cropBox = cropBox;
        boolean testAlteredCrop = true;
        if (testAlteredCrop && this.mediaBox != null && this.mediaBox.length >= 4) {
            if (cropBox[0] < this.mediaBox[0]) {
                cropBox[0] = this.mediaBox[0];
            }
            if (cropBox[1] < this.mediaBox[1]) {
                cropBox[1] = this.mediaBox[1];
            }
            if (cropBox[2] > this.mediaBox[2]) {
                cropBox[2] = this.mediaBox[2];
            }
            if (cropBox[3] > this.mediaBox[3]) {
                cropBox[3] = this.mediaBox[3];
            }
        }
    }

    public int setPageRotation(int value, int pageNumber) {
        int raw_rotation = value;
        if (raw_rotation < 0) {
            raw_rotation = 360 + raw_rotation;
        }
        if (raw_rotation != 0 || this.rotations != null) {
            if (this.rotations == null) {
                this.rotations = pageNumber < 2000 ? new Vector_Int(2000) : new Vector_Int(pageNumber * 2);
            }
            this.rotations.setElementAt(raw_rotation, pageNumber);
        }
        return raw_rotation;
    }

    public final int getMediaBoxWidth(int pageNumber) {
        this.setSizeForPage(pageNumber);
        return (int)this.mediaBoxW;
    }

    public String getMediaValue(int currentPage) {
        StringBuilder returnValue = new StringBuilder();
        float[] mediaBox = this.defaultMediaBox;
        if (this.mediaBoxes != null) {
            mediaBox = (float[])this.mediaBoxes.elementAt(currentPage);
        }
        if (mediaBox != null) {
            for (int j = 0; j < 4; ++j) {
                returnValue.append(mediaBox[j]);
                returnValue.append(' ');
            }
        }
        return returnValue.toString();
    }

    public String getCropValue(int currentPage) {
        float[] cropBox = null;
        if (this.cropBoxes != null) {
            cropBox = (float[])this.cropBoxes.elementAt(currentPage);
        } else if (cropBox != null) {
            cropBox = (float[])this.mediaBoxes.elementAt(currentPage);
        }
        if (cropBox == null) {
            cropBox = this.defaultMediaBox;
        }
        StringBuilder returnValue = new StringBuilder();
        for (int j = 0; j < 4; ++j) {
            returnValue.append(cropBox[j]);
            returnValue.append(' ');
        }
        return returnValue.toString();
    }

    public int getScaledCropBoxX(int pageNumber) {
        this.setSizeForPage(pageNumber);
        return PdfPageData.roundFloat(this.cropBoxX * this.scalingValue);
    }

    public int getScaledCropBoxWidth(int pageNumber) {
        this.setSizeForPage(pageNumber);
        return PdfPageData.roundFloat(this.cropBoxW * this.scalingValue);
    }

    public int getScaledCropBoxY(int pageNumber) {
        this.setSizeForPage(pageNumber);
        return PdfPageData.roundFloat(this.cropBoxY * this.scalingValue);
    }

    public int getScaledCropBoxHeight(int pageNumber) {
        this.setSizeForPage(pageNumber);
        return PdfPageData.roundFloat(this.cropBoxH * this.scalingValue);
    }

    public int getCropBoxX(int pageNumber) {
        this.setSizeForPage(pageNumber);
        return (int)this.cropBoxX;
    }

    public float getCropBoxX2D(int pageNumber) {
        this.setSizeForPage(pageNumber);
        return this.cropBoxX;
    }

    public int getCropBoxWidth(int pageNumber) {
        this.setSizeForPage(pageNumber);
        return (int)this.cropBoxW;
    }

    public float getCropBoxWidth2D(int pageNumber) {
        this.setSizeForPage(pageNumber);
        return this.cropBoxW;
    }

    public int getCropBoxY(int pageNumber) {
        this.setSizeForPage(pageNumber);
        return (int)this.cropBoxY;
    }

    public float getCropBoxY2D(int pageNumber) {
        this.setSizeForPage(pageNumber);
        return this.cropBoxY;
    }

    public int getCropBoxHeight(int pageNumber) {
        this.setSizeForPage(pageNumber);
        return (int)this.cropBoxH;
    }

    public float getCropBoxHeight2D(int pageNumber) {
        this.setSizeForPage(pageNumber);
        return this.cropBoxH;
    }

    private synchronized void setSizeForPage(int pageNumber) {
        if (pageNumber == this.lastPage) {
            return;
        }
        if (pageNumber > this.pageCount) {
            this.pageCount = pageNumber;
        }
        if (pageNumber > this.pagesRead) {
            this.mediaBoxX = 0.0f;
            this.mediaBoxY = 0.0f;
            this.mediaBoxW = 0.0f;
            this.mediaBoxH = 0.0f;
            this.cropBoxX = 0.0f;
            this.cropBoxY = 0.0f;
            this.cropBoxW = 0.0f;
            this.cropBoxH = 0.0f;
            this.lastPage = pageNumber;
        } else if (pageNumber > 0 && this.lastPage != pageNumber) {
            this.lastPage = pageNumber;
            boolean usingDefault = false;
            float[] cropBox = (float[])this.cropBoxes.elementAt(pageNumber);
            float[] mediaBox = (float[])this.mediaBoxes.elementAt(pageNumber);
            if (mediaBox == null && this.defaultMediaBox != null) {
                mediaBox = this.defaultMediaBox;
                usingDefault = true;
            }
            this.rotation = this.rotations != null ? this.rotations.elementAt(pageNumber) : this.defaultrotation;
            while (this.rotation >= 360) {
                this.rotation -= 360;
            }
            if (this.valuesSet && usingDefault) {
                this.cropBoxX = this.defaultcropBoxX;
                this.mediaBoxX = this.defaultmediaBoxX;
                this.cropBoxY = this.defaultcropBoxY;
                this.mediaBoxY = this.defaultmediaBoxY;
                this.cropBoxW = this.defaultcropBoxW;
                this.mediaBoxW = this.defaultmediaBoxW;
                this.cropBoxH = this.defaultcropBoxH;
                this.mediaBoxH = this.defaultmediaBoxH;
            } else {
                this.mediaBoxX = 0.0f;
                this.mediaBoxY = 0.0f;
                this.mediaBoxW = 800.0f;
                this.mediaBoxH = 800.0f;
                if (mediaBox != null) {
                    this.mediaBoxX = mediaBox[0];
                    this.mediaBoxY = mediaBox[1];
                    this.mediaBoxW = mediaBox[2] - this.mediaBoxX;
                    this.mediaBoxH = mediaBox[3] - this.mediaBoxY;
                    if (this.mediaBoxY > 0.0f && this.mediaBoxH == -this.mediaBoxY) {
                        this.mediaBoxH = -this.mediaBoxH;
                        this.mediaBoxY = 0.0f;
                    }
                }
                if (cropBox != null) {
                    float temp;
                    this.cropBoxX = cropBox[0];
                    this.cropBoxY = cropBox[1];
                    this.cropBoxW = cropBox[2];
                    this.cropBoxH = cropBox[3];
                    if (this.cropBoxX > this.cropBoxW) {
                        temp = this.cropBoxX;
                        this.cropBoxX = this.cropBoxW;
                        this.cropBoxW = temp;
                    }
                    if (this.cropBoxY > this.cropBoxH) {
                        temp = this.cropBoxY;
                        this.cropBoxY = this.cropBoxH;
                        this.cropBoxH = temp;
                    }
                    this.cropBoxW -= this.cropBoxX;
                    this.cropBoxH -= this.cropBoxY;
                    if (this.cropBoxY > 0.0f && this.cropBoxH == -this.cropBoxY) {
                        this.cropBoxH = -this.cropBoxH;
                        this.cropBoxY = 0.0f;
                    }
                } else {
                    this.cropBoxX = this.mediaBoxX;
                    this.cropBoxY = this.mediaBoxY;
                    this.cropBoxW = this.mediaBoxW;
                    this.cropBoxH = this.mediaBoxH;
                }
            }
            if (this.cropBoxH < 0.0f) {
                this.cropBoxY += this.cropBoxH;
                this.cropBoxH = -this.cropBoxH;
            }
            if (this.cropBoxW < 0.0f) {
                this.cropBoxX += this.cropBoxW;
                this.cropBoxW = -this.cropBoxW;
            }
            if (usingDefault && !this.valuesSet) {
                this.defaultrotation = this.rotation;
                this.defaultcropBoxX = this.cropBoxX;
                this.defaultmediaBoxX = this.mediaBoxX;
                this.defaultcropBoxY = this.cropBoxY;
                this.defaultmediaBoxY = this.mediaBoxY;
                this.defaultcropBoxW = this.cropBoxW;
                this.defaultmediaBoxW = this.mediaBoxW;
                this.defaultcropBoxH = this.cropBoxH;
                this.defaultmediaBoxH = this.mediaBoxH;
                this.valuesSet = true;
            }
        }
    }

    public float getScalingValue() {
        return this.scalingValue;
    }

    public void setScalingValue(float scalingValue) {
        this.scalingValue = scalingValue;
    }

    private static int roundFloat(float origValue) {
        float frac;
        int roundedValue = (int)origValue;
        boolean useCustomRounding = true;
        if (useCustomRounding && (double)(frac = origValue - (float)roundedValue) > 0.3) {
            ++roundedValue;
        }
        return roundedValue;
    }

    public final int getPageCount() {
        return this.pageCount;
    }

    public final int getRotation(int pageNumber) {
        this.setSizeForPage(pageNumber);
        return this.rotation;
    }

    public final int getScaledMediaBoxHeight(int pageNumber) {
        this.setSizeForPage(pageNumber);
        return PdfPageData.roundFloat(this.mediaBoxH * this.scalingValue);
    }

    public final int getScaledMediaBoxWidth(int pageNumber) {
        this.setSizeForPage(pageNumber);
        return PdfPageData.roundFloat(this.mediaBoxW * this.scalingValue);
    }

    public final int getScaledMediaBoxX(int pageNumber) {
        this.setSizeForPage(pageNumber);
        return PdfPageData.roundFloat(this.mediaBoxX * this.scalingValue);
    }

    public final int getScaledMediaBoxY(int pageNumber) {
        this.setSizeForPage(pageNumber);
        return PdfPageData.roundFloat(this.mediaBoxY * this.scalingValue);
    }

    public boolean hasMultipleSizes() {
        if (this.hasMultipleSizesSet) {
            return this.hasMultipleSizes;
        }
        int pageCount = this.pageCount;
        int pageW = this.getCropBoxWidth(1);
        int pageH = this.getCropBoxHeight(1);
        int pageR = this.getRotation(1);
        if (pageCount > 1) {
            for (int jj = 2; jj < pageCount + 1; ++jj) {
                if (pageW == this.getCropBoxWidth(jj) && pageH == this.getCropBoxHeight(jj) && pageR == this.getRotation(jj)) continue;
                jj = pageCount;
                this.hasMultipleSizes = true;
            }
        }
        this.hasMultipleSizesSet = true;
        return this.hasMultipleSizes;
    }
}

