/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.jbig2.segment.symboldictionary;

import java.io.IOException;
import org.jpedal.jbig2.JBIG2Exception;
import org.jpedal.jbig2.decoders.ArithmeticDecoderStats;
import org.jpedal.jbig2.decoders.DecodeIntResult;
import org.jpedal.jbig2.decoders.HuffmanDecoder;
import org.jpedal.jbig2.decoders.JBIG2StreamDecoder;
import org.jpedal.jbig2.image.JBIG2Bitmap;
import org.jpedal.jbig2.segment.Segment;
import org.jpedal.jbig2.segment.symboldictionary.SymbolDictionaryFlags;
import org.jpedal.jbig2.util.BinaryOperation;

public class SymbolDictionarySegment
extends Segment {
    private int noOfExportedSymbols;
    private int noOfNewSymbols;
    short[] symbolDictionaryAdaptiveTemplateX = new short[4];
    short[] symbolDictionaryAdaptiveTemplateY = new short[4];
    short[] symbolDictionaryRAdaptiveTemplateX = new short[2];
    short[] symbolDictionaryRAdaptiveTemplateY = new short[2];
    private JBIG2Bitmap[] bitmaps;
    private SymbolDictionaryFlags symbolDictionaryFlags = new SymbolDictionaryFlags();
    private ArithmeticDecoderStats genericRegionStats;
    private ArithmeticDecoderStats refinementRegionStats;

    public SymbolDictionarySegment(JBIG2StreamDecoder streamDecoder) {
        super(streamDecoder);
    }

    @Override
    public void readSegment() throws IOException, JBIG2Exception {
        int i;
        if (JBIG2StreamDecoder.debug) {
            System.out.println("==== Read Segment Symbol Dictionary ====");
        }
        this.readSymbolDictionaryFlags();
        int numberOfInputSymbols = 0;
        int noOfReferredToSegments = this.segmentHeader.getReferredToSegmentCount();
        int[] referredToSegments = this.segmentHeader.getReferredToSegments();
        for (int i2 = 0; i2 < noOfReferredToSegments; ++i2) {
            Segment seg = this.decoder.findSegment(referredToSegments[i2]);
            int type = seg.getSegmentHeader().getSegmentType();
            if (type == 0) {
                numberOfInputSymbols += ((SymbolDictionarySegment)seg).noOfExportedSymbols;
                continue;
            }
            if (type != 53) continue;
        }
        int symbolCodeLength = 0;
        for (i = 1; i < numberOfInputSymbols + this.noOfNewSymbols; i <<= 1) {
            ++symbolCodeLength;
        }
        JBIG2Bitmap[] bitmaps = new JBIG2Bitmap[numberOfInputSymbols + this.noOfNewSymbols];
        int k = 0;
        SymbolDictionarySegment inputSymbolDictionary = null;
        for (i = 0; i < noOfReferredToSegments; ++i) {
            Segment seg = this.decoder.findSegment(referredToSegments[i]);
            if (seg.getSegmentHeader().getSegmentType() != 0) continue;
            inputSymbolDictionary = (SymbolDictionarySegment)seg;
            for (int j = 0; j < inputSymbolDictionary.noOfExportedSymbols; ++j) {
                bitmaps[k++] = inputSymbolDictionary.bitmaps[j];
            }
        }
        int[][] huffmanDHTable = null;
        int[][] huffmanDWTable = null;
        int[][] huffmanBMSizeTable = null;
        int[][] huffmanAggInstTable = null;
        boolean sdHuffman = this.symbolDictionaryFlags.getFlagValue(SymbolDictionaryFlags.SD_HUFF) != 0;
        int sdHuffmanDifferenceHeight = this.symbolDictionaryFlags.getFlagValue(SymbolDictionaryFlags.SD_HUFF_DH);
        int sdHuffmanDiferrenceWidth = this.symbolDictionaryFlags.getFlagValue(SymbolDictionaryFlags.SD_HUFF_DW);
        int sdHuffBitmapSize = this.symbolDictionaryFlags.getFlagValue(SymbolDictionaryFlags.SD_HUFF_BM_SIZE);
        int sdHuffAggregationInstances = this.symbolDictionaryFlags.getFlagValue(SymbolDictionaryFlags.SD_HUFF_AGG_INST);
        i = 0;
        if (sdHuffman) {
            if (sdHuffmanDifferenceHeight == 0) {
                huffmanDHTable = HuffmanDecoder.huffmanTableD;
            } else if (sdHuffmanDifferenceHeight == 1) {
                huffmanDHTable = HuffmanDecoder.huffmanTableE;
            }
            if (sdHuffmanDiferrenceWidth == 0) {
                huffmanDWTable = HuffmanDecoder.huffmanTableB;
            } else if (sdHuffmanDiferrenceWidth == 1) {
                huffmanDWTable = HuffmanDecoder.huffmanTableC;
            }
            if (sdHuffBitmapSize == 0) {
                huffmanBMSizeTable = HuffmanDecoder.huffmanTableA;
            }
            if (sdHuffAggregationInstances == 0) {
                huffmanAggInstTable = HuffmanDecoder.huffmanTableA;
            }
        }
        int contextUsed = this.symbolDictionaryFlags.getFlagValue(SymbolDictionaryFlags.BITMAP_CC_USED);
        int sdTemplate = this.symbolDictionaryFlags.getFlagValue(SymbolDictionaryFlags.SD_TEMPLATE);
        if (!sdHuffman) {
            if (contextUsed != 0 && inputSymbolDictionary != null) {
                this.arithmeticDecoder.resetGenericStats(sdTemplate, inputSymbolDictionary.genericRegionStats);
            } else {
                this.arithmeticDecoder.resetGenericStats(sdTemplate, null);
            }
            this.arithmeticDecoder.resetIntStats(symbolCodeLength);
            this.arithmeticDecoder.start();
        }
        int sdRefinementAggregate = this.symbolDictionaryFlags.getFlagValue(SymbolDictionaryFlags.SD_REF_AGG);
        int sdRefinementTemplate = this.symbolDictionaryFlags.getFlagValue(SymbolDictionaryFlags.SD_R_TEMPLATE);
        if (sdRefinementAggregate != 0) {
            if (contextUsed != 0 && inputSymbolDictionary != null) {
                this.arithmeticDecoder.resetRefinementStats(sdRefinementTemplate, inputSymbolDictionary.refinementRegionStats);
            } else {
                this.arithmeticDecoder.resetRefinementStats(sdRefinementTemplate, null);
            }
        }
        int[] deltaWidths = new int[this.noOfNewSymbols];
        int deltaHeight = 0;
        i = 0;
        while (i < this.noOfNewSymbols) {
            int instanceDeltaHeight = 0;
            instanceDeltaHeight = sdHuffman ? this.huffmanDecoder.decodeInt(huffmanDHTable).intResult() : this.arithmeticDecoder.decodeInt(this.arithmeticDecoder.iadhStats).intResult();
            if (instanceDeltaHeight < 0 && -instanceDeltaHeight >= deltaHeight && JBIG2StreamDecoder.debug) {
                System.out.println("Bad delta-height value in JBIG2 symbol dictionary");
            }
            deltaHeight += instanceDeltaHeight;
            int symbolWidth = 0;
            int totalWidth = 0;
            int j = i;
            while (true) {
                int deltaWidth = 0;
                DecodeIntResult decodeIntResult = sdHuffman ? this.huffmanDecoder.decodeInt(huffmanDWTable) : this.arithmeticDecoder.decodeInt(this.arithmeticDecoder.iadwStats);
                if (!decodeIntResult.booleanResult()) break;
                deltaWidth = decodeIntResult.intResult();
                if (deltaWidth < 0 && -deltaWidth >= symbolWidth && JBIG2StreamDecoder.debug) {
                    System.out.println("Bad delta-width value in JBIG2 symbol dictionary");
                }
                symbolWidth += deltaWidth;
                if (sdHuffman && sdRefinementAggregate == 0) {
                    deltaWidths[i] = symbolWidth;
                    totalWidth += symbolWidth;
                } else if (sdRefinementAggregate == 1) {
                    int refAggNum = 0;
                    refAggNum = sdHuffman ? this.huffmanDecoder.decodeInt(huffmanAggInstTable).intResult() : this.arithmeticDecoder.decodeInt(this.arithmeticDecoder.iaaiStats).intResult();
                    if (refAggNum == 1) {
                        int symbolID = 0;
                        int referenceDX = 0;
                        int referenceDY = 0;
                        if (sdHuffman) {
                            symbolID = this.decoder.readBits(symbolCodeLength);
                            referenceDX = this.huffmanDecoder.decodeInt(HuffmanDecoder.huffmanTableO).intResult();
                            referenceDY = this.huffmanDecoder.decodeInt(HuffmanDecoder.huffmanTableO).intResult();
                            this.decoder.consumeRemainingBits();
                            this.arithmeticDecoder.start();
                        } else {
                            symbolID = (int)this.arithmeticDecoder.decodeIAID(symbolCodeLength, this.arithmeticDecoder.iaidStats);
                            referenceDX = this.arithmeticDecoder.decodeInt(this.arithmeticDecoder.iardxStats).intResult();
                            referenceDY = this.arithmeticDecoder.decodeInt(this.arithmeticDecoder.iardyStats).intResult();
                        }
                        JBIG2Bitmap referredToBitmap = bitmaps[symbolID];
                        JBIG2Bitmap bitmap = new JBIG2Bitmap(symbolWidth, deltaHeight, this.arithmeticDecoder, this.huffmanDecoder, this.mmrDecoder);
                        bitmap.readGenericRefinementRegion(sdRefinementTemplate, false, referredToBitmap, referenceDX, referenceDY, this.symbolDictionaryRAdaptiveTemplateX, this.symbolDictionaryRAdaptiveTemplateY);
                        bitmaps[numberOfInputSymbols + i] = bitmap;
                    } else {
                        JBIG2Bitmap bitmap = new JBIG2Bitmap(symbolWidth, deltaHeight, this.arithmeticDecoder, this.huffmanDecoder, this.mmrDecoder);
                        bitmap.readTextRegion(sdHuffman, true, refAggNum, 0, numberOfInputSymbols + i, null, symbolCodeLength, bitmaps, 0, 0, false, 1, 0, HuffmanDecoder.huffmanTableF, HuffmanDecoder.huffmanTableH, HuffmanDecoder.huffmanTableK, HuffmanDecoder.huffmanTableO, HuffmanDecoder.huffmanTableO, HuffmanDecoder.huffmanTableO, HuffmanDecoder.huffmanTableO, HuffmanDecoder.huffmanTableA, sdRefinementTemplate, this.symbolDictionaryRAdaptiveTemplateX, this.symbolDictionaryRAdaptiveTemplateY, this.decoder);
                        bitmaps[numberOfInputSymbols + i] = bitmap;
                    }
                } else {
                    JBIG2Bitmap bitmap = new JBIG2Bitmap(symbolWidth, deltaHeight, this.arithmeticDecoder, this.huffmanDecoder, this.mmrDecoder);
                    bitmap.readBitmap(false, sdTemplate, false, false, null, this.symbolDictionaryAdaptiveTemplateX, this.symbolDictionaryAdaptiveTemplateY, 0);
                    bitmaps[numberOfInputSymbols + i] = bitmap;
                }
                ++i;
            }
            if (!sdHuffman || sdRefinementAggregate != 0) continue;
            int bmSize = this.huffmanDecoder.decodeInt(huffmanBMSizeTable).intResult();
            this.decoder.consumeRemainingBits();
            JBIG2Bitmap collectiveBitmap = new JBIG2Bitmap(totalWidth, deltaHeight, this.arithmeticDecoder, this.huffmanDecoder, this.mmrDecoder);
            if (bmSize == 0) {
                int padding = totalWidth % 8;
                int bytesPerRow = (int)Math.ceil((double)totalWidth / 8.0);
                int size = deltaHeight * (totalWidth + 7 >> 3);
                short[] bitmap = new short[size];
                this.decoder.readByte(bitmap);
                short[][] logicalMap = new short[deltaHeight][bytesPerRow];
                int count = 0;
                for (int row = 0; row < deltaHeight; ++row) {
                    for (int col = 0; col < bytesPerRow; ++col) {
                        logicalMap[row][col] = bitmap[count];
                        ++count;
                    }
                }
                int collectiveBitmapRow = 0;
                int collectiveBitmapCol = 0;
                for (int row = 0; row < deltaHeight; ++row) {
                    for (int col = 0; col < bytesPerRow; ++col) {
                        int bit;
                        short mask;
                        int bitPointer;
                        short currentByte;
                        if (col == bytesPerRow - 1) {
                            currentByte = logicalMap[row][col];
                            for (bitPointer = 7; bitPointer >= padding; --bitPointer) {
                                mask = (short)(1 << bitPointer);
                                bit = (currentByte & mask) >> bitPointer;
                                collectiveBitmap.setPixel(collectiveBitmapCol, collectiveBitmapRow, bit);
                                ++collectiveBitmapCol;
                            }
                            ++collectiveBitmapRow;
                            collectiveBitmapCol = 0;
                            continue;
                        }
                        currentByte = logicalMap[row][col];
                        for (bitPointer = 7; bitPointer >= 0; --bitPointer) {
                            mask = (short)(1 << bitPointer);
                            bit = (currentByte & mask) >> bitPointer;
                            collectiveBitmap.setPixel(collectiveBitmapCol, collectiveBitmapRow, bit);
                            ++collectiveBitmapCol;
                        }
                    }
                }
            } else {
                collectiveBitmap.readBitmap(true, 0, false, false, null, null, null, bmSize);
            }
            int x = 0;
            while (j < i) {
                bitmaps[numberOfInputSymbols + j] = collectiveBitmap.getSlice(x, 0, deltaWidths[j], deltaHeight);
                x += deltaWidths[j];
                ++j;
            }
        }
        this.bitmaps = new JBIG2Bitmap[this.noOfExportedSymbols];
        i = 0;
        int j = 0;
        boolean export = false;
        while (i < numberOfInputSymbols + this.noOfNewSymbols) {
            int run = 0;
            run = sdHuffman ? this.huffmanDecoder.decodeInt(HuffmanDecoder.huffmanTableA).intResult() : this.arithmeticDecoder.decodeInt(this.arithmeticDecoder.iaexStats).intResult();
            if (export) {
                for (int cnt = 0; cnt < run; ++cnt) {
                    this.bitmaps[j++] = bitmaps[i++];
                }
            } else {
                i += run;
            }
            export = !export;
        }
        int contextRetained = this.symbolDictionaryFlags.getFlagValue(SymbolDictionaryFlags.BITMAP_CC_RETAINED);
        if (!sdHuffman && contextRetained == 1) {
            this.genericRegionStats = this.genericRegionStats.copy();
            if (sdRefinementAggregate == 1) {
                this.refinementRegionStats = this.refinementRegionStats.copy();
            }
        }
        this.decoder.consumeRemainingBits();
    }

    private void readSymbolDictionaryFlags() throws IOException {
        int noOfNewSymbols;
        int noOfExportedSymbols;
        short[] symbolDictionaryFlagsField = new short[2];
        this.decoder.readByte(symbolDictionaryFlagsField);
        int flags = BinaryOperation.getInt16(symbolDictionaryFlagsField);
        this.symbolDictionaryFlags.setFlags(flags);
        if (JBIG2StreamDecoder.debug) {
            System.out.println("symbolDictionaryFlags = " + flags);
        }
        int sdHuff = this.symbolDictionaryFlags.getFlagValue(SymbolDictionaryFlags.SD_HUFF);
        int sdTemplate = this.symbolDictionaryFlags.getFlagValue(SymbolDictionaryFlags.SD_TEMPLATE);
        if (sdHuff == 0) {
            if (sdTemplate == 0) {
                this.symbolDictionaryAdaptiveTemplateX[0] = this.readATValue();
                this.symbolDictionaryAdaptiveTemplateY[0] = this.readATValue();
                this.symbolDictionaryAdaptiveTemplateX[1] = this.readATValue();
                this.symbolDictionaryAdaptiveTemplateY[1] = this.readATValue();
                this.symbolDictionaryAdaptiveTemplateX[2] = this.readATValue();
                this.symbolDictionaryAdaptiveTemplateY[2] = this.readATValue();
                this.symbolDictionaryAdaptiveTemplateX[3] = this.readATValue();
                this.symbolDictionaryAdaptiveTemplateY[3] = this.readATValue();
            } else {
                this.symbolDictionaryAdaptiveTemplateX[0] = this.readATValue();
                this.symbolDictionaryAdaptiveTemplateY[0] = this.readATValue();
            }
        }
        int refAgg = this.symbolDictionaryFlags.getFlagValue(SymbolDictionaryFlags.SD_REF_AGG);
        int sdrTemplate = this.symbolDictionaryFlags.getFlagValue(SymbolDictionaryFlags.SD_R_TEMPLATE);
        if (refAgg != 0 && sdrTemplate == 0) {
            this.symbolDictionaryRAdaptiveTemplateX[0] = this.readATValue();
            this.symbolDictionaryRAdaptiveTemplateY[0] = this.readATValue();
            this.symbolDictionaryRAdaptiveTemplateX[1] = this.readATValue();
            this.symbolDictionaryRAdaptiveTemplateY[1] = this.readATValue();
        }
        short[] noOfExportedSymbolsField = new short[4];
        this.decoder.readByte(noOfExportedSymbolsField);
        this.noOfExportedSymbols = noOfExportedSymbols = BinaryOperation.getInt32(noOfExportedSymbolsField);
        if (JBIG2StreamDecoder.debug) {
            System.out.println("noOfExportedSymbols = " + noOfExportedSymbols);
        }
        short[] noOfNewSymbolsField = new short[4];
        this.decoder.readByte(noOfNewSymbolsField);
        this.noOfNewSymbols = noOfNewSymbols = BinaryOperation.getInt32(noOfNewSymbolsField);
        if (JBIG2StreamDecoder.debug) {
            System.out.println("noOfNewSymbols = " + noOfNewSymbols);
        }
    }

    public int getNoOfExportedSymbols() {
        return this.noOfExportedSymbols;
    }

    public void setNoOfExportedSymbols(int noOfExportedSymbols) {
        this.noOfExportedSymbols = noOfExportedSymbols;
    }

    public int getNoOfNewSymbols() {
        return this.noOfNewSymbols;
    }

    public void setNoOfNewSymbols(int noOfNewSymbols) {
        this.noOfNewSymbols = noOfNewSymbols;
    }

    public JBIG2Bitmap[] getBitmaps() {
        return this.bitmaps;
    }

    public SymbolDictionaryFlags getSymbolDictionaryFlags() {
        return this.symbolDictionaryFlags;
    }

    public void setSymbolDictionaryFlags(SymbolDictionaryFlags symbolDictionaryFlags) {
        this.symbolDictionaryFlags = symbolDictionaryFlags;
    }

    private ArithmeticDecoderStats getGenericRegionStats() {
        return this.genericRegionStats;
    }

    private void setGenericRegionStats(ArithmeticDecoderStats genericRegionStats) {
        this.genericRegionStats = genericRegionStats;
    }

    private void setRefinementRegionStats(ArithmeticDecoderStats refinementRegionStats) {
        this.refinementRegionStats = refinementRegionStats;
    }

    private ArithmeticDecoderStats getRefinementRegionStats() {
        return this.refinementRegionStats;
    }
}

