/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.io;

import com.sun.media.jai.codec.ByteArraySeekableStream;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.Raster;
import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Map;
import javax.media.jai.JAI;
import javax.media.jai.RenderedOp;
import org.jpedal.io.JAIHelper;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.utils.LogWriter;

public class TiffDecoder {
    private byte[] bytes = null;

    public TiffDecoder(int w, int h, Map values, byte[] data) {
        boolean isBlack = false;
        int k = 0;
        String value = (String)values.get("K");
        if (value != null) {
            k = Integer.parseInt(value);
        }
        if ((value = (String)values.get("BlackIs1")) != null) {
            isBlack = Boolean.valueOf(value);
        }
        this.buildImage(w, h, data, isBlack, k);
    }

    public TiffDecoder(int w, int h, PdfObject DecodeParms, byte[] data) {
        boolean isBlack = false;
        int k = 0;
        if (DecodeParms != null) {
            k = DecodeParms.getInt(27);
            int columnsSet = DecodeParms.getInt(1162902911);
            if (columnsSet != -1) {
                w = columnsSet;
            }
            isBlack = DecodeParms.getBoolean(1297445940);
        }
        this.buildImage(w, h, data, isBlack, k);
    }

    public static void saveAsTIFF(int w, int h, PdfObject DecodeParms, byte[] data, String fileName) {
        block17: {
            ByteArrayOutputStream bos;
            block16: {
                String[] headerValues;
                boolean isBlack = false;
                int k = 0;
                if (DecodeParms != null) {
                    k = DecodeParms.getInt(27);
                    int columnsSet = DecodeParms.getInt(1162902911);
                    if (columnsSet != -1) {
                        w = columnsSet;
                    }
                    isBlack = DecodeParms.getBoolean(1297445940);
                }
                bos = new ByteArrayOutputStream();
                for (String headerValue : headerValues = new String[]{"4d", "4d", "00", "2a", "00", "00", "00", "08"}) {
                    bos.write(Integer.parseInt(headerValue, 16));
                }
                int tagCount = 9;
                TiffDecoder.writeWord(String.valueOf(tagCount), bos);
                TiffDecoder.writeTag("256", "04", "01", String.valueOf(w), bos);
                TiffDecoder.writeTag("257", "04", "01", String.valueOf(h), bos);
                TiffDecoder.writeTag("258", "03", "01", "00010000h", bos);
                if (k == 0) {
                    TiffDecoder.writeTag("259", "03", "01", "00030000h", bos);
                } else if (k > 0) {
                    TiffDecoder.writeTag("259", "03", "01", "00020000h", bos);
                } else if (k < 0) {
                    TiffDecoder.writeTag("259", "03", "01", "00040000h", bos);
                }
                if (!isBlack) {
                    TiffDecoder.writeTag("262", "03", "01", "00000000h", bos);
                } else {
                    TiffDecoder.writeTag("262", "03", "01", "00010000h", bos);
                }
                TiffDecoder.writeTag("273", "04", "1", "122", bos);
                TiffDecoder.writeTag("277", "03", "01", "00010000h", bos);
                TiffDecoder.writeTag("278", "04", "01", String.valueOf(h), bos);
                TiffDecoder.writeTag("279", "04", "1", String.valueOf(data.length), bos);
                TiffDecoder.writeDWord("0", bos);
                try {
                    bos.write(data);
                    bos.close();
                }
                catch (IOException e) {
                    if (!LogWriter.isOutput()) break block16;
                    LogWriter.writeLog("[PDF] Tiff exception  " + e);
                }
            }
            try {
                FileOutputStream fos = new FileOutputStream(fileName);
                fos.write(bos.toByteArray());
                fos.close();
            }
            catch (Error err) {
                if (LogWriter.isOutput()) {
                    LogWriter.writeLog("[PDF] Tiff error " + err);
                }
            }
            catch (Exception e1) {
                if (!LogWriter.isOutput()) break block17;
                LogWriter.writeLog("[PDF] Tiff exception  " + e1);
            }
        }
    }

    private void buildImage(int w, int h, byte[] data, boolean isBlack, int k) {
        block17: {
            ByteArrayOutputStream bos;
            block16: {
                String[] headerValues;
                bos = new ByteArrayOutputStream();
                for (String headerValue : headerValues = new String[]{"4d", "4d", "00", "2a", "00", "00", "00", "08"}) {
                    bos.write(Integer.parseInt(headerValue, 16));
                }
                int tagCount = 9;
                TiffDecoder.writeWord(String.valueOf(tagCount), bos);
                TiffDecoder.writeTag("256", "04", "01", String.valueOf(w), bos);
                TiffDecoder.writeTag("257", "04", "01", String.valueOf(h), bos);
                TiffDecoder.writeTag("258", "03", "01", "00010000h", bos);
                if (k == 0) {
                    TiffDecoder.writeTag("259", "03", "01", "00030000h", bos);
                } else if (k > 0) {
                    TiffDecoder.writeTag("259", "03", "01", "00020000h", bos);
                } else if (k < 0) {
                    TiffDecoder.writeTag("259", "03", "01", "00040000h", bos);
                }
                if (!isBlack) {
                    TiffDecoder.writeTag("262", "03", "01", "00000000h", bos);
                } else {
                    TiffDecoder.writeTag("262", "03", "01", "00010000h", bos);
                }
                TiffDecoder.writeTag("273", "04", "1", "122", bos);
                TiffDecoder.writeTag("277", "03", "01", "00010000h", bos);
                TiffDecoder.writeTag("278", "04", "01", String.valueOf(h), bos);
                TiffDecoder.writeTag("279", "04", "1", String.valueOf(data.length), bos);
                TiffDecoder.writeDWord("0", bos);
                try {
                    bos.write(data);
                    bos.close();
                }
                catch (IOException e) {
                    if (!LogWriter.isOutput()) break block16;
                    LogWriter.writeLog("[PDF] Tiff exception  " + e);
                }
            }
            try {
                JAIHelper.confirmJAIOnClasspath();
                ByteArraySeekableStream fss = new ByteArraySeekableStream(bos.toByteArray());
                RenderedOp op = JAI.create((String)"stream", (Object)fss);
                Raster raster = op.getData();
                DataBuffer db = raster.getDataBuffer();
                DataBufferByte dbb = (DataBufferByte)db;
                this.bytes = dbb.getData();
                if (!isBlack) {
                    int bcount = this.bytes.length;
                    for (int i = 0; i < bcount; ++i) {
                        this.bytes[i] = (byte)(255 - this.bytes[i]);
                    }
                }
            }
            catch (Error err) {
                if (LogWriter.isOutput()) {
                    LogWriter.writeLog("[PDF] Tiff error " + err);
                }
            }
            catch (Exception e1) {
                if (!LogWriter.isOutput()) break block17;
                LogWriter.writeLog("[PDF] Tiff exception  " + e1);
            }
        }
    }

    public byte[] getRawBytes() {
        return this.bytes;
    }

    private static void writeWord(String i, ByteArrayOutputStream bos) {
        int value = i.endsWith("h") ? Integer.parseInt(i.substring(0, i.length() - 1), 16) : (i.endsWith("o") ? Integer.parseInt(i.substring(0, i.length() - 1), 8) : Integer.parseInt(i));
        bos.write(value >> 8);
        bos.write(value & 0xFF);
    }

    private static void writeDWord(String i, ByteArrayOutputStream bos) {
        int value = i.endsWith("h") ? Integer.parseInt(i.substring(0, i.length() - 1), 16) : (i.endsWith("o") ? Integer.parseInt(i.substring(0, i.length() - 1), 8) : Integer.parseInt(i));
        bos.write(value >> 24 & 0xFF);
        bos.write(value >> 16 & 0xFF);
        bos.write(value >> 8 & 0xFF);
        bos.write(value & 0xFF);
    }

    private static void writeTag(String TagId, String dataType, String DataCount, String DataOffset, ByteArrayOutputStream bos) {
        TiffDecoder.writeWord(TagId, bos);
        TiffDecoder.writeWord(dataType, bos);
        TiffDecoder.writeDWord(DataCount, bos);
        TiffDecoder.writeDWord(DataOffset, bos);
    }
}

