/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.io;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import javax.imageio.stream.ImageInputStream;
import org.jpedal.io.RandomAccessBuffer;
import org.jpedal.utils.LogWriter;

public class ImageInputStreamFileBuffer
implements RandomAccessBuffer {
    private String fileName = "";
    ImageInputStream iis;

    public ImageInputStreamFileBuffer(ImageInputStream iis) {
        this.iis = iis;
    }

    @Override
    public long getFilePointer() throws IOException {
        return this.iis.getStreamPosition();
    }

    @Override
    public void seek(long pos) throws IOException {
        this.iis.seek(pos);
    }

    @Override
    public int read() throws IOException {
        return this.iis.read();
    }

    @Override
    public String readLine() throws IOException {
        return this.iis.readLine();
    }

    @Override
    public long length() throws IOException {
        return this.iis.length();
    }

    @Override
    public void close() throws IOException {
        this.iis.close();
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.iis.read(b);
    }

    @Override
    public byte[] getPdfBuffer() {
        byte[] pdfByteArray;
        block3: {
            pdfByteArray = null;
            try {
                int read;
                ByteArrayOutputStream os = new ByteArrayOutputStream();
                byte[] buffer = new byte[4096];
                while ((read = this.iis.read(buffer)) != -1) {
                    os.write(buffer, 0, read);
                }
                os.flush();
                os.close();
                pdfByteArray = os.toByteArray();
            }
            catch (IOException e) {
                e.printStackTrace();
                if (!LogWriter.isOutput()) break block3;
                LogWriter.writeLog("[PDF] Exception " + e + " getting byte[] for " + this.fileName);
            }
        }
        return pdfByteArray;
    }
}

