/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.fonts.tt.conversion;

import org.jpedal.fonts.tt.FontFile2;
import org.jpedal.fonts.tt.Maxp;
import org.jpedal.fonts.tt.conversion.CMAPWriter;
import org.jpedal.fonts.tt.conversion.FontWriter;
import org.jpedal.utils.LogWriter;

public class TTFontWriter
extends FontWriter {
    private static final long serialVersionUID = -6569687309537259643L;
    byte[] rawFontData;
    byte[] cmap = null;

    public TTFontWriter(byte[] rawFontData) {
        super(rawFontData);
        Maxp currentMaxp = new Maxp(new FontFile2(rawFontData));
        this.glyphCount = currentMaxp.getGlyphCount();
        this.rawFontData = rawFontData;
    }

    @Override
    void readTables() {
        block2: {
            this.cmap = null;
            TTFontWriter fontData = new TTFontWriter(this.rawFontData);
            CMAPWriter orginalCMAP = new CMAPWriter(fontData, fontData.selectTable(2), null);
            try {
                this.cmap = orginalCMAP.writeTable();
            }
            catch (Exception e) {
                if (!LogWriter.isOutput()) break block2;
                LogWriter.writeLog("Exception: " + e.getMessage());
            }
        }
    }

    @Override
    public byte[] getTableBytes(int tableID) {
        if (tableID == 2) {
            return this.cmap;
        }
        return super.getTableBytes(tableID);
    }
}

