/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.viewer.paper;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.print.DocFlavor;
import javax.print.PrintService;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.standard.MediaPrintableArea;
import javax.print.attribute.standard.MediaSize;
import javax.print.attribute.standard.MediaSizeName;
import org.jpedal.examples.viewer.paper.MarginPaper;

public class PaperSizes {
    Map<String, MarginPaper> paperDefinitions = new HashMap<String, MarginPaper>();
    ArrayList<String> paperList = new ArrayList();
    private static final double mmToSubInch = 2.834645669291339;
    Map<String, String> paperNames = new HashMap<String, String>();
    private int defaultPageIndex = 0;
    private String defaultSize;
    private PrintService printService;

    public PaperSizes(PrintService printService) {
        this.defaultSize = null;
        this.populateNameMap();
        PaperSizes.addCustomPaperSizes();
        this.setPrintService(printService);
    }

    public PaperSizes(String defaultSize) {
        this.defaultSize = defaultSize;
        this.populateNameMap();
        PaperSizes.addCustomPaperSizes();
    }

    public String[] getAvailablePaperSizes() {
        Object[] objs = this.paperList.toArray();
        String[] names = new String[objs.length];
        for (int i = 0; i < objs.length; ++i) {
            names[i] = (String)objs[i];
        }
        return names;
    }

    public MarginPaper getSelectedPaper(Object id) {
        return this.paperDefinitions.get(id);
    }

    private static void addCustomPaperSizes() {
    }

    private void setDefault() {
        int i;
        if (this.paperList == null) {
            return;
        }
        this.defaultPageIndex = -1;
        String paperSizeFlag = System.getProperty("org.jpedal.printPaperSize");
        if (paperSizeFlag != null) {
            for (i = 0; i < this.paperList.size(); ++i) {
                if (!this.paperList.get(i).equals(paperSizeFlag)) continue;
                this.defaultPageIndex = i;
            }
        }
        if (this.defaultPageIndex == -1 && this.defaultSize != null && this.defaultSize.length() > 0) {
            for (i = 0; i < this.paperList.size(); ++i) {
                if (!this.defaultSize.equals(this.paperList.get(i))) continue;
                this.defaultPageIndex = i;
            }
        }
        if (this.defaultPageIndex == -1) {
            this.defaultSize = "A4";
            String[] letterSizeDefaults = new String[]{"US", "CA", "MX", "CO", "VE", "AR", "CL", "PH"};
            String country = Locale.getDefault().getCountry();
            for (String letterSizeDefault : letterSizeDefaults) {
                if (!country.equals(letterSizeDefault)) continue;
                this.defaultSize = "North American Letter";
            }
            for (int j = 0; j < this.paperList.size(); ++j) {
                if (!this.defaultSize.equals(this.paperList.get(j))) continue;
                this.defaultPageIndex = j;
            }
            if (this.defaultPageIndex == -1) {
                this.defaultPageIndex = 0;
            }
        }
    }

    public synchronized void setPrintService(PrintService p) {
        this.printService = p;
        this.paperDefinitions = new HashMap<String, MarginPaper>();
        this.paperList = new ArrayList();
        this.checkAndAddSize(MediaSizeName.ISO_A4);
        this.checkAndAddSize(MediaSizeName.NA_LETTER);
        this.checkAndAddSize(MediaSizeName.ISO_A0);
        this.checkAndAddSize(MediaSizeName.ISO_A1);
        this.checkAndAddSize(MediaSizeName.ISO_A2);
        this.checkAndAddSize(MediaSizeName.ISO_A3);
        this.checkAndAddSize(MediaSizeName.ISO_A5);
        this.checkAndAddSize(MediaSizeName.ISO_A6);
        this.checkAndAddSize(MediaSizeName.ISO_A7);
        this.checkAndAddSize(MediaSizeName.ISO_A8);
        this.checkAndAddSize(MediaSizeName.ISO_A9);
        this.checkAndAddSize(MediaSizeName.ISO_A10);
        this.checkAndAddSize(MediaSizeName.ISO_B0);
        this.checkAndAddSize(MediaSizeName.ISO_B1);
        this.checkAndAddSize(MediaSizeName.ISO_B2);
        this.checkAndAddSize(MediaSizeName.ISO_B3);
        this.checkAndAddSize(MediaSizeName.ISO_B4);
        this.checkAndAddSize(MediaSizeName.ISO_B5);
        this.checkAndAddSize(MediaSizeName.ISO_B6);
        this.checkAndAddSize(MediaSizeName.ISO_B7);
        this.checkAndAddSize(MediaSizeName.ISO_B8);
        this.checkAndAddSize(MediaSizeName.ISO_B9);
        this.checkAndAddSize(MediaSizeName.ISO_B10);
        this.checkAndAddSize(MediaSizeName.JIS_B0);
        this.checkAndAddSize(MediaSizeName.JIS_B1);
        this.checkAndAddSize(MediaSizeName.JIS_B2);
        this.checkAndAddSize(MediaSizeName.JIS_B3);
        this.checkAndAddSize(MediaSizeName.JIS_B4);
        this.checkAndAddSize(MediaSizeName.JIS_B5);
        this.checkAndAddSize(MediaSizeName.JIS_B6);
        this.checkAndAddSize(MediaSizeName.JIS_B7);
        this.checkAndAddSize(MediaSizeName.JIS_B8);
        this.checkAndAddSize(MediaSizeName.JIS_B9);
        this.checkAndAddSize(MediaSizeName.JIS_B10);
        this.checkAndAddSize(MediaSizeName.ISO_C0);
        this.checkAndAddSize(MediaSizeName.ISO_C1);
        this.checkAndAddSize(MediaSizeName.ISO_C2);
        this.checkAndAddSize(MediaSizeName.ISO_C3);
        this.checkAndAddSize(MediaSizeName.ISO_C4);
        this.checkAndAddSize(MediaSizeName.ISO_C5);
        this.checkAndAddSize(MediaSizeName.ISO_C6);
        this.checkAndAddSize(MediaSizeName.NA_LEGAL);
        this.checkAndAddSize(MediaSizeName.EXECUTIVE);
        this.checkAndAddSize(MediaSizeName.LEDGER);
        this.checkAndAddSize(MediaSizeName.TABLOID);
        this.checkAndAddSize(MediaSizeName.INVOICE);
        this.checkAndAddSize(MediaSizeName.FOLIO);
        this.checkAndAddSize(MediaSizeName.QUARTO);
        this.checkAndAddSize(MediaSizeName.JAPANESE_POSTCARD);
        this.checkAndAddSize(MediaSizeName.JAPANESE_DOUBLE_POSTCARD);
        this.checkAndAddSize(MediaSizeName.A);
        this.checkAndAddSize(MediaSizeName.B);
        this.checkAndAddSize(MediaSizeName.C);
        this.checkAndAddSize(MediaSizeName.D);
        this.checkAndAddSize(MediaSizeName.E);
        this.checkAndAddSize(MediaSizeName.ISO_DESIGNATED_LONG);
        this.checkAndAddSize(MediaSizeName.ITALY_ENVELOPE);
        this.checkAndAddSize(MediaSizeName.MONARCH_ENVELOPE);
        this.checkAndAddSize(MediaSizeName.PERSONAL_ENVELOPE);
        this.checkAndAddSize(MediaSizeName.NA_NUMBER_9_ENVELOPE);
        this.checkAndAddSize(MediaSizeName.NA_NUMBER_10_ENVELOPE);
        this.checkAndAddSize(MediaSizeName.NA_NUMBER_11_ENVELOPE);
        this.checkAndAddSize(MediaSizeName.NA_NUMBER_12_ENVELOPE);
        this.checkAndAddSize(MediaSizeName.NA_NUMBER_14_ENVELOPE);
        this.checkAndAddSize(MediaSizeName.NA_6X9_ENVELOPE);
        this.checkAndAddSize(MediaSizeName.NA_7X9_ENVELOPE);
        this.checkAndAddSize(MediaSizeName.NA_9X11_ENVELOPE);
        this.checkAndAddSize(MediaSizeName.NA_9X12_ENVELOPE);
        this.checkAndAddSize(MediaSizeName.NA_10X13_ENVELOPE);
        this.checkAndAddSize(MediaSizeName.NA_10X14_ENVELOPE);
        this.checkAndAddSize(MediaSizeName.NA_10X15_ENVELOPE);
        this.checkAndAddSize(MediaSizeName.NA_5X7);
        this.checkAndAddSize(MediaSizeName.NA_8X10);
        PaperSizes.addCustomPaperSizes();
        this.setDefault();
    }

    public String[] getPaperSizes() {
        String[] result = new String[]{this.paperNames.get(MediaSizeName.ISO_A4.toString()), this.paperNames.get(MediaSizeName.NA_LETTER.toString()), this.paperNames.get(MediaSizeName.ISO_A0.toString()), this.paperNames.get(MediaSizeName.ISO_A1.toString()), this.paperNames.get(MediaSizeName.ISO_A2.toString()), this.paperNames.get(MediaSizeName.ISO_A3.toString()), this.paperNames.get(MediaSizeName.ISO_A5.toString()), this.paperNames.get(MediaSizeName.ISO_A6.toString()), this.paperNames.get(MediaSizeName.ISO_A7.toString()), this.paperNames.get(MediaSizeName.ISO_A8.toString()), this.paperNames.get(MediaSizeName.ISO_A9.toString()), this.paperNames.get(MediaSizeName.ISO_A10.toString()), this.paperNames.get(MediaSizeName.ISO_B0.toString()), this.paperNames.get(MediaSizeName.ISO_B1.toString()), this.paperNames.get(MediaSizeName.ISO_B2.toString()), this.paperNames.get(MediaSizeName.ISO_B3.toString()), this.paperNames.get(MediaSizeName.ISO_B4.toString()), this.paperNames.get(MediaSizeName.ISO_B5.toString()), this.paperNames.get(MediaSizeName.ISO_B6.toString()), this.paperNames.get(MediaSizeName.ISO_B7.toString()), this.paperNames.get(MediaSizeName.ISO_B8.toString()), this.paperNames.get(MediaSizeName.ISO_B9.toString()), this.paperNames.get(MediaSizeName.ISO_B10.toString()), this.paperNames.get(MediaSizeName.JIS_B0.toString()), this.paperNames.get(MediaSizeName.JIS_B1.toString()), this.paperNames.get(MediaSizeName.JIS_B2.toString()), this.paperNames.get(MediaSizeName.JIS_B3.toString()), this.paperNames.get(MediaSizeName.JIS_B4.toString()), this.paperNames.get(MediaSizeName.JIS_B5.toString()), this.paperNames.get(MediaSizeName.JIS_B6.toString()), this.paperNames.get(MediaSizeName.JIS_B7.toString()), this.paperNames.get(MediaSizeName.JIS_B8.toString()), this.paperNames.get(MediaSizeName.JIS_B9.toString()), this.paperNames.get(MediaSizeName.JIS_B10.toString()), this.paperNames.get(MediaSizeName.ISO_C0.toString()), this.paperNames.get(MediaSizeName.ISO_C1.toString()), this.paperNames.get(MediaSizeName.ISO_C2.toString()), this.paperNames.get(MediaSizeName.ISO_C3.toString()), this.paperNames.get(MediaSizeName.ISO_C4.toString()), this.paperNames.get(MediaSizeName.ISO_C5.toString()), this.paperNames.get(MediaSizeName.ISO_C6.toString()), this.paperNames.get(MediaSizeName.NA_LEGAL.toString()), this.paperNames.get(MediaSizeName.EXECUTIVE.toString()), this.paperNames.get(MediaSizeName.LEDGER.toString()), this.paperNames.get(MediaSizeName.TABLOID.toString()), this.paperNames.get(MediaSizeName.INVOICE.toString()), this.paperNames.get(MediaSizeName.FOLIO.toString()), this.paperNames.get(MediaSizeName.QUARTO.toString()), this.paperNames.get(MediaSizeName.JAPANESE_POSTCARD.toString()), this.paperNames.get(MediaSizeName.JAPANESE_DOUBLE_POSTCARD.toString()), this.paperNames.get(MediaSizeName.A.toString()), this.paperNames.get(MediaSizeName.B.toString()), this.paperNames.get(MediaSizeName.C.toString()), this.paperNames.get(MediaSizeName.D.toString()), this.paperNames.get(MediaSizeName.E.toString()), this.paperNames.get(MediaSizeName.ISO_DESIGNATED_LONG.toString()), this.paperNames.get(MediaSizeName.ITALY_ENVELOPE.toString()), this.paperNames.get(MediaSizeName.MONARCH_ENVELOPE.toString()), this.paperNames.get(MediaSizeName.PERSONAL_ENVELOPE.toString()), this.paperNames.get(MediaSizeName.NA_NUMBER_9_ENVELOPE.toString()), this.paperNames.get(MediaSizeName.NA_NUMBER_10_ENVELOPE.toString()), this.paperNames.get(MediaSizeName.NA_NUMBER_11_ENVELOPE.toString()), this.paperNames.get(MediaSizeName.NA_NUMBER_12_ENVELOPE.toString()), this.paperNames.get(MediaSizeName.NA_NUMBER_14_ENVELOPE.toString()), this.paperNames.get(MediaSizeName.NA_6X9_ENVELOPE.toString()), this.paperNames.get(MediaSizeName.NA_7X9_ENVELOPE.toString()), this.paperNames.get(MediaSizeName.NA_9X11_ENVELOPE.toString()), this.paperNames.get(MediaSizeName.NA_9X12_ENVELOPE.toString()), this.paperNames.get(MediaSizeName.NA_10X13_ENVELOPE.toString()), this.paperNames.get(MediaSizeName.NA_10X14_ENVELOPE.toString()), this.paperNames.get(MediaSizeName.NA_10X15_ENVELOPE.toString()), this.paperNames.get(MediaSizeName.NA_5X7.toString()), this.paperNames.get(MediaSizeName.NA_8X10.toString())};
        return result;
    }

    private void checkAndAddSize(MediaSizeName name) {
        float[] values;
        HashPrintRequestAttributeSet attributes = new HashPrintRequestAttributeSet();
        if (!this.printService.isAttributeValueSupported(name, new DocFlavor.BYTE_ARRAY(DocFlavor.BYTE_ARRAY.PNG.getMimeType()), attributes)) {
            return;
        }
        String o = this.paperNames.get(name.toString());
        String printDescription = o != null ? o.toString() : name.toString();
        MediaSize size = MediaSize.getMediaSizeForName(name);
        double pX = size.getX(1000);
        double pY = size.getY(1000);
        attributes.add(name);
        MediaPrintableArea[] area = (MediaPrintableArea[])this.printService.getSupportedAttributeValues(MediaPrintableArea.class, null, attributes);
        if (area.length == 0) {
            return;
        }
        int useArea = 0;
        if (area[useArea] == null) {
            int i = 0;
            while (i != area.length && area[useArea] == null) {
                useArea = i++;
            }
        }
        if ((double)(values = area[useArea].getPrintableArea(1000))[2] > pX - 0.5 && (double)values[2] < pX + 0.5) {
            values[2] = (float)pX;
        }
        if ((double)values[3] > pY - 0.5 && (double)values[3] < pY + 0.5) {
            values[3] = (float)pY;
        }
        if ((double)values[2] > pX ^ (double)values[3] > pY) {
            double temp = pX;
            pX = pY;
            pY = temp;
        }
        MarginPaper paper = new MarginPaper();
        paper.setSize(pX * 2.834645669291339, pY * 2.834645669291339);
        paper.setMinImageableArea((double)values[0] * 2.834645669291339, (double)values[1] * 2.834645669291339, (double)values[2] * 2.834645669291339, (double)values[3] * 2.834645669291339);
        this.paperDefinitions.put(printDescription, paper);
        this.paperList.add(printDescription);
    }

    public int getDefaultPageIndex() {
        return this.defaultPageIndex;
    }

    private void populateNameMap() {
        this.paperNames.put("iso-a0", "A0");
        this.paperNames.put("iso-a1", "A1");
        this.paperNames.put("iso-a2", "A2");
        this.paperNames.put("iso-a3", "A3");
        this.paperNames.put("iso-a4", "A4");
        this.paperNames.put("iso-a5", "A5");
        this.paperNames.put("iso-a6", "A6");
        this.paperNames.put("iso-a7", "A7");
        this.paperNames.put("iso-a8", "A8");
        this.paperNames.put("iso-a9", "A9");
        this.paperNames.put("iso-a10", "A10");
        this.paperNames.put("iso-b0", "B0");
        this.paperNames.put("iso-b1", "B1");
        this.paperNames.put("iso-b2", "B2");
        this.paperNames.put("iso-b3", "B3");
        this.paperNames.put("iso-b4", "B4");
        this.paperNames.put("iso-b5", "B5");
        this.paperNames.put("iso-b6", "B6");
        this.paperNames.put("iso-b7", "B7");
        this.paperNames.put("iso-b8", "B8");
        this.paperNames.put("iso-b9", "B9");
        this.paperNames.put("iso-b10", "B10");
        this.paperNames.put("na-letter", "North American Letter");
        this.paperNames.put("na-legal", "North American Legal");
        this.paperNames.put("na-8x10", "North American 8x10 inch");
        this.paperNames.put("na-5x7", "North American 5x7 inch");
        this.paperNames.put("executive", "Executive");
        this.paperNames.put("folio", "Folio");
        this.paperNames.put("invoice", "Invoice");
        this.paperNames.put("tabloid", "Tabloid");
        this.paperNames.put("ledger", "Ledger");
        this.paperNames.put("quarto", "Quarto");
        this.paperNames.put("iso-c0", "C0");
        this.paperNames.put("iso-c1", "C1");
        this.paperNames.put("iso-c2", "C2");
        this.paperNames.put("iso-c3", "C3");
        this.paperNames.put("iso-c4", "C4");
        this.paperNames.put("iso-c5", "C5");
        this.paperNames.put("iso-c6", "C6");
        this.paperNames.put("iso-designated-long", "ISO Designated Long size");
        this.paperNames.put("na-10x13-envelope", "North American 10x13 inch");
        this.paperNames.put("na-9x12-envelope", "North American 9x12 inch");
        this.paperNames.put("na-number-10-envelope", "North American number 10 business envelope");
        this.paperNames.put("na-7x9-envelope", "North American 7x9 inch envelope");
        this.paperNames.put("na-9x11-envelope", "North American 9x11 inch envelope");
        this.paperNames.put("na-10x14-envelope", "North American 10x14 inch envelope");
        this.paperNames.put("na-number-9-envelope", "North American number 9 business envelope");
        this.paperNames.put("na-6x9-envelope", "North American 6x9 inch envelope");
        this.paperNames.put("na-10x15-envelope", "North American 10x15 inch envelope");
        this.paperNames.put("monarch-envelope", "Monarch envelope");
        this.paperNames.put("jis-b0", "Japanese B0");
        this.paperNames.put("jis-b1", "Japanese B1");
        this.paperNames.put("jis-b2", "Japanese B2");
        this.paperNames.put("jis-b3", "Japanese B3");
        this.paperNames.put("jis-b4", "Japanese B4");
        this.paperNames.put("jis-b5", "Japanese B5");
        this.paperNames.put("jis-b6", "Japanese B6");
        this.paperNames.put("jis-b7", "Japanese B7");
        this.paperNames.put("jis-b8", "Japanese B8");
        this.paperNames.put("jis-b9", "Japanese B9");
        this.paperNames.put("jis-b10", "Japanese B10");
        this.paperNames.put("a", "Engineering ANSI A");
        this.paperNames.put("b", "Engineering ANSI B");
        this.paperNames.put("c", "Engineering ANSI C");
        this.paperNames.put("d", "Engineering ANSI D");
        this.paperNames.put("e", "Engineering ANSI E");
        this.paperNames.put("arch-a", "Architectural A");
        this.paperNames.put("arch-b", "Architectural B");
        this.paperNames.put("arch-c", "Architectural C");
        this.paperNames.put("arch-d", "Architectural D");
        this.paperNames.put("arch-e", "Architectural E");
        this.paperNames.put("japanese-postcard", "Japanese Postcard");
        this.paperNames.put("oufuko-postcard", "Oufuko Postcard");
        this.paperNames.put("italian-envelope", "Italian Envelope");
        this.paperNames.put("personal-envelope", "Personal Envelope");
        this.paperNames.put("na-number-11-envelope", "North American Number 11 Envelope");
        this.paperNames.put("na-number-12-envelope", "North American Number 12 Envelope");
        this.paperNames.put("na-number-14-envelope", "North American Number 14 Envelope");
    }
}

