/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.viewer.gui.swing;

import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JFrame;
import org.jpedal.PdfDecoder;
import org.jpedal.examples.viewer.Commands;
import org.jpedal.examples.viewer.Values;
import org.jpedal.examples.viewer.Viewer;
import org.jpedal.examples.viewer.gui.generic.GUIThumbnailPanel;
import org.jpedal.examples.viewer.utils.Printer;
import org.jpedal.examples.viewer.utils.PropertiesFile;
import org.jpedal.gui.GUIFactory;
import org.jpedal.utils.Messages;

public class FrameCloser
extends WindowAdapter {
    private Commands currentCommands;
    GUIFactory currentGUI;
    PdfDecoder decode_pdf;
    private Printer currentPrinter;
    GUIThumbnailPanel thumbnails;
    Values commonValues;
    PropertiesFile properties;

    public FrameCloser(Commands currentCommands, GUIFactory currentGUI, PdfDecoder decode_pdf, Printer currentPrinter, GUIThumbnailPanel thumbnails, Values commonValues, PropertiesFile properties) {
        this.currentCommands = currentCommands;
        this.currentGUI = currentGUI;
        this.decode_pdf = decode_pdf;
        this.currentPrinter = currentPrinter;
        this.thumbnails = thumbnails;
        this.commonValues = commonValues;
        this.properties = properties;
    }

    @Override
    public void windowClosing(WindowEvent e) {
        try {
            this.properties.setValue("lastDocumentPage", String.valueOf(this.commonValues.getCurrentPage()));
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (Printer.isPrinting()) {
            this.currentGUI.showMessageDialog(Messages.getMessage("PdfViewerBusyPrinting.message"));
        }
        if (!Values.isProcessing()) {
            this.thumbnails.terminateDrawing();
            int confirm = 0;
            if (this.currentGUI.confirmClose()) {
                confirm = this.currentGUI.showConfirmDialog(Messages.getMessage("PdfViewerCloseing.message"), null, 0);
            }
            if (confirm == 0) {
                this.currentCommands.handleUnsaveForms();
                this.decode_pdf.closePdfFile();
                if (Viewer.exitOnClose) {
                    System.exit(0);
                } else {
                    this.currentGUI.getFrame().setVisible(false);
                    if (this.currentGUI.getFrame() instanceof JFrame) {
                        ((JFrame)this.currentGUI.getFrame()).dispose();
                    }
                }
            }
        } else {
            this.currentGUI.showMessageDialog(Messages.getMessage("PdfViewerDecodeWait.message"));
        }
    }
}

