/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.viewer.gui.popups;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.geom.Ellipse2D;
import java.awt.image.BufferedImage;
import java.text.NumberFormat;
import java.util.ArrayList;
import javax.print.DocFlavor;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import javax.print.attribute.SetOfIntegerSyntax;
import javax.print.attribute.standard.PageRanges;
import javax.print.attribute.standard.PrinterResolution;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jpedal.PdfDecoder;
import org.jpedal.examples.viewer.Viewer;
import org.jpedal.examples.viewer.paper.MarginPaper;
import org.jpedal.examples.viewer.paper.PaperSizes;
import org.jpedal.exception.PdfException;
import org.jpedal.io.ColorSpaceConvertor;
import org.jpedal.objects.PrinterOptions;
import org.jpedal.utils.Messages;

public class PrintPanel
extends JPanel {
    private static final long serialVersionUID = -6093216971364470153L;
    private boolean debugPrinterChange = false;
    int pageCount;
    int currentPage;
    int currentPreviewedPage = 1;
    int pagePrintCount = 1;
    private boolean okClicked = false;
    private String[] printersList;
    private PaperSizes paperDefinitions;
    private int defaultResolution;
    private boolean isFirstTime = true;
    private static final double mmPerSubInch = 0.35277777777777775;
    private PdfDecoder pdf;
    private JCheckBox autoRotateCenter;
    private ButtonGroup buttonGroup1;
    private JButton cancelButton;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel4;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JLabel jLabel9;
    private JLabel jLabel10;
    private JLabel jLabel11;
    private JLabel jLabel12;
    private JLabel jLabel13;
    private JLabel jLabel14;
    private JLabel jLabel15;
    private JSpinner left;
    private JSpinner right;
    private JSpinner top;
    private JSpinner bottom;
    private JComboBox resolution;
    private JButton okButton;
    private JPanel pageHandlingPanel;
    private JPanel previewPanel;
    private JComponent previewComponent;
    private CustomSlider previewSlider;
    private JComboBox pageSize;
    private JTextField pagesFrom;
    private JTextField pagesTo;
    private JCheckBox paperSourceByPDF;
    private JCheckBox grayscale;
    private JSpinner printHandlingCopies;
    private JComboBox printHandlingScaling;
    private JRadioButton printRangeAll;
    private JRadioButton printRangeCurrentPage;
    private JRadioButton printRangeCurrentView;
    private JRadioButton printRangeFrom;
    private JPanel printRangePanel;
    private JCheckBox printRangeReversePages;
    private JComboBox printRangeSubset;
    private JComboBox printerName;
    private JPanel printerPanel;
    private JTabbedPane tabbedPane;

    public PrintPanel(String[] printersList, String defaultPrinter, PaperSizes paperDefinitions, int defaultResolution, int pageNumber, PdfDecoder decoder) {
        this.pdf = decoder;
        this.pageCount = this.pdf.getPageCount();
        this.currentPage = pageNumber;
        this.defaultResolution = defaultResolution;
        this.paperDefinitions = paperDefinitions;
        this.resetDefaults(printersList, defaultPrinter, this.pageCount, this.currentPage);
        this.isFirstTime = false;
    }

    public void resetDefaults(String[] printersList, String defaultPrinter, int pageCount, int currentPage) {
        String printerFlag;
        this.printersList = printersList;
        this.pageCount = pageCount;
        this.currentPage = currentPage;
        this.initComponents();
        if (this.pageSize.getItemCount() == 0) {
            return;
        }
        int defaultPagesize = this.paperDefinitions.getDefaultPageIndex();
        if (defaultPagesize < this.pageSize.getModel().getSize()) {
            this.pageSize.setSelectedIndex(defaultPagesize);
        }
        if ((printerFlag = System.getProperty("org.jpedal.defaultPrinter")) != null) {
            for (String aPrintersList : printersList) {
                if (!printerFlag.equals(aPrintersList)) continue;
                this.printerName.setSelectedItem(aPrintersList);
            }
        } else {
            this.printerName.setSelectedItem(defaultPrinter);
        }
    }

    private void initComponents() {
        if (this.isFirstTime) {
            this.buttonGroup1 = new ButtonGroup();
            this.printerPanel = new JPanel();
            this.jLabel1 = new JLabel();
            this.jLabel2 = new JLabel();
            this.tabbedPane = new JTabbedPane();
            this.printerName = new JComboBox();
            this.pageSize = new JComboBox();
            this.jLabel10 = new JLabel();
            this.jLabel11 = new JLabel();
            this.jLabel12 = new JLabel();
            this.jLabel13 = new JLabel();
            this.jLabel14 = new JLabel();
            this.jLabel15 = new JLabel();
            this.left = new JSpinner();
            this.right = new JSpinner();
            this.top = new JSpinner();
            this.bottom = new JSpinner();
            this.resolution = new JComboBox();
            this.printRangePanel = new JPanel();
            this.pagesFrom = new JTextField();
            this.printRangeCurrentPage = new JRadioButton();
            this.printRangeAll = new JRadioButton();
            this.printRangeCurrentView = new JRadioButton();
            this.printRangeFrom = new JRadioButton();
            this.jLabel4 = new JLabel();
            this.printRangeSubset = new JComboBox();
            this.printRangeReversePages = new JCheckBox();
            this.jLabel7 = new JLabel();
            this.pagesTo = new JTextField();
            this.pageHandlingPanel = new JPanel();
            this.previewPanel = new JPanel();
            this.previewComponent = new JComponent(){
                private static final long serialVersionUID = -2687893784898612593L;

                @Override
                public void paintComponent(Graphics g) {
                    PrintPanel.this.printPreview((Graphics2D)g);
                }
            };
            this.previewSlider = new CustomSlider();
            this.jLabel8 = new JLabel();
            this.printHandlingCopies = new JSpinner();
            this.jLabel9 = new JLabel();
            this.printHandlingScaling = new JComboBox();
            this.autoRotateCenter = new JCheckBox();
            this.paperSourceByPDF = new JCheckBox();
            this.grayscale = new JCheckBox();
            this.okButton = new JButton();
            this.cancelButton = new JButton();
        } else {
            this.removeAll();
        }
        this.setLayout(null);
        this.add(this.tabbedPane);
        this.tabbedPane.setBounds(10, 7, 400, 330);
        this.printerPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        this.jLabel1.setText(Messages.getMessage("PdfViewerPrint.Name"));
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.fill = 2;
        gbc.insets = new Insets(5, 5, 5, 5);
        this.printerPanel.add((Component)this.jLabel1, gbc);
        this.jLabel2.setText(Messages.getMessage("PdfViewerPrint.PageSize"));
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.gridwidth = 1;
        this.printerPanel.add((Component)this.jLabel2, gbc);
        this.printerName.setModel(new DefaultComboBoxModel<String>(this.printersList));
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.gridwidth = 5;
        this.printerPanel.add((Component)this.printerName, gbc);
        this.printerName.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (PrintPanel.this.debugPrinterChange) {
                    System.out.println("itemStateChanged");
                }
                PrintPanel.this.previewComponent.repaint();
                if (PrintPanel.this.debugPrinterChange) {
                    System.out.println("repainted preview component");
                }
                PrintPanel.this.okButton.setEnabled(false);
                PrintPanel.this.pageSize.setEnabled(false);
                PrintPanel.this.pageSize.setModel(new DefaultComboBoxModel<String>(new String[]{"Loading..."}));
                PrintPanel.this.resolution.setEnabled(false);
                PrintPanel.this.resolution.setModel(new DefaultComboBoxModel<String>(new String[]{"Loading..."}));
                if (PrintPanel.this.debugPrinterChange) {
                    System.out.println("GUI options disabled");
                }
                Thread t = new Thread(){

                    @Override
                    public void run() {
                        if (PrintPanel.this.debugPrinterChange) {
                            System.out.println("Thread invoked.");
                        }
                        PrintService[] ps = PrintServiceLookup.lookupPrintServices(null, null);
                        if (PrintPanel.this.debugPrinterChange) {
                            System.out.println("Found print services.");
                        }
                        PrintService p = null;
                        for (PrintService p1 : ps) {
                            if (PrintPanel.this.debugPrinterChange) {
                                System.out.println("checking " + p1.getName());
                            }
                            if (!p1.getName().equals(PrintPanel.this.printerName.getSelectedItem())) continue;
                            p = p1;
                            if (!PrintPanel.this.debugPrinterChange) continue;
                            System.out.println("Match!");
                        }
                        if (p != null) {
                            if (PrintPanel.this.debugPrinterChange) {
                                System.out.println("Getting available resolutions...");
                            }
                            PrintPanel.this.resolution.setModel(new DefaultComboBoxModel<String>(PrintPanel.getAvailableResolutions(p)));
                            if (PrintPanel.this.debugPrinterChange) {
                                System.out.println("Getting default resolution...");
                            }
                            int resInd = PrintPanel.this.getDefaultResolutionIndex();
                            if (PrintPanel.this.resolution.getModel().getSize() > resInd) {
                                PrintPanel.this.resolution.setSelectedIndex(resInd);
                            }
                            PrintPanel.this.resolution.setEnabled(true);
                            PrintPanel.this.paperDefinitions.setPrintService(p);
                            if (PrintPanel.this.debugPrinterChange) {
                                System.out.println("Getting available paper sizes...");
                            }
                            PrintPanel.this.pageSize.setModel(new DefaultComboBoxModel<String>(PrintPanel.this.getAvailablePaperSizes()));
                            if (PrintPanel.this.debugPrinterChange) {
                                System.out.println("Getting default pagesize...");
                            }
                            int pageInd = PrintPanel.this.paperDefinitions.getDefaultPageIndex();
                            if (PrintPanel.this.pageSize.getModel().getSize() > pageInd) {
                                PrintPanel.this.pageSize.setSelectedIndex(pageInd);
                            }
                            PrintPanel.this.pageSize.setEnabled(true);
                            PrintPanel.this.okButton.setEnabled(true);
                            if (PrintPanel.this.debugPrinterChange) {
                                System.out.println("Reenabled GUI");
                            }
                        }
                        if (PrintPanel.this.debugPrinterChange) {
                            System.out.println("Updating margins");
                        }
                        PrintPanel.this.updateMargins();
                    }
                };
                if (PrintPanel.this.debugPrinterChange) {
                    System.out.println("Invoking update thread...");
                }
                SwingUtilities.invokeLater(t);
            }
        });
        Thread t = new Thread(){

            @Override
            public void run() {
                PrintService[] ps = PrintServiceLookup.lookupPrintServices(null, null);
                PrintService p = null;
                for (PrintService p1 : ps) {
                    if (!p1.getName().equals(PrintPanel.this.printerName.getSelectedItem())) continue;
                    p = p1;
                }
                if (p != null) {
                    PrintPanel.this.paperDefinitions.setPrintService(p);
                    PrintPanel.this.resolution.setModel(new DefaultComboBoxModel<String>(PrintPanel.getAvailableResolutions(p)));
                    int defaultResolution = PrintPanel.this.getDefaultResolutionIndex();
                    if (PrintPanel.this.resolution.getModel().getSize() > defaultResolution) {
                        PrintPanel.this.resolution.setSelectedIndex(defaultResolution);
                    }
                    PrintPanel.this.resolution.setEnabled(true);
                    PrintPanel.this.pageSize.setModel(new DefaultComboBoxModel<String>(PrintPanel.this.getAvailablePaperSizes()));
                    int defaultPageSize = PrintPanel.this.paperDefinitions.getDefaultPageIndex();
                    if (defaultPageSize < PrintPanel.this.pageSize.getModel().getSize()) {
                        PrintPanel.this.pageSize.setSelectedIndex(defaultPageSize);
                    }
                    PrintPanel.this.pageSize.setEnabled(true);
                    PrintPanel.this.okButton.setEnabled(true);
                }
                PrintPanel.this.updateMargins();
            }
        };
        this.pageSize.setModel(new DefaultComboBoxModel<String>(new String[]{"Loading..."}));
        this.pageSize.setEnabled(false);
        this.resolution.setModel(new DefaultComboBoxModel<String>(new String[]{"Loading..."}));
        this.resolution.setEnabled(false);
        this.okButton.setEnabled(false);
        t.start();
        this.pageSize.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                PrintPanel.this.updatePreview();
                PrintPanel.this.updateMargins();
            }
        });
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.gridwidth = 5;
        this.printerPanel.add((Component)this.pageSize, gbc);
        this.jLabel10.setText(Messages.getMessage("PdfViewerPrintMargins.margin"));
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.gridwidth = 1;
        this.printerPanel.add((Component)this.jLabel10, gbc);
        this.jLabel11.setText(Messages.getMessage("PdfViewerPrintMargins.left"));
        gbc.gridx = 1;
        gbc.gridy = 2;
        gbc.gridwidth = 1;
        this.printerPanel.add((Component)this.jLabel11, gbc);
        this.left.setModel(new CustomSpinnerModel());
        gbc.gridx = 2;
        gbc.gridy = 2;
        gbc.gridwidth = 1;
        this.left.setMinimumSize(new Dimension(65, 22));
        this.left.setPreferredSize(new Dimension(65, 22));
        this.printerPanel.add((Component)this.left, gbc);
        this.jLabel12.setText(Messages.getMessage("PdfViewerPrintMargins.right"));
        gbc.gridx = 3;
        gbc.gridy = 2;
        gbc.gridwidth = 1;
        this.printerPanel.add((Component)this.jLabel12, gbc);
        this.right.setModel(new CustomSpinnerModel());
        gbc.gridx = 4;
        gbc.gridy = 2;
        gbc.gridwidth = 1;
        this.right.setMinimumSize(new Dimension(65, 22));
        this.right.setPreferredSize(new Dimension(65, 22));
        this.printerPanel.add((Component)this.right, gbc);
        this.jLabel13.setText(Messages.getMessage("PdfViewerPrintMargins.top"));
        gbc.gridx = 1;
        gbc.gridy = 3;
        gbc.gridwidth = 1;
        this.printerPanel.add((Component)this.jLabel13, gbc);
        this.top.setModel(new CustomSpinnerModel());
        gbc.gridx = 2;
        gbc.gridy = 3;
        gbc.gridwidth = 1;
        this.top.setMinimumSize(new Dimension(65, 22));
        this.top.setPreferredSize(new Dimension(65, 22));
        this.printerPanel.add((Component)this.top, gbc);
        this.jLabel14.setText(Messages.getMessage("PdfViewerPrintMargins.bottom"));
        gbc.gridx = 3;
        gbc.gridy = 3;
        gbc.gridwidth = 1;
        this.printerPanel.add((Component)this.jLabel14, gbc);
        this.bottom.setModel(new CustomSpinnerModel());
        gbc.gridx = 4;
        gbc.gridy = 3;
        gbc.gridwidth = 1;
        this.bottom.setMinimumSize(new Dimension(65, 22));
        this.bottom.setPreferredSize(new Dimension(65, 22));
        this.printerPanel.add((Component)this.bottom, gbc);
        ChangeListener marginListener = new ChangeListener(){
            static final double mmToSubInch = 2.834645669291339;

            @Override
            public void stateChanged(ChangeEvent e) {
                MarginPaper paper = PrintPanel.this.getSelectedPaper();
                if (paper == null) {
                    return;
                }
                double l = (Double)PrintPanel.this.left.getValue() * 2.834645669291339;
                double r = (Double)PrintPanel.this.right.getValue() * 2.834645669291339;
                double t = (Double)PrintPanel.this.top.getValue() * 2.834645669291339;
                double b = (Double)PrintPanel.this.bottom.getValue() * 2.834645669291339;
                paper.setImageableArea(l, t, paper.getWidth() - l - r, paper.getHeight() - t - b);
                PrintPanel.this.updatePreview();
            }
        };
        this.left.addChangeListener(marginListener);
        this.right.addChangeListener(marginListener);
        this.top.addChangeListener(marginListener);
        this.bottom.addChangeListener(marginListener);
        this.jLabel15.setText(Messages.getMessage("PdfViewerPrintResolution.text"));
        gbc.gridx = 0;
        gbc.gridy = 4;
        gbc.gridwidth = 1;
        this.printerPanel.add((Component)this.jLabel15, gbc);
        gbc.gridx = 1;
        gbc.gridy = 4;
        gbc.gridwidth = 5;
        this.printerPanel.add((Component)this.resolution, gbc);
        this.tabbedPane.addTab(Messages.getMessage("PdfViewerPrintTab.printer"), this.printerPanel);
        this.printRangePanel.setLayout(new GridBagLayout());
        this.pagesFrom.setText("1");
        this.pagesFrom.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                PrintPanel.this.pagesBoxPressed(evt);
            }
        });
        gbc.gridx = 1;
        gbc.gridy = 3;
        gbc.gridwidth = 1;
        this.pagesFrom.setMinimumSize(new Dimension(65, 22));
        this.pagesFrom.setPreferredSize(new Dimension(65, 22));
        gbc.insets = new Insets(0, 0, 0, 0);
        this.printRangePanel.add((Component)this.pagesFrom, gbc);
        gbc.insets = new Insets(5, 5, 5, 5);
        this.buttonGroup1.add(this.printRangeCurrentPage);
        this.printRangeCurrentPage.setText(Messages.getMessage("PdfViewerRadioButton.CurrentPage"));
        this.printRangeCurrentPage.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.printRangeCurrentPage.setMargin(new Insets(0, 0, 0, 0));
        this.printRangeCurrentPage.setOpaque(false);
        this.printRangeCurrentPage.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                PrintPanel.this.currentPageStateChanged(evt);
            }
        });
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.gridwidth = 1;
        this.printRangePanel.add((Component)this.printRangeCurrentPage, gbc);
        this.buttonGroup1.add(this.printRangeAll);
        this.printRangeAll.setSelected(true);
        this.printRangeAll.setText(Messages.getMessage("PdfViewerRadioButton.All"));
        this.printRangeAll.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.printRangeAll.setMargin(new Insets(0, 0, 0, 0));
        this.printRangeAll.setOpaque(false);
        if (this.isFirstTime) {
            this.printRangeAll.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent evt) {
                    PrintPanel.this.allStateChanged(evt);
                }
            });
        }
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        this.printRangePanel.add((Component)this.printRangeAll, gbc);
        this.buttonGroup1.add(this.printRangeCurrentView);
        this.printRangeCurrentView.setText(Messages.getMessage("PdfViewerPrint.CurrentView"));
        this.printRangeCurrentView.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.printRangeCurrentView.setEnabled(true);
        this.printRangeCurrentView.setMargin(new Insets(0, 0, 0, 0));
        this.printRangeCurrentView.setOpaque(false);
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.gridwidth = 1;
        this.printRangePanel.add((Component)this.printRangeCurrentView, gbc);
        if (this.pdf.getDisplayView() != 1) {
            this.printRangeCurrentView.setEnabled(false);
            this.printRangeCurrentView.setToolTipText(Messages.getMessage("PageLayoutMessage.SinglePageOnly"));
        } else {
            this.printRangeCurrentView.setEnabled(true);
            this.printRangeCurrentView.setToolTipText(null);
        }
        if (this.isFirstTime) {
            this.printRangeCurrentView.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent evt) {
                    PrintPanel.this.printRangeCurrentView(evt);
                }
            });
        }
        this.buttonGroup1.add(this.printRangeFrom);
        this.printRangeFrom.setText(Messages.getMessage("PdfViewerPrint.PagesFrom"));
        this.printRangeFrom.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.printRangeFrom.setMargin(new Insets(0, 0, 0, 0));
        this.printRangeFrom.setOpaque(false);
        if (this.isFirstTime) {
            this.printRangeFrom.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent evt) {
                    PrintPanel.this.pagesFromStateChanged(evt);
                }
            });
        }
        gbc.gridx = 0;
        gbc.gridy = 3;
        gbc.gridwidth = 1;
        this.printRangePanel.add((Component)this.printRangeFrom, gbc);
        this.jLabel4.setText(Messages.getMessage("PdfViewerPrint.Subset"));
        gbc.gridx = 0;
        gbc.gridy = 4;
        gbc.gridwidth = 1;
        this.printRangePanel.add((Component)this.jLabel4, gbc);
        this.printRangeSubset.setModel(new DefaultComboBoxModel<String>(new String[]{Messages.getMessage("PdfViewerPrint.AllPagesInRange"), Messages.getMessage("PdfViewerPrint.OddPagesOnly"), Messages.getMessage("PdfViewerPrint.EvenPagesOnly")}));
        gbc.gridx = 1;
        gbc.gridy = 4;
        gbc.gridwidth = 4;
        gbc.insets = new Insets(5, 0, 5, 0);
        this.printRangePanel.add((Component)this.printRangeSubset, gbc);
        gbc.insets = new Insets(5, 5, 5, 5);
        this.printRangeSubset.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                PrintPanel.this.updatePreview();
            }
        });
        this.printRangeReversePages.setText(Messages.getMessage("PdfViewerPrint.ReversePages"));
        this.printRangeReversePages.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.printRangeReversePages.setMargin(new Insets(0, 0, 0, 0));
        gbc.gridx = 0;
        gbc.gridy = 5;
        gbc.gridwidth = 3;
        this.printRangePanel.add((Component)this.printRangeReversePages, gbc);
        this.printRangeReversePages.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                PrintPanel.this.updatePreview();
            }
        });
        this.jLabel7.setText(Messages.getMessage("PdfViewerPrint.PagesTo"));
        gbc.gridx = 2;
        gbc.gridy = 3;
        gbc.gridwidth = 1;
        this.printRangePanel.add((Component)this.jLabel7, gbc);
        this.pagesTo.setText(String.valueOf(this.pageCount));
        if (this.isFirstTime) {
            this.pagesTo.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent evt) {
                    PrintPanel.this.pagesBoxPressed(evt);
                }
            });
        }
        gbc.gridx = 3;
        gbc.gridy = 3;
        gbc.gridwidth = 1;
        this.pagesTo.setMinimumSize(new Dimension(65, 22));
        this.pagesTo.setPreferredSize(new Dimension(65, 22));
        gbc.insets = new Insets(0, 0, 0, 0);
        this.printRangePanel.add((Component)this.pagesTo, gbc);
        gbc.insets = new Insets(5, 5, 5, 5);
        this.tabbedPane.addTab(Messages.getMessage("PdfViewerPrintTab.range"), this.printRangePanel);
        this.pageHandlingPanel.setLayout(new GridBagLayout());
        this.jLabel8.setText(Messages.getMessage("PdfViewerPrint.Copies"));
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        this.pageHandlingPanel.add((Component)this.jLabel8, gbc);
        this.printHandlingCopies.setModel(new SpinnerNumberModel(1, 1, 1000, 1));
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.fill = 3;
        gbc.insets = new Insets(0, 0, 0, 0);
        gbc.anchor = 17;
        this.printHandlingCopies.setMinimumSize(new Dimension(65, 22));
        this.printHandlingCopies.setPreferredSize(new Dimension(65, 22));
        this.pageHandlingPanel.add((Component)this.printHandlingCopies, gbc);
        gbc.fill = 2;
        gbc.anchor = 10;
        gbc.insets = new Insets(5, 5, 5, 5);
        this.jLabel9.setText(Messages.getMessage("PdfViewerPrint.PageScaling"));
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.gridwidth = 1;
        this.pageHandlingPanel.add((Component)this.jLabel9, gbc);
        this.printHandlingScaling.setModel(new DefaultComboBoxModel<String>(PrinterOptions.PRINT_SCALING_OPTIONS));
        this.printHandlingScaling.setSelectedIndex(PrinterOptions.LAST_SCALING_CHOICE);
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.gridwidth = 1;
        gbc.insets = new Insets(5, 0, 5, 0);
        this.pageHandlingPanel.add((Component)this.printHandlingScaling, gbc);
        gbc.insets = new Insets(5, 5, 5, 5);
        this.printHandlingScaling.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                PrintPanel.this.updatePreview();
            }
        });
        this.autoRotateCenter.setSelected(true);
        this.autoRotateCenter.setText(Messages.getMessage("PdfViewerPrint.AutoRotateAndCenter"));
        this.autoRotateCenter.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.autoRotateCenter.setMargin(new Insets(0, 0, 0, 0));
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.gridwidth = 1;
        this.pageHandlingPanel.add((Component)this.autoRotateCenter, gbc);
        this.autoRotateCenter.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                PrintPanel.this.updatePreview();
            }
        });
        this.paperSourceByPDF.setText(Messages.getMessage("PdfViewerPrint.ChoosePaperByPdfSize"));
        this.paperSourceByPDF.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.paperSourceByPDF.setMargin(new Insets(0, 0, 0, 0));
        gbc.gridx = 0;
        gbc.gridy = 3;
        gbc.gridwidth = 2;
        this.pageHandlingPanel.add((Component)this.paperSourceByPDF, gbc);
        this.paperSourceByPDF.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                PrintPanel.this.updatePreview();
            }
        });
        this.grayscale.setText(Messages.getMessage("PdfViewerPrint.Grayscale"));
        this.grayscale.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        gbc.gridx = 0;
        gbc.gridy = 4;
        gbc.gridwidth = 2;
        this.pageHandlingPanel.add((Component)this.grayscale, gbc);
        this.grayscale.setMargin(new Insets(0, 0, 0, 0));
        this.grayscale.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                PrintPanel.this.updatePreview();
            }
        });
        this.tabbedPane.addTab(Messages.getMessage("PdfViewerPrintTab.handling"), this.pageHandlingPanel);
        this.previewPanel.setLayout(null);
        this.previewPanel.setBorder(BorderFactory.createTitledBorder(null, Messages.getMessage("PdfViewerLabel.PrintPreview"), 0, 0, new Font("Tahoma", 0, 11), Color.BLACK));
        this.previewPanel.add(this.previewComponent);
        this.previewComponent.setBounds(5, 5, 220, 275);
        this.previewPanel.add(this.previewSlider);
        this.previewSlider.setBounds(5, 280, 220, 40);
        this.previewSlider.setValue(1);
        this.updatePreview();
        this.add(this.previewPanel);
        this.previewPanel.setBounds(420, 7, 230, 330);
        this.okButton.setText(Messages.getMessage("PdfMessage.Ok"));
        if (this.isFirstTime) {
            this.okButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    PrintPanel.this.okEvent(evt);
                }
            });
        }
        this.add(this.okButton);
        this.okButton.setBounds(445, 348, 90, 23);
        this.cancelButton.setText(Messages.getMessage("PdfMessage.Cancel"));
        if (this.isFirstTime) {
            this.cancelButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    PrintPanel.this.cancelEvent(evt);
                }
            });
        }
        this.add(this.cancelButton);
        this.cancelButton.setBounds(560, 348, 90, 23);
    }

    private static String[] getAvailableResolutions(PrintService p) {
        PrinterResolution[] resolutions = (PrinterResolution[])p.getSupportedAttributeValues(PrinterResolution.class, DocFlavor.SERVICE_FORMATTED.PAGEABLE, null);
        if (resolutions == null) {
            return new String[]{"Default"};
        }
        String[] names = new String[resolutions.length];
        for (int i = 0; i < resolutions.length; ++i) {
            PrinterResolution res = resolutions[i];
            names[i] = res.getCrossFeedResolution(100) + "x" + res.getFeedResolution(100) + " dpi";
        }
        return names;
    }

    public PrinterResolution getResolution() {
        PrintService[] ps = PrintServiceLookup.lookupPrintServices(null, null);
        PrintService p = null;
        for (PrintService p1 : ps) {
            if (!p1.getName().equals(this.printerName.getSelectedItem())) continue;
            p = p1;
        }
        PrinterResolution[] resolutions = (PrinterResolution[])p.getSupportedAttributeValues(PrinterResolution.class, DocFlavor.SERVICE_FORMATTED.PAGEABLE, null);
        if (resolutions == null) {
            return null;
        }
        return resolutions[this.resolution.getSelectedIndex()];
    }

    private int getDefaultResolutionIndex() {
        PrintService[] ps = PrintServiceLookup.lookupPrintServices(null, null);
        PrintService p = null;
        for (PrintService p1 : ps) {
            if (!p1.getName().equals(this.printerName.getSelectedItem())) continue;
            p = p1;
        }
        PrinterResolution[] resolutions = (PrinterResolution[])p.getSupportedAttributeValues(PrinterResolution.class, DocFlavor.SERVICE_FORMATTED.PAGEABLE, null);
        if (resolutions == null) {
            return 0;
        }
        if (this.defaultResolution == -1) {
            this.defaultResolution = 600;
        }
        int minDiff = Integer.MAX_VALUE;
        int indexToUse = 0;
        for (int i = 0; i < resolutions.length; ++i) {
            int fDiff;
            PrinterResolution res = resolutions[i];
            int cfDiff = res.getCrossFeedResolution(100) - this.defaultResolution;
            if (cfDiff < 0) {
                cfDiff = -cfDiff;
            }
            if ((fDiff = res.getFeedResolution(100) - this.defaultResolution) < 0) {
                fDiff = -fDiff;
            }
            if (cfDiff + fDiff >= minDiff) continue;
            minDiff = cfDiff + fDiff;
            indexToUse = i;
        }
        return indexToUse;
    }

    private void updateMargins() {
        MarginPaper p = this.getSelectedPaper();
        if (p == null) {
            return;
        }
        ((CustomSpinnerModel)this.left.getModel()).setMinValue(p.getMinX() * 0.35277777777777775);
        ((CustomSpinnerModel)this.top.getModel()).setMinValue(p.getMinY() * 0.35277777777777775);
        ((CustomSpinnerModel)this.right.getModel()).setMinValue((p.getWidth() - p.getMaxRX()) * 0.35277777777777775);
        ((CustomSpinnerModel)this.bottom.getModel()).setMinValue((p.getHeight() - p.getMaxBY()) * 0.35277777777777775);
        Double a = 0.0;
        this.left.setValue(a);
        this.top.setValue(a);
        this.right.setValue(a);
        this.bottom.setValue(a);
    }

    private void printPreview(Graphics2D g2) {
        int iY;
        int iX;
        int iH;
        int iW;
        int pH;
        int pW;
        int pageHeight;
        int pageWidth;
        int w = this.previewComponent.getWidth();
        int h = this.previewComponent.getHeight();
        if (this.printRangeCurrentView.isSelected()) {
            pageWidth = (int)(this.pdf.getVisibleRect().getWidth() / (double)this.pdf.getScaling());
            pageHeight = (int)(this.pdf.getVisibleRect().getHeight() / (double)this.pdf.getScaling());
        } else {
            pageWidth = this.pdf.getPdfPageData().getCropBoxWidth(this.currentPreviewedPage);
            pageHeight = this.pdf.getPdfPageData().getCropBoxHeight(this.currentPreviewedPage);
        }
        if (this.paperSourceByPDF.isSelected()) {
            pW = pageWidth;
            pH = pageHeight;
            iW = pW;
            iH = pH;
            iX = 0;
            iY = 0;
        } else {
            MarginPaper p = this.paperDefinitions.getSelectedPaper(this.pageSize.getSelectedItem());
            if (p == null) {
                g2.drawString(Messages.getMessage("PdfPrintPreview.Loading"), w / 2 - 25, h / 2 - 5);
                return;
            }
            pW = (int)p.getWidth();
            pH = (int)p.getHeight();
            iX = (int)p.getImageableX();
            iY = (int)p.getImageableY();
            iW = (int)p.getImageableWidth();
            iH = (int)p.getImageableHeight();
        }
        if (this.autoRotateCenter.isSelected() && (pageWidth > pageHeight && iW < iH || pageWidth < pageHeight && iW > iH)) {
            int temp = pW;
            pW = pH;
            pH = temp;
            temp = iW;
            iW = iH;
            iH = temp;
            temp = iX;
            iX = iY;
            iY = temp;
            iY = pH - iY - iH;
        }
        int lO = 25;
        int tO = 30;
        int rO = 5;
        int bO = 25;
        double paperHeightInInches = (double)pH / 72.0;
        double paperWidthInInches = (double)pW / 72.0;
        double wScale = (double)(w - (lO + rO)) / (double)pW;
        double hScale = (double)(h - (tO + bO)) / (double)pH;
        double scale = wScale < hScale ? wScale : hScale;
        pW = (int)(scale * (double)pW);
        pH = (int)(scale * (double)pH);
        iX = (int)(scale * (double)iX);
        iY = (int)(scale * (double)iY);
        iW = (int)(scale * (double)iW);
        iH = (int)(scale * (double)iH);
        pageWidth = (int)(scale * (double)pageWidth);
        pageHeight = (int)(scale * (double)pageHeight);
        double pageScale = 1.0;
        if (this.printHandlingScaling.getSelectedIndex() == 1 || this.printHandlingScaling.getSelectedIndex() == 2 && (pageWidth > iW || pageHeight > iH)) {
            pageScale = (double)iW / (double)pageWidth;
            if ((double)iH / (double)pageHeight < pageScale) {
                pageScale = (double)iH / (double)pageHeight;
            }
            pageWidth = (int)(pageScale * (double)pageWidth);
            pageHeight = (int)(pageScale * (double)pageHeight);
        }
        lO += (w - (lO + rO + pW)) / 2;
        tO += (h - (tO + bO + pH)) / 2;
        g2.setPaint(Color.WHITE);
        g2.fillRect(lO, tO, pW, pH);
        g2.setPaint(Color.RED);
        g2.drawLine(lO + iX, tO, lO + iX, tO + pH);
        g2.drawLine(lO, tO + iY, lO + pW, tO + iY);
        g2.drawLine(lO + iW + iX, tO, lO + iW + iX, tO + pH);
        g2.drawLine(lO, tO + iH + iY, lO + pW, tO + iH + iY);
        ++iX;
        ++iY;
        --iW;
        --iH;
        g2.setPaint(Color.BLACK);
        NumberFormat f = NumberFormat.getNumberInstance();
        f.setMaximumFractionDigits(1);
        String widthString = f.format(paperWidthInInches);
        int tLen = widthString.length() * 3;
        g2.drawString(widthString, lO + pW / 2 - tLen, tO - 5);
        g2.drawLine(lO, tO - 15, lO, tO - 5);
        g2.drawLine(lO + pW, tO - 15, lO + pW, tO - 5);
        g2.drawLine(lO, tO - 10, lO + pW / 2 - tLen - 6, tO - 10);
        g2.drawLine(lO + pW / 2 + tLen + 6, tO - 10, lO + pW, tO - 10);
        g2.drawLine(lO, tO - 10, lO + 5, tO - 15);
        g2.drawLine(lO, tO - 10, lO + 5, tO - 5);
        g2.drawLine(lO + pW, tO - 10, lO + pW - 5, tO - 15);
        g2.drawLine(lO + pW, tO - 10, lO + pW - 5, tO - 5);
        String heightString = f.format(paperHeightInInches);
        tLen = heightString.length() * 3;
        g2.drawString(heightString, lO - 12 - tLen, tO + pH / 2 + 5);
        g2.drawLine(lO - 15, tO, lO - 5, tO);
        g2.drawLine(lO - 15, tO + pH, lO - 5, tO + pH);
        g2.drawLine(lO - 10, tO, lO - 10, tO + pH / 2 - 8);
        g2.drawLine(lO - 10, tO + pH / 2 + 8, lO - 10, tO + pH);
        g2.drawLine(lO - 10, tO, lO - 5, tO + 5);
        g2.drawLine(lO - 10, tO, lO - 15, tO + 5);
        g2.drawLine(lO - 10, tO + pH, lO - 15, tO + pH - 5);
        g2.drawLine(lO - 10, tO + pH, lO - 5, tO + pH - 5);
        try {
            BufferedImage img;
            if (this.printRangeCurrentView.isSelected()) {
                img = new BufferedImage((int)this.pdf.getVisibleRect().getWidth(), (int)this.pdf.getVisibleRect().getHeight(), 2);
                Graphics g = img.getGraphics();
                g.translate((int)(-this.pdf.getVisibleRect().getX()), (int)(-this.pdf.getVisibleRect().getY()));
                Border bStore = this.pdf.getBorder();
                Color cStore = this.pdf.getBackground();
                this.pdf.setBorder(BorderFactory.createEmptyBorder());
                this.pdf.setBackground(Color.WHITE);
                this.pdf.paintComponent(g);
                this.pdf.setBorder(bStore);
                this.pdf.setBackground(cStore);
            } else {
                img = this.pdf.getPageAsImage(this.currentPreviewedPage);
            }
            if (this.grayscale.isSelected()) {
                img = ColorSpaceConvertor.convertColorspace(img, 10);
            }
            g2.setClip(lO + iX, tO + iY, iW, iH);
            int centeringX = (int)((double)(iW - pageWidth) / 2.0);
            int centeringY = (int)((double)(iH - pageHeight) / 2.0);
            g2.drawImage(img, lO + iX + centeringX, tO + iY + centeringY, pageWidth, pageHeight, null);
        }
        catch (PdfException pdfException) {
            // empty catch block
        }
        g2.setClip(null);
        g2.drawRect(lO, tO, pW, pH);
        f.setMaximumFractionDigits(0);
        g2.drawString(Messages.getMessage("PdfPrintPreview.UnitScale") + f.format(pageScale * 100.0) + '%', 5, h - 5);
    }

    private void updatePreview() {
        int selection = this.previewSlider.getValue();
        SetOfIntegerSyntax set = this.getPrintRange();
        if (set == null) {
            this.currentPreviewedPage = 0;
            this.pagePrintCount = 0;
        } else {
            int[][] ranges = set.getMembers();
            int count = 0;
            for (int[] range1 : ranges) {
                count += range1[1] - (range1[0] - 1);
            }
            int[] pagesToPrint = new int[count];
            this.pagePrintCount = pagesToPrint.length;
            count = 0;
            for (int[] range : ranges) {
                int rangeLength = range[1] - (range[0] - 1);
                for (int j = 0; j < rangeLength; ++j) {
                    pagesToPrint[count] = range[0] + j;
                    ++count;
                }
            }
            if (selection > this.pagePrintCount) {
                selection = 1;
                this.previewSlider.setValue(1);
            }
            this.currentPreviewedPage = this.printRangeReversePages.isSelected() ? pagesToPrint[pagesToPrint.length - selection] : pagesToPrint[selection - 1];
        }
        this.previewSlider.setMaxValue(this.pagePrintCount);
        this.previewComponent.repaint();
    }

    private void pagesBoxPressed(MouseEvent evt) {
        this.printRangeFrom.setSelected(true);
        this.printRangeSubset.setEnabled(true);
        this.printRangeReversePages.setEnabled(true);
        this.updatePreview();
    }

    private void pagesFromStateChanged(ItemEvent evt) {
        if (this.printRangeFrom.isSelected()) {
            this.printRangeSubset.setEnabled(true);
            this.printRangeReversePages.setEnabled(true);
            this.updatePreview();
        }
    }

    private void printRangeCurrentView(ItemEvent evt) {
        if (this.printRangeCurrentView.isSelected()) {
            this.printRangeSubset.setEnabled(false);
            this.printRangeReversePages.setEnabled(false);
            this.updatePreview();
        }
    }

    private void currentPageStateChanged(ItemEvent evt) {
        if (this.printRangeCurrentPage.isSelected()) {
            this.printRangeSubset.setEnabled(false);
            this.printRangeReversePages.setEnabled(false);
            this.updatePreview();
        }
    }

    private void allStateChanged(ItemEvent evt) {
        if (this.printRangeAll.isSelected()) {
            this.printRangeSubset.setEnabled(true);
            this.printRangeReversePages.setEnabled(true);
            this.updatePreview();
        }
    }

    private void cancelEvent(ActionEvent evt) {
        this.okClicked = false;
        this.getTopLevelAncestor().setVisible(false);
    }

    private void okEvent(ActionEvent evt) {
        this.okClicked = true;
        this.getTopLevelAncestor().setVisible(false);
    }

    public SetOfIntegerSyntax getPrintRange() {
        PageRanges pageRange = null;
        if (this.printRangeAll.isSelected()) {
            pageRange = new PageRanges(1, this.pageCount);
            if (this.printRangeSubset.getSelectedIndex() == 0) {
                return pageRange;
            }
            if (this.printRangeSubset.getSelectedIndex() == 1) {
                String members = "";
                int i = -1;
                while ((i = pageRange.next(i)) != -1) {
                    if (i % 2 != 1) continue;
                    members = members + i + ",";
                }
                StringBuilder sb = new StringBuilder(members);
                sb.deleteCharAt(members.length() - 1);
                members = sb.toString();
                pageRange = new PageRanges(members);
            } else if (this.printRangeSubset.getSelectedIndex() == 2) {
                String members = "";
                int i = -1;
                while ((i = pageRange.next(i)) != -1) {
                    if (i % 2 != 0) continue;
                    members = members + i + ",";
                }
                StringBuilder sb = new StringBuilder(members);
                sb.deleteCharAt(members.length() - 1);
                members = sb.toString();
                pageRange = new PageRanges(members);
            }
        } else if (this.printRangeCurrentPage.isSelected()) {
            pageRange = new PageRanges(this.currentPage);
        } else if (this.printRangeCurrentView.isSelected()) {
            pageRange = new PageRanges(this.currentPage);
        } else if (this.printRangeFrom.isSelected()) {
            int end;
            int start;
            try {
                start = Integer.parseInt(this.pagesFrom.getText());
            }
            catch (NumberFormatException e) {
                this.pagesFrom.setText("1");
                start = 1;
            }
            try {
                end = Integer.parseInt(this.pagesTo.getText());
            }
            catch (NumberFormatException e) {
                this.pagesTo.setText(String.valueOf(this.pageCount));
                end = this.pageCount;
            }
            if (start < 0) {
                start = 1;
                this.pagesFrom.setText("1");
            } else if (start > this.pageCount) {
                start = this.pageCount;
                this.pagesFrom.setText(String.valueOf(this.pageCount));
            }
            if (end < 0) {
                end = 1;
                this.pagesTo.setText("1");
            } else if (end > this.pageCount) {
                end = this.pageCount;
                this.pagesTo.setText(String.valueOf(this.pageCount));
            }
            if (start > end) {
                int tmp = end;
                end = start;
                start = tmp;
                if (Viewer.showMessages) {
                    JOptionPane.showMessageDialog(this, Messages.getMessage("PdfViewerPrint.SwapValues"));
                }
            }
            pageRange = new PageRanges(start, end);
            if (this.printRangeSubset.getSelectedIndex() == 0) {
                return pageRange;
            }
            if (this.printRangeSubset.getSelectedIndex() == 1) {
                String members = "";
                int i = -1;
                while ((i = pageRange.next(i)) != -1) {
                    if (i % 2 != 1) continue;
                    members = members + i + ",";
                }
                StringBuilder sb = new StringBuilder(members);
                if (members.length() == 0) {
                    return null;
                }
                sb.deleteCharAt(members.length() - 1);
                members = sb.toString();
                pageRange = new PageRanges(members);
            } else if (this.printRangeSubset.getSelectedIndex() == 2) {
                String members = "";
                int i = -1;
                while ((i = pageRange.next(i)) != -1) {
                    if (i % 2 != 0) continue;
                    members = members + i + ",";
                }
                StringBuilder sb = new StringBuilder(members);
                int length = members.length();
                if (length > 0) {
                    sb.deleteCharAt(length - 1);
                }
                pageRange = (members = sb.toString()).length() > 0 ? new PageRanges(members) : null;
            }
        }
        return pageRange;
    }

    public int getCopies() {
        String copies = this.printHandlingCopies.getValue().toString();
        return Integer.parseInt(copies);
    }

    public int getPageScaling() {
        int option = this.printHandlingScaling.getSelectedIndex();
        int value = 0;
        switch (option) {
            case 0: {
                value = 0;
                break;
            }
            case 1: {
                value = 1;
                break;
            }
            case 2: {
                value = 2;
            }
        }
        PrinterOptions.LAST_SCALING_CHOICE = value;
        return value;
    }

    public String getPrinter() {
        if (this.printerName == null) {
            return "";
        }
        if (this.printerName.getSelectedItem() == null) {
            return null;
        }
        return this.printerName.getSelectedItem().toString();
    }

    public boolean okClicked() {
        return this.okClicked;
    }

    public boolean isAutoRotateAndCenter() {
        return this.autoRotateCenter.isSelected();
    }

    public boolean isPaperSourceByPDFSize() {
        return this.paperSourceByPDF.isSelected();
    }

    public boolean isPrintingCurrentView() {
        return this.printRangeCurrentView.isSelected();
    }

    public String[] getAvailablePaperSizes() {
        return this.paperDefinitions.getAvailablePaperSizes();
    }

    public MarginPaper getSelectedPaper() {
        return this.paperDefinitions.getSelectedPaper(this.pageSize.getSelectedItem());
    }

    public boolean isPagesReversed() {
        return this.printRangeReversePages.isSelected();
    }

    public boolean isOddPagesOnly() {
        return this.printRangeSubset.getSelectedIndex() == 1;
    }

    public boolean isEvenPagesOnly() {
        return this.printRangeSubset.getSelectedIndex() == 2;
    }

    public boolean isMonochrome() {
        return this.grayscale.isSelected();
    }

    private static class CustomSpinnerModel
    extends SpinnerNumberModel {
        private static final long serialVersionUID = -1561911354444155587L;
        private double value = 0.0;
        private ArrayList<ChangeListener> listeners = new ArrayList();
        private double minValue = 0.0;

        private CustomSpinnerModel() {
        }

        @Override
        public Object getPreviousValue() {
            if (this.value <= this.minValue) {
                return null;
            }
            if (this.value - 0.5 < this.minValue) {
                return this.minValue;
            }
            return this.value - 0.5;
        }

        @Override
        public Object getNextValue() {
            return this.value + 0.5;
        }

        @Override
        public Object getValue() {
            return this.value;
        }

        @Override
        public void addChangeListener(ChangeListener l) {
            this.listeners.add(l);
        }

        @Override
        public void removeChangeListener(ChangeListener l) {
            this.listeners.remove(l);
        }

        @Override
        public void setValue(Object value) {
            try {
                double newValue = (Double)value;
                this.value = newValue < this.minValue ? this.minValue : newValue;
            }
            catch (Exception e) {
                throw new IllegalArgumentException();
            }
            ChangeEvent e = new ChangeEvent(this);
            for (ChangeListener listener : this.listeners) {
                listener.stateChanged(e);
            }
        }

        public void setMinValue(double minValue) {
            this.minValue = minValue;
            this.setValue(this.getValue());
        }
    }

    private class CustomSlider
    extends JPanel {
        private static final long serialVersionUID = -3375046146423776311L;
        private int value = 1;
        private int maxValue = 100;
        private static final int rightMargin = 9;
        private static final int leftMargin = 9;
        private boolean dragging = false;

        public CustomSlider() {
            this.addMouseMotionListener(new MouseMotionAdapter(){

                @Override
                public void mouseDragged(MouseEvent e) {
                    if (CustomSlider.this.dragging) {
                        CustomSlider.this.value = (int)((double)(e.getX() - 9) / (double)(CustomSlider.this.getWidth() - 18) * (double)(CustomSlider.this.maxValue - 1) + 1.5);
                        if (CustomSlider.this.value > CustomSlider.this.maxValue) {
                            CustomSlider.this.value = CustomSlider.this.maxValue;
                        }
                        if (CustomSlider.this.value < 1) {
                            CustomSlider.this.value = 1;
                        }
                        PrintPanel.this.updatePreview();
                        CustomSlider.this.repaint();
                    }
                }
            });
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (e.getY() < 20) {
                        double newValue = (double)(e.getX() - 9) / (double)(CustomSlider.this.getWidth() - 18) * (double)(CustomSlider.this.maxValue - 1) + 1.0;
                        if (newValue > (double)CustomSlider.this.value) {
                            CustomSlider.this.value++;
                        } else if (newValue < (double)CustomSlider.this.value) {
                            CustomSlider.this.value--;
                        }
                        if (CustomSlider.this.value > CustomSlider.this.maxValue) {
                            CustomSlider.this.value = CustomSlider.this.maxValue;
                        }
                        if (CustomSlider.this.value < 1) {
                            CustomSlider.this.value = 1;
                        }
                        PrintPanel.this.updatePreview();
                        CustomSlider.this.repaint();
                    }
                }

                @Override
                public void mousePressed(MouseEvent e) {
                    if (e.getY() < 20) {
                        CustomSlider.this.dragging = true;
                    }
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                    CustomSlider.this.dragging = false;
                }
            });
        }

        @Override
        public void paint(Graphics g) {
            Graphics2D g2 = (Graphics2D)g;
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            int w = this.getWidth();
            int h = this.getHeight();
            g2.setPaint(new Color(240, 240, 240));
            g2.fillRect(0, 0, w, h);
            g2.setPaint(Color.BLACK);
            g2.drawString(Messages.getMessage("PdfPrintPreview.Sheet") + this.value + Messages.getMessage("PdfPrintPreview.SheetOf") + this.maxValue, 2, h - 3);
            g2.setPaint(Color.LIGHT_GRAY);
            g2.fillRect(10, 11, w - 19, 3);
            g2.setPaint(Color.GRAY);
            g2.drawLine(9, 12, w - 9, 12);
            float pageX = 9.0f + (float)(this.value - 1) / (float)(this.maxValue - 1) * (float)(w - 18);
            Ellipse2D.Float number = new Ellipse2D.Float(pageX - 6.0f, 6.5f, 12.0f, 12.0f);
            Ellipse2D.Float number2 = new Ellipse2D.Float(pageX - 4.0f, 8.5f, 8.0f, 8.0f);
            g2.setPaint(Color.BLACK);
            g2.fill(number);
            g2.setPaint(Color.WHITE);
            g2.fill(number2);
        }

        public void setValue(int value) {
            this.value = value;
            this.repaint();
        }

        public void setMaxValue(int maxValue) {
            if (maxValue != this.maxValue) {
                this.value = 1;
                this.maxValue = maxValue;
                PrintPanel.this.updatePreview();
                return;
            }
            this.maxValue = maxValue;
            this.repaint();
        }

        public int getValue() {
            return this.value;
        }
    }
}

