/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.handlers;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import org.jpedal.color.PdfPaint;
import org.jpedal.external.ColorHandler;

public class ExampleColorHandler
implements ColorHandler {
    @Override
    public void setPaint(Graphics2D g2, PdfPaint col, int pageNumber, boolean isPrinting) {
        if (isPrinting) {
            int rgb = col.getRGB();
            if (rgb > -8388608) {
                g2.setPaint(Color.WHITE);
            } else {
                g2.setPaint(Color.BLACK);
            }
        } else {
            g2.setPaint(col);
        }
    }

    @Override
    public BufferedImage processImage(BufferedImage image, int pageNumber, boolean isPrinting) {
        BufferedImage newImage = null;
        if (isPrinting) {
            newImage = new BufferedImage(image.getWidth(), image.getHeight(), 12);
            Graphics2D newG2bw = newImage.createGraphics();
            newG2bw.setPaint(Color.WHITE);
            newG2bw.fillRect(0, 0, image.getWidth(), image.getHeight());
            newG2bw.drawImage((Image)image, 0, 0, null);
        }
        return newImage;
    }
}

