/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.handlers;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.util.Iterator;
import java.util.Map;
import javax.swing.JFileChooser;
import org.jpedal.PdfDecoder;
import org.jpedal.examples.viewer.Values;
import org.jpedal.examples.viewer.gui.SwingGUI;
import org.jpedal.external.AnnotationHandler;
import org.jpedal.io.ObjectStore;
import org.jpedal.io.PdfObjectReader;
import org.jpedal.objects.raw.FormObject;
import org.jpedal.objects.raw.PdfArrayIterator;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.render.ImageObject;

public class ExampleAnnotationHandler
implements AnnotationHandler {
    @Override
    public void handleAnnotations(PdfDecoder decode_pdf, Map objs, int p) {
        PdfArrayIterator annotListForPage = decode_pdf.getFormRenderer().getAnnotsOnPage(p);
        if (annotListForPage != null && annotListForPage.getTokenCount() > 0) {
            int i = 0;
            int count = annotListForPage.getTokenCount();
            int[] type = new int[count];
            Color[] colors = new Color[count];
            Object[] obj = new Object[count];
            while (annotListForPage.hasMoreTokens()) {
                Object[] rawObj;
                int mX = decode_pdf.getPdfPageData().getMediaBoxX(p);
                int mY = decode_pdf.getPdfPageData().getMediaBoxY(p);
                String annotKey = annotListForPage.getNextValueAsString(true);
                for (Object aRawObj : rawObj = decode_pdf.getFormRenderer().getCompData().getRawForm(annotKey)) {
                    FormObject annotObj;
                    int subtype;
                    if (aRawObj == null || (subtype = (annotObj = (FormObject)aRawObj).getParameterConstant(1147962727)) != 473513531) continue;
                    objs.put(annotObj, "x");
                    Color col = Color.BLUE;
                    Rectangle location = annotObj.getBoundingRectangle();
                    type[i] = 3;
                    ImageObject imgObject = new ImageObject();
                    imgObject.x = location.x + mX;
                    imgObject.y = location.y + mY;
                    imgObject.image = ExampleAnnotationHandler.createUniqueImage(16, String.valueOf(i + 1), col);
                    obj[i] = imgObject;
                    ++i;
                }
            }
        }
    }

    @Override
    public void checkLinks(Map objs, boolean mouseClicked, PdfObjectReader pdfObjectReader, int x, int y, SwingGUI currentGUI, Values commonValues) {
        Iterator objKeys = objs.keySet().iterator();
        FormObject annotObj = null;
        while (objKeys.hasNext() && !(annotObj = (FormObject)objKeys.next()).getBoundingRectangle().contains(x, y)) {
            annotObj = null;
        }
        if (annotObj != null) {
            System.out.println("clicked on=" + mouseClicked + " obj=" + annotObj + ' ' + annotObj.getObjectRefAsString() + ' ' + annotObj.getBoundingRectangle());
            if (!mouseClicked) {
                return;
            }
            PdfObject EFobj = null;
            PdfObject FSobj = annotObj.getDictionary(5667);
            if (FSobj != null) {
                EFobj = FSobj.getDictionary(5398);
            }
            JFileChooser chooser = new JFileChooser(commonValues.getInputDir());
            chooser.setFileSelectionMode(0);
            int state = chooser.showSaveDialog(currentGUI.getFrame());
            if (state == 0) {
                File fileTarget = chooser.getSelectedFile();
                if (EFobj != null) {
                    pdfObjectReader.checkResolved(EFobj);
                }
                PdfObject Fobj = EFobj.getDictionary(22);
                String nameOnDisk = Fobj.getCachedStreamFile(pdfObjectReader.getObjectReader());
                System.out.println("file=" + nameOnDisk);
                if (nameOnDisk != null) {
                    ObjectStore.copy(nameOnDisk, fileTarget.toString());
                } else {
                    byte[] fileData = Fobj.getDecodedStream();
                    if (fileData != null) {
                        try {
                            FileOutputStream fos = new FileOutputStream(fileTarget);
                            fos.write(fileData);
                            fos.close();
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }
            }
        }
    }

    private static BufferedImage createUniqueImage(int size, String text, Color col) {
        BufferedImage img = new BufferedImage(size, size, 2);
        Graphics2D g2 = (Graphics2D)img.getGraphics();
        g2.setColor(col);
        g2.fill(new Rectangle(0, 0, size, size));
        g2.setColor(Color.BLACK);
        g2.draw(new Rectangle(0, 0, size - 1, size - 1));
        g2.setColor(Color.white);
        g2.drawString(text, 2, 12);
        return img;
    }
}

