/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples;

import org.jpedal.PdfDecoder;
import org.jpedal.objects.PdfPageData;

public class ShowPageSize {
    public ShowPageSize(String file_name) {
        PdfDecoder decode_pdf = new PdfDecoder(false);
        try {
            decode_pdf.openPdfFile(file_name);
            int pageCount = decode_pdf.getPageCount();
            System.out.println("Page count=" + pageCount);
            PdfPageData pageData = decode_pdf.getPdfPageData();
            for (int ii = 0; ii < pageCount; ++ii) {
                if (pageData.getRotation(ii) != 0) {
                    System.out.println("Has rotation " + pageData.getRotation(ii) + " degrees");
                }
                System.out.print("page (size in pixels) " + ii + " mediaBox=" + pageData.getMediaBoxX(ii) + ' ' + pageData.getMediaBoxY(ii) + ' ' + pageData.getMediaBoxWidth(ii) + ' ' + pageData.getMediaBoxHeight(ii) + " CropBox=" + pageData.getCropBoxX(ii) + ' ' + pageData.getCropBoxY(ii) + ' ' + pageData.getCropBoxWidth(ii) + ' ' + pageData.getCropBoxHeight(ii));
                float factor = 72.0f;
                System.out.print(" (size in inches) " + ii + " mediaBox=" + (float)pageData.getMediaBoxX(ii) / factor + ' ' + (float)pageData.getMediaBoxY(ii) / factor + ' ' + (float)pageData.getMediaBoxWidth(ii) / factor + ' ' + (float)pageData.getMediaBoxHeight(ii) / factor + " CropBox=" + (float)pageData.getCropBoxX(ii) / factor + ' ' + (float)pageData.getCropBoxY(ii) / factor + (float)pageData.getCropBoxWidth(ii) / factor + ' ' + (float)pageData.getCropBoxHeight(ii) / factor);
                factor = 28.346457f;
                System.out.print(" (size in cm) " + ii + " mediaBox=" + (float)pageData.getMediaBoxX(ii) / factor + ' ' + (float)pageData.getMediaBoxY(ii) / factor + ' ' + (float)pageData.getMediaBoxWidth(ii) / factor + ' ' + (float)pageData.getMediaBoxHeight(ii) / factor + " CropBox=" + (float)pageData.getCropBoxX(ii) / factor + ' ' + (float)pageData.getCropBoxY(ii) / factor + (float)pageData.getCropBoxWidth(ii) / factor + ' ' + (float)pageData.getCropBoxHeight(ii) / factor + '\n');
            }
            decode_pdf.closePdfFile();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        if (args.length != 1) {
            System.out.println("Please pass in file name (including path");
        } else {
            new ShowPageSize(args[0]);
        }
    }
}

