/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import javax.imageio.ImageIO;
import org.jpedal.PdfDecoder;
import org.jpedal.objects.raw.FormObject;
import org.jpedal.objects.raw.PdfArrayIterator;
import org.jpedal.objects.raw.PdfObject;

public class ShowLinks {
    private boolean includeImages = true;

    public ShowLinks(String file_name) {
        BufferedImage img = null;
        PdfDecoder decodePdf = this.includeImages ? new PdfDecoder(true) : new PdfDecoder(false);
        try {
            decodePdf.openPdfFile(file_name);
            for (int ii = 1; ii < decodePdf.getPageCount() + 1; ++ii) {
                PdfArrayIterator annotListForPage = decodePdf.getFormRenderer().getAnnotsOnPage(ii);
                if (annotListForPage != null && annotListForPage.getTokenCount() > 0) {
                    if (this.includeImages) {
                        img = decodePdf.getPageAsImage(ii);
                    }
                    while (annotListForPage.hasMoreTokens()) {
                        Object[] rawObj;
                        String annotKey = annotListForPage.getNextValueAsString(true);
                        for (Object aRawObj : rawObj = decodePdf.getFormRenderer().getCompData().getRawForm(annotKey)) {
                            PdfObject aData;
                            FormObject annotObj;
                            int subtype;
                            if (aRawObj == null || (subtype = (annotObj = (FormObject)aRawObj).getParameterConstant(1147962727)) != 473513531) continue;
                            System.out.println("link object");
                            float[] coords = annotObj.getFloatArray(573911876);
                            System.out.println("PDF Rect= " + coords[0] + ' ' + coords[1] + ' ' + coords[2] + ' ' + coords[3]);
                            int pageH = decodePdf.getPdfPageData().getCropBoxHeight(ii);
                            float x = coords[0];
                            float w = coords[2] - coords[0];
                            float h = coords[3] - coords[1];
                            float y = (float)pageH - coords[1] - h;
                            System.out.println("Javaspace Rect x=" + x + " y=" + y + " w=" + w + " h=" + h);
                            if (this.includeImages) {
                                Graphics2D g2 = (Graphics2D)img.getGraphics();
                                g2.setPaint(Color.RED);
                                g2.drawRect((int)x, (int)y, (int)w, (int)h);
                            }
                            if ((aData = annotObj.getDictionary(17)) == null || aData.getNameAsConstant(35) != 2433561) continue;
                            String text = aData.getTextStreamValue(2433561);
                            System.out.println("text=" + text);
                        }
                    }
                }
                if (!this.includeImages) continue;
                ImageIO.write((RenderedImage)img, "PNG", new File("image-" + ii + ".png"));
            }
            decodePdf.closePdfFile();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        System.out.println("Simple demo to extract pdf file links if any");
        if (args.length != 1) {
            System.out.println("No filename given or  wrong number of values");
        } else {
            String file_name = args[0];
            System.out.println("File :" + file_name);
            File pdf_file = new File(file_name);
            if (!pdf_file.exists()) {
                System.out.println("File " + file_name + " not found");
            } else {
                new ShowLinks(file_name);
            }
        }
        System.exit(1);
    }
}

