/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples;

import java.io.File;
import org.jpedal.PdfDecoder;

public class PageCount {
    private String user_dir = System.getProperty("user.dir");
    private static String test_file = "/mnt/win_d/sample.pdf";

    public PageCount() {
    }

    public PageCount(String file_name) {
        String separator = System.getProperty("file.separator");
        if (!this.user_dir.endsWith(separator)) {
            this.user_dir = this.user_dir + separator;
        }
        try {
            PdfDecoder decode_pdf = new PdfDecoder(false);
            System.out.println("Opening file :" + file_name);
            decode_pdf.openPdfFile(file_name);
            System.out.println("Page count=" + decode_pdf.getPageCount());
            decode_pdf.closePdfFile();
        }
        catch (Exception e) {
            System.err.println("5.Exception " + e + " in pdf code");
        }
    }

    public static void main(String[] args) {
        System.out.println("Simple demo to extract number of pages");
        String file_name = test_file;
        if (args.length != 1) {
            System.out.println("Default test file used");
        } else {
            file_name = args[0];
            System.out.println("File :" + file_name);
        }
        File pdf_file = new File(file_name);
        if (!pdf_file.exists()) {
            System.out.println("File " + file_name + " not found");
        } else {
            new PageCount(file_name);
        }
    }
}

