/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.color;

import java.awt.color.ColorSpace;
import java.awt.color.ICC_ColorSpace;
import java.awt.color.ICC_Profile;
import java.awt.image.BufferedImage;
import java.awt.image.ColorConvertOp;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.IndexColorModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.io.ByteArrayInputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import org.jpedal.color.ColorSpaces;
import org.jpedal.color.GenericColorSpace;
import org.jpedal.color.PdfColor;
import org.jpedal.exception.PdfException;
import org.jpedal.io.ColorSpaceConvertor;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.utils.LogWriter;

public class ICCColorSpace
extends GenericColorSpace {
    private static final long serialVersionUID = 6146463234044553226L;
    private int[] a1;
    private int[] b1;
    private int[] c1;
    private Map cache = new HashMap();
    boolean isCached = false;

    @Override
    public void reset() {
        super.reset();
        this.isConverted = false;
        this.isCached = true;
    }

    public ICCColorSpace(PdfObject colorSpace) {
        this.a1 = new int[256];
        this.b1 = new int[256];
        this.c1 = new int[256];
        for (int i = 0; i < 256; ++i) {
            this.a1[i] = -1;
            this.b1[i] = -1;
            this.c1[i] = -1;
        }
        this.value = 1247168582;
        this.cs = ColorSpace.getInstance(1000);
        byte[] icc_data = colorSpace.getDecodedStream();
        if (icc_data == null) {
            if (LogWriter.isOutput()) {
                LogWriter.writeLog("Error in ICC data");
            }
        } else {
            try {
                this.cs = new ICC_ColorSpace(ICC_Profile.getInstance(icc_data));
            }
            catch (Exception e) {
                if (LogWriter.isOutput()) {
                    LogWriter.writeLog("[PDF] Problem " + e.getMessage() + " with ICC data ");
                }
                this.failed = true;
            }
        }
        this.componentCount = this.cs.getNumComponents();
    }

    @Override
    public final void setColor(String[] number_values, int items) {
        float[] colValues = new float[items];
        for (int ii = 0; ii < items; ++ii) {
            colValues[ii] = Float.parseFloat(number_values[ii]);
        }
        this.setColor(colValues, items);
    }

    @Override
    public final void setColor(float[] operand, int size) {
        float[] values = new float[size];
        int[] lookup = new int[size];
        this.rawValues = new float[size];
        for (int i = 0; i < size; ++i) {
            float val;
            this.rawValues[i] = val = operand[i];
            values[i] = val;
            lookup[i] = val > 1.0f ? (int)val : (int)(val * 255.0f);
        }
        if (size == 3 && this.a1[lookup[0]] != -1 && this.b1[lookup[1]] != -1 && this.c1[lookup[2]] != -1) {
            this.currentColor = new PdfColor(this.a1[lookup[0]], this.b1[lookup[1]], this.c1[lookup[2]]);
        } else if (size == 4 && this.cache.get((lookup[0] << 24) + (lookup[1] << 16) + (lookup[2] << 8) + lookup[3]) != null) {
            Object val = this.cache.get((lookup[0] << 24) + (lookup[1] << 16) + (lookup[2] << 8) + lookup[3]);
            int raw = (Integer)val;
            int r = raw >> 16 & 0xFF;
            int g = raw >> 8 & 0xFF;
            int b = raw & 0xFF;
            this.currentColor = new PdfColor(r, g, b);
        } else {
            try {
                values = this.cs.toRGB(values);
            }
            catch (Exception ee) {
                float[] newValues = new float[]{values[0], values[0], values[0]};
                values = newValues;
            }
            this.currentColor = new PdfColor(values[0], values[1], values[2]);
            if (size == 3) {
                this.a1[lookup[0]] = (int)(values[0] * 255.0f);
                this.b1[lookup[1]] = (int)(values[1] * 255.0f);
                this.c1[lookup[2]] = (int)(values[2] * 255.0f);
            } else if (size == 4) {
                int raw = ((int)(values[0] * 255.0f) << 16) + ((int)(values[1] * 255.0f) << 8) + (int)(values[2] * 255.0f);
                this.cache.put((lookup[0] << 24) + (lookup[1] << 16) + (lookup[2] << 8) + lookup[3], raw);
            }
        }
    }

    @Override
    public byte[] convertIndexToRGB(byte[] data) {
        this.isConverted = true;
        if (this.componentCount == 4) {
            return this.convert4Index(data);
        }
        return data;
    }

    @Override
    public BufferedImage JPEGToRGBImage(byte[] data, int w, int h, float[] decodeArray, int pX, int pY, boolean arrayInverted, PdfObject XObject2) {
        if (data.length > 9 && data[6] == 74 && data[7] == 70 && data[8] == 73 && data[9] == 70) {
            return this.nonRGBJPEGToRGBImage(data, w, h, null, pX, pY);
        }
        return this.algorithmicICCToRGB(data, w, h, false, pX, pY, decodeArray);
    }

    @Override
    public BufferedImage JPEG2000ToRGBImage(byte[] data, int w, int h, float[] decodeArray, int pX, int pY) throws PdfException {
        BufferedImage image;
        byte[] index = this.getIndexedMap();
        if (this.cs.getNumComponents() == 3 || index != null) {
            return super.JPEG2000ToRGBImage(data, w, h, decodeArray, pX, pY);
        }
        try {
            ByteArrayInputStream in = new ByteArrayInputStream(data);
            ImageReader iir = ImageIO.getImageReadersByFormatName("JPEG2000").next();
            ImageInputStream iin = ImageIO.createImageInputStream(in);
            iir.setInput(iin, true);
            if (index != null) {
                if (!this.isIndexConverted()) {
                    index = this.convertIndexToRGB(index);
                }
                RenderedImage renderimage = iir.readAsRenderedImage(0, iir.getDefaultReadParam());
                Raster ras = renderimage.getData();
                IndexColorModel cm = new IndexColorModel(8, index.length / 3, index, 0, false);
                image = new BufferedImage(cm, ras.createCompatibleWritableRaster(), false, null);
                image = ICCColorSpace.cleanupImage(image, pX, pY, image.getType());
            } else {
                WritableRaster rgbRaster;
                image = iir.read(0);
                Raster ras = image.getRaster();
                if (decodeArray != null) {
                    if (decodeArray.length == 6 && decodeArray[0] == 1.0f && decodeArray[1] == 0.0f && decodeArray[2] == 1.0f && decodeArray[3] == 0.0f && decodeArray[4] == 1.0f && decodeArray[5] == 0.0f || decodeArray.length > 2 && decodeArray[0] == 1.0f && decodeArray[1] == 0.0f) {
                        DataBuffer buf = ras.getDataBuffer();
                        int count = buf.getSize();
                        for (int ii = 0; ii < count; ++ii) {
                            buf.setElem(ii, 255 - buf.getElem(ii));
                        }
                    } else if (decodeArray.length == 6 && decodeArray[0] == 0.0f && decodeArray[1] == 1.0f && decodeArray[2] == 0.0f && decodeArray[3] == 1.0f && decodeArray[4] == 0.0f && decodeArray[5] == 1.0f || decodeArray == null || decodeArray.length > 0) {
                        // empty if block
                    }
                }
                ras = ICCColorSpace.cleanupRaster(ras, pX, pY, 4);
                w = ras.getWidth();
                h = ras.getHeight();
                if (image.getType() == 13) {
                    rgbRaster = ColorSpaceConvertor.createCompatibleWritableRaaster(image.getColorModel(), w, h);
                    CSToRGB = new ColorConvertOp(this.cs, image.getColorModel().getColorSpace(), ColorSpaces.hints);
                    image = new BufferedImage(w, h, image.getType());
                } else if (image.getType() != 10) {
                    if (CSToRGB == null) {
                        ICCColorSpace.initCMYKColorspace();
                    }
                    rgbRaster = ColorSpaceConvertor.createCompatibleWritableRaaster(rgbModel, w, h);
                    CSToRGB = new ColorConvertOp(this.cs, rgbCS, ColorSpaces.hints);
                    CSToRGB.filter(ras, rgbRaster);
                    image = new BufferedImage(w, h, 1);
                } else {
                    rgbRaster = null;
                }
                if (rgbRaster != null) {
                    image.setData(rgbRaster);
                }
            }
            iir.dispose();
            iin.close();
            in.close();
        }
        catch (Exception ee) {
            if (LogWriter.isOutput()) {
                LogWriter.writeLog("Problem reading JPEG 2000: " + ee);
            }
            ee.printStackTrace();
            throw new PdfException("Exception " + ee + " with JPEG2000 image - please ensure imageio.jar (see http://www.idrsolutions.com/additional-jars/) on classpath");
        }
        catch (Error ee2) {
            ee2.printStackTrace();
            if (LogWriter.isOutput()) {
                LogWriter.writeLog("Problem reading JPEG 2000 with error " + ee2);
            }
            throw new PdfException("Error with JPEG2000 image - please ensure imageio.jar (see http://www.idrsolutions.com/additional-jars/) on classpath");
        }
        return image;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BufferedImage algorithmicICCToRGB(byte[] data, int w, int h, boolean debug, int pX, int pY, float[] decodeArray) {
        BufferedImage image = null;
        ImageReader iir = null;
        ImageInputStream iin = null;
        ByteArrayInputStream in = new ByteArrayInputStream(data);
        try {
            ImageReader o;
            Iterator<ImageReader> iterator = ImageIO.getImageReadersByFormatName("JPEG");
            while (iterator.hasNext() && !(iir = (o = iterator.next())).canReadRaster()) {
            }
            ImageIO.setUseCache(false);
            iin = ImageIO.createImageInputStream(in);
            iir.setInput(iin, true);
            Raster ras = iir.readRaster(0, null);
            if (iir.getRawImageType(0) == null || this.alternative == -1) {
                BufferedImage bufferedImage = this.nonRGBJPEGToRGBImage(data, w, h, decodeArray, pX, pY);
                return bufferedImage;
            }
            ras = ICCColorSpace.cleanupRaster(ras, pX, pY, this.componentCount);
            w = ras.getWidth();
            h = ras.getHeight();
            byte[] new_data = new byte[w * h * 3];
            data = ((DataBufferByte)ras.getDataBuffer()).getData();
            int pixelCount = w * h * 3;
            float lastR = 0.0f;
            float lastG = 0.0f;
            float lastB = 0.0f;
            int pixelReached = 0;
            float lastIn1 = -1.0f;
            float lastIn2 = -1.0f;
            float lastIn3 = -1.0f;
            for (int i = 0; i < pixelCount; i += 3) {
                float in1 = (float)(data[i] & 0xFF) / 255.0f;
                float in2 = (float)(data[1 + i] & 0xFF) / 255.0f;
                float in3 = (float)(data[2 + i] & 0xFF) / 255.0f;
                if (lastIn1 != in1 || lastIn2 != in2 || lastIn3 != in3) {
                    if (debug) {
                        System.out.println(in1 + " " + in2 + ' ' + in3);
                    }
                    float[] inputValues = new float[]{in1, in2, in3};
                    float[] outputValues = this.cs.toRGB(inputValues);
                    lastR = outputValues[0] * 255.0f;
                    lastG = outputValues[1] * 255.0f;
                    lastB = outputValues[2] * 255.0f;
                    lastIn1 = in1;
                    lastIn2 = in2;
                    lastIn3 = in3;
                }
                new_data[pixelReached++] = (byte)lastR;
                new_data[pixelReached++] = (byte)lastG;
                new_data[pixelReached++] = (byte)lastB;
            }
            int[] bands = new int[]{0, 1, 2};
            DataBufferByte db = new DataBufferByte(new_data, new_data.length);
            image = new BufferedImage(w, h, 1);
            WritableRaster raster = Raster.createInterleavedRaster(db, w, h, w * 3, 3, bands, null);
            image.setData(raster);
        }
        catch (Exception e) {
            if (LogWriter.isOutput()) {
                LogWriter.writeLog("Problem with color conversion");
            }
        }
        finally {
            block21: {
                try {
                    in.close();
                    iir.dispose();
                    iin.close();
                }
                catch (Exception ee) {
                    if (!LogWriter.isOutput()) break block21;
                    LogWriter.writeLog("Problem closing  " + ee);
                }
            }
        }
        return image;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("ICCColorSpace [");
        if (this.a1 != null) {
            builder.append("a1=");
            builder.append(Arrays.toString(this.a1));
            builder.append(", ");
        }
        if (this.b1 != null) {
            builder.append("b1=");
            builder.append(Arrays.toString(this.b1));
            builder.append(", ");
        }
        if (this.c1 != null) {
            builder.append("c1=");
            builder.append(Arrays.toString(this.c1));
            builder.append(", ");
        }
        if (this.cache != null) {
            builder.append("cache=");
            builder.append(this.cache);
            builder.append(", ");
        }
        builder.append("isCached=");
        builder.append(this.isCached);
        builder.append("]");
        return builder.toString();
    }
}

