/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.color;

import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.io.ByteArrayInputStream;
import java.util.Iterator;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import org.jpedal.color.GenericColorSpace;
import org.jpedal.color.PdfColor;
import org.jpedal.objects.raw.MaskObject;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.utils.LogWriter;

public class DeviceGrayColorSpace
extends GenericColorSpace {
    private static final long serialVersionUID = -8160089076145994695L;

    public DeviceGrayColorSpace() {
        this.value = 1568372915;
        this.cs = ColorSpace.getInstance(1003);
    }

    @Override
    public final void setColor(String[] number_values, int opCount) {
        float[] colValues = new float[]{Float.parseFloat(number_values[0])};
        this.setColor(colValues, 1);
    }

    @Override
    public final void setColor(float[] operand, int length) {
        float tmp = operand[0];
        int val = tmp <= 1.0f ? (int)(255.0f * tmp) : (int)tmp;
        if (val < 0) {
            val = 0;
        }
        this.currentColor = new PdfColor(val, val, val);
    }

    @Override
    public byte[] convertIndexToRGB(byte[] index) {
        this.isConverted = true;
        int count = index.length;
        byte[] newIndex = new byte[count * 3];
        for (int i = 0; i < count; ++i) {
            byte value = index[i];
            for (int j = 0; j < 3; ++j) {
                newIndex[i * 3 + j] = value;
            }
        }
        return newIndex;
    }

    @Override
    public BufferedImage JPEGToRGBImage(byte[] data, int ww, int hh, float[] decodeArray, int pX, int pY, boolean arrayInverted, PdfObject XObject2) {
        BufferedImage image;
        block9: {
            ImageInputStream iin;
            ImageReader iir;
            ByteArrayInputStream in;
            block8: {
                if (XObject2 != null && XObject2 instanceof MaskObject) {
                    return super.JPEGToRGBImage(data, ww, hh, decodeArray, pX, pY, arrayInverted, XObject2);
                }
                in = null;
                iir = null;
                iin = null;
                try {
                    ImageReader o;
                    in = new ByteArrayInputStream(data);
                    Iterator<ImageReader> iterator = ImageIO.getImageReadersByFormatName("JPEG");
                    while (iterator.hasNext() && !(iir = (o = iterator.next())).canReadRaster()) {
                    }
                    ImageIO.setUseCache(false);
                    iin = ImageIO.createImageInputStream(in);
                    iir.setInput(iin, true);
                    Raster ras = iir.readRaster(0, null);
                    ras = DeviceGrayColorSpace.cleanupRaster(ras, pX, pY, 1);
                    int w = ras.getWidth();
                    int h = ras.getHeight();
                    DataBufferByte rgb = (DataBufferByte)ras.getDataBuffer();
                    byte[] rawData = rgb.getData();
                    int byteLength = rawData.length;
                    byte[] rgbData = new byte[byteLength * 3];
                    int ptr = 0;
                    for (int ii = 0; ii < byteLength; ++ii) {
                        if (arrayInverted) {
                            rawData[ii] = (byte)(rawData[ii] ^ 0xFF);
                        }
                        rgbData[ptr] = rawData[ii];
                        rgbData[++ptr] = rawData[ii];
                        rgbData[++ptr] = rawData[ii];
                        ++ptr;
                    }
                    int[] bands = new int[]{0, 1, 2};
                    image = new BufferedImage(w, h, 1);
                    WritableRaster raster = Raster.createInterleavedRaster(new DataBufferByte(rgbData, rgbData.length), w, h, w * 3, 3, bands, null);
                    image.setData(raster);
                }
                catch (Exception ee) {
                    image = null;
                    if (!LogWriter.isOutput()) break block8;
                    LogWriter.writeLog("Couldn't read JPEG, not even raster: " + ee);
                }
            }
            try {
                in.close();
                iir.dispose();
                iin.close();
            }
            catch (Exception ee) {
                if (!LogWriter.isOutput()) break block9;
                LogWriter.writeLog("Problem closing  " + ee);
            }
        }
        return image;
    }
}

