/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal;

import java.awt.Point;
import org.jpedal.PdfDecoder;
import org.jpedal.examples.viewer.gui.SwingGUI;
import org.jpedal.external.ExternalHandlers;

public class DisplayOffsets {
    private int userOffsetX = 0;
    private int userOffsetY = 0;
    private int userPrintOffsetX = 0;
    private int userPrintOffsetY = 0;
    private int facingCursorX = 10000;
    private int facingCursorY = 10000;

    public void setUserOffsets(int x, int y, int mode, ExternalHandlers externalHandlers, PdfDecoder pdfDecoder) {
        switch (mode) {
            case 0: {
                this.userOffsetX = x;
                this.userOffsetY = y;
                break;
            }
            case 1: {
                this.userPrintOffsetX = x;
                this.userPrintOffsetY = -y;
                break;
            }
            case 995: {
                this.facingCursorX = 0;
                this.facingCursorY = pdfDecoder.getHeight();
                SwingGUI gui1 = (SwingGUI)externalHandlers.getExternalHandler(11);
                if (gui1 != null) {
                    gui1.setDragCorner(mode);
                }
                pdfDecoder.repaint();
                break;
            }
            case 998: {
                this.facingCursorX = x;
                this.facingCursorY = y;
                SwingGUI gui2 = (SwingGUI)externalHandlers.getExternalHandler(11);
                if (gui2 != null) {
                    gui2.setDragCorner(mode);
                }
                pdfDecoder.repaint();
                break;
            }
            case 999: {
                this.facingCursorX = x;
                this.facingCursorY = y;
                SwingGUI gui3 = (SwingGUI)externalHandlers.getExternalHandler(11);
                if (gui3 != null) {
                    gui3.setDragCorner(mode);
                }
                pdfDecoder.repaint();
                break;
            }
            case 996: {
                this.facingCursorX = x;
                this.facingCursorY = y;
                SwingGUI gui4 = (SwingGUI)externalHandlers.getExternalHandler(11);
                if (gui4 != null) {
                    gui4.setDragCorner(mode);
                }
                pdfDecoder.repaint();
                break;
            }
            case 997: {
                this.facingCursorX = x;
                this.facingCursorY = y;
                SwingGUI gui5 = (SwingGUI)externalHandlers.getExternalHandler(11);
                if (gui5 != null) {
                    gui5.setDragCorner(mode);
                }
                pdfDecoder.repaint();
                break;
            }
            default: {
                throw new RuntimeException("No such mode - look in org.jpedal.external.OffsetOptions for valid values");
            }
        }
    }

    public Point getUserOffsets(int mode) {
        switch (mode) {
            case 0: {
                return new Point(this.userOffsetX, this.userOffsetY);
            }
            case 1: {
                return new Point(this.userPrintOffsetX, this.userPrintOffsetY);
            }
            case 999: {
                return new Point(this.facingCursorX, this.facingCursorY);
            }
        }
        throw new RuntimeException("No such mode - look in org.jpedal.external.OffsetOptions for valid values");
    }

    public int getUserPrintOffsetX() {
        return this.userPrintOffsetX;
    }

    public int getUserPrintOffsetY() {
        return this.userPrintOffsetY;
    }

    public int getUserOffsetX() {
        return this.userOffsetX;
    }

    public int getUserOffsetY() {
        return this.userOffsetY;
    }
}

