/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.pdf.color.shading;

import com.idrsolutions.pdf.color.shading.CoonsPatch;
import com.idrsolutions.pdf.color.shading.ShadingDatastreamReader;
import java.awt.Graphics2D;
import java.awt.PaintContext;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.Raster;
import java.util.ArrayList;
import org.jpedal.color.GenericColorSpace;
import org.jpedal.examples.handlers.DefaultImageHelper;
import org.jpedal.external.ImageHelper;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.utils.LogWriter;

public class PatchContext
implements PaintContext {
    private double scaling = 1.0;
    private ImageHelper images = new DefaultImageHelper();
    private ArrayList patches = new ArrayList();
    private int offX;
    private int offY;
    private int pHeight;
    private final int type;
    private final float[][] CTM;
    float[][] matrix;
    boolean debugSaveOut;
    private Rectangle deviceBounds;
    private Rectangle2D patternBounds;
    private final boolean isFromSH;

    public PatchContext(PdfObject shadingObj, float[] domain, float[][] CTM, GenericColorSpace shadingColorSpace, float[][] matrix, int type) {
        this.CTM = CTM;
        this.matrix = matrix;
        this.type = type;
        this.isFromSH = CTM == matrix;
        int BitsPerComponent = shadingObj.getInt(-1344207655);
        int BitsPerFlag = shadingObj.getInt(1500422077);
        int BitsPerCoordinate = shadingObj.getInt(-335950113);
        int compCount = shadingColorSpace.getColorComponentCount();
        byte[] bytes = shadingObj.getDecodedStream();
        ShadingDatastreamReader c = new ShadingDatastreamReader(bytes, BitsPerCoordinate, BitsPerComponent, compCount, BitsPerFlag, shadingColorSpace, type);
        this.patches = c.getPatches();
    }

    @Override
    public void dispose() {
    }

    public void setValues(int pHeight, float scaling, int offX, int offY) {
        this.offX = offX;
        this.offY = offY;
        this.pHeight = pHeight;
        this.scaling = scaling;
    }

    @Override
    public ColorModel getColorModel() {
        return ColorModel.getRGBdefault();
    }

    @Override
    public Raster getRaster(int xstart, int ystart, int w, int h) {
        BufferedImage result;
        block18: {
            double dy;
            double dx;
            double dh;
            double dw;
            GeneralPath bounds;
            if (this.pHeight == 0) {
                BufferedImage result2 = new BufferedImage(w, h, 2);
                return result2.getData();
            }
            if (this.isFromSH) {
                Rectangle2D patternRect = this.getPatternBounds();
                if (patternRect == null) {
                    return new BufferedImage(w, h, 2).getData();
                }
                bounds = new GeneralPath(patternRect);
                dw = (double)this.deviceBounds.width / bounds.getBounds2D().getWidth();
                dh = (double)this.deviceBounds.height / bounds.getBounds2D().getHeight();
                dx = -(bounds.getBounds2D().getX() * dw + ((double)xstart - this.deviceBounds.getX()));
                dy = -(bounds.getBounds2D().getY() * dh + ((double)ystart - this.deviceBounds.getY()));
            } else {
                boolean flip = false;
                if (this.CTM[0][0] == 1.0f && this.CTM[1][1] == 1.0f) {
                    dx = this.matrix[2][0];
                    dy = this.matrix[2][1];
                    dw = this.matrix[0][0];
                    dh = -this.matrix[1][1];
                } else {
                    dx = this.CTM[2][0];
                    dy = this.CTM[2][1];
                    dw = this.CTM[0][0];
                    dh = -this.CTM[1][1];
                    if (dh < 0.0) {
                        flip = true;
                    }
                }
                if (Math.abs(dh) < 1.0) {
                    dh *= 255.0;
                }
                if (Math.abs(dw) < 1.0) {
                    dw *= 255.0;
                }
                if (this.type == 7) {
                    if (this.CTM[0][0] != 1.0f) {
                        dw = 1.1 * (double)this.matrix[0][0] / (double)this.CTM[0][0];
                        dh = 1.1 * (double)this.matrix[1][1] / (double)this.CTM[1][1];
                    } else {
                        dx /= 2.0;
                        dy /= 2.0;
                        dw = (double)this.matrix[0][0] * 1.05;
                        dh = (double)this.matrix[1][1] * 1.05;
                    }
                }
                if (flip) {
                    dy -= dh;
                    dh = -dh;
                }
                dy = (double)this.pHeight - dy / this.scaling;
                float shadeCoordsLeft = (float)(((double)(xstart -= this.offX) - (dx /= this.scaling)) / (dw /= this.scaling));
                float shadeCoordsTop = (float)(((double)(ystart -= this.offY) - dy) / (dh /= this.scaling));
                float shadeCoordsRight = (float)((double)shadeCoordsLeft + (double)w / dw);
                float shadeCoordsBottom = (float)((double)shadeCoordsTop + (double)h / dh);
                bounds = new GeneralPath();
                bounds.moveTo(shadeCoordsLeft, shadeCoordsTop);
                bounds.lineTo(shadeCoordsRight, shadeCoordsTop);
                bounds.lineTo(shadeCoordsRight, shadeCoordsBottom);
                bounds.lineTo(shadeCoordsLeft, shadeCoordsBottom);
                bounds.lineTo(shadeCoordsLeft, shadeCoordsTop);
                dx -= (double)xstart;
                dy -= (double)ystart;
            }
            result = new BufferedImage(w, h, 2);
            Graphics2D g2 = (Graphics2D)result.getGraphics();
            AffineTransform trans = new AffineTransform();
            trans.translate(dx, dy);
            trans.scale(dw, dh);
            g2.setTransform(trans);
            boolean drawBack = this.patches.size() != 1;
            for (Object patche1 : this.patches) {
                CoonsPatch p = (CoonsPatch)patche1;
                if (!p.getBounds2D().intersects(bounds.getBounds2D())) continue;
                p.printOntoG2(g2, bounds.getBounds2D(), drawBack);
            }
            if (this.debugSaveOut) {
                BufferedImage out = new BufferedImage(500, 500, 2);
                Graphics2D og2 = (Graphics2D)out.getGraphics();
                AffineTransform otrans = new AffineTransform();
                otrans.scale(500.0, 500.0);
                og2.setTransform(otrans);
                for (Object patche : this.patches) {
                    CoonsPatch p = (CoonsPatch)patche;
                    p.printOntoG2(og2, bounds.getBounds2D(), drawBack);
                }
                try {
                    this.images.write(out, "png", "C:/users/sam/desktop/new/" + this + ".png");
                }
                catch (Exception e) {
                    if (!LogWriter.isOutput()) break block18;
                    LogWriter.writeLog("Exception: " + e.getMessage());
                }
            }
        }
        return result.getData();
    }

    public void setRect(Rectangle db) {
        this.deviceBounds = db;
    }

    private Rectangle2D getPatternBounds() {
        if (this.patternBounds != null) {
            return this.patternBounds;
        }
        if (this.patches.size() < 1) {
            return null;
        }
        CoonsPatch firstPatch = (CoonsPatch)this.patches.get(0);
        Rectangle2D firstRect = firstPatch.getBounds2D();
        double minX = firstRect.getMinX();
        double minY = firstRect.getMinY();
        double maxX = firstRect.getMaxX();
        double maxY = firstRect.getMaxY();
        for (int i = 1; i < this.patches.size(); ++i) {
            CoonsPatch p = (CoonsPatch)this.patches.get(i);
            Rectangle2D pRect = p.getBounds2D();
            if (pRect.getMinX() < minX) {
                minX = pRect.getMinX();
            }
            if (pRect.getMinY() < minY) {
                minY = pRect.getMinY();
            }
            if (pRect.getMaxX() > maxX) {
                maxX = pRect.getMaxX();
            }
            if (!(pRect.getMaxY() > maxY)) continue;
            maxY = pRect.getMaxY();
        }
        GeneralPath bounds = new GeneralPath();
        bounds.moveTo(minX, minY);
        bounds.lineTo(maxX, minY);
        bounds.lineTo(maxX, maxY);
        bounds.lineTo(minX, maxY);
        this.patternBounds = bounds.getBounds2D();
        return bounds.getBounds2D();
    }
}

