/*
 * Decompiled with CFR 0.152.
 */
package com.kvn.mockj.reflection;

import com.kvn.mockj.reflection.TypeReference;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import org.apache.commons.lang3.RandomStringUtils;
import sun.reflect.generics.reflectiveObjects.ParameterizedTypeImpl;

public class MockR {
    private static final RandomStringUtils STRING_RANDOM = new RandomStringUtils();
    private static final Random RANDOM = new Random();

    public static <T> T random(TypeReference<T> typeReference) {
        Class targetClass = (Class)typeReference.getType();
        if (Collection.class.isAssignableFrom(targetClass)) {
            if (typeReference.getArgTypes() == null) {
                throw new IllegalArgumentException("\u53c2\u6570\u9519\u8bef\uff1aCollection \u7c7b\u578b\u5fc5\u987b\u5e26\u4e0a\u6cdb\u578b\u53c2\u6570");
            }
            return (T)MockR.randomCollection((ParameterizedTypeImpl)typeReference.getType());
        }
        if (targetClass.isArray()) {
            return (T)MockR.randomArray(targetClass);
        }
        if (Map.class.isAssignableFrom(targetClass)) {
            return (T)MockR.randomMap(typeReference.getArgTypes()[0], typeReference.getArgTypes()[1]);
        }
        if (typeReference.getArgTypes() == null) {
            return (T)MockR.randomObject(targetClass, 2);
        }
        return (T)MockR.randomObject(targetClass, 2);
    }

    private static Object randomMap(Type keyType, Type valueType) {
        Class keyClass = (Class)keyType;
        Class valueClass = (Class)valueType;
        if (!MockR.isSupportRandomMap(keyClass) || !MockR.isSupportRandomMap(valueClass)) {
            return null;
        }
        Object key = MockR.randomObject(keyClass, 2);
        Object value = MockR.randomObject(valueClass, 2);
        HashMap<Object, Object> map = new HashMap<Object, Object>();
        map.put(key, value);
        return map;
    }

    private static boolean isSupportRandomMap(Class clazz) {
        if (Collection.class.isAssignableFrom(clazz)) {
            return false;
        }
        if (clazz.isArray()) {
            return false;
        }
        if (Map.class.isAssignableFrom(clazz)) {
            return false;
        }
        if (clazz.isInterface()) {
            return false;
        }
        return !Map.class.isAssignableFrom(clazz);
    }

    private static Object randomArray(Class targetClass) {
        Object array = Array.newInstance(targetClass.getComponentType(), 1);
        Array.set(array, 0, MockR.randomObject(targetClass.getComponentType(), 2));
        return array;
    }

    private static Object randomCollection(ParameterizedTypeImpl targetType) {
        Type rawType = targetType.getRawType();
        Type argType = targetType.getActualTypeArguments()[0];
        Class targetClass = (Class)rawType;
        AbstractCollection instance = null;
        if (targetClass.isInterface()) {
            if (List.class == targetClass) {
                instance = new ArrayList();
            } else if (Set.class == targetClass) {
                instance = new HashSet();
            }
        } else {
            try {
                instance = (ArrayList)targetClass.newInstance();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (instance == null) {
            return null;
        }
        Object obj = MockR.randomObject((Class)argType, 2);
        instance.add(obj);
        return instance;
    }

    private static Object randomObject(Class targetClass, int cascadeLayers) {
        Method[] methods;
        if (MockR.isPrimitiveOrWrapClass(targetClass)) {
            return MockR.randomInstancePrimitiveClass(targetClass);
        }
        if (targetClass == String.class) {
            return RandomStringUtils.randomAlphabetic((int)4);
        }
        if (targetClass == BigDecimal.class) {
            return new BigDecimal(RANDOM.nextFloat());
        }
        if (targetClass == Date.class) {
            return new Date();
        }
        if (targetClass == Timestamp.class) {
            return new Timestamp(System.currentTimeMillis());
        }
        if (targetClass.isEnum()) {
            return targetClass.getEnumConstants()[0];
        }
        if (targetClass.isInterface()) {
            return null;
        }
        Object instance = null;
        try {
            instance = targetClass.newInstance();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        if (cascadeLayers <= 0) {
            return null;
        }
        for (Method m : methods = targetClass.getMethods()) {
            ParameterizedTypeImpl pt;
            ParameterizedTypeImpl type;
            if (!m.getName().startsWith("set") || m.getParameterTypes().length != 1) continue;
            Class<?> fieldClass = m.getParameterTypes()[0];
            Object fieldValue = null;
            fieldValue = Collection.class.isAssignableFrom(fieldClass) ? ((type = MockR.findGenericType(targetClass, m)) == null ? null : MockR.randomCollection(type)) : (fieldClass.isArray() ? MockR.randomArray(fieldClass) : (Map.class.isAssignableFrom(fieldClass) ? ((pt = MockR.findGenericType(targetClass, m)) == null ? null : MockR.randomMap(pt.getActualTypeArguments()[0], pt.getActualTypeArguments()[1])) : MockR.randomObject(fieldClass, cascadeLayers - 1)));
            try {
                m.invoke(instance, fieldValue);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return instance;
    }

    private static ParameterizedTypeImpl findGenericType(Class targetClass, Method setter) {
        Class<?> fieldClass = setter.getParameterTypes()[0];
        String getMethodName = fieldClass == Boolean.TYPE ? "is" + setter.getName().substring(3) : "g" + setter.getName().substring(1);
        Method getMethod = null;
        try {
            getMethod = targetClass.getDeclaredMethod(getMethodName, new Class[0]);
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
            System.out.println("\u5c5e\u6027[" + targetClass.getSimpleName() + "#" + fieldClass.getName() + "]\u4e0d\u5b58\u5728 getter \u65b9\u6cd5");
            return null;
        }
        ParameterizedType pt = (ParameterizedType)getMethod.getGenericReturnType();
        return pt instanceof ParameterizedTypeImpl ? (ParameterizedTypeImpl)pt : null;
    }

    private static <T> T randomInstancePrimitiveClass(Class<T> clazz) {
        String className;
        int numberLength = 100000;
        switch (className = clazz.getName()) {
            case "java.lang.Boolean": 
            case "boolean": {
                return (T)Boolean.valueOf(RANDOM.nextBoolean());
            }
            case "java.lang.Character": 
            case "char": {
                return (T)Character.valueOf((char)(RANDOM.nextInt() % 128));
            }
            case "java.lang.Byte": 
            case "byte": {
                return (T)Byte.valueOf((byte)(RANDOM.nextInt() % 128));
            }
            case "java.lang.Short": 
            case "short": {
                return (T)Short.valueOf((short)(RANDOM.nextInt() % Short.MAX_VALUE));
            }
            case "java.lang.Integer": 
            case "int": {
                return (T)Integer.valueOf(RANDOM.nextInt() % numberLength);
            }
            case "java.lang.Long": 
            case "long": {
                return (T)Long.valueOf(RANDOM.nextInt() % numberLength);
            }
            case "java.lang.Float": 
            case "float": {
                return (T)Float.valueOf(RANDOM.nextInt() % numberLength);
            }
            case "java.lang.Double": 
            case "double": {
                return (T)Double.valueOf(RANDOM.nextInt() % numberLength);
            }
        }
        throw new RuntimeException(className + "\u4e0d\u652f\u6301\uff0cbug");
    }

    private static boolean isPrimitiveOrWrapClass(Class clz) {
        if (clz.isPrimitive()) {
            return true;
        }
        return MockR.isWrapClass(clz);
    }

    private static boolean isWrapClass(Class clz) {
        try {
            return ((Class)clz.getField("TYPE").get(null)).isPrimitive();
        }
        catch (Exception e) {
            return false;
        }
    }
}

