/*
 * Decompiled with CFR 0.152.
 */
package com.kenmeidearu.materialdatetimepicker.date;

import android.animation.ObjectAnimator;
import android.app.Activity;
import android.app.Dialog;
import android.app.DialogFragment;
import android.content.Context;
import android.content.DialogInterface;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.graphics.Color;
import android.os.Bundle;
import android.os.Parcelable;
import android.support.annotation.ColorInt;
import android.support.annotation.NonNull;
import android.support.annotation.StringRes;
import android.support.v4.content.ContextCompat;
import android.text.format.DateUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.AlphaAnimation;
import android.view.animation.Animation;
import android.widget.Button;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.kenmeidearu.materialdatetimepicker.HapticFeedbackController;
import com.kenmeidearu.materialdatetimepicker.R;
import com.kenmeidearu.materialdatetimepicker.TypefaceHelper;
import com.kenmeidearu.materialdatetimepicker.Utils;
import com.kenmeidearu.materialdatetimepicker.date.AccessibleDateAnimator;
import com.kenmeidearu.materialdatetimepicker.date.DatePickerController;
import com.kenmeidearu.materialdatetimepicker.date.DayPickerView;
import com.kenmeidearu.materialdatetimepicker.date.MonthAdapter;
import com.kenmeidearu.materialdatetimepicker.date.MonthPickerView;
import com.kenmeidearu.materialdatetimepicker.date.SimpleDayPickerView;
import com.kenmeidearu.materialdatetimepicker.date.TimePickerView;
import com.kenmeidearu.materialdatetimepicker.date.Timepoint;
import com.kenmeidearu.materialdatetimepicker.date.YearPickerView;
import java.io.Serializable;
import java.text.DateFormatSymbols;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashSet;
import java.util.Locale;

public class DatePickerDialog
extends DialogFragment
implements View.OnClickListener,
DatePickerController {
    private static final int UNINITIALIZED = -1;
    private static final int MONTH_AND_DAY_VIEW = 0;
    private static final int YEAR_VIEW = 1;
    private static final int MONTH_VIEW = 2;
    private static final String KEY_INITIAL_TIME = "initial_time";
    private static final String KEY_IS_24_HOUR_VIEW = "is_24_hour_view";
    private static final String KEY_ENABLE_SECONDS = "enable_seconds";
    private static final String KEY_ENABLE_MINUTES = "enable_minutes";
    private static final String KEY_SELECTED_YEAR = "year";
    private static final String KEY_SELECTED_MONTH = "month";
    private static final String KEY_SELECTED_DAY = "day";
    private static final String KEY_SELECTABLE_HOUR = "hour";
    private static final String KEY_LIST_POSITION = "list_position";
    private static final String KEY_WEEK_START = "week_start";
    private static final String KEY_YEAR_START = "year_start";
    private static final String KEY_YEAR_END = "year_end";
    private static final String KEY_CURRENT_VIEW = "current_view";
    private static final String KEY_LIST_POSITION_OFFSET = "list_position_offset";
    private static final String KEY_MIN_DATE = "min_date";
    private static final String KEY_MAX_DATE = "max_date";
    private static final String KEY_HIGHLIGHTED_DAYS = "highlighted_days";
    private static final String KEY_SELECTABLE_DAYS = "selectable_days";
    private static final String KEY_DISABLED_DAYS = "disabled_days";
    private static final String KEY_THEME_DARK = "theme_dark";
    private static final String KEY_THEME_DARK_CHANGED = "theme_dark_changed";
    private static final String KEY_ACCENT = "accent";
    private static final String KEY_VIBRATE = "vibrate";
    private static final String KEY_DISMISS = "dismiss";
    private static final String KEY_AUTO_DISMISS = "auto_dismiss";
    private static final String KEY_DEFAULT_VIEW = "default_view";
    private static final String KEY_TITLE = "title";
    private static final String KEY_OK_RESID = "ok_resid";
    private static final String KEY_OK_STRING = "ok_string";
    private static final String KEY_CANCEL_RESID = "cancel_resid";
    private static final String KEY_CANCEL_STRING = "cancel_string";
    private static final int DEFAULT_START_YEAR = 1900;
    private static final int DEFAULT_END_YEAR = 2100;
    private static final int ANIMATION_DURATION = 300;
    private static final int ANIMATION_DELAY = 500;
    private static SimpleDateFormat YEAR_FORMAT = new SimpleDateFormat("yyyy", Locale.getDefault());
    private static SimpleDateFormat MONTH_FORMAT = new SimpleDateFormat("MMM", Locale.getDefault());
    private static SimpleDateFormat DAY_FORMAT = new SimpleDateFormat("dd", Locale.getDefault());
    private final Calendar mCalendar = this.trimToMidnight(Calendar.getInstance());
    private OnDateSetListener mCallBack;
    private HashSet<OnDateChangedListener> mListeners = new HashSet();
    private DialogInterface.OnCancelListener mOnCancelListener;
    private DialogInterface.OnDismissListener mOnDismissListener;
    private AccessibleDateAnimator mAnimator;
    private TextView mDayOfWeekView;
    private String mDoublePlaceholderText;
    private LinearLayout mMonthAndDayView;
    private RelativeLayout timeDisplayView;
    private TextView mSelectedMonthTextView;
    private TextView mSelectedDayTextView;
    private TextView mYearView;
    private DayPickerView mDayPickerView;
    private YearPickerView mYearPickerView;
    private MonthPickerView mMonthPickerView;
    private TimePickerView mHourPickerView;
    private TimePickerView mMinutePickerView;
    private TimePickerView mSecondPickerView;
    private int mCurrentView = -1;
    private int mWeekStart = this.mCalendar.getFirstDayOfWeek();
    private int mMinYear = 1900;
    private int mMaxYear = 2100;
    private String mTitle;
    private Calendar mMinDate;
    private Calendar mMaxDate;
    private Calendar[] highlightedDays;
    private Calendar[] selectableDays;
    private Calendar[] disabledDays;
    private boolean mThemeDark = false;
    private boolean mThemeDarkChanged = false;
    private int mAccentColor = -1;
    private boolean mVibrate = true;
    private boolean mDismissOnPause = false;
    private boolean mAutoDismiss = false;
    private int mDefaultView = 0;
    private int mOkResid = R.string.mdtp_ok;
    private String mOkString;
    private int mCancelResid = R.string.mdtp_cancel;
    private String mCancelString;
    private HapticFeedbackController mHapticFeedbackController;
    private boolean mDelayAnimation = true;
    private String mDayPickerDescription;
    private String mSelectDay;
    private String mMonthPickerDescription;
    private String mSelectMonth;
    private String mYearPickerDescription;
    private String mSelectYear;
    private Timepoint mCurrentTime;
    public static final int HOUR_INDEX = 3;
    public static final int MINUTE_INDEX = 4;
    public static final int SECOND_INDEX = 5;
    public static final int AM = 6;
    public static final int PM = 7;
    private TextView mHourView;
    private TextView mHourSpaceView;
    private TextView mMinuteView;
    private TextView mMinuteSpaceView;
    private TextView mSecondView;
    private TextView mSecondSpaceView;
    private TextView mAmPmTextView;
    private View mAmPmHitspace;
    private String mAmText;
    private String mPmText;
    private Timepoint mInitialTime;
    private boolean mIs24HourMode;
    private boolean mEnableSeconds;
    private boolean mEnableMinutes;
    private boolean mOnlyDate;
    private String mHourPickerDescription;
    private String mSelectHours;
    private String mMinutePickerDescription;
    private String mSelectMinutes;
    private String mSecondPickerDescription;
    private String mSelectSeconds;

    public static DatePickerDialog newInstance(OnDateSetListener callBack, int year, int monthOfYear, int dayOfMonth, int hourOfDay, int minute, boolean is24HourMode) {
        DatePickerDialog ret = new DatePickerDialog();
        ret.initialize(callBack, year, monthOfYear, dayOfMonth, hourOfDay, minute, 0, is24HourMode);
        return ret;
    }

    public void initialize(OnDateSetListener callBack, int year, int monthOfYear, int dayOfMonth, int hourOfDay, int minute, int second, boolean is24HourMode) {
        this.mCallBack = callBack;
        this.mCalendar.set(1, year);
        this.mCalendar.set(2, monthOfYear);
        this.mCalendar.set(5, dayOfMonth);
        this.mInitialTime = new Timepoint(hourOfDay, minute, second);
        this.mIs24HourMode = is24HourMode;
    }

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        Activity activity = this.getActivity();
        activity.getWindow().setSoftInputMode(3);
        this.mCurrentView = -1;
        if (savedInstanceState != null && savedInstanceState.containsKey(KEY_INITIAL_TIME) && savedInstanceState.containsKey(KEY_IS_24_HOUR_VIEW)) {
            this.mCalendar.set(1, savedInstanceState.getInt(KEY_SELECTED_YEAR));
            this.mCalendar.set(2, savedInstanceState.getInt(KEY_SELECTED_MONTH));
            this.mCalendar.set(5, savedInstanceState.getInt(KEY_SELECTED_DAY));
            this.mDefaultView = savedInstanceState.getInt(KEY_DEFAULT_VIEW);
            this.mInitialTime = (Timepoint)savedInstanceState.getParcelable(KEY_INITIAL_TIME);
            this.mIs24HourMode = savedInstanceState.getBoolean(KEY_IS_24_HOUR_VIEW);
            this.mEnableSeconds = savedInstanceState.getBoolean(KEY_ENABLE_SECONDS);
            this.mEnableMinutes = savedInstanceState.getBoolean(KEY_ENABLE_MINUTES);
        }
    }

    public void onSaveInstanceState(@NonNull Bundle outState) {
        super.onSaveInstanceState(outState);
        outState.putInt(KEY_SELECTED_YEAR, this.mCalendar.get(1));
        outState.putInt(KEY_SELECTED_MONTH, this.mCalendar.get(2));
        outState.putInt(KEY_SELECTED_DAY, this.mCalendar.get(5));
        outState.putInt(KEY_SELECTABLE_HOUR, this.mCalendar.get(11));
        outState.putInt(KEY_WEEK_START, this.mWeekStart);
        outState.putInt(KEY_YEAR_START, this.mMinYear);
        outState.putInt(KEY_YEAR_END, this.mMaxYear);
        outState.putInt(KEY_CURRENT_VIEW, this.mCurrentView);
        int listPosition = -1;
        if (this.mCurrentView == 0) {
            listPosition = this.mDayPickerView.getMostVisiblePosition();
        } else if (this.mCurrentView == 2) {
            listPosition = this.mMonthPickerView.getFirstVisiblePosition();
            outState.putInt(KEY_LIST_POSITION_OFFSET, this.mMonthPickerView.getFirstPositionOffset());
        } else if (this.mCurrentView == 1) {
            listPosition = this.mYearPickerView.getFirstVisiblePosition();
            outState.putInt(KEY_LIST_POSITION_OFFSET, this.mYearPickerView.getFirstPositionOffset());
        } else if (this.mCurrentView == 3) {
            listPosition = this.mHourPickerView.getFirstVisiblePosition();
            outState.putInt(KEY_LIST_POSITION_OFFSET, this.mHourPickerView.getFirstPositionOffset());
        } else if (this.mCurrentView == 4) {
            listPosition = this.mMinutePickerView.getFirstVisiblePosition();
            outState.putInt(KEY_LIST_POSITION_OFFSET, this.mMinutePickerView.getFirstPositionOffset());
        } else if (this.mCurrentView == 5) {
            listPosition = this.mSecondPickerView.getFirstVisiblePosition();
            outState.putInt(KEY_LIST_POSITION_OFFSET, this.mSecondPickerView.getFirstPositionOffset());
        }
        outState.putInt(KEY_LIST_POSITION, listPosition);
        outState.putSerializable(KEY_MIN_DATE, (Serializable)this.mMinDate);
        outState.putSerializable(KEY_MAX_DATE, (Serializable)this.mMaxDate);
        outState.putSerializable(KEY_HIGHLIGHTED_DAYS, (Serializable)this.highlightedDays);
        outState.putSerializable(KEY_SELECTABLE_DAYS, (Serializable)this.selectableDays);
        outState.putSerializable(KEY_DISABLED_DAYS, (Serializable)this.disabledDays);
        outState.putBoolean(KEY_THEME_DARK, this.mThemeDark);
        outState.putBoolean(KEY_THEME_DARK_CHANGED, this.mThemeDarkChanged);
        outState.putInt(KEY_ACCENT, this.mAccentColor);
        outState.putBoolean(KEY_VIBRATE, this.mVibrate);
        outState.putBoolean(KEY_DISMISS, this.mDismissOnPause);
        outState.putBoolean(KEY_AUTO_DISMISS, this.mAutoDismiss);
        outState.putInt(KEY_DEFAULT_VIEW, this.mDefaultView);
        outState.putString(KEY_TITLE, this.mTitle);
        outState.putInt(KEY_OK_RESID, this.mOkResid);
        outState.putString(KEY_OK_STRING, this.mOkString);
        outState.putInt(KEY_CANCEL_RESID, this.mCancelResid);
        outState.putString(KEY_CANCEL_STRING, this.mCancelString);
        outState.putBoolean(KEY_IS_24_HOUR_VIEW, this.mIs24HourMode);
        outState.putParcelable(KEY_INITIAL_TIME, (Parcelable)this.mInitialTime);
        outState.putBoolean(KEY_ENABLE_SECONDS, this.mEnableSeconds);
        outState.putBoolean(KEY_ENABLE_MINUTES, this.mEnableMinutes);
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        this.setToNearestDate(this.mCalendar);
        View view = inflater.inflate(R.layout.mdtp_date_picker_dialog, container, false);
        this.timeDisplayView = (RelativeLayout)view.findViewById(R.id.time_display);
        this.mDayOfWeekView = (TextView)view.findViewById(R.id.date_picker_header);
        this.mMonthAndDayView = (LinearLayout)view.findViewById(R.id.date_picker_month_and_year);
        this.mSelectedMonthTextView = (TextView)view.findViewById(R.id.date_picker_month);
        this.mSelectedMonthTextView.setOnClickListener((View.OnClickListener)this);
        this.mSelectedDayTextView = (TextView)view.findViewById(R.id.date_picker_day);
        this.mSelectedDayTextView.setOnClickListener((View.OnClickListener)this);
        this.mYearView = (TextView)view.findViewById(R.id.date_picker_year);
        this.mYearView.setOnClickListener((View.OnClickListener)this);
        int listPosition = -1;
        int listPositionOffset = 0;
        int currentView = this.mDefaultView;
        if (savedInstanceState != null) {
            this.mWeekStart = savedInstanceState.getInt(KEY_WEEK_START);
            this.mMinYear = savedInstanceState.getInt(KEY_YEAR_START);
            this.mMaxYear = savedInstanceState.getInt(KEY_YEAR_END);
            currentView = savedInstanceState.getInt(KEY_CURRENT_VIEW);
            listPosition = savedInstanceState.getInt(KEY_LIST_POSITION);
            listPositionOffset = savedInstanceState.getInt(KEY_LIST_POSITION_OFFSET);
            this.mMinDate = (Calendar)savedInstanceState.getSerializable(KEY_MIN_DATE);
            this.mMaxDate = (Calendar)savedInstanceState.getSerializable(KEY_MAX_DATE);
            this.highlightedDays = (Calendar[])savedInstanceState.getSerializable(KEY_HIGHLIGHTED_DAYS);
            this.selectableDays = (Calendar[])savedInstanceState.getSerializable(KEY_SELECTABLE_DAYS);
            this.disabledDays = (Calendar[])savedInstanceState.getSerializable(KEY_DISABLED_DAYS);
            this.mThemeDark = savedInstanceState.getBoolean(KEY_THEME_DARK);
            this.mThemeDarkChanged = savedInstanceState.getBoolean(KEY_THEME_DARK_CHANGED);
            this.mAccentColor = savedInstanceState.getInt(KEY_ACCENT);
            this.mVibrate = savedInstanceState.getBoolean(KEY_VIBRATE);
            this.mDismissOnPause = savedInstanceState.getBoolean(KEY_DISMISS);
            this.mAutoDismiss = savedInstanceState.getBoolean(KEY_AUTO_DISMISS);
            this.mTitle = savedInstanceState.getString(KEY_TITLE);
            this.mOkResid = savedInstanceState.getInt(KEY_OK_RESID);
            this.mOkString = savedInstanceState.getString(KEY_OK_STRING);
            this.mCancelResid = savedInstanceState.getInt(KEY_CANCEL_RESID);
            this.mCancelString = savedInstanceState.getString(KEY_CANCEL_STRING);
        }
        Activity activity = this.getActivity();
        this.mDayPickerView = new SimpleDayPickerView((Context)activity, this);
        this.mYearPickerView = new YearPickerView((Context)activity, this);
        this.mMonthPickerView = new MonthPickerView((Context)activity, this);
        this.mHourPickerView = new TimePickerView((Context)activity, this, "HOUR", this.mIs24HourMode);
        this.mMinutePickerView = new TimePickerView((Context)activity, this, "MINUTE", this.mIs24HourMode);
        this.mSecondPickerView = new TimePickerView((Context)activity, this, "SECOND", this.mIs24HourMode);
        if (!this.mThemeDarkChanged) {
            this.mThemeDark = Utils.isDarkTheme((Context)activity, this.mThemeDark);
        }
        Resources res = this.getResources();
        this.mDayPickerDescription = res.getString(R.string.mdtp_day_picker_description);
        this.mSelectDay = res.getString(R.string.mdtp_select_day);
        this.mMonthPickerDescription = res.getString(R.string.mdtp_month_picker_description);
        this.mSelectMonth = res.getString(R.string.mdtp_select_month);
        this.mYearPickerDescription = res.getString(R.string.mdtp_year_picker_description);
        this.mSelectYear = res.getString(R.string.mdtp_select_year);
        this.mHourPickerDescription = res.getString(R.string.mdtp_hour_picker_description);
        this.mSelectHours = res.getString(R.string.mdtp_select_hours);
        this.mMinutePickerDescription = res.getString(R.string.mdtp_minute_picker_description);
        this.mSelectMinutes = res.getString(R.string.mdtp_select_minutes);
        this.mSecondPickerDescription = res.getString(R.string.mdtp_second_picker_description);
        this.mSelectSeconds = res.getString(R.string.mdtp_select_seconds);
        this.mHourView = (TextView)view.findViewById(R.id.hours);
        this.mHourView.setOnClickListener((View.OnClickListener)this);
        this.mHourSpaceView = (TextView)view.findViewById(R.id.hour_space);
        this.mMinuteSpaceView = (TextView)view.findViewById(R.id.minutes_space);
        this.mMinuteView = (TextView)view.findViewById(R.id.minutes);
        this.mMinuteView.setOnClickListener((View.OnClickListener)this);
        this.mSecondSpaceView = (TextView)view.findViewById(R.id.seconds_space);
        this.mSecondView = (TextView)view.findViewById(R.id.seconds);
        this.mSecondView.setOnClickListener((View.OnClickListener)this);
        this.mAmPmTextView = (TextView)view.findViewById(R.id.ampm_label);
        this.mAmPmTextView.setOnClickListener((View.OnClickListener)this);
        String[] amPmTexts = new DateFormatSymbols().getAmPmStrings();
        this.mAmText = amPmTexts[0];
        this.mPmText = amPmTexts[1];
        this.mAmPmHitspace = view.findViewById(R.id.ampm_hitspace);
        if (this.mIs24HourMode) {
            this.mAmPmTextView.setVisibility(8);
        } else {
            this.mAmPmTextView.setVisibility(0);
            this.updateAmPmDisplay(this.mInitialTime.isAM() ? 6 : 7);
            this.mAmPmHitspace.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    DatePickerDialog.this.tryVibrate();
                    int amOrPm = DatePickerDialog.this.getIsCurrentlyAmOrPm();
                    if (amOrPm == 6) {
                        amOrPm = 7;
                    } else if (amOrPm == 7) {
                        amOrPm = 6;
                    }
                    DatePickerDialog.this.setAmOrPm(amOrPm);
                }
            });
        }
        if (!this.mEnableSeconds) {
            this.mSecondView.setVisibility(8);
            view.findViewById(R.id.separator_seconds).setVisibility(8);
        }
        if (!this.mEnableMinutes) {
            this.mMinuteSpaceView.setVisibility(8);
            view.findViewById(R.id.separator).setVisibility(8);
        }
        if (this.mOnlyDate) {
            this.timeDisplayView.setVisibility(8);
        }
        if (this.mIs24HourMode && !this.mEnableSeconds && this.mEnableMinutes) {
            RelativeLayout.LayoutParams paramsSeparator = new RelativeLayout.LayoutParams(-2, -2);
            paramsSeparator.addRule(13);
            TextView separatorView = (TextView)view.findViewById(R.id.separator);
            separatorView.setLayoutParams((ViewGroup.LayoutParams)paramsSeparator);
        } else if (!this.mEnableMinutes && !this.mEnableSeconds) {
            RelativeLayout.LayoutParams paramsHour = new RelativeLayout.LayoutParams(-2, -2);
            paramsHour.addRule(13);
            this.mHourSpaceView.setLayoutParams((ViewGroup.LayoutParams)paramsHour);
            if (!this.mIs24HourMode) {
                RelativeLayout.LayoutParams paramsAmPm = new RelativeLayout.LayoutParams(-2, -2);
                paramsAmPm.addRule(1, R.id.hour_space);
                paramsAmPm.addRule(4, R.id.hour_space);
                this.mAmPmTextView.setLayoutParams((ViewGroup.LayoutParams)paramsAmPm);
            }
        } else if (this.mEnableSeconds) {
            RelativeLayout.LayoutParams paramsMinutes;
            View separator = view.findViewById(R.id.separator);
            RelativeLayout.LayoutParams paramsSeparator = new RelativeLayout.LayoutParams(-2, -2);
            paramsSeparator.addRule(0, R.id.minutes_space);
            paramsSeparator.addRule(15, -1);
            separator.setLayoutParams((ViewGroup.LayoutParams)paramsSeparator);
            if (!this.mIs24HourMode) {
                paramsMinutes = new RelativeLayout.LayoutParams(-2, -2);
                paramsMinutes.addRule(13);
                this.mMinuteSpaceView.setLayoutParams((ViewGroup.LayoutParams)paramsMinutes);
            } else {
                paramsMinutes = new RelativeLayout.LayoutParams(-2, -2);
                paramsMinutes.addRule(1, R.id.center_view);
                this.mMinuteSpaceView.setLayoutParams((ViewGroup.LayoutParams)paramsMinutes);
            }
        }
        int bgColorResource = this.mThemeDark ? R.color.mdtp_date_picker_view_animator_dark_theme : R.color.mdtp_date_picker_view_animator;
        view.setBackgroundColor(ContextCompat.getColor((Context)activity, (int)bgColorResource));
        this.mAnimator = (AccessibleDateAnimator)view.findViewById(R.id.animator);
        this.mAnimator.addView((View)this.mDayPickerView);
        this.mAnimator.addView((View)this.mYearPickerView);
        this.mAnimator.addView((View)this.mMonthPickerView);
        this.mAnimator.addView((View)this.mHourPickerView);
        this.mAnimator.addView((View)this.mMinutePickerView);
        this.mAnimator.addView((View)this.mSecondPickerView);
        this.mAnimator.setTimeMilis(this.mInitialTime);
        this.mAnimator.setDateMillis(this.mCalendar.getTimeInMillis());
        AlphaAnimation animation = new AlphaAnimation(0.0f, 1.0f);
        animation.setDuration(300L);
        this.mAnimator.setInAnimation((Animation)animation);
        AlphaAnimation animation2 = new AlphaAnimation(1.0f, 0.0f);
        animation2.setDuration(300L);
        this.mAnimator.setOutAnimation((Animation)animation2);
        Button okButton = (Button)view.findViewById(R.id.ok);
        okButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                DatePickerDialog.this.tryVibrate();
                DatePickerDialog.this.notifyOnDateListener();
                DatePickerDialog.this.dismiss();
            }
        });
        okButton.setTypeface(TypefaceHelper.get((Context)activity, "Roboto-Medium"));
        if (this.mOkString != null) {
            okButton.setText((CharSequence)this.mOkString);
        } else {
            okButton.setText(this.mOkResid);
        }
        Button cancelButton = (Button)view.findViewById(R.id.cancel);
        cancelButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                DatePickerDialog.this.tryVibrate();
                if (DatePickerDialog.this.getDialog() != null) {
                    DatePickerDialog.this.getDialog().cancel();
                }
            }
        });
        cancelButton.setTypeface(TypefaceHelper.get((Context)activity, "Roboto-Medium"));
        if (this.mCancelString != null) {
            cancelButton.setText((CharSequence)this.mCancelString);
        } else {
            cancelButton.setText(this.mCancelResid);
        }
        cancelButton.setVisibility(this.isCancelable() ? 0 : 8);
        if (this.mAccentColor == -1) {
            this.mAccentColor = Utils.getAccentColorFromThemeIfAvailable((Context)this.getActivity());
        }
        if (this.mDayOfWeekView != null) {
            this.mDayOfWeekView.setBackgroundColor(Utils.darkenColor(this.mAccentColor));
        }
        view.findViewById(R.id.day_picker_selected_date_layout).setBackgroundColor(this.mAccentColor);
        okButton.setTextColor(this.mAccentColor);
        cancelButton.setTextColor(this.mAccentColor);
        if (this.getDialog() == null) {
            view.findViewById(R.id.done_background).setVisibility(8);
        }
        this.updateDisplay(false);
        this.setCurrentView(currentView);
        if (listPosition != -1) {
            if (currentView == 0) {
                this.mDayPickerView.postSetSelection(listPosition);
            } else if (currentView == 2) {
                this.mMonthPickerView.postSetSelectionFromTop(listPosition, listPositionOffset);
            } else if (currentView == 1) {
                this.mYearPickerView.postSetSelectionFromTop(listPosition, listPositionOffset);
            } else if (currentView == 3) {
                this.mHourPickerView.postSetSelectionFromTop(listPosition, listPositionOffset);
            } else if (currentView == 4) {
                this.mMinutePickerView.postSetSelectionFromTop(listPosition, listPositionOffset);
            } else if (currentView == 5) {
                this.mSecondPickerView.postSetSelectionFromTop(listPosition, listPositionOffset);
            }
        }
        this.mHapticFeedbackController = new HapticFeedbackController((Context)activity);
        return view;
    }

    public void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        ViewGroup viewGroup = (ViewGroup)this.getView();
        if (viewGroup != null) {
            viewGroup.removeAllViewsInLayout();
            View view = this.onCreateView(this.getActivity().getLayoutInflater(), viewGroup, null);
            viewGroup.addView(view);
        }
    }

    public Dialog onCreateDialog(Bundle savedInstanceState) {
        Dialog dialog = super.onCreateDialog(savedInstanceState);
        dialog.requestWindowFeature(1);
        return dialog;
    }

    public void onResume() {
        super.onResume();
        this.mHapticFeedbackController.start();
    }

    public void onPause() {
        super.onPause();
        this.mHapticFeedbackController.stop();
        if (this.mDismissOnPause) {
            this.dismiss();
        }
    }

    public void onCancel(DialogInterface dialog) {
        super.onCancel(dialog);
        if (this.mOnCancelListener != null) {
            this.mOnCancelListener.onCancel(dialog);
        }
    }

    public void onDismiss(DialogInterface dialog) {
        super.onDismiss(dialog);
        if (this.mOnDismissListener != null) {
            this.mOnDismissListener.onDismiss(dialog);
        }
    }

    private void setCurrentView(int viewIndex) {
        long millis = this.mCalendar.getTimeInMillis();
        switch (viewIndex) {
            case 0: {
                ObjectAnimator pulseAnimator = Utils.getPulseAnimator((View)this.mDayOfWeekView, 0.9f, 1.05f);
                if (this.mDelayAnimation) {
                    pulseAnimator.setStartDelay(500L);
                    this.mDelayAnimation = false;
                }
                this.mDayPickerView.onDateChanged();
                if (this.mCurrentView != viewIndex) {
                    this.mMonthAndDayView.setSelected(true);
                    this.mSelectedDayTextView.setSelected(true);
                    this.mSelectedMonthTextView.setSelected(false);
                    this.mYearView.setSelected(false);
                    this.mHourView.setSelected(false);
                    this.mMinuteView.setSelected(false);
                    this.mSecondView.setSelected(false);
                    this.mAmPmTextView.setSelected(false);
                    this.mHourView.setTextColor(this.getResources().getColor(R.color.mdtp_accent_color_focused));
                    this.mMinuteView.setTextColor(this.getResources().getColor(R.color.mdtp_accent_color_focused));
                    this.mSecondView.setTextColor(this.getResources().getColor(R.color.mdtp_accent_color_focused));
                    this.mAnimator.setDisplayedChild(0);
                    this.mCurrentView = viewIndex;
                }
                pulseAnimator.start();
                int flags = 16;
                String dayString = DateUtils.formatDateTime((Context)this.getActivity(), (long)millis, (int)flags);
                this.mAnimator.setContentDescription(this.mDayPickerDescription + ": " + dayString);
                Utils.tryAccessibilityAnnounce((View)this.mAnimator, this.mSelectDay);
                break;
            }
            case 2: {
                ObjectAnimator pulseAnimator = Utils.getPulseAnimator((View)this.mSelectedMonthTextView, 0.85f, 1.1f);
                if (this.mDelayAnimation) {
                    pulseAnimator.setStartDelay(500L);
                    this.mDelayAnimation = false;
                }
                this.mMonthPickerView.onDateChanged();
                if (this.mCurrentView != viewIndex) {
                    this.mMonthAndDayView.setSelected(true);
                    this.mSelectedDayTextView.setSelected(false);
                    this.mSelectedMonthTextView.setSelected(true);
                    this.mYearView.setSelected(false);
                    this.mHourView.setSelected(false);
                    this.mMinuteView.setSelected(false);
                    this.mSecondView.setSelected(false);
                    this.mAmPmTextView.setSelected(false);
                    this.mHourView.setTextColor(this.getResources().getColor(R.color.mdtp_accent_color_focused));
                    this.mMinuteView.setTextColor(this.getResources().getColor(R.color.mdtp_accent_color_focused));
                    this.mSecondView.setTextColor(this.getResources().getColor(R.color.mdtp_accent_color_focused));
                    this.mAnimator.setDisplayedChild(2);
                    this.mCurrentView = viewIndex;
                }
                pulseAnimator.start();
                String monthString = MONTH_FORMAT.format(millis);
                this.mAnimator.setContentDescription(this.mMonthPickerDescription + ": " + monthString);
                Utils.tryAccessibilityAnnounce((View)this.mAnimator, this.mSelectMonth);
                break;
            }
            case 1: {
                ObjectAnimator pulseAnimator = Utils.getPulseAnimator((View)this.mYearView, 0.85f, 1.1f);
                if (this.mDelayAnimation) {
                    pulseAnimator.setStartDelay(500L);
                    this.mDelayAnimation = false;
                }
                this.mYearPickerView.onDateChanged();
                if (this.mCurrentView != viewIndex) {
                    this.mMonthAndDayView.setSelected(false);
                    this.mSelectedDayTextView.setSelected(false);
                    this.mSelectedMonthTextView.setSelected(false);
                    this.mYearView.setSelected(true);
                    this.mHourView.setSelected(false);
                    this.mMinuteView.setSelected(false);
                    this.mSecondView.setSelected(false);
                    this.mAmPmTextView.setSelected(false);
                    this.mHourView.setTextColor(this.getResources().getColor(R.color.mdtp_accent_color_focused));
                    this.mMinuteView.setTextColor(this.getResources().getColor(R.color.mdtp_accent_color_focused));
                    this.mSecondView.setTextColor(this.getResources().getColor(R.color.mdtp_accent_color_focused));
                    this.mAnimator.setDisplayedChild(1);
                    this.mCurrentView = viewIndex;
                }
                pulseAnimator.start();
                String yearString = YEAR_FORMAT.format(millis);
                this.mAnimator.setContentDescription(this.mYearPickerDescription + ": " + yearString);
                Utils.tryAccessibilityAnnounce((View)this.mAnimator, this.mSelectYear);
                break;
            }
            case 3: {
                ObjectAnimator pulseAnimator = Utils.getPulseAnimator((View)this.mHourView, 0.85f, 1.1f);
                if (this.mDelayAnimation) {
                    pulseAnimator.setStartDelay(500L);
                    this.mDelayAnimation = false;
                }
                this.mHourPickerView.onDateChanged();
                if (this.mCurrentView != viewIndex) {
                    this.mMonthAndDayView.setSelected(true);
                    this.mSelectedDayTextView.setSelected(false);
                    this.mSelectedMonthTextView.setSelected(false);
                    this.mYearView.setSelected(false);
                    this.mHourView.setSelected(true);
                    this.mMinuteView.setSelected(false);
                    this.mSecondView.setSelected(false);
                    this.mAmPmTextView.setSelected(false);
                    this.mHourView.setTextColor(this.getResources().getColor(R.color.mdtp_white));
                    this.mMinuteView.setTextColor(this.getResources().getColor(R.color.mdtp_accent_color_focused));
                    this.mSecondView.setTextColor(this.getResources().getColor(R.color.mdtp_accent_color_focused));
                    this.mAnimator.setDisplayedChild(3);
                    this.mCurrentView = viewIndex;
                }
                pulseAnimator.start();
                String hourString = MONTH_FORMAT.format(millis);
                this.mAnimator.setContentDescription(this.mHourPickerDescription + ": " + hourString);
                Utils.tryAccessibilityAnnounce((View)this.mAnimator, this.mSelectHours);
                break;
            }
            case 4: {
                ObjectAnimator pulseAnimator = Utils.getPulseAnimator((View)this.mMinuteView, 0.85f, 1.1f);
                if (this.mDelayAnimation) {
                    pulseAnimator.setStartDelay(500L);
                    this.mDelayAnimation = false;
                }
                this.mMinutePickerView.onDateChanged();
                if (this.mCurrentView != viewIndex) {
                    this.mMonthAndDayView.setSelected(true);
                    this.mSelectedDayTextView.setSelected(false);
                    this.mSelectedMonthTextView.setSelected(false);
                    this.mYearView.setSelected(false);
                    this.mHourView.setSelected(false);
                    this.mMinuteView.setSelected(true);
                    this.mSecondView.setSelected(false);
                    this.mAmPmTextView.setSelected(false);
                    this.mHourView.setTextColor(this.getResources().getColor(R.color.mdtp_accent_color_focused));
                    this.mMinuteView.setTextColor(this.getResources().getColor(R.color.mdtp_white));
                    this.mSecondView.setTextColor(this.getResources().getColor(R.color.mdtp_accent_color_focused));
                    this.mAnimator.setDisplayedChild(4);
                    this.mCurrentView = viewIndex;
                }
                pulseAnimator.start();
                String minuteString = MONTH_FORMAT.format(millis);
                this.mAnimator.setContentDescription(this.mMinutePickerDescription + ": " + minuteString);
                Utils.tryAccessibilityAnnounce((View)this.mAnimator, this.mSelectMinutes);
                break;
            }
            case 5: {
                ObjectAnimator pulseAnimator = Utils.getPulseAnimator((View)this.mSecondView, 0.85f, 1.1f);
                if (this.mDelayAnimation) {
                    pulseAnimator.setStartDelay(500L);
                    this.mDelayAnimation = false;
                }
                this.mSecondPickerView.onDateChanged();
                if (this.mCurrentView != viewIndex) {
                    this.mMonthAndDayView.setSelected(true);
                    this.mSelectedDayTextView.setSelected(false);
                    this.mSelectedMonthTextView.setSelected(false);
                    this.mYearView.setSelected(false);
                    this.mHourView.setSelected(false);
                    this.mMinuteView.setSelected(false);
                    this.mSecondView.setSelected(true);
                    this.mAmPmTextView.setSelected(false);
                    this.mHourView.setTextColor(this.getResources().getColor(R.color.mdtp_accent_color_focused));
                    this.mMinuteView.setTextColor(this.getResources().getColor(R.color.mdtp_accent_color_focused));
                    this.mSecondView.setTextColor(this.getResources().getColor(R.color.mdtp_white));
                    this.mAnimator.setDisplayedChild(5);
                    this.mCurrentView = viewIndex;
                }
                pulseAnimator.start();
                String secondString = MONTH_FORMAT.format(millis);
                this.mAnimator.setContentDescription(this.mSecondPickerDescription + ": " + secondString);
                Utils.tryAccessibilityAnnounce((View)this.mAnimator, this.mSelectSeconds);
            }
        }
    }

    private void updateDisplay(boolean announce) {
        if (this.mDayOfWeekView != null) {
            if (this.mTitle != null) {
                this.mDayOfWeekView.setText((CharSequence)this.mTitle.toUpperCase(Locale.getDefault()));
            } else {
                this.mDayOfWeekView.setText((CharSequence)this.mCalendar.getDisplayName(7, 2, Locale.getDefault()).toUpperCase(Locale.getDefault()));
            }
        }
        this.mSelectedMonthTextView.setText((CharSequence)this.mCalendar.getDisplayName(2, 1, Locale.getDefault()).toUpperCase(Locale.getDefault()));
        this.mSelectedDayTextView.setText((CharSequence)DAY_FORMAT.format(this.mCalendar.getTime()));
        this.mYearView.setText((CharSequence)YEAR_FORMAT.format(this.mCalendar.getTime()));
        this.setHour(this.mInitialTime.getHour());
        this.setMinute(this.mInitialTime.getMinute());
        this.setSecond(this.mInitialTime.getSecond());
        long millis = this.mCalendar.getTimeInMillis();
        this.mAnimator.setDateMillis(millis);
        int flags = 24;
        String monthAndDayText = DateUtils.formatDateTime((Context)this.getActivity(), (long)millis, (int)flags);
        this.mDayOfWeekView.setContentDescription((CharSequence)monthAndDayText);
        if (announce) {
            flags = 20;
            String fullDateText = DateUtils.formatDateTime((Context)this.getActivity(), (long)millis, (int)flags);
            Utils.tryAccessibilityAnnounce((View)this.mAnimator, fullDateText);
        }
    }

    public void vibrate(boolean vibrate) {
        this.mVibrate = vibrate;
    }

    public void dismissOnPause(boolean dismissOnPause) {
        this.mDismissOnPause = dismissOnPause;
    }

    public void autoDismiss(boolean autoDismiss) {
        this.mAutoDismiss = autoDismiss;
    }

    public void setThemeDark(boolean themeDark) {
        this.mThemeDark = themeDark;
        this.mThemeDarkChanged = true;
    }

    @Override
    public boolean isThemeDark() {
        return this.mThemeDark;
    }

    public void setAccentColor(String color2) {
        this.mAccentColor = Color.parseColor((String)color2);
    }

    public void setAccentColor(@ColorInt int color2) {
        this.mAccentColor = Color.argb((int)255, (int)Color.red((int)color2), (int)Color.green((int)color2), (int)Color.blue((int)color2));
    }

    @Override
    public int getAccentColor() {
        return this.mAccentColor;
    }

    public void showYearPickerFirst(boolean yearPicker) {
        this.mDefaultView = yearPicker ? 1 : 0;
    }

    public void showMonthPickerFirst(boolean monthPicker) {
        this.mDefaultView = monthPicker ? 2 : 0;
    }

    public void dateOnly(boolean dateonly) {
        this.mOnlyDate = dateonly;
    }

    public void setFirstDayOfWeek(int startOfWeek) {
        if (startOfWeek < 1 || startOfWeek > 7) {
            throw new IllegalArgumentException("Value must be between Calendar.SUNDAY and Calendar.SATURDAY");
        }
        this.mWeekStart = startOfWeek;
        if (this.mDayPickerView != null) {
            this.mDayPickerView.onChange();
        }
    }

    public void setYearRange(int startYear, int endYear) {
        if (endYear < startYear) {
            throw new IllegalArgumentException("Year end must be larger than or equal to year start");
        }
        this.mMinYear = startYear;
        this.mMaxYear = endYear;
        if (this.mDayPickerView != null) {
            this.mDayPickerView.onChange();
        }
    }

    public void setMinDate(Calendar calendar) {
        this.mMinDate = this.trimToMidnight(calendar);
        if (this.mDayPickerView != null) {
            this.mDayPickerView.onChange();
        }
    }

    public Calendar getMinDate() {
        return this.mMinDate;
    }

    public void setMaxDate(Calendar calendar) {
        this.mMaxDate = this.trimToMidnight(calendar);
        if (this.mDayPickerView != null) {
            this.mDayPickerView.onChange();
        }
    }

    public Calendar getMaxDate() {
        return this.mMaxDate;
    }

    public void setHighlightedDays(Calendar[] highlightedDays) {
        Arrays.sort(highlightedDays);
        for (Calendar highlightedDay : highlightedDays) {
            this.trimToMidnight(highlightedDay);
        }
        this.highlightedDays = highlightedDays;
        if (this.mDayPickerView != null) {
            this.mDayPickerView.onChange();
        }
    }

    @Override
    public Calendar[] getHighlightedDays() {
        return this.highlightedDays;
    }

    public void setSelectableDays(Calendar[] selectableDays) {
        Arrays.sort(selectableDays);
        for (Calendar selectableDay : selectableDays) {
            this.trimToMidnight(selectableDay);
        }
        this.selectableDays = selectableDays;
        if (this.mDayPickerView != null) {
            this.mDayPickerView.onChange();
        }
    }

    public Calendar[] getSelectableDays() {
        return this.selectableDays;
    }

    public void setDisabledDays(Calendar[] disabledDays) {
        Arrays.sort(disabledDays);
        for (Calendar disabledDay : disabledDays) {
            this.trimToMidnight(disabledDay);
        }
        this.disabledDays = disabledDays;
        if (this.mDayPickerView != null) {
            this.mDayPickerView.onChange();
        }
    }

    public Calendar[] getDisabledDays() {
        return this.disabledDays;
    }

    public void setTitle(String title) {
        this.mTitle = title;
    }

    public void setOkText(String okString) {
        this.mOkString = okString;
    }

    public void setOkText(@StringRes int okResid) {
        this.mOkString = null;
        this.mOkResid = okResid;
    }

    public void setCancelText(String cancelString) {
        this.mCancelString = cancelString;
    }

    public void setCancelText(@StringRes int cancelResid) {
        this.mCancelString = null;
        this.mCancelResid = cancelResid;
    }

    public void setOnDateSetListener(OnDateSetListener listener) {
        this.mCallBack = listener;
    }

    public void setOnCancelListener(DialogInterface.OnCancelListener onCancelListener) {
        this.mOnCancelListener = onCancelListener;
    }

    public void setOnDismissListener(DialogInterface.OnDismissListener onDismissListener) {
        this.mOnDismissListener = onDismissListener;
    }

    private void adjustDayInMonthIfNeeded(Calendar calendar) {
        int daysInMonth;
        int day = calendar.get(5);
        if (day > (daysInMonth = calendar.getActualMaximum(5))) {
            calendar.set(5, daysInMonth);
        }
        this.setToNearestDate(calendar);
    }

    public void onClick(View v) {
        this.tryVibrate();
        if (v.getId() == R.id.date_picker_year) {
            this.setCurrentView(1);
        } else if (v.getId() == R.id.date_picker_day) {
            this.setCurrentView(0);
        } else if (v.getId() == R.id.date_picker_month) {
            this.setCurrentView(2);
        } else if (v.getId() == R.id.hours) {
            this.setCurrentView(3);
        } else if (v.getId() == R.id.minutes) {
            this.setCurrentView(4);
        } else if (v.getId() == R.id.seconds) {
            this.setCurrentView(5);
        } else if (v.getId() == R.id.ampm_label) {
            int apm = this.getIsCurrentlyAmOrPm() == 6 ? 7 : 6;
            this.updateAmPmDisplay(apm);
        }
    }

    @Override
    public void onYearSelected(int year) {
        this.mCalendar.set(1, year);
        this.adjustDayInMonthIfNeeded(this.mCalendar);
        this.updatePickers();
        this.setCurrentView(0);
        this.updateDisplay(true);
    }

    @Override
    public void onTimeSelected(int value, String type) {
        switch (type.toUpperCase()) {
            case "HOUR": {
                this.mInitialTime = new Timepoint(value, this.mInitialTime.getMinute(), this.mInitialTime.getSecond());
                break;
            }
            case "MINUTE": {
                this.mInitialTime = new Timepoint(this.mInitialTime.getHour(), value, this.mInitialTime.getSecond());
                break;
            }
            case "SECOND": {
                this.mInitialTime = new Timepoint(this.mInitialTime.getHour(), this.mInitialTime.getMinute(), value);
                break;
            }
            default: {
                this.mInitialTime = new Timepoint(value, this.mInitialTime.getMinute(), this.mInitialTime.getSecond());
            }
        }
        this.updatePickers();
        this.setCurrentView(0);
        this.updateDisplay(true);
    }

    @Override
    public void onMonthSelected(int month) {
        this.mCalendar.set(2, month);
        this.adjustDayInMonthIfNeeded(this.mCalendar);
        this.updatePickers();
        this.setCurrentView(0);
        this.updateDisplay(true);
    }

    @Override
    public void onDayOfMonthSelected(int year, int month, int day) {
        this.mCalendar.set(1, year);
        this.mCalendar.set(2, month);
        this.mCalendar.set(5, day);
        this.updatePickers();
        this.updateDisplay(true);
        if (this.mAutoDismiss) {
            this.notifyOnDateListener();
            this.dismiss();
        }
    }

    private void updatePickers() {
        for (OnDateChangedListener listener : this.mListeners) {
            listener.onDateChanged();
        }
    }

    @Override
    public MonthAdapter.CalendarDay getSelectedDay() {
        return new MonthAdapter.CalendarDay(this.mCalendar, this.mInitialTime);
    }

    @Override
    public Calendar getStartDate() {
        if (this.selectableDays != null) {
            return this.selectableDays[0];
        }
        if (this.mMinDate != null) {
            return this.mMinDate;
        }
        Calendar output = Calendar.getInstance();
        output.set(1, this.mMinYear);
        output.set(5, 1);
        output.set(2, 0);
        return output;
    }

    @Override
    public Calendar getEndDate() {
        if (this.selectableDays != null) {
            return this.selectableDays[this.selectableDays.length - 1];
        }
        if (this.mMaxDate != null) {
            return this.mMaxDate;
        }
        Calendar output = Calendar.getInstance();
        output.set(1, this.mMaxYear);
        output.set(5, 31);
        output.set(2, 11);
        return output;
    }

    @Override
    public int getMinYear() {
        if (this.selectableDays != null) {
            return this.selectableDays[0].get(1);
        }
        return this.mMinDate != null && this.mMinDate.get(1) > this.mMinYear ? this.mMinDate.get(1) : this.mMinYear;
    }

    @Override
    public int getMaxYear() {
        if (this.selectableDays != null) {
            return this.selectableDays[this.selectableDays.length - 1].get(1);
        }
        return this.mMaxDate != null && this.mMaxDate.get(1) < this.mMaxYear ? this.mMaxDate.get(1) : this.mMaxYear;
    }

    @Override
    public int getMinMonth() {
        if (this.selectableDays != null) {
            return this.selectableDays[0].get(2);
        }
        return this.mMinDate != null && this.mMinDate.get(2) > 0 ? this.mMinDate.get(2) : 0;
    }

    @Override
    public int getMaxMonth() {
        if (this.selectableDays != null) {
            return this.selectableDays[this.selectableDays.length - 1].get(2);
        }
        String[] months = new DateFormatSymbols().getMonths();
        return this.mMaxDate != null && this.mMaxDate.get(2) < months.length - 1 ? this.mMaxDate.get(2) : months.length - 1;
    }

    @Override
    public boolean isOutOfRange(int year, int month, int day) {
        return this.isDisabled(year, month, day) || !this.isSelectable(year, month, day);
    }

    public boolean isOutOfRange(Calendar calendar) {
        return this.isOutOfRange(calendar.get(1), calendar.get(2), calendar.get(5));
    }

    private boolean isDisabled(int year, int month, int day) {
        return this.containsDate(this.disabledDays, year, month, day) || this.isBeforeMin(year, month, day) || this.isAfterMax(year, month, day);
    }

    private boolean isDisabled(Calendar c) {
        return this.isDisabled(c.get(1), c.get(2), c.get(5));
    }

    private boolean isSelectable(int year, int month, int day) {
        return this.selectableDays == null || this.containsDate(this.selectableDays, year, month, day);
    }

    private boolean containsDate(Calendar[] dates, int year, int month, int day) {
        if (dates == null) {
            return false;
        }
        for (Calendar c : dates) {
            if (year < c.get(1)) break;
            if (year > c.get(1)) continue;
            if (month < c.get(2)) break;
            if (month > c.get(2)) continue;
            if (day < c.get(5)) break;
            if (day > c.get(5)) continue;
            return true;
        }
        return false;
    }

    private boolean isBeforeMin(int year, int month, int day) {
        if (this.mMinDate == null) {
            return false;
        }
        if (year < this.mMinDate.get(1)) {
            return true;
        }
        if (year > this.mMinDate.get(1)) {
            return false;
        }
        if (month < this.mMinDate.get(2)) {
            return true;
        }
        if (month > this.mMinDate.get(2)) {
            return false;
        }
        return day < this.mMinDate.get(5);
    }

    private boolean isBeforeMin(Calendar calendar) {
        return this.isBeforeMin(calendar.get(1), calendar.get(2), calendar.get(5));
    }

    private boolean isAfterMax(int year, int month, int day) {
        if (this.mMaxDate == null) {
            return false;
        }
        if (year > this.mMaxDate.get(1)) {
            return true;
        }
        if (year < this.mMaxDate.get(1)) {
            return false;
        }
        if (month > this.mMaxDate.get(2)) {
            return true;
        }
        if (month < this.mMaxDate.get(2)) {
            return false;
        }
        return day > this.mMaxDate.get(5);
    }

    private boolean isAfterMax(Calendar calendar) {
        return this.isAfterMax(calendar.get(1), calendar.get(2), calendar.get(5));
    }

    private void setToNearestDate(Calendar calendar) {
        if (this.selectableDays != null) {
            long distance = Long.MAX_VALUE;
            Calendar currentBest = calendar;
            for (Calendar c : this.selectableDays) {
                long newDistance = Math.abs(calendar.getTimeInMillis() - c.getTimeInMillis());
                if (newDistance >= distance || this.isDisabled(c)) break;
                distance = newDistance;
                currentBest = c;
            }
            calendar.setTimeInMillis(currentBest.getTimeInMillis());
            return;
        }
        if (this.disabledDays != null) {
            Calendar forwardDate = (Calendar)calendar.clone();
            Calendar backwardDate = (Calendar)calendar.clone();
            while (this.isDisabled(forwardDate) && this.isDisabled(backwardDate)) {
                forwardDate.add(5, 1);
                backwardDate.add(5, -1);
            }
            if (!this.isDisabled(backwardDate)) {
                calendar.setTimeInMillis(backwardDate.getTimeInMillis());
                return;
            }
            if (!this.isDisabled(forwardDate)) {
                calendar.setTimeInMillis(forwardDate.getTimeInMillis());
                return;
            }
        }
        if (this.isBeforeMin(calendar)) {
            calendar.setTimeInMillis(this.mMinDate.getTimeInMillis());
            return;
        }
        if (this.isAfterMax(calendar)) {
            calendar.setTimeInMillis(this.mMaxDate.getTimeInMillis());
            return;
        }
    }

    private Calendar trimToMidnight(Calendar calendar) {
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar;
    }

    @Override
    public int getFirstDayOfWeek() {
        return this.mWeekStart;
    }

    @Override
    public void registerOnDateChangedListener(OnDateChangedListener listener) {
        this.mListeners.add(listener);
    }

    @Override
    public void unregisterOnDateChangedListener(OnDateChangedListener listener) {
        this.mListeners.remove(listener);
    }

    @Override
    public void tryVibrate() {
        if (this.mVibrate) {
            this.mHapticFeedbackController.tryVibrate();
        }
    }

    public void notifyOnDateListener() {
        if (this.mCallBack != null) {
            this.mCallBack.onDateSet(this, this.mCalendar.get(1), this.mCalendar.get(2), this.mCalendar.get(5), this.mInitialTime.getHour(), this.mInitialTime.getMinute(), this.mInitialTime.getSecond());
        }
    }

    public void enableSeconds(boolean enableSeconds) {
        if (enableSeconds) {
            this.mEnableMinutes = true;
        }
        this.mEnableSeconds = enableSeconds;
    }

    public void enableMinutes(boolean enableMinutes) {
        if (!enableMinutes) {
            this.mEnableSeconds = false;
        }
        this.mEnableMinutes = enableMinutes;
    }

    private void setHour(int value) {
        String format;
        if (this.mIs24HourMode) {
            format = "%02d";
        } else {
            format = "%d";
            if ((value %= 12) == 0) {
                value = 12;
            }
        }
        String text = String.format(format, value);
        this.mHourView.setText((CharSequence)text);
        this.mHourSpaceView.setText((CharSequence)text);
    }

    private void setMinute(int value) {
        if (value == 60) {
            value = 0;
        }
        String text = String.format(Locale.getDefault(), "%02d", value);
        this.mMinuteView.setText((CharSequence)text);
        this.mMinuteSpaceView.setText((CharSequence)text);
    }

    private void setSecond(int value) {
        if (value == 60) {
            value = 0;
        }
        String text = String.format(Locale.getDefault(), "%02d", value);
        this.mSecondView.setText((CharSequence)text);
        this.mSecondSpaceView.setText((CharSequence)text);
    }

    private void updateAmPmDisplay(int amOrPm) {
        if (amOrPm == 6) {
            this.mAmPmTextView.setText((CharSequence)this.mAmText);
            this.mAmPmHitspace.setContentDescription((CharSequence)this.mAmText);
        } else if (amOrPm == 7) {
            this.mAmPmTextView.setText((CharSequence)this.mPmText);
            this.mAmPmHitspace.setContentDescription((CharSequence)this.mPmText);
        } else {
            this.mAmPmTextView.setText((CharSequence)this.mDoublePlaceholderText);
        }
        this.setAmOrPm(amOrPm);
    }

    public int getIsCurrentlyAmOrPm() {
        if (this.mInitialTime.isAM()) {
            return 6;
        }
        if (this.mInitialTime.isPM()) {
            return 7;
        }
        return -1;
    }

    public void setAmOrPm(int amOrPm) {
        Timepoint newSelection = new Timepoint(this.mInitialTime);
        if (amOrPm == 6) {
            newSelection.setAM();
        } else if (amOrPm == 7) {
            newSelection.setPM();
        }
        this.mInitialTime = newSelection;
    }

    public static interface OnDateChangedListener {
        public void onDateChanged();
    }

    public static interface OnDateSetListener {
        public void onDateSet(DatePickerDialog var1, int var2, int var3, int var4, int var5, int var6, int var7);
    }
}

