/*
 * Decompiled with CFR 0.152.
 */
package net.glxn.qrgen.android;

import android.graphics.Bitmap;
import com.google.zxing.common.BitMatrix;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import net.glxn.qrgen.android.BitmapIO;
import net.glxn.qrgen.android.MatrixToImageConfig;

public class MatrixToImageWriter {
    private static final MatrixToImageConfig DEFAULT_CONFIG = new MatrixToImageConfig();

    private MatrixToImageWriter() {
    }

    public static Bitmap toBitmap(BitMatrix matrix) {
        return MatrixToImageWriter.toBitmap(matrix, DEFAULT_CONFIG);
    }

    public static Bitmap toBitmap(BitMatrix matrix, MatrixToImageConfig config) {
        int onColor = config.getPixelOnColor();
        int offColor = config.getPixelOffColor();
        int width = matrix.getWidth();
        int height = matrix.getHeight();
        int[] pixels = new int[width * height];
        for (int y = 0; y < height; ++y) {
            int offset = y * width;
            for (int x = 0; x < width; ++x) {
                pixels[offset + x] = matrix.get(x, y) ? onColor : offColor;
            }
        }
        Bitmap image = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)config.getBufferedImageColorModel());
        image.setPixels(pixels, 0, width, 0, 0, width, height);
        return image;
    }

    public static void writeToFile(BitMatrix matrix, String format, File file) throws IOException {
        MatrixToImageWriter.writeToFile(matrix, format, file, DEFAULT_CONFIG);
    }

    public static void writeToFile(BitMatrix matrix, String format, File file, MatrixToImageConfig config) throws IOException {
        Bitmap image = MatrixToImageWriter.toBitmap(matrix, config);
        if (!BitmapIO.write(image, format, file)) {
            throw new IOException("Could not write an image of format " + format + " to " + file);
        }
    }

    public static void writeToStream(BitMatrix matrix, String format, OutputStream stream) throws IOException {
        MatrixToImageWriter.writeToStream(matrix, format, stream, DEFAULT_CONFIG);
    }

    public static void writeToStream(BitMatrix matrix, String format, OutputStream stream, MatrixToImageConfig config) throws IOException {
        Bitmap image = MatrixToImageWriter.toBitmap(matrix, config);
        if (!BitmapIO.write(image, format, stream)) {
            throw new IOException("Could not write an image of format " + format);
        }
    }
}

