/*
 * Decompiled with CFR 0.152.
 */
package com.github.kagkarlsson.examples.boot.config;

import com.github.kagkarlsson.examples.boot.CounterService;
import com.github.kagkarlsson.scheduler.SchedulerName;
import com.github.kagkarlsson.scheduler.boot.config.DbSchedulerCustomizer;
import com.github.kagkarlsson.scheduler.task.Task;
import com.github.kagkarlsson.scheduler.task.helper.Tasks;
import com.github.kagkarlsson.scheduler.task.schedule.Schedule;
import com.github.kagkarlsson.scheduler.task.schedule.Schedules;
import java.time.Duration;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class TaskConfiguration {
    private static final Logger log = LoggerFactory.getLogger(TaskConfiguration.class);

    @Bean
    Task<Void> recurringSampleTask(CounterService counter) {
        return Tasks.recurring((String)"recurring-sample-task", (Schedule)Schedules.fixedDelay((Duration)Duration.ofMinutes(1L))).execute((instance, ctx) -> {
            log.info("Running recurring-simple-task. Instance: {}, ctx: {}", (Object)instance, (Object)ctx);
            counter.increase();
        });
    }

    @Bean
    Task<Void> sampleOneTimeTask() {
        return Tasks.oneTime((String)"sample-one-time-task").execute((instance, ctx) -> log.info("I am a one-time task!"));
    }

    @Bean
    DbSchedulerCustomizer customizer() {
        return new DbSchedulerCustomizer(){

            public Optional<SchedulerName> schedulerName() {
                return Optional.of(new SchedulerName.Fixed("spring-boot-scheduler-1"));
            }
        };
    }
}

