/*
 * Decompiled with CFR 0.152.
 */
package com.github.kagkarlsson.examples.boot.config;

import com.github.kagkarlsson.examples.boot.ExampleContext;
import com.github.kagkarlsson.scheduler.task.CompletionHandler;
import com.github.kagkarlsson.scheduler.task.TaskDescriptor;
import com.github.kagkarlsson.scheduler.task.helper.CustomTask;
import com.github.kagkarlsson.scheduler.task.helper.Tasks;
import com.github.kagkarlsson.scheduler.task.schedule.Schedule;
import com.github.kagkarlsson.scheduler.task.schedule.Schedules;
import java.io.Serializable;
import java.time.Duration;
import java.time.Instant;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import utils.EventLogger;

@Configuration
public class JobChainingConfiguration {
    public static final TaskDescriptor<JobState> CHAINED_STEP_1_TASK = TaskDescriptor.of((String)"chained-step-1", JobState.class);
    public static final TaskDescriptor<JobState> CHAINED_STEP_2_TASK = TaskDescriptor.of((String)"chained-step-2", JobState.class);
    public static final TaskDescriptor<JobState> CHAINED_STEP_3_TASK = TaskDescriptor.of((String)"chained-step-3", JobState.class);
    private static int CHAINED_JOB_ID = 1;

    public static void start(ExampleContext ctx) {
        ctx.log("Scheduling a chained one-time task to run.");
        int id = CHAINED_JOB_ID++;
        ctx.schedulerClient.scheduleIfNotExists(CHAINED_STEP_1_TASK.instance("chain-" + id).data((Object)new JobState(id, 0)).scheduledTo(Instant.now()));
    }

    @Bean
    public CustomTask<JobState> chainedStep1() {
        return Tasks.custom(CHAINED_STEP_1_TASK).execute((taskInstance, executionContext) -> {
            JobState data = (JobState)taskInstance.getData();
            EventLogger.logTask(CHAINED_STEP_1_TASK, "Ran step1. Schedules step2 after successful run. Data: " + data);
            JobState nextJobState = new JobState(data.id, data.counter + 1);
            EventLogger.logTask(CHAINED_STEP_1_TASK, "Ran step1. Schedules step2 after successful run. Data: " + nextJobState);
            return new CompletionHandler.OnCompleteReplace(CHAINED_STEP_2_TASK, (Object)nextJobState);
        });
    }

    @Bean
    public CustomTask<JobState> chainedStep2() {
        return Tasks.custom(CHAINED_STEP_2_TASK).execute((taskInstance, executionContext) -> {
            JobState data = (JobState)taskInstance.getData();
            JobState nextJobState = new JobState(data.id, data.counter + 1);
            if (nextJobState.counter >= 5) {
                EventLogger.logTask(CHAINED_STEP_2_TASK, "Ran step2. Condition met. Schedules final step (step3) after successful run. Data: " + data);
                return new CompletionHandler.OnCompleteReplace(CHAINED_STEP_3_TASK, (Object)nextJobState);
            }
            EventLogger.logTask(CHAINED_STEP_2_TASK, "Ran step2. Condition for progressing not yet met, rescheduling. Data: " + data);
            return new CompletionHandler.OnCompleteReschedule((Schedule)Schedules.fixedDelay((Duration)Duration.ofSeconds(5L)), (Object)nextJobState);
        });
    }

    @Bean
    public CustomTask<JobState> chainedStep3() {
        return Tasks.custom(CHAINED_STEP_3_TASK).execute((taskInstance, executionContext) -> {
            EventLogger.logTask(CHAINED_STEP_3_TASK, "Ran step3. This was the final step in the processing, removing. Data: " + taskInstance.getData());
            return new CompletionHandler.OnCompleteRemove();
        });
    }

    public static class JobState
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public final int id;
        public final int counter;

        public JobState() {
            this(0, 0);
        }

        public JobState(int id, int counter) {
            this.id = id;
            this.counter = counter;
        }

        public String toString() {
            return "JobState{id=" + this.id + ", counter=" + this.counter + "}";
        }
    }
}

