/*
 * Decompiled with CFR 0.152.
 */
package com.github.kagkarlsson.examples;

import com.github.kagkarlsson.examples.helpers.Example;
import com.github.kagkarlsson.scheduler.Scheduler;
import com.github.kagkarlsson.scheduler.task.FailureHandler;
import com.github.kagkarlsson.scheduler.task.Task;
import com.github.kagkarlsson.scheduler.task.helper.OneTimeTask;
import com.github.kagkarlsson.scheduler.task.helper.Tasks;
import java.time.Duration;
import java.time.Instant;
import javax.sql.DataSource;

public class MaxRetriesMain
extends Example {
    public static void main(String[] args) {
        new MaxRetriesMain().runWithDatasource();
    }

    @Override
    public void run(DataSource dataSource) {
        OneTimeTask failingTask = Tasks.oneTime((String)"max_retries_task").onFailure((FailureHandler)new FailureHandler.MaxRetriesFailureHandler(3, (executionComplete, executionOperations) -> {
            System.out.println("Execution has failed " + executionComplete.getExecution().consecutiveFailures + " times. Trying again in a bit...");
            executionOperations.reschedule(executionComplete, Instant.now().plusSeconds(1L));
        })).execute((taskInstance, executionContext) -> {
            throw new RuntimeException("simulated task exception");
        });
        Scheduler scheduler = Scheduler.create((DataSource)dataSource, (Task[])new Task[]{failingTask}).pollingInterval(Duration.ofSeconds(2L)).registerShutdownHook().build();
        scheduler.schedule(failingTask.instance("1"), Instant.now());
        scheduler.start();
    }
}

