/*
 * Decompiled with CFR 0.152.
 */
package com.github.kagkarlsson.scheduler.task;

import java.util.Objects;

public interface TaskInstanceId {
    public String getTaskName();

    public String getId();

    public static TaskInstanceId of(String taskName, String id) {
        return new StandardTaskInstanceId(taskName, id);
    }

    public static class StandardTaskInstanceId
    implements TaskInstanceId {
        private final String taskName;
        private final String id;

        public StandardTaskInstanceId(String taskName, String id) {
            this.taskName = taskName;
            this.id = id;
        }

        @Override
        public String getTaskName() {
            return this.taskName;
        }

        @Override
        public String getId() {
            return this.id;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            StandardTaskInstanceId that = (StandardTaskInstanceId)o;
            return Objects.equals(this.taskName, that.taskName) && Objects.equals(this.id, that.id);
        }

        public int hashCode() {
            return Objects.hash(this.taskName, this.id);
        }
    }
}

