/*
 * Decompiled with CFR 0.152.
 */
package com.github.kagkarlsson.scheduler;

import java.time.Duration;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecutorUtils {
    private static final Logger LOG = LoggerFactory.getLogger(ExecutorUtils.class);

    public static boolean shutdownNowAndAwaitTermination(ExecutorService executor, Duration timeout) {
        executor.shutdownNow();
        return ExecutorUtils.awaitTermination(executor, timeout);
    }

    public static boolean shutdownAndAwaitTermination(ExecutorService executorService, Duration timeout) {
        executorService.shutdown();
        return ExecutorUtils.awaitTermination(executorService, timeout);
    }

    private static boolean awaitTermination(ExecutorService executor, Duration timeout) {
        try {
            return executor.awaitTermination(timeout.toMillis(), TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            LOG.warn("Interrupted while waiting for termination of executor.", (Throwable)e);
            return false;
        }
    }

    public static ThreadFactory defaultThreadFactoryWithPrefix(String prefix) {
        return new PrefixingDefaultThreadFactory(prefix);
    }

    private static class PrefixingDefaultThreadFactory
    implements ThreadFactory {
        private final String prefix;
        private final ThreadFactory defaultThreadFactory = Executors.defaultThreadFactory();

        public PrefixingDefaultThreadFactory(String prefix) {
            this.prefix = prefix;
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread thread = this.defaultThreadFactory.newThread(r);
            thread.setName(this.prefix + thread.getName());
            return thread;
        }
    }
}

