/*
 * Decompiled with CFR 0.152.
 */
package com.github.kagkarlsson.scheduler.task;

import com.github.kagkarlsson.scheduler.task.Execution;
import com.github.kagkarlsson.scheduler.task.ExecutionComplete;
import com.github.kagkarlsson.scheduler.task.ExecutionOperations;
import java.time.Instant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface DeadExecutionHandler<T> {
    public void deadExecution(Execution var1, ExecutionOperations<T> var2);

    public static class CancelDeadExecution<T>
    implements DeadExecutionHandler<T> {
        private static final Logger LOG = LoggerFactory.getLogger(ReviveDeadExecution.class);

        @Override
        public void deadExecution(Execution execution, ExecutionOperations<T> executionOperations) {
            LOG.error("Cancelling dead execution: " + execution);
            executionOperations.stop();
        }
    }

    public static class ReviveDeadExecution<T>
    implements DeadExecutionHandler<T> {
        private static final Logger LOG = LoggerFactory.getLogger(ReviveDeadExecution.class);

        @Override
        public void deadExecution(Execution execution, ExecutionOperations<T> executionOperations) {
            Instant now = Instant.now();
            LOG.warn("Reviving dead execution: " + execution + " to " + now);
            executionOperations.reschedule(new ExecutionComplete(execution, now, ExecutionComplete.Result.FAILED, null), now);
        }
    }
}

