/*
 * Decompiled with CFR 0.152.
 */
package com.github.kagkarlsson.scheduler.task;

import com.github.kagkarlsson.scheduler.task.CompletionHandler;
import com.github.kagkarlsson.scheduler.task.DeadExecutionHandler;
import com.github.kagkarlsson.scheduler.task.ExecutionContext;
import com.github.kagkarlsson.scheduler.task.ExecutionHandler;
import com.github.kagkarlsson.scheduler.task.OneTimeTask;
import com.github.kagkarlsson.scheduler.task.RecurringTask;
import com.github.kagkarlsson.scheduler.task.Schedule;
import com.github.kagkarlsson.scheduler.task.Task;
import com.github.kagkarlsson.scheduler.task.TaskInstance;

public class ComposableTask {
    public static RecurringTask recurringTask(String name, Schedule schedule, Runnable executionHandler) {
        return ComposableTask.recurringTask(name, schedule, (TaskInstance<T> instance, ExecutionContext ctx) -> executionHandler.run());
    }

    public static RecurringTask recurringTask(String name, Schedule schedule, final ExecutionHandler executionHandler) {
        return new RecurringTask(name, schedule){

            @Override
            public void execute(TaskInstance taskInstance, ExecutionContext executionContext) {
                executionHandler.execute(taskInstance, executionContext);
            }
        };
    }

    public static OneTimeTask onetimeTask(String name, Runnable executionHandler) {
        return ComposableTask.onetimeTask(name, (TaskInstance<T> instance, ExecutionContext ctx) -> executionHandler.run());
    }

    public static OneTimeTask onetimeTask(String name, final ExecutionHandler executionHandler) {
        return new OneTimeTask(name){

            @Override
            public void execute(TaskInstance taskInstance, ExecutionContext executionContext) {
                executionHandler.execute(taskInstance, executionContext);
            }
        };
    }

    public static Task customTask(String name, CompletionHandler completionHandler, Runnable executionHandler) {
        return ComposableTask.customTask(name, completionHandler, (TaskInstance<T> instance, ExecutionContext ctx) -> executionHandler.run());
    }

    public static Task customTask(String name, CompletionHandler completionHandler, final ExecutionHandler executionHandler) {
        return new Task(name, completionHandler, (DeadExecutionHandler)new DeadExecutionHandler.RescheduleDeadExecution()){

            @Override
            public void execute(TaskInstance taskInstance, ExecutionContext executionContext) {
                executionHandler.execute(taskInstance, executionContext);
            }
        };
    }
}

