/*
 * Decompiled with CFR 0.152.
 */
package com.github.kagkarlsson.scheduler.task;

import com.github.kagkarlsson.scheduler.task.NextExecutionTime;
import com.github.kagkarlsson.scheduler.task.SchedulableTaskInstance;
import com.github.kagkarlsson.scheduler.task.TaskInstance;
import com.github.kagkarlsson.scheduler.task.TaskInstanceId;
import java.time.Instant;
import java.util.function.Supplier;

public interface SchedulableInstance<T>
extends TaskInstanceId {
    public static <T> SchedulableInstance<T> of(TaskInstance<T> taskInstance, Instant executionTime) {
        return new SchedulableTaskInstance<T>(taskInstance, executionTime);
    }

    public static <T> SchedulableInstance<T> of(TaskInstance<T> taskInstance, NextExecutionTime executionTime) {
        return new SchedulableTaskInstance<T>(taskInstance, executionTime);
    }

    public TaskInstance<T> getTaskInstance();

    public Instant getNextExecutionTime(Instant var1);

    @Override
    default public String getTaskName() {
        return this.getTaskInstance().getTaskName();
    }

    @Override
    default public String getId() {
        return this.getTaskInstance().getId();
    }

    public static class Builder<T> {
        private final String taskName;
        private final String id;
        private Supplier<T> dataSupplier = () -> null;
        private int priority = 50;

        public Builder(String taskName, String id) {
            this.id = id;
            this.taskName = taskName;
        }

        public Builder<T> data(Supplier<T> dataSupplier) {
            this.dataSupplier = dataSupplier;
            return this;
        }

        public Builder<T> data(T data) {
            this.dataSupplier = () -> data;
            return this;
        }

        public Builder<T> priority(int priority) {
            this.priority = priority;
            return this;
        }

        public SchedulableInstance<T> scheduledTo(Instant executionTime) {
            TaskInstance<T> taskInstance = new TaskInstance<T>(this.taskName, this.id, this.dataSupplier, this.priority);
            return new SchedulableTaskInstance<T>(taskInstance, executionTime);
        }
    }
}

