/*
 * Decompiled with CFR 0.152.
 */
package com.github.kagkarlsson.scheduler;

import com.github.kagkarlsson.scheduler.ExecutionTimeAndId;
import java.util.Objects;
import java.util.Optional;

public class ScheduledExecutionsFilter {
    private Boolean pickedValue;
    private boolean includeUnresolved = false;
    private ExecutionTimeAndId afterExecution;
    private ExecutionTimeAndId beforeExecution;
    private Integer limit;

    private ScheduledExecutionsFilter() {
    }

    public static ScheduledExecutionsFilter all() {
        return new ScheduledExecutionsFilter().withIncludeUnresolved(true);
    }

    public static ScheduledExecutionsFilter onlyResolved() {
        return new ScheduledExecutionsFilter().withIncludeUnresolved(false);
    }

    public ScheduledExecutionsFilter withPicked(boolean pickedValue) {
        this.pickedValue = pickedValue;
        return this;
    }

    public ScheduledExecutionsFilter withIncludeUnresolved(boolean includeUnresolved) {
        this.includeUnresolved = includeUnresolved;
        return this;
    }

    public Optional<Boolean> getPickedValue() {
        return Optional.ofNullable(this.pickedValue);
    }

    public boolean getIncludeUnresolved() {
        return this.includeUnresolved;
    }

    public ScheduledExecutionsFilter limit(int limit) {
        if (limit <= 0) {
            throw new IllegalArgumentException("Limit must be positive, was: " + limit);
        }
        this.limit = limit;
        return this;
    }

    public ScheduledExecutionsFilter after(ExecutionTimeAndId execution) {
        this.afterExecution = Objects.requireNonNull(execution);
        return this;
    }

    public ScheduledExecutionsFilter before(ExecutionTimeAndId execution) {
        this.beforeExecution = Objects.requireNonNull(execution);
        return this;
    }

    public Optional<ExecutionTimeAndId> getAfterExecution() {
        return Optional.ofNullable(this.afterExecution);
    }

    public Optional<ExecutionTimeAndId> getBeforeExecution() {
        return Optional.ofNullable(this.beforeExecution);
    }

    public Optional<Integer> getLimit() {
        return Optional.ofNullable(this.limit);
    }
}

