/*
 * Decompiled with CFR 0.152.
 */
package com.github.kagkarlsson.scheduler;

import com.github.kagkarlsson.scheduler.ScheduledExecution;
import java.time.Instant;
import java.util.Base64;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public record ExecutionTimeAndId(Instant executionTime, String taskInstanceId) {
    private static final Pattern PATTERN = Pattern.compile("(\\d+),(\\d+):(.*)");

    public ExecutionTimeAndId(Instant executionTime, String taskInstanceId) {
        this.executionTime = Objects.requireNonNull(executionTime, "Execution time cannot be null");
        this.taskInstanceId = Objects.requireNonNull(taskInstanceId, "Task instance ID cannot be null");
    }

    public static ExecutionTimeAndId from(ScheduledExecution<?> execution) {
        return new ExecutionTimeAndId(execution.getExecutionTime(), execution.getTaskInstance().getId());
    }

    public String toEncodedString() {
        String template = this.executionTime.getEpochSecond() + "," + this.executionTime.getNano() + ":" + this.taskInstanceId;
        return Base64.getEncoder().encodeToString(template.getBytes());
    }

    public static ExecutionTimeAndId fromEncodedString(String encoded) {
        try {
            String decoded = new String(Base64.getDecoder().decode(encoded));
            Matcher matcher = PATTERN.matcher(decoded);
            if (!matcher.matches()) {
                throw new IllegalArgumentException("Invalid execution time and id format");
            }
            long epochSecond = Long.parseLong(matcher.group(1));
            int nanos = Integer.parseInt(matcher.group(2));
            String taskId = matcher.group(3);
            return new ExecutionTimeAndId(Instant.ofEpochSecond(epochSecond, nanos), taskId);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Invalid execution time and id: " + encoded, e);
        }
    }
}

