/*
 * Decompiled with CFR 0.152.
 */
package com.github.kagkarlsson.scheduler;

import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DueExecutionsBatch {
    private static final Logger LOG = LoggerFactory.getLogger(DueExecutionsBatch.class);
    private final int generationNumber;
    private final AtomicInteger executionsLeftInBatch;
    private final Predicate<Integer> whenToTriggerCheckForNewBatch;
    private boolean possiblyMoreExecutionsInDb;
    private boolean stale = false;
    private boolean triggeredExecuteDue;

    public DueExecutionsBatch(int generationNumber, int executionsAdded, boolean possiblyMoreExecutionsInDb, Predicate<Integer> whenToTriggerCheckForNewBatch) {
        this.generationNumber = generationNumber;
        this.possiblyMoreExecutionsInDb = possiblyMoreExecutionsInDb;
        this.executionsLeftInBatch = new AtomicInteger(executionsAdded);
        this.whenToTriggerCheckForNewBatch = whenToTriggerCheckForNewBatch;
    }

    public void markBatchAsStale() {
        this.stale = true;
    }

    public void oneExecutionDone(Runnable triggerCheckForNewBatch) {
        this.executionsLeftInBatch.decrementAndGet();
        LOG.trace("Batch state: generationNumber:{}, stale:{}, triggeredExecuteDue:{}, possiblyMoreExecutionsInDb:{}, executionsLeftInBatch:{}", new Object[]{this.generationNumber, this.stale, this.triggeredExecuteDue, this.possiblyMoreExecutionsInDb, this.executionsLeftInBatch.get()});
        if (!this.stale && !this.triggeredExecuteDue && this.possiblyMoreExecutionsInDb && this.whenToTriggerCheckForNewBatch.test(this.executionsLeftInBatch.get())) {
            LOG.trace("Triggering check for new batch.");
            triggerCheckForNewBatch.run();
            this.triggeredExecuteDue = true;
        }
    }

    public boolean isOlderGenerationThan(int compareTo) {
        return this.generationNumber < compareTo;
    }

    public int getGenerationNumber() {
        return this.generationNumber;
    }
}

