/*
 * Decompiled with CFR 0.152.
 */
package com.github.kagkarlsson.scheduler.task;

import com.github.kagkarlsson.scheduler.task.SchedulableInstance;
import com.github.kagkarlsson.scheduler.task.SchedulableTaskInstance;
import com.github.kagkarlsson.scheduler.task.TaskInstanceId;
import com.github.kagkarlsson.scheduler.task.helper.ScheduleAndData;
import java.time.Instant;
import java.util.Objects;
import java.util.function.Supplier;

public class TaskInstance<T>
implements TaskInstanceId {
    private final String taskName;
    private final String id;
    private final Supplier<T> dataSupplier;
    private final int priority;

    public TaskInstance(String taskName, String id) {
        this(taskName, id, null);
    }

    public TaskInstance(String taskName, String id, T data) {
        this(taskName, id, () -> data, 50);
    }

    public TaskInstance(String taskName, String id, Supplier<T> dataSupplier, int priority) {
        this.taskName = taskName;
        this.id = id;
        this.dataSupplier = dataSupplier;
        this.priority = priority;
    }

    public String getTaskAndInstance() {
        return this.taskName + "_" + this.id;
    }

    @Override
    public String getTaskName() {
        return this.taskName;
    }

    @Override
    public String getId() {
        return this.id;
    }

    public T getData() {
        return this.dataSupplier.get();
    }

    public int getPriority() {
        return this.priority;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TaskInstance that = (TaskInstance)o;
        return this.priority == that.priority && Objects.equals(this.taskName, that.taskName) && Objects.equals(this.id, that.id);
    }

    public int hashCode() {
        return Objects.hash(this.taskName, this.id, this.priority);
    }

    public String toString() {
        return "TaskInstance: task=" + this.taskName + ", id=" + this.id + ", priority=" + this.priority;
    }

    public static class Builder<T> {
        private final String taskName;
        private final String id;
        private Supplier<T> dataSupplier = () -> null;
        private int priority = 50;

        public Builder(String taskName, String id) {
            this.id = id;
            this.taskName = taskName;
        }

        public Builder<T> dataSupplier(Supplier<T> dataSupplier) {
            this.dataSupplier = dataSupplier;
            return this;
        }

        public Builder<T> data(T data) {
            this.dataSupplier = () -> data;
            return this;
        }

        public Builder<T> priority(int priority) {
            this.priority = priority;
            return this;
        }

        public TaskInstance<T> build() {
            return new TaskInstance<T>(this.taskName, this.id, this.dataSupplier, this.priority);
        }

        public SchedulableInstance<T> scheduledTo(Instant executionTime) {
            TaskInstance<T> taskInstance = new TaskInstance<T>(this.taskName, this.id, this.dataSupplier, this.priority);
            return new SchedulableTaskInstance<T>(taskInstance, executionTime);
        }

        public SchedulableInstance<T> scheduledAccordingToData() {
            TaskInstance<T> taskInstance = new TaskInstance<T>(this.taskName, this.id, this.dataSupplier, this.priority);
            T data = this.dataSupplier.get();
            if (!(data instanceof ScheduleAndData)) {
                throw new RuntimeException("To be able to use method 'scheduledAccordingToData()', dataClass must implement ScheduleAndData interface and contain a Schedule");
            }
            ScheduleAndData scheduleAndData = (ScheduleAndData)data;
            return new SchedulableTaskInstance<T>(taskInstance, scheduleAndData.getSchedule()::getInitialExecutionTime);
        }
    }
}

